@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('payment_by_factor');
$_description=in_array('description', $report);
$_test=true;

?>
  <h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleIncomeReport')</h3>


<table class="report-table">
  

 <?php
 $count = 0;
 $total_home_currency=0;
 $currencies=[];
 ?>

  <thead>
    <tr class="bg">
     @if($_test)<td class="center" ><div> @lang('layout.Transporter_name')</div></td>@endif
     @if($_test)<td class="center" ><div> @lang('layout.Amount')</div></td>@endif
     @if($_test)<td class="center" ><div> @lang('layout.Currency')</div></td>@endif
     @if($_test)<td class="center" ><div> @lang('layout.Rate')</div></td>@endif
     @if($_test)<td class="center" ><div> @lang('layout.LoadingDate')</div></td>@endif
     @if($_test)<td class="center" ><div> @lang('layout.Source')</div></td>@endif
     @if($_test)<td class="center" ><div> @lang('layout.Destination')</div></td>@endif
     @if($_test)<td class="center" ><div> @lang('layout.ItemName')</div></td>@endif
     @if($_test)<td class="center" ><div> @lang('layout.Measure')</div></td>@endif
     @if($_test)<td class="center" ><div> @lang('layout.Quantity')</div></td>@endif

   </tr>
  </thead>
  

  @foreach($data AS $record)
    <?php
  
   $total_home_currency+=$record->amount/$record->rate;
   if(array_key_exists($record->unit, $currencies))
   {
    $currencies[$record->unit]=$currencies[$record->unit]+$record->amount;
  }
  else
  {

    $currencies[$record->unit]=$record->amount;
  }
  ?>
  <tr>
     @if($_test)<td class="center">{{$record->driver}}</td>@endif
     @if($_test)<td class="center">{{$record->amount}}</td>@endif
     @if($_test)<td class="center">{{$record->unit}}</td>@endif
     @if($_test)<td class="center">{{$record->rate}}</td>@endif
     @if($_test)<td class="center">{{convertDate($record->loading_date)}}</td>@endif
     @if($_test)<td class="center">{{$record->source}}</td>@endif
     @if($_test)<td class="center">{{$record->destination}}</td>@endif
     @if($_test)<td class="center">{{$record->item}}</td>@endif
     @if($_test)<td class="center">{{$record->selected_measure}}</td>@endif
     @if($_test)<td class="center">{{$record->item_quantity}}</td>@endif
  </tr>
  
  @endforeach   
</table>


<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center">  @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>



 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection