@extends('layouts.app')
@section('content')


    <!-- END PAGE HEADER-->


    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'vehiclelist'"
                      @closed="closeModal">
			<div slot="body">
                <input type="hidden" name="foreign_type" value="ok">
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.VehicleType') </label>
                            <v-select class="vue-select2" v-model="vehicleTypeSelected" label="name"
                                      :options="{{ $vehicleTypes }}">
                            </v-select>
                                    <input type="hidden" name="vehicle_type_id" :value="(vehicleTypeSelected==null)?null:vehicleTypeSelected.id">
                        </div>
						
                    </div>
                </div>

            </div>		  
					  
        </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VehicleList')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
					<a href="{{route('vehicle.index')}}">
                        <button class="btn btn-success">
                            <i class="fa"></i> @lang('menu.Vehicle')
                        </button>
                    </a>
                    @permission('vehicle-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>
                    @endpermission
                    @permission('vehicle-create')
                    <a href="{{route('vehicle.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="vehicle">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.VehicleName')</th>
                        <th>@lang('layout.VehicleType')</th>
                        <th>@lang('layout.PaletNumber')</th>
                        <th>@lang('layout.TankerNumber')</th>
                        <th>@lang('layout.Driver')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rent')</th>
                        <th>@lang('layout.IncomeAccount')</th>
                        <th>@lang('layout.CostAccount')</th>
                        <th>@lang('layout.Photo')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
	
	Vue.component('v-select', VueSelect.VueSelect)
        let data_table;
        $(document).ready(function () {


            data_table = $('#vehicle').DataTable({
                ajax: '{{route("vehicle.foreign_vehicle")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
					{data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                    {data: 'vehicle_name', name: 'vehicle_name'},
                    {data: 'vehicle_type', name: 'vehicle_type', orderable: false, searchable: false},
                    {data: 'palet_number', name: 'palet_number'},
                    {data: 'tanker_number', name: 'tanker_number'},
                    {data: 'driver', name: 'members.name'},
                    {data: 'currency', name: 'currency'},
                    {data: 'rent', name: 'rent'},
                    {data: 'income', name: 'income', orderable: false, searchable: false},
                    {data: 'expense', name: 'expense', orderable: false, searchable: false},
                    {data: 'image', name: 'image', orderable: false, searchable: false},
					{data: 'actions', name: 'actions',orderable:false,searchable:false},
                ]
            });


        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('vehicle.report') !!}',
                excelRoute: '{!! route('vehicle.report') !!}',
				vehicleTypeSelected: null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
    </script>


@endpush
