@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'vehiclelist'"
                      @closed="closeModal">
			<div slot="body">
				<input type="hidden" name="foreign_type">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.VehicleType') </label>
                            <v-select class="vue-select2" v-model="vehicleTypeSelected" label="name" :options="{{ $vehicleTypes }}">
                            </v-select> 
                            <input type="hidden" name="vehicle_type_id" :value="(vehicleTypeSelected==null)?null:vehicleTypeSelected.id">
                        </div>
                        <div class="col-md-3">
                            <label class="control-label ">@lang('layout.VehicleCategory') </label>
                            <v-select class="vue-select2" v-model="vehicleCategorySelected" label="name" :options="{{ $vehicleCategory }}">
                            </v-select> 
                            <input type="hidden" name="vehicle_category_id" :value="(vehicleCategorySelected==null)?null:vehicleCategorySelected.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label">@lang('layout.SelectDriver')</label>
                            <v-select label="name" :options="drivers" placeholder="{{ __('layout.SelectDriver') }}" @search="MemberSearch" v-model="selected_main_driver"></v-select>
                            <input type="hidden" name="main_driver_id" :value="!selected_main_driver?null:selected_main_driver.id" >
                        </div>
                    </div>
                </div>
            </div>		  
					
        </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VehicleList')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
					 <a href="{{route('vehicle.foreign_vehicle')}}">
                        <button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.ForeignVehicle')
                        </button>
                    </a>
                    @permission('vehicle-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
					</span>
                    @endpermission
                    @permission('vehicle-create')
                    <a href="{{route('vehicle.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="vehicle">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>@lang('layout.VehicleName')</th>
                            <th>@lang('layout.VehicleType')</th>
                            <th>@lang('layout.PaletNumber')</th>
                            <th>@lang('layout.TankerNumber')</th>
                            <th>@lang('layout.IncomeAccount')</th>
                            <th>@lang('layout.CostAccount')</th>
                            <th>@lang('layout.Photo')</th>
                            <th>@lang('layout.Driver')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
	
	Vue.component('v-select', VueSelect.VueSelect)
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            data_table = $('#vehicle').DataTable({
                ajax: '{{route("vehicle.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?3:1}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
					{data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:true,searchable:false},
                    {data: 'vehicle_name', name: 'vehicle_name'},
                    {data: 'vehicle_type', name: 'vehicle_type', orderable: false, searchable: false},
                    {data: 'palet_number', name: 'palet_number'},
                    {data: 'tanker_number', name: 'tanker_number'},
                    {data: 'income', name: 'income'},
                    {data: 'expense', name: 'expense'},
                    {data: 'image', name: 'image', orderable: false, searchable: false},
                    {data: 'main_driver', name: 'main_driver'},
                    {data: 'user', name: 'users.name'},
					{data: 'actions', name: 'actions',orderable:false,searchable:false},
                ]
            });

        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('vehicle.report') !!}',
                excelRoute: '{!! route('vehicle.report') !!}',
				vehicleTypeSelected: null,
				vehicleCategorySelected: null,
                drivers: [],
				selected_main_driver: null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Driver'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.drivers = [];
                            vm.drivers = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
    </script>


@endpush
