@extends('layouts.app')
@section('style')
<style>

</style>
@stop

@section('content')
<!-- BEGIN CONTENT BODY -->

<!-- END PAGE BAR -->
<div class="">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.VehicleEdit')</span>
                {{--<span class="caption-helper">some info...</span>--}}
            </div>
        </div>
        <div class="portlet-body form" id="vehicle" v-cloak>
            <!-- BEGIN FORM-->
            {{Form::model($vehicle,['route' => ['vehicle.update',$vehicle->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'vehicle-form','files'=> true])}}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.VehicleName') </label>
                                <div class="">
                                {{Form::text('vehicle_name',null,['class' => 'form-control','placeholder' => __('layout.VehicleName'),'v-validate' =>'"required"','data-vv-as' => __('layout.VehicleName')])}}
                                <span class="required">@{{ errors.first('vehicle_name') }}</span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                    <label class="control-label">@lang('layout.VehicleType')</label>
                                <div class="">
                                    <div class="">
                                    <v-select label="name" v-model="vehicleTypeSelected" :options="vehicleTypes">
                                        </v-select>
                                        <input type="hidden" name="vehicle_type_id" :value="(vehicleTypeSelected==null)?null:vehicleTypeSelected.id">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <label class="control-label">@lang('menu.VehicleCategory')</label>
                                <div class="">
                                    <div class="">
                                    <v-select label="name" v-model="vehicleCategorySelected" :options="vehicleCategory">
                                        </v-select>
                                        <input type="hidden" name="vehicle_category_id" :value="(vehicleCategorySelected==null)?null:vehicleCategorySelected.id">
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="col-md-12">
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.PaletNumber') </label>
                                <div class="">
                                {{Form::text('palet_number',null,['class' => 'form-control','placeholder' => __('layout.PaletNumber'),'v-validate' =>'"required"','data-vv-as' => __('layout.PaletNumber')])}}
                                <span class="required">@{{ errors.first('palet_number') }}</span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label class="control-label ">@lang('layout.TankerNumber') </label>
                                <div class="">
                                {{Form::text('tanker_number',null,['class' => 'form-control','placeholder' => __('layout.TankerNumber'),'v-validate' =>'""','data-vv-as' => __('layout.TankerNumber')])}}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.SelectDriver')</label>
                                <v-select label="name" :options="drivers" placeholder="{{ __('layout.SelectDriver') }}" @search="MemberSearch" v-model="selected_main_driver"></v-select>
                                <input type="hidden" name="main_driver_id" :value="!selected_main_driver?null:selected_main_driver.id" >
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="col-md-6">
                                    <label class="control-label">@lang('layout.ExpenseAccount')</label>
                                <div class="">
                                    <v-select label="name" v-model="SelectedCost" :options="costAccount">
                                        </v-select>
                                        <input type="hidden" name="cost_id" :value="(SelectedCost==null)?null:SelectedCost.id">
                                </div>
                            </div>
                            <div class="col-md-6">
                                    <label class="control-label">@lang('layout.IncomeAccount')</label>
                                <div class="">
                                    <div class="">
                                    <v-select label="name" v-model="SelectedIncome" :options="incomeAccount">
                                        </v-select>
                                        <input type="hidden" name="income_id" :value="(SelectedIncome==null)?null:SelectedIncome.id">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                <div class="col-md-12 ">
                                        <label class=" control-label">@lang('layout.OpeningBalance')</label>
                                        <div>
                                        <label class="mt-checkbox mt-checkbox-outline">
                                        <input v-if="vehicle.opening_type == 'ok'" type="checkbox" checked="checked" @click="ChangeOpening" name="opening_type" value="ok" >
                                        <input v-if="vehicle.opening_type != 'ok'" type="checkbox" @click="ChangeOpening" name="opening_type" value="ok" >
                                        <span></span>
                                        </label>
                                        </div>
                                </div>
                            </div>
                            <div v-if="opening == true" class="col-md-5">
                            <label class="control-label">@lang('layout.EquityAccount')</label>
                                <div class="">
                                    <div class="">
                                    <v-select label="name" v-model="Selectedequity" :options="equityAccount">
                                        </v-select>
                                        <input type="hidden" name="equity_id" :value="(Selectedequity==null)?null:Selectedequity.id">
                                    </div>
                                </div>
                            </div>
                            <div v-if="opening == true" class="col-md-5">
                                <div class="">

                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.OpeningBalance')</label>

                                        <input type="number" name="opening" value="{{ $amount }}" class="form-control">
                                        <span class="required"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                <div class="col-md-12 ">
                                        <label class=" control-label">@lang('layout.ForeignVehicle')</label>
                                        <div>
                                        <label class="mt-checkbox mt-checkbox-outline">
                                        <input type="checkbox" @click="ChangeVehicleType" v-if="vehicle.foreign_type == 'ok'" checked="checked" name="foreign_type" value="ok" >
                                        <input v-if="vehicle.foreign_type != 'ok'" type="checkbox" @click="ChangeVehicleType" name="foreign_type" value="ok" >
                                        <span></span>
                                        </label>
                                        </div>
                                </div>
                            </div>
                            <div v-if="foreign_vehicle == true" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                <div class="">

                                    <div class="col-md-12">
                                        <label class="control-label">@lang('layout.SelectDriver')</label>
                                        <v-select label="name" :options="drivers" placeholder="{{ __('layout.SelectDriver') }}" @search="MemberSearch" v-model="selectedMember"></v-select>
                                        <input type="hidden" name="driver_id"
                                            v-validate="'required'" data-vv-as="@lang('layout.Driver')"
                                            :value="!selectedMember?null:selectedMember.id" required>
                                        <span class="required">@{{ errors.first('driver_id') }}</span>
                                    </div>
                                </div>
                            </div>
                        <div v-if="foreign_vehicle == true" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="">

                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select label="code" :options="currency"
                                            v-model="selected_currency"></v-select>
                                    <input type="hidden" name="currency"
                                        v-validate="'required'"
                                        data-vv-as="@lang('layout.Currency')"
                                        :value="selected_currency.code">
                                    <span class="required">@{{ errors.first('currency') }}</span>
                                </div>
                            </div>
                        </div>

                        <div v-if="foreign_vehicle == true" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="">

                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Rent')</label>
                                    {{Form::number('rent',null,['class' => 'form-control','placeholder' => __('layout.Rent'),'v-validate' =>'"required"','data-vv-as' => __('layout.Rent')])}}
                                    <span class="required">@{{ errors.first('rent') }}</span>
                                </div>
                            </div>
                        </div>
                        </div>
                        <div class="col-md-12">
                            <div class="col-md-3">
                                <label class="control-label ">@lang('layout.ChassisNumber') </label>
                                <div class="">
                                {{Form::text('chassis_number',null,['class' => 'form-control','placeholder' => __('layout.ChassisNumber'),'v-validate' =>'""','data-vv-as' => __('layout.ChassisNumber')])}}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label class="control-label ">@lang('layout.EngineNumber') </label>
                                <div class="">
                                {{Form::text('engine_number',null,['class' => 'form-control','placeholder' => __('layout.EngineNumber'),'v-validate' =>'""','data-vv-as' => __('layout.EngineNumber')])}}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.RoadActivity') </label>
                                <div class="">
                                {{Form::text('road_activity',null,['class' => 'form-control','placeholder' => __('layout.RoadActivity'),'v-validate' =>'""','data-vv-as' => __('layout.RoadActivity')])}}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.Phone') </label>
                                <div class="">
                                {{Form::text('phone',null,['class' => 'form-control','placeholder' => __('layout.Phone'),'v-validate' =>'""','data-vv-as' => __('layout.Phone')])}}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.GarlicLicenseNumber') </label>
                                <div class="">
                                {{Form::text('garlic_license_number',null,['class' => 'form-control','placeholder' => __('layout.GarlicLicenseNumber'),'v-validate' =>'""','data-vv-as' => __('layout.GarlicLicenseNumber')])}}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.GarlicLicenseIssueDate') </label>
                                <div class="">
                                {{Form::text('garlic_license_issue_date',null,['class' => 'form-control date','placeholder' => __('layout.GarlicLicenseIssueDate'),'v-validate' =>'""','data-vv-as' => __('layout.GarlicLicenseIssueDate')])}}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.GarlicLicenseEndDate') </label>
                                <div class="">
                                {{Form::text('garlic_license_end_date',null,['class' => 'form-control date','placeholder' => __('layout.GarlicLicenseEndDate'),'v-validate' =>'""','data-vv-as' => __('layout.GarlicLicenseEndDate')])}}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.LogBookStartDate') </label>
                                <div class="">
                                {{Form::text('log_book_start_date',null,['class' => 'form-control date','placeholder' => __('layout.LogBookStartDate'),'v-validate' =>'""','data-vv-as' => __('layout.LogBookStartDate')])}}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.LogBookEndDate') </label>
                                <div class="">
                                {{Form::text('log_book_end_date',null,['class' => 'form-control date','placeholder' => __('layout.LogBookEndDate'),'v-validate' =>'""','data-vv-as' => __('layout.LogBookEndDate')])}}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.BuildCompany') </label>
                                <div class="">
                                {{Form::text('build_company',null,['class' => 'form-control','placeholder' => __('layout.BuildCompany'),'v-validate' =>'""','data-vv-as' => __('layout.BuildCompany')])}}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.Model') </label>
                                <div class="">
                                {{Form::text('model',null,['class' => 'form-control','placeholder' => __('layout.Model'),'v-validate' =>'""','data-vv-as' => __('layout.Model')])}}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.BuildYear') </label>
                                <div class="">
                                {{Form::text('build_year',null,['class' => 'form-control','placeholder' => __('layout.BuildYear'),'v-validate' =>'""','data-vv-as' => __('layout.BuildYear')])}}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="control-label ">@lang('layout.Color') </label>
                                <div class="">
                                {{Form::text('color',null,['class' => 'form-control','placeholder' => __('layout.Color'),'v-validate' =>'""','data-vv-as' => __('layout.Color')])}}
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                                <div class="col-md-6">
                                
                                    <label class="control-label ">@lang('layout.Description')</label>
                                    <div class="">
                                    {{Form::textarea('description',null,['class' => 'form-control','rows' => '2'])}}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Photo')</label>
                                <div class="">
                                    {!! Form::file('image', null, array('placeholder' => 'Photo','class' => 'form-control')) !!}
                                </div>
                                
                                </div>
                        </div>
                    </div>
                </div>
                    <div class="form-actions">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-offset-3 col-md-9">
                                        <button type="button" class="btn green" @click="handleSubmit($event)" >@lang('layout.Submit')</button>
                                        <a href="{{route('service.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6"></div>
                        </div>
                    </div>
                    {{Form::close()}}
                    <!-- END FORM-->
                </div>
            </div>
        </div>

        @endsection
        @push('scripts')
        <script src="{{url('/vue/sweetalert1.min.js')}}"></script>

        <script src="{{url('/vue/vue-resource.js')}}"></script>


        <script>
          
          
            @if(App::getLocale())
            Vue.use(VeeValidate, {
                locale: '{{App::getLocale()}}',
            });
            @else
            Vue.use(VeeValidate, {
                locale: 'en',
            });
            @endif

            Vue.component('v-select', VueSelect.VueSelect);
			var currency = {!!$currency!!};
            var vu= new Vue({
                el: '#vehicle',
                data: {
                    type: 'inventoryPart',
                    vehicleTypeSelected:null,
                    vehicleCategorySelected:null,
                    vehicleTypes: {!! json_encode($vehicleTypes) !!},
                    vehicleCategory: {!! json_encode($vehicleCategory) !!},
                    SelectedIncome:null,
                    incomeAccount: {!! json_encode($income) !!},
                    SelectedCost:null,
                    costAccount: {!! json_encode($cost) !!},
                    Selectedequity:null,
                    equityAccount: {!! json_encode($equity) !!},
                    vehicle: {!! json_encode($vehicle) !!},
					foreign_vehicle: false,
					opening: false,
					drivers: [],
					selectedMember: null,
                    selected_main_driver: null,
					currency: currency,
					selected_currency: defaultCurrency(),
					
                },
				
				mounted: function () {
                    if (this.vehicle) {
                        this.vehicleTypeSelected=_.find(this.vehicleTypes,(v)=>v.id==this.vehicle.vehicle_type_id);
                        this.vehicleCategorySelected=_.find(this.vehicleCategory,(v)=>v.id==this.vehicle.vehicle_category_id);
                        this.SelectedIncome=_.find(this.incomeAccount,(v)=>v.id==this.vehicle.income_id);
                        this.SelectedCost=_.find(this.costAccount,(v)=>v.id==this.vehicle.expense_id);
                        if (this.vehicle.foreign_type == 'ok') {
                            this.foreign_vehicle = true;
                            this.selected_currency=_.find(this.currency,(v)=>v.code==this.vehicle.currency);
                            this.selectedMember={!!$selectedDriver!!};
                        }
                        if (this.vehicle.opening_type == 'ok') {
                            this.opening = true;
                            this.Selectedequity=_.find(this.equityAccount,(v)=>v.id==this.vehicle.equity_id);
                        }
                        @if($selectedMainDriver) 
                        this.selected_main_driver={!!$selectedMainDriver!!}; 
                        @endif
                    }
                },
            
                methods: {
                  
                   handleSubmit(e) {
                     this.$validator.validate().then(valid => {
                        if (valid) {
									// alert(e.target);
									regForm(e.target);
								}
							});
                 },
                 MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Driver'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu.drivers = [];
                            vu.drivers = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
				 ChangeVehicleType() {
                        if (vu.foreign_vehicle == false) {
							vu.foreign_vehicle = true;
                        }else{
							vu.foreign_vehicle = false;
						}
						// console.log(vu.foreign_vehicle);
                    },
                ChangeOpening() {
                        if (vu.opening == false) {
							vu.opening = true;
                        }else{
							vu.opening = false;
						}
						// console.log(vu.opening);
                    },
                onComplete: function () {
                    document.getElementById("account-form").submit()
				//                this.$emit('on-complete')
				//                alert('Yay. Done!');
				},
//                     addMeasure: function () {

// //                 var sendMeasure =  this.measureType;
// //                 sendMeasure.measure = this.measure;

//                         this.$http.post("{{route('measure.store')}}", {
//                             type: this.measureType,
//                             measure: this.measure
//                         }).then(function (success) {

//                             this.$http.get("{{route('inventory.create')}}").then(function (response) {


//                                 this.measures = response.body;
//                                 this.showModal = false;

// //
//                             }),
//                                 this.errorMessage = '';

// //
//                         }, function (response) {

//                             this.errorMessage = response.body

//                         });

//                     },

    submit: function () {
        swal({
            title: "Are you sure?",
            text: "",
            icon: "info",
            buttons: true,
            dangerMode: true,
        })
        .then((willDelete) => {
            if (willDelete) {
                document.getElementById("service-form").submit()

            } else {

            }
        });


    },

}
});

</script>


@endpush