@extends('layouts.factor-master')

@section('content')
<?php
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleReport')</h3>

@if($vehicleCategoryName || $MainDriverName  || $vehicleTypesName)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($vehicleCategoryName)
      <td>
        <span>@lang('menu.VehicleCategory')</span>: {{$vehicleCategoryName}}
      </td>
      @endif 
      @if($MainDriverName)
      <td>
        <span>@lang('layout.Driver')</span>: {{$MainDriverName}}
      </td>
      @endif

      @if($vehicleTypesName)
      <td>
        <span>@lang('layout.VehicleType')</span>: {{$vehicleTypesName}}
      </td>
      @endif
    </tr>
</table>
@endif


<br>
<table class="main-table">

<thead>
<tr class="bg">
<th>@lang('layout.Record') </th>
<th>@lang('layout.VehicleName')</th>
@if(!$vehicleTypesName)
<th>@lang('layout.VehicleType')</th>
@endif
@if(!$vehicleCategoryName)
<th>@lang('layout.VehicleCategory')</th>
@endif
<th>@lang('layout.PaletNumber')</th>
<th>@lang('layout.TankerNumber')</th>
@if($foreign_type == 'ok')
<th>@lang('layout.Driver')</th>
<th>@lang('layout.Currency')</th>
<th>@lang('layout.Rent')</th>
@endif
<th>@lang('layout.IncomeAccount')</th>
<th>@lang('layout.CostAccount')</th>
@if(!$MainDriverName)
<th>@lang('layout.Driver')</th>
@endif
<th>@lang('layout.User')</th>
</tr>
</thead>
<?php
$count = 1;
?>
@foreach($data AS $record)
<tr>

<td  class="center">{{$count++}}</td>
<td  class="center">{{$record->vehicle_name}}</td>
@if(!$vehicleTypesName)
<td  class="center">{{$record->vehicle_type}}</td>
@endif
@if(!$vehicleCategoryName)
<td  class="center">{{$record->vehicle_category}}</td>
@endif
<td  class="center">{{$record->palet_number}}</td>
<td  class="center">{{$record->tanker_number}}</td>
@if($foreign_type == 'ok')
<td  class="center">{{$record->driver}}</td>
<td  class="center">{{$record->currency}}</td>
<td  class="center">{{$record->rent}}</td>
@endif
<td  class="center">{{$record->income}}</td>
<td  class="center">{{$record->expense}}</td>
@if(!$MainDriverName)
<td  class="center">{{$record->mainDriver}}</td>
@endif 
<td  class="center">{{$record->user}}</td>
</tr>
@endforeach   
</table>

<table>
  <tr>

  </tr>
</table>



 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection