@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('inventory_transfer');
    $_name = true;

    ?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.LoadingReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            <th style="min-width: 100px">@lang('layout.Driver') </th>
			<th style="min-width: 100px">@lang('layout.Transporter_name') </th>
			<th style="min-width: 100px">@lang('layout.VehicleName')</th>
			<th style="min-width: 100px">@lang('layout.TankerNumber')</th>
			<th style="min-width: 100px">@lang('layout.DriverType')</th>
			<th style="min-width: 100px">@lang('layout.WayBillNumber') </th>
			<th style="min-width: 100px">@lang('layout.TransitNumber') </th>
			<th style="min-width: 100px">@lang('layout.SourcePlace') </th>
			<th style="min-width: 100px">@lang('layout.Destination') </th>
			<th style="min-width: 100px">@lang('layout.Discharge') </th>
			<th style="min-width: 100px">@lang('layout.LoadingDate') </th>
			<th style="min-width: 100px">@lang('layout.ItemName') </th>
			<th style="min-width: 100px">@lang('layout.Site') </th>
			<th style="min-width: 100px">@lang('layout.Measure') </th>
			<th>@lang('layout.Quantity') </th>
			<th>@lang('layout.Price') </th>
			<th>@lang('layout.Currency') </th>
			<th>@lang('layout.Rate') </th>
			<th>@lang('layout.TotalTransferFee') </th>
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)

            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->driver_name}}</td>
                <td class="center">{{$record->other_driver_name}}</td>
                <td class="center">{{$record->vehicle_name}}    @if($record->driver_type == 'OwnDriver') {{$record->vehicle_name}} @else {{$record->other_vehicle_name}} @endif</td>
                <td class="center">{{$record->tanker_name}}</td>
                <td class="center">{{__('layout.' . $record->driver_type)}}</td>
                <td class="center">{{$record->cmr_number}}</td>
                <td class="center">{{$record->transit_number}}</td>
                <td class="center">{{$record->source}}</td>
                <td class="center">{{$record->destination}}</td>
                <td class="center">
                @if($record->state == 'On')
                @lang('layout.Not')
                @else
                @lang('layout.yes')
                @endif
                </td>
                <td class="center">{{convertDate($record->loading_date)}}</td>
                <td class="center">{{$record->items}}</td>
                <td class="center">{{$record->site}}</td>
                <td class="center">{{$record->measure}}</td>
                <td class="center">{{$record->qty}}</td>
                <td class="center">{{$record->total_transfer_fee}}</td>
                <td class="center">{{$record->Currency}}</td>
                <td class="center">{{$record->Rate}}</td>
                <td class="center">{{$record->Total}}</td>
                
            </tr>

        @endforeach
    </table>


    
           <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection