@extends('layouts.app')

@section('content')

<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.ShowUser')
        </div>
    </div>
    <div class="portlet-body">
        <div class="row">    
            <div class="col-md-12">
                <!--begin: widget 1-2 -->
                <div class="mt-widget-1">
                    <div class="mt-icon">
                    </div>
                    <div class="mt-img">
                        @if($user->photo != Null)
                                
                                <img class=" twPc-avatarImg"
                                src="{!!url('/uploads/'.$user->photo)!!}"
                                style="width:120px; height:120px;">

                        @else
                        <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"
                                style="width:120px; height:120px;">
                        @endif
                        
                    </div>
                    <div class="mt-body">
                        <h3 class="mt-username">{{ $user->name }}</h3>
                        @if(!empty($user->roles))
                            @foreach($user->roles as $v)
                                <button type="button" class="btn btn-circle red btn-sm" style="margin-top: 15px">{{ $v->display_name  }}</button>
                            @endforeach
                        @endif



                        <div class="mt-stats">
                            <div class="btn-group btn-group btn-group-justified">
                            <table class="table">
                                <tr style="background-color: #d4d7dc;">
                                    <td>@lang('layout.UserType')</td>
                                    <td>@lang('layout.Email')</td>
                                    <td>@lang('layout.ResetPasswordEmail')</td>
                                </tr>
                                <tr class="active">
                                    <td>{{ $user->user_type }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>{{ $user->reset_password_email }}</td>
                                </tr> 
                            </table>
                            
                            @if($user->start_time || $user->end_time)
                            <table class="table">
                                <tr style="background-color: #d4d7dc;">
                                    <td colspan="2">@lang('layout.AccessTime')</td>
                                </tr>
                                <tr class="active">
                                    <td>{{ $user->start_time }}</td>
                                    <td>{{ $user->end_time }}</td>
                                </tr> 
                            </table>
                            @endif

                            @if($position || $user->signature)
                            <table class="table">
                                <thead>
                                <tr style="background-color: #d4d7dc;">
                                    
                                    @if($position)<td>@lang('menu.Position')</td>@endif
                                    @if($user->signature)<td>@lang('layout.Signature')</td>@endif
                                </tr>
                                </thead>
                                <tbody>
                                <tr class="active">
                                    @if($position)<td>{{ $position->name }}</td>@endif
                                    @if($user->signature)<td> <img alt="" class="img-circle" src="{!!url('/uploads/'.$user->signature)!!}"/> </td>@endif


                                </tr>
                                </tbody>
                            </table>
                            @endif
                            </div>
                          
                        </div>
                    </div>
                </div>
                <!--end: widget 1-2 -->
            </div>
            
        </div>
    </div>
</div>




@endsection