@extends('layouts.app')

@section('style')

<style>

.modal-container{
    width: 50% !important;
}
</style>
@endsection

@section('content')

<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'user_list'"
                  @closed="closeModal">

        <div slot="body">
        </div>
    </report-modal>
</div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">  @lang('layout.UserList')  </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('user-export')
                        <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @endpermission
                    @permission('user-create')
                    <a class="btn btn-success" href="{{ route('users.create') }}"><i class="fa fa-plus"></i> @lang('layout.AddNew') </a>
                    @endpermission
                    
                </div>

            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="usertable">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Email')</th>
                        <th>@lang('layout.ResetPasswordEmail')</th>
                        <th>@lang('layout.Role')</th>
            
                        <th>@lang('layout.UserType')</th>
                        <th>@lang('menu.Position')</th>
                        <th>@lang('layout.Language')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')

    <script>
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#usertable').DataTable({
                ajax: '{{route("users.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                    {data: 'name', name: 'name'},
                    {data: 'email', name: 'email'},
                    {data: 'reset_password_email', name: 'reset_password_email'},
                    {data: 'display_name', name: 'display_name'},
                    {data: 'user_type', name: 'user_type'},
                    {data: 'position_name', name: 'position_name'},
                    {data: 'lang', name: 'lang'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                   if(typeof data_table =='object')
                   {
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });

        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('users.report') !!}',
                excelRoute: '{!! route('users.report') !!}',
            },
           



            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    vm.$data.is_show = true;
                }
            }
        });

    </script>
@endpush