@extends('layouts.app')
@section('style')
    <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@stop


@section('content')

        <div class="portlet light bordered sale">
            <!-- BEGIN TAB PORTLET-->
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>&nbsp;
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.EditUser')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div  class="portlet-body">
                        {!! Form::model($user, ['method' => 'PATCH','route' => ['users.update', $user->id],'enctype'=>'multipart/form-data']) !!}
                        <div class="row"  id="app" v-cloak>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Name'):</label>
                                    {!! Form::text('name', null, array('placeholder' => __('layout.Name'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Email'):</label>
                                    {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.ResetPasswordEmail'):</label>
                                    {!! Form::text('reset_password_email', null, array('placeholder' => __('layout.ResetPasswordEmail'),'class' => 'form-control','v-validate' =>'"email"','data-vv-as' => __('layout.ResetPasswordEmail'))) !!}
                                    <span class="required">@{{ errors.first('reset_password_email') }}</span>
                                </div>
                            </div> 
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Language'):</label>
                                    {!! Form::select('lang', ['en' => 'English', 'fa' => 'Persian','pa' =>'Pashto','ru' =>'Russia'],null,array('class' => 'form-control'))!!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.CurrentPassword'):</label>
                                    {!! Form::password('currenct_password', array('placeholder' =>__('layout.CurrentPassword'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Password'):</label>
                                    {!! Form::password('password', array('placeholder' =>__('layout.Password'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.ConfirmPassword'):</label>
                                    {!! Form::password('confirm-password', array('placeholder' => __('layout.ConfirmPassword'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Role'):</label>
                                    {!! Form::select('roles[]', $roles,$userRole, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'role')) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('menu.Backups'):</label>
                                    {!! Form::select('backup', ['yes' => __('layout.BackupRestor'), 'noRestor' => __('layout.Backup'), 'no' => __('layout.Not')],null,array('class' => 'form-control'))!!}
                                    <span class="required"></span>

                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.UserType'):</label>
                                    {!! Form::select('user_type', ['admin' => __('layout.Admin'),'user' => __('layout.User')],null,array('class' => 'form-control'))!!}
                                    <span class="required"></span>

                                </div>
                            </div>
                        <div class="row col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.UserLockTime')(@lang('layout.Minute')):</label>
                                    {!! Form::select('lockout_time', [0 => __('layout.NoLock'),1 =>1,2=>2,3=>3,5=>5,10=>10,15=>15],null,array('class' => 'form-control'))!!}
                                    <span class="required"></span>

                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Site')</label>
                                    {!! Form::select('multy_site_id[]', $sites,$select_site, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'sites')) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    {!! Form::select('account_id[]', $bankExpense,$select_bankExpense, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'bankExpense')) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.AccessDays'):</label>
                                    {!! Form::select('days[]', $day,$sectedDay, array('class' => 'form-control','multiple','id'=>'days','v-validate' =>'"required"','data-vv-as' => __('layout.AccessDays'))) !!}
                                    <span class="required">@{{ errors.first('days[]') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="row col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                            
                            @if(systemConfig()[24] == 1)
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label">@lang('menu.FinancialClass')</label>
                                    {!! Form::select('financial_class_id[]', $financialClass,$select_financialClass, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'financialClass')) !!}
                                </div>
                            </div>
                            @endif
                            @if(getTelegramBot()=="true")
                            <div class="col-md-2">
                                <div class="form-group ">
                                    <label class="control-label">@lang('layout.TelegramID')</label>
                                    <v-select label="name" v-model="selected_telegram_id" :options="telegram_id"></v-select>
                                    <input type="hidden" name="telegram_id"  :value="(!selected_telegram_id)?null:selected_telegram_id.chat_id">
                                </div>
                            </div>
                            @endif

                            <div class="col-md-2">
                                <div class="form-group ">
                                    <label class="control-label">@lang('layout.Phone')</label>
                                    {!! Form::number('phone', null, array('placeholder' => __('layout.Phone'),'class' => 'form-control')) !!}
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                    <label class="control-label">@lang('menu.Position'):</label>
                                    <select v-model="select_pos" name="position_id" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <option v-for="pos in position" :value="pos.id">@{{pos.name}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2 text-center">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.InActiveChangeName'):</label>
                                    <input type="checkbox" v-model="changeStatusName" class="form-control" name="change_user_name" value="off">
                                </div>
                            </div>
                        </div>
                            <div class="row" style="margin-top: 30px;">
                                
                            <div class="col-md-3" v-show="select_pos">
                                <?php
                                    $signature = null;
                                    if($user && $user->signature!=null)
                                    {
                                        $signature =  url("/uploads/".$user->signature);
                                    } 
                                ?>
                                <div class="form-group"> 
                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                            <img src="{!!$signature!!}" alt="" /> </div>
                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                                        <div>
                                            <span class="btn default btn-file">
                                                <span class="fileinput-new">@lang('layout.Signature')</span>
                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                <input type="hidden" name="old_signature" value="{{$user->signature}}" > 
                                                {!! Form::file('signature', []) !!}</span>
                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                            <h3>@lang('layout.AccessTime')</h3>
                            <div>
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <label class="control-label">@lang('layout.On'): 
                                            <input type="checkbox" class="form-control" name="time" v-model="time" >
                                             </label>

                                    </div>
                                </div>
                                <div v-show="time">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Start'):</label>
                                            <div class="input-group">
                                                <input type="text" class="form-control timepicker timepicker-no-seconds" name="start_time" value="{{$user->start_time}}">
                                                <span class="input-group-btn">
                                                <button class="btn default" type="button">
                                                    <i class="fa fa-clock-o"></i>
                                                </button>
                                            </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">


                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.End'):</label>

                                            <div class="input-group">
                                                <input type="text" class="form-control timepicker timepicker-no-seconds" name="end_time" value="{{$user->end_time}}">
                                                <span class="input-group-btn">
                                                <button class="btn default" type="button">
                                                    <i class="fa fa-clock-o"></i>
                                                </button>
                                            </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-12 col-sm-12 col-md-12">
                                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                <a href="{{route('users.index')}}" class="btn default"><i
                                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                            </div>
                        </div>
                        {!! Form::close() !!}
                </div>

            </div>
@endsection

@push('scripts')

    @push('scripts')

    <script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
    <script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
    <script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

        <script>
            
            @if(App::getLocale())
            Vue.use(VeeValidate, {
                locale: '{{App::getLocale()}}',
            });
            @else
            Vue.use(VeeValidate, {
                locale: 'en',
            });
            @endif

            var checked  = {!! $checked !!};
            var position = {!!json_encode($position)!!};
            var telegram_id = {!!$telegram_id!!};
            var user={!! $user !!};
            new Vue({

                el: "#app",
                data: {
                    time: checked,
                    position: position,
                    select_pos: "{{$user->position_id}}",
                    telegram_id:telegram_id,
                    selected_telegram_id:null,
                    user:user,
                    changeStatusName: '',
                },
                mounted() {
                    if(this.user.telegram_id != null)
                    {
                        this.selected_telegram_id = _.find(this.telegram_id, (t) =>t.chat_id == this.user.telegram_id);
                    }
                    
                    this.changeStatusName = this.user.change_user_name;                    
                },  

            });
            
            $('#role').multiselect({
                placeholder: "@lang('layout.SelectRole')"
            });
            $('#days').multiselect({
                placeholder: "@lang('layout.SelectDays')"
            });
            $('#sites').multiselect({
                placeholder: "@lang('layout.SelectSite')",
            });
            $('#bankExpense').multiselect({
                placeholder: "@lang('layout.SelectAccount')",
            });
            $('#financialClass').multiselect({
                placeholder: "@lang('menu.FinancialClass')",
            });

        </script>
        
    @endpush