@extends('layouts.app')
@section('content')
@include('pays.modal')



<!-- app -->
<div id="app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="all_pay"/>
    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body">
            <div class="row">
                <div class="form-group">

                    <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selectedMember" label="name"
                            :options="member">
                        </v-select>
                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.member_id">
                </div>
                <div  class="col-md-6">
                    <label class="control-label ">@lang('layout.SelectType') </label>
                    <select name="type_name" id="" class="form-control">
                        <option  value="">@lang('layout.SelectType')</option>
                        <?php
                        if($paymentTypes !=null)
                        {
                            ?>
                            @foreach($paymentTypes as  $type)
                            <option  value="{{$type->type}}">{{$type->type}}</option>
                            @endforeach
                            <?php
                        }
                        ?>
                    </select>
                </div>

            </div>
        </div>
        <div class="row">
            <div class="form-group">
                <div class="col-md-12">
                    <div class="form-group">
                        <label class="control-label"> @lang('layout.Date')</label>
                        <div class="input-group">
                            <input class="form-control date" id="range-from-example" autocomplete="off">
                            <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                            <input type="hidden" id="range-from-example-alt" name="from_date">
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="range-to-example" autocomplete="off">
                            <input type="hidden" id="range-to-example-alt" name="to_date">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div slot="footer">
        <button type="submit" class="btn btn-success" @click="ok">
            @lang('layout.Submit')
        </button>
        <button type="button" class="btn btn-danger" @click="close">
            @lang('layout.Cancel')
        </button>

    </div>
</modal>
{{Form::close()}}
</div>
<!-- app -->
<div id="app2" v-cloak>
    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="all_pay"/>
    <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false" >
        <div slot="body">
            <div class="row">
                <div class="form-group">

                    <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selectedMember" label="name"
                        :options="member">
                    </v-select>
                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.member_id">
                </div>
                    <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectType') </label>
                        <select name="type_name" id="" class="form-control">
                            <option  value="">@lang('layout.SelectType')</option>
                            @foreach($paymentTypes as  $type)
                            <option  value="{{$type->type}}">{{$type->type}}</option>
                            @endforeach
                        </select>
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example2" autocomplete="off">
                                <!-- <input id="range-from-example" class="form-control " name="from_date"> -->
                                <input type="hidden" id="range-from-example-alt2" name="from_date">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example2" autocomplete="off">
                                <input type="hidden" id="range-to-example-alt2" name="to_date">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>

        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- BEGIN TAB PORTLET-->
<div class="row">
    <!-- app -->

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.PayList')</span>
            </div>
            <div class="tools"> </div>
            <div class="pull-right">
                @permission('customers-list')

                <button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i>@lang('layout.Excel')</button>

                <button type="button" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-file-pdf-o"></i>@lang('layout.PDF')</button>

                @endpermission
                @permission('customers-list')
                <a href="{{route('pay.create')}}">
                    <button id="sample_editable_1_new" class="btn green btn-sm btn-outline">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a>
                @endpermission 
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="sale">
                <thead>
                    <tr>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>


<!-- END TAB PORTLET-->
<iframe id="payframe" style="display: none;" ></iframe>
<!-- END CONTENT BODY -->
@stop

@push('scripts')
<script src="{{url('vue/select2/vue-select@2.2.0.js')}}"></script>
<script src="{{url('vue/select2/select2.js')}}"></script>
<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>


<script>
    Vue.component("v-select", VueSelect.VueSelect);
    @if (Session('payment_id'))
    printVoucher("{{Session('payment_id')}}")
    @endif
$(document).ready(function() {
            $('#sale').DataTable( {
                ajax:'{{route("pay.index")}}',
                order: [[ 6, "desc" ]],
                scrollCollapse: true,
                paging:         true,
                serverSide: true,
                columns: [  
                { data: 'Name',         name: 'Name' },
                { data: 'Account',      name: 'Account' },
                { data: 'currency',     name: 'currency' },
                { data: 'Rate',         name: 'Rate' },
                { data: 'Payment_type', name: 'Payment_type' },
                { data: 'Amount',       name: 'Amount' },
                { data: 'Date',         name: 'Date' },
                { data: 'Description',  name: 'Description' },
                { data: 'actions',      name: 'actions' },
                ]
            });
        });


    function printVoucher(id){
        document.getElementById("payframe").src ="{{url('printPayment')}}/"+id;

    }   


// register modal component
var Modal=Vue.component('modal', {
    template: '#modal-template',
    methods: {
        ok: function() {
            this.$emit('ok')
        }
    }
});

new Vue({
    el: '#app',
    data: {
        showModal: false,
        selectedMember:null,
            member:null,
    },
    methods:{
        ok:function(){
//alert('you clicked me');
this.showModal = !this.showModal;
},
close:function(e)
{
    this.showModal = !this.showModal;
},
editExample : function(){
     this.member={!!$member!!}
//Your other code that launches the modal
this.showModal= true;
this.$nextTick(function(){
    $(document).ready(function(){
        $(".date").persianDatepicker(modelDate());
    });
})
}
},
})
$('#print_pdf_all').on('click',function(e){
    $('#show-modal').click();
    e.preventDefault();
})
new Vue({
    el: '#app2',
    data: {
        showModal: false,
        selectedMember:null,
        member:null,
    },
    methods:{
        ok:function(){
//alert('you clicked me');
this.showModal = !this.showModal;
},
close:function(e)
{
    this.showModal = !this.showModal;
},
editExample2 : function(){
    this.member={!!$member!!}
//Your other code that launches the modal
this.showModal= true;
this.$nextTick(function(){
    $(document).ready(function(){
       $(".date").persianDatepicker(modelDate());
    });
})
}
},
})
$('#excell_all').on('click',function(e){
    $('#show-modal2').click();
    e.preventDefault();
})

</script>
@endpush
