@extends('layouts.app')
@section('style') 
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">

 <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css" />

        <link href="{{url('/assets/bootstrap-fileinput/profile-rtl.min.css')}}" rel="stylesheet" type="text/css" />
@stop
@section('content')
 

       <div class="row">
    <div class="col-md-12">
        <!-- BEGIN PROFILE SIDEBAR -->
        <div class="profile-sidebar">
            <!-- PORTLET MAIN -->
            <div class="portlet light profile-sidebar-portlet ">
                <!-- SIDEBAR USERPIC -->
                <div class="profile-userpic">
                    <img src="{!!url('/uploads/'.auth()->user()->photo)!!}" class="img-responsive" alt=""> </div>
                <!-- END SIDEBAR USERPIC -->
                <!-- SIDEBAR USER TITLE -->
                <div class="profile-usertitle">
                    <div class="profile-usertitle-name"> {{auth()->user()->name}} </div>
                    <div class="profile-usertitle-job">
                        @foreach($userRole as $role)
                        <li style="list-style-type: none;" >{{$role['display_name']}}</li>
                        @endforeach    
                        
                        {{-- @foreach($roles as $role)
                        <li style="list-style-type: none;" >{{$role}}</li>
                        @endforeach --}}
                    </div>
                </div>

                <!-- END SIDEBAR USER TITLE -->
               
                <!-- SIDEBAR MENU -->
               
            </div>

        </div>
        <!-- END BEGIN PROFILE SIDEBAR -->
        <!-- BEGIN PROFILE CONTENT -->
        <div class="profile-content">
            <div class="row">
                <div class="col-md-12">
                    <div class="portlet light ">
                        <div class="portlet-title tabbable-line">
                            <a href="#" class="btn btn-danger" style="float: left;">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                            <div class="caption caption-md">
                                <i class="icon-globe theme-font hide"></i>
                                <span class="caption-subject font-blue-madison bold uppercase">@lang('layout.ProfileAccount')</span>
                            </div>
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab_1_1" data-toggle="tab">@lang('layout.PersonalInfo')</a>
                                </li>
                                <li>
                                    <a href="#tab_1_2" data-toggle="tab">@lang('layout.ChangeImage')</a>
                                </li>
                                <li>
                                    <a href="#tab_1_3" data-toggle="tab">@lang('layout.ChangePassword')</a>
                                </li>
                                <li>
                                    <!-- <a href="#tab_1_4" data-toggle="tab">Privacy Settings</a> -->
                                </li>
                            </ul>
                        </div>
                        {!! Form::model($user, ['route' => ['profile.update' ,$user->id],'method' => 'PATCH','enctype'=>'multipart/form-data']) !!} 
                        <div class="portlet-body">
                            <div class="tab-content">
                                <!-- PERSONAL INFO TAB -->
                                <div class="tab-pane active" id="tab_1_1">
                                    @if(Auth()->user()->change_user_name == 'off')
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Name'):</label>
                                            {!! Form::text('name', null,  array('readonly', 'class' => 'form-control')) !!}
                                        </div>
                                        @else
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Name'):</label>
                                            {!! Form::text('name', null, array('class' => 'form-control')) !!}
                                        </div>
                                        @endif

                                        <div class="form-group">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.Language'):</label>
                                                {!! Form::select('lang', ['en' => 'English', 'fa' => 'Persian','pa' =>'Pashto','ru' =>'Russia'],null,array('class' => 'form-control'))!!}
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Email'):</label>
                                            {!! Form::text('email', null, array('class' => 'form-control')) !!}
                                        </div>
                                        
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.UserLockTime')(@lang('layout.Minute')):</label>
                                            {!! Form::select('lockout_time', [0 => __('layout.NoLock'),1 =>1,2=>2,3=>3,5=>5,10=>10,15=>15],null,array('class' => 'form-control'))!!}
                                        </div>

                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Phone'):</label>
                                            {!! Form::number('phone', null, array('class' => 'form-control')) !!}
                                        </div>
                                     
                                </div>
                                <!-- END PERSONAL INFO TAB -->

                                <?php
                                    $photo = null;
                                    if($user && $user->photo!=null)
                                    {
                                        $photo =  url("/uploads/".$user->photo);
                                    } 
                                ?>

                                <!-- CHANGE AVATAR TAB -->
                                <div class="tab-pane" id="tab_1_2">
                                   
                                        <div class="form-group">
                                            <div class="fileinput fileinput-new" data-provides="fileinput">
                                                <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                    <img src="{!!$photo!!}" alt="" /> </div>
                                                <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"> </div>
                                                <div>
                                                    <span class="btn default btn-file">
                                                        <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                        <!-- <input type="file" name="photo">  -->
                                                        {!! Form::file('photo', []) !!}</span>
                                                    <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        
                                </div>
                                <!-- END CHANGE AVATAR TAB -->
                                <!-- CHANGE PASSWORD TAB -->
                                <div class="tab-pane" id="tab_1_3">
                                        <!-- <div class="form-group">
                                            <label class="control-label">Current Password</label>
                                            <input type="password" class="form-control" /> </div> -->
                                            <div class="form-group ">
                                                <label class="control-label">@lang('layout.CurrentPassword'):</label>
                                                <div class="input-icon">
                                                <i class="fa fa-eye-slash" id="toggle_current_pass" style="color: green;cursor:pointer"></i>
                                                {!! Form::password('currenct_password', array('class' => 'form-control','id'=>'current_pass')) !!}
                                                </div>
                                            </div>


                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.Password'):</label>
                                            <div class="input-icon">
                                                <i class="fa fa-eye-slash" id="toggle_new_pass" style="color: green;cursor:pointer"></i>
                                            {!! Form::password('password', array('class' => 'form-control','id'=>'new_pass')) !!}
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label">@lang('layout.ConfirmPassword'):</label>
                                            <div class="input-icon">
                                                <i class="fa fa-eye-slash" id="toggle_confirm_pass" style="color: green;cursor:pointer"></i>
                                            {!! Form::password('confirm-password', array('class' => 'form-control','id'=>'confirm_pass')) !!}
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label class=" control-label">@lang('layout.LogOutOtherUsers')</label>
                                            <div>
                                                <label class="mt-checkbox mt-checkbox-outline">
                                                    <input type="checkbox" name="logOutOtherUsers" value="ok">
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
                                        <!-- <div class="margin-top-10">
                                            <a href="javascript:;" class="btn green"> Change Password </a>
                                            <a href="javascript:;" class="btn default"> Cancel </a>
                                        </div> -->
                                </div>
                                <!-- END CHANGE PASSWORD TAB -->
                                <!-- PRIVACY SETTINGS TAB -->
                                <div class="tab-pane" id="tab_1_4">

                                </div>
                                <div class="margiv-top-10 col-md-offset-6 col-md-12">
                                            <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>   
                                            
                                            <a href="{{url('/')}}" class="btn default"><i class="fa fa-mail-reply"></i>
                                                @lang('layout.Cancel')</a>
                                        </div>
                                <!-- END PRIVACY SETTINGS TAB -->
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
        <!-- END PROFILE CONTENT -->
    </div>
</div>
@endsection
 
@push('scripts')

<script src="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/bootstrap-fileinput/jquery.sparkline.min.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/bootstrap-fileinput/app.min.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/bootstrap-fileinput/profile.min.js')}}" type="text/javascript"></script> 
<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
<script>
    $('#role').multiselect({
        placeholder: 'Select Type'
    });



// Show/Hide password or change type password to text 
    $(document).ready(function(){
        
        //current Password
        $('#toggle_current_pass').click(function(){
            const current_pass = document.querySelector('#current_pass');
            const type = current_pass.getAttribute('type') === 'password'? 'text': 'password';
             current_pass.setAttribute('type',type);
            $(this).toggleClass('fa-eye fa-eye-slash')
        });        
        
        //New Password
        $('#toggle_new_pass').click(function(){
            const new_pass = document.querySelector('#new_pass');
            const type = new_pass.getAttribute('type') === 'password'? 'text': 'password';
             new_pass.setAttribute('type',type);
            $(this).toggleClass('fa-eye fa-eye-slash')
        });        
        
        //Confirm Password
        $('#toggle_confirm_pass').click(function(){
            const confirm_pass = document.querySelector('#confirm_pass');
            const type = confirm_pass.getAttribute('type') === 'password'? 'text': 'password';
             confirm_pass.setAttribute('type',type);
            $(this).toggleClass('fa-eye fa-eye-slash')
        });
    });

    

</script>
 
@endpush

