@extends('layouts.app')
 
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPay') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'pay.store','method' => 'POST','class' => 'form-horizontal','id'=>'pay-submit'])}}
                    <div class="form-body" id="app" v-cloak>
                        <div class="row">
                            <div class="col-md-8">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.SelectMember')</label>
                                        <v-select class="vue-select2" v-model="selectedMember" label="name"
                                                :options="{{$member}}">
                                        </v-select>
                                        <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Type')</label>
                                        <select class="form-control" name="type">
                                            <option disabled>@lang('layout.SelectType')</option>
                                            <option value="invoice">@lang('layout.Invoice')</option>
                                            <option value="bill">@lang('layout.Bill')</option>
                                            <option value="salary">@lang('layout.Salary')</option>
                                            <option value="loan">@lang('layout.Loan')</option>
                                            <option value="prepaid">@lang('layout.Prepaid')</option>
                                        </select>
                                    </div> 
                                </div>
                                <div class="row">
                                    <div class="col-md-6" style="padding: 0px;">
                                        <div :class="currency_len">
                                           <label class="control-label">@lang('layout.PaymentCurrency')</label>
                                            <select  class="form-control" v-model="selectedCurrency" v-on:change="setSize(selectedCurrency.code)">
                                                 <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/> 
                                        </div>
                                        <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                <div class="input-group">
                                                    <input  v-model="selected_rate" class="form-control"
                                                           type="number" step="any" min="0" @keyup="check_code(paymentCurrency.code)">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="currency_rate" :value="selected_rate">
                                            </div>
                                        </div> 
                                    </div> 
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="account_id">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                Account.name }}
                                            </option>
                                        </select>
                                    </div>
                                </div> 
                                <div class="row">  
                                    <div class="col-md-6">
                                        <div :class="pcurrency_len" style="padding-left: 0px;">
                                           <label class="control-label">@lang('layout.Currency')</label>

                                            <select  class="form-control" v-model="paymentCurrency" v-on:change="setPaymentSize(paymentCurrency.code)" id="testest">
                                                 <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="paymentCurrency" v-bind:value="paymentCurrency.code"/> 
                                        </div>
                                        <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'" style="padding-right: 0px;">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                                <div class="input-group">
                                                    <input  v-model="selected_rate1" class="form-control"
                                                           type="number" min="0" step="any" :readonly="selectedCurrency.code==paymentCurrency.code">
                                                    <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="rate" :value="selected_rate1">
                                            </div>
                                        </div> 
                                    </div>                                       
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Amount')</label>
                                        <div class="input-group">
                                            <input type="number" name="amount" class="form-control" v-model="amount" step="any" min="0">
                                            <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                        </div>
                                    </div> 
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                        <div class="input-group">
                                            <input type="number" :value="(amount*selected_rate1/(selected_rate)).toFixed(2)" class="form-control" min="0" step="any">
                                            <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                            
                                        </div>    
                                    
                                    </div>
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Discount')</label>
                                       {{Form::number('discount',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        {{Form::textarea('description',null,['class'=>'form-control','rows'=>'3'])}}
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="panel panel-default" style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Currency') </th>
                                                    <th>@lang('layout.Payable')</th>
                                                    <th>@lang('layout.Receivable')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                 <span v-if="selectedMember">
                                                   <tr v-for="summ in (selectedMember)?selectedMember.sumary:null" >
                                                      <td class="highlight">
                                                         @{{ summ.currency }}
                                                      </td>
                                                      <td class="hidden-xs"> @{{ summ.payable }}</td>
                                                      <td>
                                                          @{{summ.receivable }}
                                                      </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>                            
                            </div>
                        </div>
                    </div>
                    <div class="col-md-10">
                        <div class="row">
                            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                <button  type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                                <a href="{{route('pay.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                            </div>  
                        </div>
                    </div>
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
@push('scripts') 
 
<script> 
      
    new Vue({
        el: '#app',
        data: {
            

        },
        computed: {
           

        },
        methods: {
             
        }
    });   
</script>


@endpush
 