@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.AssemblyInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr style="background-color:#9998ee">
                        <th class="hidden-xs">
                            <i class="fa fa-bars"></i> @lang('layout.FormulaCode')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-briefcase"></i> @lang('layout.FormulaName')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.ItemName')
                        </th>

                        <th>
                            <i class="fa fa-dashboard"></i> @lang('layout.Measure')
                        </th>
                        <th>
                            <i class="fa fa-user"></i> @lang('layout.CreatedBy')
                        </th>

                        <th>
                            <i class="fa fa-sort-amount-desc"></i> @lang('layout.Min')
                        </th>
                        <th>
                            <i class="fa fa-signal"></i> @lang('layout.Max')
                        </th>
                    </tr>

                    </thead>
                    <tbody>
                    <tr>
                        <td class="hidden-xs"> {{$formulaInfo->code }}  </td>
                        <td class="hidden-xs"> {{$formulaInfo->formula_name}}  </td>
                        <td class="hidden-xs"> {{$formulaInfo->item_name}}  </td>
                        <td class="hidden-xs"> {{$formulaInfo->measure}}  </td>
                        <td class="hidden-xs"> {{$formulaInfo->creator}}  </td>
                        <td class="hidden-xs"> {{$formulaInfo->min }}  </td>
                        <td class="hidden-xs"> {{$formulaInfo->max }}  </td>
                    </tr>
                    <tr>
                        <td colspan="3">


                            <table>
                                <tr>
                                    <td><span><i class="fa fa-clock-o"></i> @lang('layout.Date')</span></td>
                                    <td><span>{{convertDate($formulaInfo->date)}}</span></td>
                                </tr>
                            </table>
                        </td>
                        <td colspan="4">
                            <span> <i class="fa fa-text-width"></i> @lang('layout.Description')</span>
                            <span>{{$formulaInfo->description}}</span>
                        </td>

                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="tabbable tabbable-tabdrop">

        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.AssemblyDetails')</a>
            </li>
            <li class="">
                <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Expense')</a>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="tab1">
                <div class="row">
                    <!-- app -->

                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                    <div class="portlet light bortdered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.AssemblyDetails')</span>
                            </div>
                            <div class="tools"></div>
                            <div class="pull-right">
                                @permission('discount-list')

                            <!-- button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>

                    <button type="button" class="btn btn-success" id="print_pdf_all"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')</button -->

                                @endpermission

                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="assembly">
                                    <thead>
                                    <tr>
                                        <th>@lang('layout.ItemName')</th>
                                        <th>@lang('layout.Quantity')</th>
                                        <th>@lang('layout.Measure')</th>
                                        <!-- <th>Action</th> -->
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- END EXAMPLE TABLE PORTLET-->
                </div>
            </div>
            <div class="tab-pane" id="tab2">
                <div class="portlet light bortdered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>
                            <span class="caption-subject bold uppercase">@lang('layout.Expense')</span>
                        </div>
                        <div class="tools"></div>
                        <div class="pull-right">


                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="expense">
                            <thead>
                            <tr>
                                <th>@lang('layout.Account')</th>
                                <th>@lang('layout.Amount')</th>
                                <th>@lang('layout.Description')</th>

                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        @endsection
        @push('scripts')

            <script>
                $(document).ready(function () {
                    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                    $('#assembly').DataTable({
                        ajax: {
                            url: '{{route("assembly.show",$formulaInfo->id)}}',
                            data: {type: 'assembly'}
                        },
                        serverSide: true,
                        responsive:'{{responsiveDataTable()}}',
                        pagingType:'{{paginationType()}}',
                        scrollCollapse: true,
                        paging: true,
                        columns: [
                            {data: 'item', name: 'items.name'},
                            {data: 'qut', name: 'qut', orderable: false, searchable: false},
                            {data: 'measure', name: 'measure', orderable: false, searchable: false},

                        ]

                    });
                });

                $(document).ready(function () {
                    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
                    $('#expense').DataTable({
                        ajax: {
                            url: '{{route("assembly.show",$formulaInfo->id)}}',
                            data: {type: 'expense'}
                        },
                        serverSide: true,
                        responsive:'{{responsiveDataTable()}}',
                        pagingType:'{{paginationType()}}',
                        scrollCollapse: true,
                        paging: true,
                        columns: [
                            {data: 'account', name: 'accounts.name'},
                            {data: 'amount', name: 'amount', orderable: false, searchable: false},
                            {data: 'description', name: 'assembly_expenses.description'},


                        ]

                    });
                });


            </script>


    @endpush
