@extends('layouts.app')


@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@stop

@section('content')
    <!-- BEGIN CONTENT BODY -->

    <!-- END PAGE BAR -->
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.UpdateAssembly')</span>
                    {{--<span class="caption-helper"></span>--}}
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>
            <div class="portlet-body form" id="assembaly" v-cloak>
                <!-- BEGIN FORM-->
                {{Form::open(['route' =>['unstructuredAssembly.update',$assembly->id],'method' => 'PATCH','class' => 'form-','id'=>'assembly-form'])}}
                <div class="form-body">
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label">@lang('layout.AssemblyName')</label>

                                {{Form::text('name',$assembly->formula_name,['class' => 'form-control','placeholder' =>__('layout.EnterAssemblyName')])}}
                                {{--<span class="help-block"> This is inline help </span>--}}

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label ">@lang('layout.AssemblyCode')</label>

                                {{Form::number('code',$assembly->code,['class' => 'form-control','min' =>'0','placeholder' =>__('layout.AssemblyCode')])}}

                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="control-label ">@lang('layout.Date')</label>
                                <input class="form-control date" value="{{$assembly->date}}" name="date"
                                       autocomplete="off" value="">
                            </div>
                        </div>

                        <div class="col-md-12">


                            <div class="col-md-8">
                                <div class="form-group">
                                    <label class="control-label col-md-4">@lang('layout.Description') </label>
                                    <textarea name="description" class="form-control" rows="2">
                                      {{$assembly->description}}
                                  </textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.FormulaItems') </li>
                    <div v-if="assemlby_items.length >0 " class="">
                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> #</th>
                                <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                <th style="width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(inventory,InventoryIndex) in assemlby_items" class="even">
                                <td class="td_one"><span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                                </td>
                                <td class="td_one">
                                    <v-select label="name" v-model="inventory.item" :options="temp_items"
                                              @click.native="addNew('inventory',InventoryIndex)"
                                              @search="onItemsSearch"></v-select>
                                    <input type="hidden" name="inventory_id[]"
                                           :value="(inventory.item==null)?null:inventory.item.id">
                                </td>
                                <td>
                                    <select v-if="(inventory.item !=null)"
                                            v-model="(inventory.item == null)?null:inventory.item.measure"
                                            class="form-control input_style"
                                            placeholder="Measure"

                                            required="required">

                                       <span v-if="inventory.item.measure_list !=null">
                                            <option v-if="(inventory.item !=null)"
                                                    v-for="measures in inventory.item.measure_list"
                                                    :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden" name="inventory_measure[]"
                                           :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                                </td>
                                <td>
                                    <input type="number" name="inventory_qty[]"
                                           v-model.number="(inventory.item==null)?null:inventory.item.qty"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                </td>

                                <td>

                                    <span v-on:click="deleteItem('inventory',InventoryIndex)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>


                                </td>
                            </tr>

                            </tbody>
                        </table>

                    </div>
                    <button v-if="assemlby_items.length <= 0 " type="button" class="btn default"
                            @click="addItems('inventory')">@lang('layout.AddItem')
                    </button>

                    <div class="form-section"></div>
                    <li class="list-group-item bg-green bg-font-green"> @lang('layout.AdjastmentItems') </li>

                    <div v-if="otherBuild.length >0 " class="">

                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                <th style="width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(inventory,InventoryIndex) in otherBuild" class="even">
                                <td class="td_one"><span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                                </td>
                                <td class="td_one">

                                    <v-select label="name" v-model="inventory.item" :options="temp_items"
                                              @click.native="addNew('otherBuilds',InventoryIndex)"
                                              @search="onItemsSearch"></v-select>
                                    <input type="hidden" name="other_build_id[]"
                                           :value="(inventory.item==null)?null:inventory.item.id">

                                </td>
                                <td>
                                    <select v-if="(inventory.item !=null)"
                                            v-model="(inventory.item == null)?null:inventory.item.measure"
                                            class="form-control input_style"
                                            placeholder="Measure"

                                            required="required">

                                       <span v-if="inventory.item.measure_list !=null">
                                            <option v-if="(inventory.item !=null)"
                                                    v-for="measures in inventory.item.measure_list"
                                                    :value="measures">@{{ measures.measure_name }}</option>
                                       </span>
                                    </select>

                                    <input type="hidden" name="other_build_measure[]"
                                           :value="(inventory.item==null)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                                </td>
                                <td>
                                    <input name="other_build_qty[]" class="form-control inpu-number-fild" :class=""
                                           type="number" v-model.number="(!inventory.item)?null:inventory.item.qty"
                                           placeholder="@lang('layout.Quantity')"/>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('otherBuild',InventoryIndex)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>

                                </td>
                            </tr>

                            </tbody>
                        </table>

                    </div>

                    <button v-if="otherBuild.length <= 0 " type="button" class="btn default"
                            @click="addItems('otherBuilds')">@lang('layout.AddItem')
                    </button>

                    <div v-if="type !='UnstructuredFormula'">
                        <!-- build expense -->

                        <div class="form-section"></div>
                    <!--   <li class="list-group-item bg-green bg-font-green"> @lang('layout.Expense') </li>

                    <div v-if="expenses.length >0 " class="">

                        <table id="table_content" class="table table-bordered">
                            <thead>
                            <tr>
                                <th class="text-center" style="width: 25px;"> # </th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ExpenseAccount')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Description')</th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                <th style="width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(expense,index) in expenses" class="even">
                                <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                </td>
                                <td class="td_one">
                                     
                                     <v-select label="name" v-model="expense.expense_account" :options="expense_account" @click.native="addNew('expense',index)" ></v-select>
                                      <input type="hidden" name="expense_id[]" :value="(expense.expense_account==null)?null:expense.expense_account.id">

                                </td>
                                <td>
                                  <input type="text" name="expense_description[]" v-model="expense.description" class="form-control" placeholder="@lang('layout.Description')">
                                </td>
                                <td >
                                    <input type="number" name="expense_amount[]" v-model="expense.amount" class="form-control" placeholder="@lang('layout.Amount')">
                                </td>
                                <td>
                                    <span  v-on:click="deleteItem('expense',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                </td>
                            </tr>

                            </tbody>
                        </table>

                    </div>

                    <button v-if="otherBuild.length <= 0 " type="button" class="btn default" @click="addItems('otherBuilds')">@lang('layout.AddItem')
                            </button> -->

                        <!-- end build expense -->
                    </div>
                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button" onclick="regForm(this)"
                                    class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('assembly.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>

                </div>
                {{Form::close()}}
            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')

    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script src="{{url('/vue/v-autocomplete.js')}}"></script>



    <script>
        Vue.component('v-select', VueSelect.VueSelect);


        Vue.use(VAutocomplete.default)
        Vue.use(VeeValidate);

        var formulaItems ={!! $formulaItems !!};
        var otherBuildItems = {!! $otherBuildItems !!};

        var selectedAssemblyExpense = {!! $selectedAssemblyExpense !!};
        var expense_account = {!! $expense_account !!};
        var canUpdate = '{{ $canUpdate}}';
        var assembly = {!! $assembly !!};
        var sales = new Vue({
            el: '#assembaly',
            data: {
                assembly: assembly,
                type: null,
                formulaItems: formulaItems,
                otherBuildItems: otherBuildItems,
                selected_assembly_item: null,
                assembly_item: [],
                canUpdate: canUpdate,
                btnDisable: true,
                temp_items: [],
                formula_items: [],
                assemlby_items: [],
                otherBuild: [],
                otherBuildIndex: 0,
                inventoryIndex: 0,
                inventoryItem: null,
                expense_account: expense_account,
                selectedAssemblyExpense: selectedAssemblyExpense,
                expenses: [],

            },

            computed: {
                isError: function () {
                    var isError = false;
                    if (this.selected_assembly_item == null || !this.selected_assembly_item) {
                        //isError=true;
                    }
                    return isError;
                }
            },
            mounted: function () {

                //begin formula item initialize

                for (var i = 0; i < this.formulaItems.length; i++) {
                    this.assemlby_items.push({item: this.formulaItems[i]});
                }
                for (var m = 4; m > this.formulaItems.length; m--) {
                    this.assemlby_items.push({item: null});
                }
                //// end formula item initialize

                //begin formula other item initialize

                for (var i = 0; i < this.otherBuildItems.length; i++) {
                    this.otherBuild.push({item: this.otherBuildItems[i]});
                }
                for (var m = 4; m > this.otherBuildItems.length; m--) {
                    this.otherBuild.push({item: null});
                }
                //// end formula other item initialize

                // begin assembly expense

                for (var i = 0; i < this.selectedAssemblyExpense.length; i++) {
                    this.expenses.push({
                        expense_account: this.selectedAssemblyExpense[i].selected_account,
                        description: this.selectedAssemblyExpense[i].description,
                        amount: this.selectedAssemblyExpense[i].amount
                    });

                }
                // end assembly expense
            },
            methods: {

                // begin item search
                onItemSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'items',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            sales.formula_items = [];
                            if (response.data.length > 0) {
                                sales.formula_items = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                }, getDebounceTime()),


                // end item search
                // items serarch method

                onItemsSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'items_search_assebley',
                            'type': 'assembaly',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            sales.temp_items = [];
                            if (response.data.length > 0) {
                                sales.temp_items = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                }, getDebounceTime()),
                // end item search
                // items serarch method

                addNew(type = null, index) {
                    this.temp_items = [];
                    if (type != null) {
                        if (type == 'inventory') {
                            if (this.assemlby_items[index + 1] == undefined) {
                                this.assemlby_items.push({item: null});
                            }
                        }
                        if (type == 'otherBuilds') {
                            if (this.otherBuild[index + 1] == undefined) {
                                this.otherBuild.push({item: null});
                            }
                        }
                        if (type == 'expense') {
                            if (this.expenses[index + 1] == undefined) {
                                this.expenses.push({expense_account: null, description: null, amount: null});
                            }
                        }


                    }

                },
                deleteItem(type = null, index) {
                    if (type != null && this.canUpdate == 'can') {

                        if (type == 'inventory') {

                            this.assemlby_items.splice(index, 1);


                        }
                        if (type == 'otherBuild') {
                            this.otherBuild.splice(index, 1);
                        }
                        if (type == 'expense') {
                            this.expenses.splice(index, 1);
                        }

                    }

                },

                addItems(type) {
                    if (type != null) {
                        if (type == "otherBuilds") {
                            this.temp_items = [];
                            this.otherBuild.push({item: null});
                        }
                        if (type == "inventory") {
                            this.temp_items = [];
                            this.assemlby_items.push({item: null});
                        }
                        if (type == "expense") {
                            this.expenses.push({item: null});
                        }
                    }

                },

            }
        });


    </script>


@endpush