@extends('layouts.app')


@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@stop

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewUnstructuredBuild')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="assembaly">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'unstructuredBuild.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="col-md-12">


                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.ItemName')</label>
                                    <v-select label="name" v-model="selected_assembly_item" :options="formula_items"
                                              @search="onItemSearchUnstructured"></v-select>

                                    <input type="hidden" name="item" v-validate="'required'"
                                           data-vv-as="@lang('layout.ItemName')"
                                           :value="(!selected_assembly_item)?null:selected_assembly_item.id">
                                    <span class="required">@{{ errors.first('item') }}</span>

                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label ">@lang('layout.SiteName')</label>

                                    <v-select placeholder=" @lang('layout.SelectSite')" label="name"
                                              v-model="selected_site" :options="site">

                                    </v-select>
                                    <input type="hidden" name="site" :value="(selected_site)?selected_site.id:null"
                                           v-validate="'required'" data-vv-as="@lang('layout.SiteName')">
                                    <span class="required">@{{ errors.first('site') }}</span>

                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label">@lang('layout.AssemblyCode') </label>
                                    <input type="number" name="number" value="{{$build->number}}" class="form-control">
                                    <span class="required">@{{ errors.first('number') }}</span>

                                </div>
                            </div>

                            <div class="col-md-12">

                                <div class="col-md-4">

                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.QuantityToBuild')</label>
                                        <input type="number" placeholder="@lang('layout.EnterQuantityToBuild')"
                                               name="total_build" class="form-control" v-validate="'required'"
                                               data-vv-as="@lang('layout.QuantityToBuild')">

                                        <span class="required">@{{ errors.first('build_qty') }}</span>

                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.Date')</label>
                                        <input class="form-control date" name="date" autocomplete="off" value="">
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Description') </label>
                                        <textarea name="description" class="form-control" rows="2">
                                        {{$build->description}}   
                                  </textarea>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>

                    <div class="col-md-12 col-lg-12" v-if="package_data">
                        <!-- begin package data loop -->

                        <div v-for="(p_data,p_index) in package_data" class="row"
                             style="border:3px solid white;margin-top: 10px;margin-bottom: 15px; box-shadow: 10px 10px 5px #aaaaaa ">
                            <span style="font-size: 30px; float: <?=(session()->get("system_direction") == "rtl") ? 'right' : 'left'?>"> @{{p_index+1}}</span>
                            <span style="font-size: 30px; float: <?=(session()->get("system_direction") == "rtl") ? 'left' : 'right'?>">
                                      <span v-if="p_index > 0" v-on:click="deleteItem('package',p_index)"><i
                                                  class="paddint-both glyphicon glyphicon-trash"></i></span>
                                </span>
                            <div class="col-md-12">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.ItemName')</label>
                                        <v-select label="assembly_name" v-model="p_data.item" :options="items"
                                                  @input="getItemFormula(this,p_index)"
                                                  @search="onItemSearch"></v-select>

                                        <input type="hidden" name="assembly_item[]"
                                               :value="(!p_data.item)?null:p_data.item.item_id">

                                    </div>
                                </div>

                                <div class="col-md-3" style="display: none">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.FormulaName')</label>
                                        <select class="form-control" v-model="p_data.selected_formula">
                                            <option v-for="formula in (p_data.formula_list==null)?null:p_data.formula_list"
                                                    :value="formula">@{{formula.code+'-'+formula.name}}
                                            </option>
                                        </select>
                                        <input type="hidden" name="formula[]"
                                               :value="(!p_data.selected_formula)?null:p_data.selected_formula.id">

                                    </div>
                                </div>


                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="control-label ">@lang('layout.FormulaQuantity')</label>

                                        <input type="number" placeholder="@lang('layout.FormulaQuantity')"
                                               name="build_qty[]" v-model="p_data.build_qty" class="form-control">

                                    </div>
                                </div>

                            </div>

                            <div class="col-md-12" v-if="p_data.selected_formula && p_data.selected_formula !=null">
                                <table id="table_content"
                                       class="table table-bordered table-responsive table-full-width">
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="width: 25px;"> #</th>
                                        <th class="text-center" style="min-width: 160px;"> @lang('layout.Item')</th>
                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                        <th class="text-center hidden-print"
                                            style="min-width: 80px;"> @lang('layout.Formula')</th>
                                        <th class="text-center hidden-print"
                                            style="min-width: 80px;"> @lang('layout.OnHand')</th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(item,index) in p_data.selected_formula.formula">
                                        <td class="td_one"><span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                        </td>
                                        <td class="">
                                            <input type="hidden" :name="'item_ids['+p_index+'][]'"
                                                   :value="(!item.item_id)?null:item.item_id">
                                            <span> @{{item.item_name}} </span>
                                        </td>
                                        <td>
                                            <select v-if="item" v-model="(!item)?null:item.measure"
                                                    @change="measureChange(index)" class="form-control input_style"
                                                    placeholder="Measure"

                                                    required="required" disabled>

                                                 <span v-if="item.measure_list !=null">
                                                      <option v-if="(item !=null)"
                                                              v-for="measures in item.measure_list"
                                                              :value="measures">@{{ measures.measure_name }}</option>
                                                 </span>
                                            </select>

                                            <input type="hidden" :name="'inventory_measure['+p_index+'][]'"
                                                   :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                                        </td>
                                        <td class="hidden-print">
                                            <input type="number" :name="'item_quantity['+p_index+'][]'"
                                                   v-model="(!item)?null:item.new_quantity">
                                        </td>
                                        <td class="hidden-print">
                                            <!-- <input readonly type="number"  :value="(!item)?null:item.on_hand"> -->
                                            <!-- <input readonly type="number"  :value="(!item)?null:item.on_hand">  -->
                                            <input readonly type="number"
                                                   :value="(!item)?null:buildItemQuantity(item.item_item_measure.measure_unit,item.measure.measure_unit,item.new_quantity,item.on_hand,p_data.build_qty)">
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <hr>

                            @lang('layout.AdjastmentItems')
                            <div v-if="p_data.selected_formula && p_data.selected_formula !=null" class=""
                                 id="printarea" style="overflow-x: scroll;">
                                <table id="table_content" class="table table-bordered">
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="width: 25px;"> #</th>
                                        <th class="text-center" style="min-width: 160px;"> @lang('layout.ItemName')</th>
                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="(item,index) in p_data.selected_formula.other_build">
                                        <td class="td_one"><span class="badge badge3 badge-success badge-roundless"> @{{index+1}} </span>
                                        </td>
                                        <td class="td_one">
                                            <input type="text" name="" :value="(!item.item_id)?null:item.item_name"
                                                   class="form-control" disabled="disabled">
                                            <input type="hidden" :name="'other_build_id['+p_index+'][]'"
                                                   :value="(!item.item_id)?null:item.item_id" class="form-control">


                                        </td>
                                        <td>
                                            <select v-if="item" v-model="(!item)?null:item.measure"
                                                    @change="measureChangeOtherBuild(index)"
                                                    class="form-control input_style"
                                                    placeholder="Measure"

                                                    required="required" disabled>

                                                           <span v-if="item.measure_list !=null">
                                                                <option v-if="(item !=null)"
                                                                        v-for="measures in item.measure_list"
                                                                        :value="measures">@{{ measures.measure_name }}</option>
                                                           </span>
                                            </select>


                                            <input type="hidden" :name="'other_build_measure['+p_index+'][]'"
                                                   :value="(!item)?null:(item.measure)?item.measure.measure_id:null">
                                        </td>


                                        <td>
                                            <input type="number" v-model="(!item)?null:item.new_quantity"
                                                   :name="'other_build_qty['+p_index+'][]'">
                                        </td>

                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        <!--  <button v-if="assemlby_items.length <= 0 " type="button" class="btn default" @click="addItems('inventory')">@lang('layout.AddItem')
                                </button> -->


                        </div>

                        <!-- end package data loop -->
                        <br>
                        <button type="button" @click="addNew('package',333)" class="btn btn-success"><i
                                    class="fa fa-plus"></i></button>
                    </div>

                </div>
                <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                    <button @click="handleSubmit($event)" type="button"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect);
        var site = {!! $site !!};
        var selectedSite = {!! $selectedSite !!};
        var build = {!! $build !!};
        var buildSelectedFormula = {!! $buildSelectedFormula !!};
        var buildSelectedItem = {!! $buildSelectedItem !!};
        var buildDetail = {!! $buildDetail !!};
        var otherBuildDetail = {!! $otherBuildDetail !!};
        var buildQty;
        var sales = new Vue({
            el: '#assembaly',
            data: {
                formula_items: [],
                selected_assembly_item: null,

                site: site,
                selected_site: null,
                selected_item: null,
                buildQty: null,
                assembly_item: [],
                temp_items: [],
                items: [],
                formula_list: [],
                selected_formula: null,
                package_data: [
                    {item: null, build_qty: null, formula_list: [], selected_formula: null},
                ],
            },

            computed: {
                buildQ: function () {
                    var min = null;
                    if (this.selected_formula) {
                        var rows = this.selected_formula.formula;

                        if (rows.length > 0) {
                            var temp = ((rows[0].new_quantity * rows[0].measure.measure_unit / rows[0].measure_unit));

                            //var temp_other_build=this.selected_formula.other_build;
                            min = rows[0].on_hand / temp;


                            for (var i = 1; i < rows.length; i++) {

                                var temp = ((rows[i].new_quantity * rows[i].measure.measure_unit / rows[i].measure_unit));
                                var result = (rows[i].on_hand * rows[i].item_item_measure.measure_unit) / (rows[i].measure.measure_unit);

                                if (result / temp < min) {
                                    min = result / temp;
                                }

                            }
                            min = min.toFixed(precision());

                        }

                    }
                    return min;
                },
                isError: function () {
                    var isError = false;

                    return isError;
                },
            },

            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },

                // calculate item price based on measure change
                measureChange(index) {

                    if (this.selected_formula) {

                        var item = this.selected_formula.formula[index];
                        var temp = ((item.quantity * item.measure_unit / item.measure.measure_unit));
                        result = Number.parseFloat(temp).toFixed(precision());

                        this.selected_formula.formula[index].new_quantity = result;


                    }
                },
                measureChangeOtherBuild(index) {
                    if (this.selected_formula) {
                        var item = this.selected_formula.other_build[index];
                        var temp = ((item.quantity * item.measure_unit / item.measure.measure_unit));
                        result = Number.parseFloat(temp).toFixed(precision());

                        this.selected_formula.other_build[index].new_quantity = result;
                    }
                },
                getItemFormula(e, index) {
                    if (this.package_data[index] && this.package_data[index].item != null) {
                        console.log('ttttttttttt', this.package_data[index].item)
                        this.formulaSearch(this.package_data[index].item.assembly_id, this, index);
                    }
                },
                onItemSearchUnstructured: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'items',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            sales.formula_items = [];
                            if (response.data.length > 0) {
                                sales.formula_items = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                }, getDebounceTime()),

                //ajax call to get items
                onItemSearch: _.debounce((search, loading) => {
                    sales.formula_list = [];
                    sales.selected_formula = null;
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'assemblyList',
                            keyword: search,
                            type: 'unstructuredBuild'
                        }
                    })
                        .then(function (response) {
                            sales.items = [];
                            if (response.data.length > 0) {

                                sales.items = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                }, getDebounceTime()),

                // end item search
                //ajax call to get formula
                formulaSearch(assembly_id, vm, index) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'item_formula',
                            assembly_id: assembly_id,
                            type: 'unstructuredBuild'
                        }
                    })
                        .then(function (response) {

                            if (response.data.length > 0) {
                                vm.package_data[index].formula_list = response.data;
                                vm.package_data[index].selected_formula = response.data[0];

                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                // end formula search
                // items serarch method
                onItemsSearch(search, loading) {
                    this.temp_items = [];
                    loading(true);
                    this.itemsSearch(search, loading, this);
                },
                itemsSearch(search, loading, vm) {
                    this.temp_items = [];
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'items_search_assebley',
                            'type': 'assembaly',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            if (response.data.length > 0) {

                                vm.temp_items = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },

                addNew(type = null, index) {
                    if (type != null) {
                        if (type == 'package') {
                            if (this.package_data[index + 1] == undefined) {
                                this.package_data.push({
                                    item: null,
                                    build_qty: null,
                                    formula_list: [],
                                    selected_formula: null
                                },);
                            }
                        }
                        if (type == 'otherBuilds') {
                            if (this.otherBuild[index + 1] == undefined) {
                                this.otherBuild.push({item: null});
                            }
                        }

                    }

                },
                deleteItem(type = null, index) {
                    if (type != null) {
                        if (type == 'package') {
                            this.package_data.splice(index, 1);
                        }
                        if (type == 'otherBuild') {
                            this.otherBuild.splice(index, 1);
                        }
                    }

                },

                addItems(type) {
                    if (type != null) {
                        if (type == "otherBuilds") {
                            this.temp_items = [];
                            this.otherBuild.push({item: null});
                        }
                        if (type == "inventory") {
                            this.temp_items = [];
                            this.assemlby_items.push({item: null});
                        }
                    }

                },
            }
        });


    </script>


@endpush
                