@extends('layouts.app')
@section('content')
    <div class="row">

    </div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">  @lang('layout.TransportList')  </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">

                    @permission('transport-list')
                    <a href="{{route('transport.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>

            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="transport">
                    <thead>
                    <tr>
                        {{--<th>#</th>--}}
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Fname')</th>
                        <th>@lang('layout.Phone')</th>
                        <th>@lang('layout.TazkeraNumber')</th>
                        <th>@lang('layout.PlateNumber')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#transport').DataTable({
                ajax: '{{route("transport.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    // {data: 'id', name: 'id'},
                    {data: 'name', name: 'transports.name'},
                    {data: 'fname', name: 'fname'},
                    {data: 'phone', name: 'transports.phone'},
                    {data: 'tazkira_number', name: 'transports.tazkira_number'},
                    {data: 'plate_number', name: 'transports.plate_number'},
                    {data: 'type', name: 'type', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });

    </script>
@endpush