@extends('layouts.app')
 @section('style')

@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewTransport') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'transport.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                  <div class="col-md-4">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Name')</label>
                                        {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.Name')])}}
                                    </div>
                                   </div>  

                                    <div class="col-md-4">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Fname')</label>
                                        {{Form::text('fname',null,['class' => 'form-control','placeholder' => __('layout.Fname')])}}
                                    </div>
                                   </div> 

                                   <div class="col-md-4">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Parent')</label>
                                        <v-select class="vue-select2" v-model="selectedTransport" label="name" @search="onTransportSearch" :options="transportList">
                                        </v-select>
                                        <input type="hidden" name="parent_id" v-model.number="(!selectedTransport)?null:selectedTransport.id">
                                    </div>
                                   </div>

                                   <div class="col-md-4">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Type')</label>
                                        <select class="form-control" name="type">
                                            <option value="">@lang('layout.SelectType')</option>
                                            <option value="Company">@lang('layout.Company')</option>
                                            <option value="Driver">@lang('layout.Driver')</option>
                                        </select>
                                    </div>
                                   </div> 

                                    

                                    <div class="col-md-4">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Phone')</label>
                                        {{Form::number('phone',null,['class' => 'form-control','placeholder' => __('layout.Phone')])}}
                                    </div>
                                   </div>

                                    <div class="col-md-4">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.PlateNumber')</label>
                                        {{Form::text('palate_number',null,['class' => 'form-control','placeholder' => __('layout.PlateNumber')])}}
                                    </div>
                                   </div>

                                    <div class="col-md-4">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.CarType')</label>
                                        {{Form::text('car_type',null,['class' => 'form-control','placeholder' => __('layout.CarType')])}}
                                    </div>
                                   </div>

                                  <div class="col-md-4">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.TazkeraNumber')</label>
                                        {{Form::text('tazkira_number',null,['class' => 'form-control','placeholder' => __('layout.TazkeraNumber')])}}
                                    </div>
                                   </div>

                                 <div class="col-md-4">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Commitment')</label>
                                        {{Form::textarea('commitment',null,['class' => 'form-control','rows' => '3','placeholder' => __('layout.Commitment')])}}
                                    </div>
                                   </div> 

                           
                            </div>
                        </div>
                    </div>       
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                        <a href="{{route('transport.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}

            </div>           
                 
            <!-- END FORM-->
        </div>
    </div> 

@endsection 
@push('scripts')
<script type="text/javascript">
    Vue.component("v-select", VueSelect.VueSelect);
    var vm = new Vue({
        el:'#app',
        data:{
            selectedTransport:null,
            transportList:[],

        },
        methods:{
             onTransportSearch(search,loading)
                   {  
                       loading(true);
                       this.searchTransport(search,loading,this);
                   },

       //ajax call to get items
       searchTransport(search,loading,vm)
       {
           axios.get("{{route('callMethod.search')}}",{
            params:{
                  method_name:'anyTable',
                  'search_column':'name',
                  'table_name':'transports',
                  keyword:search,
                }
           })
           .then(function (response)
           {
             this.transportList=[];
             if(response.data.length>0)
             {
                vm.transportList=response.data;
                console.log('data',vm.transportList);
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           })
       }
        }
    })
</script>

@endpush
 