@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'transport_company_all'"
                      @closed="closeModal">

            <div slot="body">
              

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off"
                                           name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off"
                                           name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>


    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.TransportCompanyList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('driver-export')
                    <span id="anchore-modal">
                           <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                              <i class="fa fa-print"></i>
                           </a>
                       </span>
                    @endpermission
                    @permission('driver-create')
                    <a href="{{route('transportCompany.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" width="100%" cellspacing="0" width="100%"
                       id="transportCompany">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.LicenseNumber')</th>
                        <th>@lang('layout.FullName') </th>
                        <th>@lang('layout.Email') </th>
                        <th>@lang('layout.Phone') </th>
                        <th>@lang('layout.RegDate') </th>
                        <th>@lang('layout.ExpireDate') </th>
                        <th>@lang('layout.User') </th>
                        <th>@lang('layout.Actions') </th>
                    </tr>
                    </thead>
                    <tfoot>

                    </tfoot>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
 

    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#transportCompany').DataTable({
                ajax: '{{route("transportCompany.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:2}}", "{{getRowOrder()}}"]],
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'license_number', name: 'license_number'},
                    {data: 'name', name: 'name'},
                    {data: 'email', name: 'email'},
                    {data: 'phone', name: 'phone'},
                    {data: 'reg_date', name: 'reg_date', searchable: false},
                    {data: 'expire_date', name: 'expire_date', searchable: false},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'account', orderable: false, searchable: false},


                ]
            });


        });
        Vue.component('v-select', VueSelect.VueSelect);


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

                selectedMember: null,
                memberlist: [],

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Vendor',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>


@endpush
