@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">

@stop


@section('content')
{{-- {{dd($transportCompany)}} --}}
    <div class="row">


        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Edit')  </span>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.TransportCompanyInformation') </span>
                </div>
              
            </div>
            <div class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::model($transportCompany,['method' => 'PATCH','route' => ['transportCompany.update',$transportCompany->id],'class'=>'form-horizontal','files'=> true])!!} 
               <div class="form-body">
                    <h3 class="form-section">@lang('layout.Information')</h3>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.FullName')</label>
                                <div class="col-md-9">
                                    {!! Form::text('name', null, array('placeholder' => __('layout.FullName'),'class' => 'form-control')) !!} 
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Code')</label>
                                <div class="col-md-9">
                                    {!! Form::text('code', $transportCompany->number, array('placeholder' => __('layout.Code'),'class' => 'form-control')) !!}  
                                </div>
                                
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                                <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Email')</label>
                                <div class="col-md-9">
                                    {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>  

                        <div class="col-md-6">
                                <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.LicenseNumber')</label>
                                <div class="col-md-9">
                                    {!! Form::text('license_number', null, array('placeholder' => __('layout.LicenseNumber'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                     
                    </div>
              
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.RegDate')</label>
                                <div class="col-md-9">
                                     <input type="text" id="reg_date" name="reg_date"  class="form-control date" autocomplete="off" value="{{convertDate($transportCompany->reg_date)}}">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.ExpireDate')</label>
                                <div class="col-md-9">
                                    <input type="text" id="date_of_birth" name="expire_date" class="form-control date" autocomplete="off" value="{{convertDate($transportCompany->expire_date)}}">
                                </div>
                            </div>
                        </div>
                       
                    </div>
                    <div class="row">
                        <div class="col-md-6" id="app2">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.LicenseType')</label>
                                <div class="col-md-9">
                                    <select  class="form-control" v-model="selected_license_type">
                                        <option  disabled="disabled">@lang('layout.SelectType')</option>
                                        <option v-for="li_type in license_type" :value="li_type">@{{ li_type.type }}</option>
                                    </select>
                                    <input type="hidden" name="license_type"
                                   :value="selected_license_type? selected_license_type.tag: null">
                                </div>
                            </div>
                        </div>


                         <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                <div class="col-md-9">
                                    {!! Form::file('photo', null, array('placeholder' => 'mm/dd/yy','class' => 'form-control')) !!}  
                                </div>
                            </div>
                        </div>
                    </div> 
       
                    <h3 class="form-section">@lang('layout.Address')</h3>
                       <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address')</label>
                                <div class="col-md-9">
                                  {!! Form::text('address1', $transportCompany->address, array('placeholder' =>__('layout.Address'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                         <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                <div class="col-md-9">
                                    {!! Form::text('phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                    </div>
               
                    <!--/row-->
                    <div class="row">
                          <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.City')</label>
                                <div class="col-md-9">
                                    {!! Form::text('city', null, array('placeholder' =>__('layout.City'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3 ">@lang('layout.Country')</label>
                                <div class="col-md-9">
                                   <select  class="form-control" name="country">
                                        <option value="Afghanistan">@lang('layout.Afghanistan')</option>
                                        <option value="Iran">@lang('layout.Iran')</option>
                                        <option value="Pakistan">@lang('layout.Pakistan')</option>
                                        <option value="China">@lang('layout.China')</option>
                                        <option value="us">@lang('layout.USA')</option>
                                        <option value="india">@lang('layout.India')</option>


                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/row-->
                    <br>
                    <br>
                       <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.PostCode')</label>
                                <div class="col-md-9">
                                  {!! Form::text('post_code', null, array('placeholder' =>__('layout.PostCode'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Branch')</label>
                                <div class="col-md-9">
                                    {!! Form::text('branch', null, array('placeholder' =>__('layout.Branch'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                         </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Description')</label>
                                <div class="col-md-9">
                                      <textarea type="textarea" rows="2" name="description"  class="form-control">{{$transportCompany->description}}</textarea>
                                </div>
                                                     
                            </div>
                        </div>
                    </div>
                 
                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                    <button type="button" class="btn default">@lang('layout.Cancel')</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>

@endsection
@push('scripts')

@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
script>
<script>
    $('#type').multiselect({
        placeholder: 'Select Type'
    });
     $('#job_title').multiselect({
        columns: 3,
        placeholder: 'Select Title',
    });
    Vue.component('v-select', VueSelect.VueSelect);
  
     var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var customer={!! $transportCompany!!};

  new Vue({
    el:'#app',
    data:{
        payable:payable,
        canUpdate:"{{$canUpdate}}",
        selected_payable:null,
        receivable:receivable,
        selected_receivable:null,
        customer:customer,
    },
    mounted:function(){
        for(var j=0;j<this.payable.length;j++)
          {
              if(this.payable[j].id==this.customer.payable_id)
              {
                 this.selected_payable=this.payable[j];
              }
               if(this.receivable[j].id==this.customer.receivable_id)
              {
                 this.selected_receivable=this.receivable[j];
              }
          }
    },

  });


    var gen = {!! json_encode($transportCompany) !!}
    // console.log('asdf',gen['membership'])
    new Vue({
        el:'#genderApp',
        data:{
            type: gen['gender'],
            members: gen['membership'],
        }
    });
    new Vue({
        el:'#countryApp',
        data:{
            country: gen['country'],
        }
    });



  new Vue({
    el:'#app2',
    data:{
         transport_license_type:"{{$license_type}}",

         license_type: [
                    {tag: 'local', type: '@lang("layout.Local")'},
                    {tag: 'international', type: '@lang("layout.International")'}
                    ],
                selected_license_type: null


    },

        created(){

               this.license_type.forEach((li_type) => {
                    if (li_type.tag == this.transport_license_type) {
                        this.selected_license_type = li_type;
                        return;
                    }
                })
    },

  });
</script>
@endpush