@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
 
@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewTransportCompany') </span>
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'transportCompany.store','method'=>'POST','class'=>'form-horizontal','files'=> true)) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <h3 class="form-section">@lang('layout.Information')</h3>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.FullName')</label>
                                <div class="col-md-9">
                                    {!! Form::text('name', null, array('placeholder' => __('layout.FullName'),'class' => 'form-control')) !!} 
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Code')</label>
                                <div class="col-md-9">
                                    {!! Form::text('code', $code, array('placeholder' => __('layout.Code'),'class' => 'form-control')) !!}  
                                </div>
                                
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                                <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Email')</label>
                                <div class="col-md-9">
                                    {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>  

                        <div class="col-md-6">
                                <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.LicenseNumber')</label>
                                <div class="col-md-9">
                                    {!! Form::text('license_number', null, array('placeholder' => __('layout.LicenseNumber'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                     
                    </div>
              
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.RegDate')</label>
                                <div class="col-md-9">
                                     <input type="text" id="reg_date" name="reg_date"  class="form-control date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.ExpireDate')</label>
                                <div class="col-md-9">
                                    <input type="text" id="date_of_birth" name="expire_date" class="form-control date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                       
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.LicenseType')</label>
                                <div class="col-md-9">
                                <select name="type" class="form-control">
                                  <option value="">@lang('layout.SelectType')</option>
                                  <option value="local">@lang('layout.Local')</option>
                                  <option value="international">@lang('layout.International')</option>
                                </select>
                                </div>
                            </div>
                        </div>
                         <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                <div class="col-md-9">
                                    {!! Form::file('photo', null, array('placeholder' => 'mm/dd/yy','class' => 'form-control')) !!}  
                                </div>
                            </div>
                        </div>
                    </div> 
       
                    <h3 class="form-section">@lang('layout.Address')</h3>
                       <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address')</label>
                                <div class="col-md-9">
                                  {!! Form::text('address1', null, array('placeholder' =>__('layout.Address'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                         <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                <div class="col-md-9">
                                    {!! Form::text('phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                    </div>
               
                    <!--/row-->
                    <div class="row">
                          <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.City')</label>
                                <div class="col-md-9">
                                    {!! Form::text('city', null, array('placeholder' =>__('layout.City'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3 ">@lang('layout.Country')</label>
                                <div class="col-md-9">
                                   <select  class="form-control" name="country">
                                        <option value="Afghanistan">@lang('layout.Afghanistan')</option>
                                        <option value="Iran">@lang('layout.Iran')</option>
                                        <option value="Pakistan">@lang('layout.Pakistan')</option>
                                        <option value="China">@lang('layout.China')</option>
                                        <option value="us">@lang('layout.USA')</option>
                                        <option value="india">@lang('layout.India')</option>


                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/row-->
                    <br>
                    <br>
                       <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.PostCode')</label>
                                <div class="col-md-9">
                                  {!! Form::text('post_code', null, array('placeholder' =>__('layout.PostCode'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Branch')</label>
                                <div class="col-md-9">
                                    {!! Form::text('branch', null, array('placeholder' =>__('layout.Branch'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                         </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Description')</label>
                                <div class="col-md-9">
                                      <textarea type="textarea" rows="2" name="description"  class="form-control"></textarea>
                                </div>
                                                     
                            </div>
                        </div>
                    </div>
                 
                </div>
                 
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    
                                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>

                                    <a href="{{route('vendor.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>
    </div>
@endsection
@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>

    Vue.component('v-select', VueSelect.VueSelect);

  
 

  new Vue({
    el:'#app',
    data:{
    },

    methods:{
        
    },
    mounted:function(){
  
    }
  });
</script>

 
@endpush