 @extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('salary_details');
$_date=in_array('date', $report);
$_name=in_array('name', $report);
$_phone=in_array('phone', $report);
$_currency=in_array('currency', $report);
$_amount=in_array('amount', $report);
?>


<h3 class="table-caption" style="text-align: center;">@lang('layout.TransportCompanyReport')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>
<table class="main-table">

  <thead>
    <tr class="bg">
    <td class="center" ><div>  @lang('layout.Record') </div></td>
    <td class="center" ><div> @lang('layout.LicenseNumber')</div></td>
    <td class="center" ><div> @lang('layout.RegDate') </div></td>
    <td class="center" ><div> @lang('layout.ExpireDate') </div></td>
    <td class="center" ><div> @lang('layout.Description')</div></td>
    <td class="center" ><div> @lang('layout.Name')</div></td>
    <td class="center" ><div> @lang('layout.Phone')</div></td>
    <td class="center" ><div> @lang('layout.Address')</div></td>
   
    <td class="center" ><div> @lang('layout.User')</div></td>
  </tr>
  </thead>
  <?php
  $count = 0;
  $total_home_currency=0;
  $currencies=[];
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->Amount;
  }
  ?>
    <td class="center">{{++$count}}</td>
    <td class="center">{{convertDate($record->regDate)}}</td>
    <td class="center">{{convertDate($record->expireDate)}}</td>
    <td class="center">{{$record->description}}</td>
    <td class="center">{{$record->license_number}}</td>
    <td class="center">{{$record->name}}</td>
    <td class="center">{{$record->phone}}</td>
    <td class="center">{{$record->address}}</td>
  
    <td class="center">{{$record->user}}</td>

  </tr>
  @endforeach
</table>





   <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection