@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
 @section('style')

@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewTransport') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'transfer.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <input type="hidden" name="sale_id" value="{{$sale_id}}">
                    <div class="form-body">
                        <div class="row">
                           <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                  <div class="col-md-4">
                                                        
                                                        <div class="col-md-12">
                                                          <label class="control-label">@lang('layout.Transporter')</label>
                                
                                                             <v-select  label="name" v-model="selected_transport" :options="transportList"  @search="onTransportChange" placeholder="@lang('layout.Transporter')"></v-select>
                                                             <input type="hidden" name="transport_id" :value="!selected_transport?null:selected_transport.id" required>

                                                        </div>
                                                  </div>
                                                    <div class="col-md-4">
                                                        
                                                        <div class="col-md-12">
                                                          <label class="control-label">@lang('layout.Transporter_name')</label>
                                                             <input type="test" name="transporter_name"  class="form-control">

                                                        </div>
                                                  </div>
                                                    <div class="col-md-4">
                                                        
                                                        <div class="col-md-12">
                                                          <label class="control-label">@lang('layout.Transporter_phone')</label>
                                                             <input type="test" name="transporter_phone"  class="form-control">

                                                        </div>
                                                  </div>
                                              
                                               
                                              </div>
                                              <div class="row">
                                                    <div class="col-md-4">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.TransferCode')</label>
                                                        {{Form::text('transfer_code',null,['class' => 'form-control','placeholder' => __('layout.TransferCode')])}}

                                                    </div>
                                                   </div> 
                                                   <div class="col-md-4">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.Receiver')</label>
                                                        {{Form::text('receiver',null,['class' => 'form-control','placeholder' => __('layout.Receiver')])}}
                                                    </div>
                                                   </div>
                                                  
                                                   <div class="col-md-4">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.Destination')</label>
                                                        {{Form::text('destination',null,['class' => 'form-control','placeholder' => __('layout.Destination')])}}
                                                    </div>
                                                   </div>
                                                     <div class="col-md-4">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.PlateNumber')</label>
                                                           <input type="text" name="plate_number" placeholder="@lang('layout.PlateNumber')" class="form-control">
                                                       
                                                    </div>
                                                   </div> 
                                                         <div class="col-md-4">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.CarType')</label>
                                                           <input type="text" name="car_type" placeholder="@lang('layout.CarType')" class="form-control">
                                                       
                                                    </div>
                                                   </div> 
                                                  <div class="col-md-4">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.Commitment')</label>
                                                       <textarea type="textarea" rows="2" name="commitment"  class="form-control"></textarea>
                                                    </div>
                                                   </div>
                                                    <div class="col-md-8">
                                                    <div class="col-md-12">
                                                        <label class="control-label ">@lang('layout.Description')</label>
                                                        {{Form::textarea('transfer_description',null,['class' => 'form-control','rows' => '3','placeholder' => __('layout.Description')])}}
                                                    </div>
                                                   </div>
                                              </div>

                                                  <div class="col-md-12" style="margin-top: 10px;">
                                                    <div class="col-md-12">
                                                      <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">
                                                        <thead>
                                                          <th style="min-width: 15px">
                                                            @lang('layout.ID')
                                                          </th>

                                                          <th style="min-width: 150px">@lang('layout.ProductName')
                                                          </th>

                                                          <th style="min-width: 150px">@lang('layout.Amount')
                                                          </th>

                                                          <th style="min-width: 150px">@lang('layout.Each')
                                                          </th>

                                                          <th style="min-width: 150px">@lang('layout.Total')
                                                          </th>

                                                        </thead>

                                                        <tbody>
                                                          <tr v-for="products in product">

                                                            <td class="highlight">
                                                              <div class="input-group">
                                                                <span>@{{products.id}}</span>
                                                              </div>
                                                            </td>

                                                            <td class="highlight">
                                                              <div class="input-group">
                                                                <label>@{{products.name}}</label>
                                                                <input type="hidden" name="product_id[]" :value="(!products)?null:products.id">
                                                              </div>

                                                            </td>

                                                            <td class="highlight">
                                                              <div class="input-group">
                                                                  <input class="form-control" type="number" name="transfer_amount[]" placeholder="@lang('layout.Amount')" v-model.number="(!products)?null:products.amount">
                                                              </div>
                                                            </td>

                                                            <td class="highlight">
                                                              <div class="input-group">
                                                                  <input class="form-control" type="number" name="transfer_cost[]" placeholder="@lang('layout.Each')" v-model.number="(!products)?null:products.eachCost">
                                                              </div>
                                                            </td>

                                                              <td class="highlight">
                                                              <div class="input-group">
                                                                  <input class="form-control" type="number" name="total_transfer[]" :value ="(!products)?null:products.amount*products.eachCost" placeholder="@lang('layout.Total')">
                                                              </div>
                                                            </td>
                                                          </tr>
                                                        </tbody>
                                                      </table>
                                                    </div>
                                                   </div>




                                                 
                                         </div>
                            
                                </div>
                        </div>
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                        <a href="{{route('transfer.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                    </div>       
                {!! Form::close() !!}

            </div>           
                 
            <!-- END FORM-->
        </div>
    </div> 

@endsection 
@push('scripts')
<script type="text/javascript">
    Vue.component("v-select", VueSelect.VueSelect);
    var product={!! json_encode($product) !!};
    var vm = new Vue({
        el:'#app',
        data:{
             selected_transport: null,
             transportList:[],
             product:product,

        },
        methods:{
             //// trasnfer
       onTransportChange(search,loading)
       {  
           loading(true);
           this.transportSearch(search,loading,this);
       },
       //ajax call to get items
       transportSearch(search,loading,vm)
       {
           axios.get("{{route('callMethod.search')}}",{
              params:{
              method_name:'getTransportInfo',
              keyword:search,
            }
           })
           .then(function (response)
           {
             this.transportList=[];
             if(response.data.length>0)
             {
              console.log('all',response.data);
                vm.transportList=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           })
       },
        }
    })
</script>

@endpush
 