@extends('layouts.app')
@section('style')

    <style>
        .v-select input[type=search], .v-select input[type=search]:focus {
            width: 50% !important;
        }

        .table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th {
            padding: 8px;
            padding: 4px 2px;
        }

        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
    </style>
@stop
@section('content')


    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase"> @lang('menu.ImportExcel') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                
                <div class="pull-right">
                </div>
            </div>
            <div class="row">
                <div class="col-lg-8">
                    <div class="tools text-center">
                        -------- <a href="{{url('/')}}/import_file/simpleImportTransferAndLoading.xlsx">
                           <button class="btn btn-success">
                           <i class="fa fa-download"></i>
                           @lang('layout.ImportExcelSample')
                           </button>
                        -------- </a>
                   </div>
                   <!-- BEGIN FORM-->
                   {{Form::open(['route'=>'transferAndLoadingImport.store','method'=>'POST','enctype'=>'multipart/form-data','class'=>'form-horizontal','id'=>'import-form'])}}
                   {{ csrf_field() }}
                       <div class="form-body">
                           <div class="col-md-12">
                               <div class="form-group" style="margin-top: 20px;">
                                   <label class="control-label col-md-5">@lang('layout.SelectFile') @lang('layout.Excel')
                                       :</label>
                                   <div class="col-md-7">
                                       {{Form::file('customer_file',null,['class' => 'form-control','placeholder' => __('layout.File')])}}
                                   </div>
                               </div>
                           </div>
                       </div>
                       <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin-top: 10px;">
                           <button type="button" onClick="sendFormData(this)" class="btn green">@lang('layout.Submit')</button>
                           <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')
                           </button>
                           <br/>
                           <br/>
                           <br/>
                           <br/>
                       </div>
                   {{Form::close()}}
                   <!-- end form -->
                </div>
                <div class="col-lg-4">
                    <ul class="text-danger">
                        <p class="text-danger">@lang('message.Info')</p>
                        <li class="text-danger">@lang('message.TipOne')</li>
                        <li class="text-danger">@lang('message.TipTwo')</li>
                        <li class="text-danger">@lang('message.TipThree')</li>
                    </ul>
                </div>
            </div>
            <div id="app" v-cloak>
                <h1 v-if="flag=='no'">@lang('layout.import_measure_msg')</h1>
                <div v-if="flag=='yes'" class="portlet-body form" style="margin-bottom:50%;">
                    
                    <div v-if="record.length>0">
                        <div style="overflow-x:scroll; width: 100%">
                            <!-- begint table -->
                            {{Form::open(['route'=>'fixedAssetManagementImport.store','method'=>'POST','class'=>'form-horizontal','enctype'=>'multipart/form-data','id'=>'import-form-second'])}}
                            {{csrf_field()}}
                            <div class="row">
                                <div class="col-md-12 col-md-12">
                                    <div class="col-md-12" style="height: 400px;">
                                        <table id="table_content" class="table table-bordered ">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th class="text-center" v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                    <th class="text-center" style="min-width: 220px">@lang('layout.Contract') </th>
                                                    <th class="text-center" style="min-width: 150px">@lang('layout.WagonNumber') </th>
                                                    <th class="text-center" style="min-width: 160px">@lang('layout.ItemName') </th>
                                                    <th class="text-center" style="min-width: 150px">@lang('layout.FromSite') </th>
                                                    <th class="text-center" style="min-width: 150px">@lang('layout.ToSite') </th>
                                                    <th class="text-center" style="min-width: 150px">@lang('layout.Quantity') </th>
                                                    <th class="text-center" style="min-width: 50px">@lang('layout.OnHand') </th>
                                                    <th class="text-center" style="min-width: 120px">@lang('layout.Measure') </th>
                                                    <th class="text-center" style="min-width: 160px">@lang('layout.Transporter_name') </th>
                                                    <!-- th v-if="driver_type == 'OwnDriver'" style="min-width: 100px">@lang('layout.TankerNumber') </th -->
                                                    <th class="text-center" style="min-width: 160px">@lang('layout.VehicleName')/@lang('layout.NumberWagon') </th>
                                                    <th class="text-center" style="min-width: 160px">@lang('layout.TankerNumber') </th>
                                                    {{-- <th v-if="driver_type == 'ForeignDriver1'" style="min-width: 160px">@lang('layout.Driver') </th>
                                                    <th v-if="driver_type == 'ForeignDriver1'" style="min-width: 160px">@lang('layout.VehicleName')/@lang('layout.NumberWagon') </th> --}}
                                                    <th class="text-center" style="min-width: 120px">@lang('layout.TransitNumber') </th>
                                                    <th class="text-center" style="min-width: 120px">@lang('layout.WayBillNumber') </th>
                                                    <th class="text-center" style="min-width: 120px">@lang('layout.SourcePlace') </th>
                                                    <th class="text-center" style="min-width: 120px">@lang('layout.Destination') </th>
                                                    <th class="text-center" style="min-width: 100px">@lang('layout.LoadingDate') </th>
                                                    <th class="text-center" style="min-width: 120px">@lang('layout.RentQuantity') </th>
                                                    <th class="text-center" style="min-width: 120px">@lang('layout.Price') </th>
                                                    <th class="text-center" style="min-width: 100px">@lang('layout.Currency') </th>
                                                    <th class="text-center" style="min-width: 120px">@lang('layout.Rate') </th>
                                                    <th class="text-center" style="min-width: 120px">@lang('layout.Rent') </th>
                                                    <th class="text-center" style="min-width: 120px">@lang('layout.Rate') </th>
                                                    <th class="text-center" style="min-width: 50px">@lang('layout.TotalTransferFee') </th>
                                                </tr>
                                            </thead>
                                            <tr v-for="(obj,index) in record">
                                                <td class="td_one">
                                                    <span class="badge badge3 badge-success badge-roundless">@{{index+1}} </span>
                                                </td>
                                                <td class="td_one">
                                                    <select class="form-control input-style" v-model="obj.category_id"
                                                    required="required" :name="'category_id['+index+']'" >
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option v-if="item_category" v-for="category in (item_category?item_category:null)" :value="category.id">
                                                            @{{category.name}}
                                                        </option>
                                                    </select> 
                                                </td>
                                                <td class="td_one">
                                                    <v-select label="company_name" v-model="obj.selectedContract" :options="contract" @input="contractChange(index), contractWagon(index)"></v-select>
                                                    {{-- <input :value="(!item.contract)?null:item.contract.company_name" style="width: 0px; height: 0px; padding: 0px; opacity: 0;"> --}}
                                                    <input type="hidden" :name="'contract_id['+index+']'" :value="(!contract)?null:contract.id">
                                                </td>
                                                <td> 
                                                    <v-select label="name" v-model="obj.wagon" :options="obj.wagonList" @input="contractChange(index)"></v-select>
                                                    <input type="hidden"  :name="'wagon_number['+index+']'" :value="(!obj.wagon)?null:obj.wagon.name">
                                                </td>
                                                <td class="highlight">
                                                    <v-select label="name" @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?onItemload(index):''"
                                                    v-model="obj.inventory" :options="obj.items_list" @search="onItemSearch"></v-select>
                                                    {{-- <input :value="(!item.inventory)?null:item.inventory.name" style="width: 0px; height: 0px; padding: 0px; opacity: 0;"> --}}
                                                    <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!obj.item)?null:obj.item.id">
                                                </td>
                                                <td class="td_one">
                                                </td>
                                                <td class="td_one">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'quantity['+index+']'" v-model="obj.quantity">                                                
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'po_number['+index+']'" v-model="obj.category_id">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'serial_number['+index+']'" v-model="obj.serial_number">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'location['+index+']'" v-model="obj.location">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control date" :name="'date_depreciation['+index+']'" autocomplete="off" >
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'cost['+index+']'" v-model="obj.cost">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'transite_number['+index+']'" v-model="obj.transite_number">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'cmr_number['+index+']'" autocomplete="off" v-model="obj.cmr_number">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'source['+index+']'" autocomplete="off" v-model="obj.source">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'distination['+index+']'" autocomplete="off" v-model="obj.distination">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control date" :name="'date['+index+']'" autocomplete="off" v-model="obj.date">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'rent_tonazh['+index+']'" autocomplete="off" v-model="obj.rent_tonazh">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'price['+index+']'" autocomplete="off" v-model="obj.price">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'distination['+index+']'" autocomplete="off">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'rate['+index+']'" autocomplete="off" v-model="obj.rate">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'rent['+index+']'" autocomplete="off" v-model="obj.rent">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'distination['+index+']'" autocomplete="off">
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'distination['+index+']'" autocomplete="off">
                                                </td> 
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <!-- end table -->
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                            <button type="button" @click="sendFormData(this)" class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
                        </div>
                        {{Form::close()}}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        Vue.component('v-select', VueSelect.VueSelect);
        var datas ={!! $data !!};
        var inventory_category = {!! $inventory_category !!};
        var site = {!! $site !!};
        var driver = {!! $driver !!};
        var currency = {!! $currency !!};
        let homeCurrency = {!! json_encode(getHomeCurrency()) !!};
        var otherIncome = {!! $otherIncome !!};
        var contract = {!! $contract !!};
        var wagon = {!! $wagon !!};
       var v =  new Vue({ 
            el: '#app',
            data: {
                flag: 'yes',
                record: [],
                item_category: inventory_category,
                contract: contract,
                wagonList:wagon, 
                wagon:null,
                item: null,
                inventory:null, 
                // currency_list: currency,
                items_list:[],
                // category_list: null,
                // category_list: Category,
                // currency_list: currency,
                // measure_list: currency,
                // inventories: [
                //     {item: null,inventory:null, items_list:[], loading:null, wagonList:wagon, wagon:null, load_type:'OverLoad', load_quantity:null, fined_quantity:null, item_category: null, driver: null,vehicle:null, currency: homeCurrency, driver_type: 'OwnDriver', tanker: null,currency_list:currency,contract:null},
                // ],
                fromSite: site,
                site_q: [],
                type: 'new',
                ccc: null,
                depreciation_type: 'straightLineMethod',
                depreciation_duration_type: 'yearly',
            },
            mounted(){
                for (var i = 0; i < datas.length; i++) {
                    // if(!datas[i].type){
                    //     datas[i].type = 'new';
                    // }
                    // datas[i].selectedContract = null;
                    if (datas[i].contract_id && this.contract) {
                        this.ccc = _.find(this.contract, (s) => s.id == datas[i].contract_id);
                        datas[i].selectedContract = _.find(this.contract, (s) => s.id == datas[i].contract_id);
                    }
                    if (datas[i].from_site_id && this.fromSite) {
                        this.ccc = _.find(this.fromSite, (s) => s.id == datas[i].from_site_id);
                        datas[i].selectedFromSite = _.find(this.fromSite, (s) => s.id == datas[i].from_site_id);
                    }    
                    // selectedFromSite
                }
                this.record = datas;
             },
            methods: {
                setNewRate(index = null) {
                    // if (this.record[index].currency) {
                    //     this.record[index].currency.rate = this.$refs.rate[index].value;
                    // }
                    // if (record[index].type) {
                    //         this.type = record[index].type;
                    //     }   
                },
                contractWagon(index) {
                        if (v.record[index]['contract']) {
                            v.record[index]['wagon'] = null;
                            v.record[index]['wagon_number_id'] = [];
                            // console.log(2222,v.record[index]['contract'], this.wagon)
                            v.record[index]['wagon_number_id'] = wagon.filter((wagonR) => {
                                return v.record[index]['contract_id'] == wagonR.contract_id;
                            });
                        }
                    },
                contractChange(index) {
                    console.log('fffffff',v.record[index]);
                        v.selected_index = index;
                        if (v.record[index]['contract_id'] != null) {
                        v.record[index]['inventory'] = null;
                        v.record[index]['item'] = null;
                        let contract_id = v.record[index]['contract_id'];
                        let inventory_category_id = (v.record[index]['item_category'] != undefined) ? v.record[index]['item_category'].id : '';
                        let wagon_number = (v.record[index]['wagon'])?v.record[index]['wagon'].name:null;
                        // console.log(333, wagon_number, contract_id);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                wagon_number: wagon_number,
                                contract_id: contract_id
                            }
                        })
                            .then(function (response) {
                                v.record[index]['items_list'] = [];
                                // console.log('dddddddddddddd',response)
                                if (response.data.length > 0) {
                                    v.record[index]['items_list'] = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },
                onItemSearch: _.debounce((search, loading) => {
                loading(true);
                let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                let contract_id = (v.inventories[v.selected_index]['contract'] != undefined) ? v.inventories[v.selected_index]['contract'].id : '';
                let wagon_number = (v.inventories[v.selected_index]['wagon'] != undefined) ? v.inventories[v.selected_index]['wagon'].id : '';
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        member_id: v.member_id,
                        method_name: 'itemesSearchSale',
                        keyword: search,
                        inventory_category_id: inventory_category_id,
                        contract_id: contract_id,
                        wagon_number: wagon_number,
                    }
                })
                    .then(function (response) {
                        v.inventories[v.selected_index]['items_list'] = [];
                        if (response.data.length > 0) {
                            v.inventories[v.selected_index]['items_list'] = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                }, getDebounceTime()),


                changeCost(e, index) {
                    this.record[index].cost = e.event.target.value;
                    return true;
                },
                changeAsset(e, index) {
                    this.record[index].asset = e.event.target.value;
                    return true;
                },
                sendFormData(e) {
                    var el = $(e);
                    var form = el.parents('form').get(0);
                    var data = $('#import-form').serialize();
                    console.log('test 22', data);
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        icon: 'warning',
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    }).then((wichButton) => {
                        if (wichButton) {
                            //form.submit();
                            document.getElementById('import-form-second').submit();
                            return true;
                        }
                        return false;
                    });
                }
            },
            created: function () {
                console.log('ssssss', this.flag);
                for (var i = 0; i < this.record.length; i++) {
                    // for(var m=0;m<this.record[i].income_list.length;m++)
                    // {
                    //     console.log('ww',this.record[i].income_list[m].name);
                    // }
                }
            }
        });
        function sendFormData(e) {
            var el = $(e);
            var form = el.parents('form').get(0);
            var data = $('#import-form').serialize();
            console.log('test 22', data);
            swal({
                title: "@lang('layout.AreYouSure?')",
                icon: 'warning',
                buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                dangerMode: true,
            }).then((wichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            });
        }
        // to send inventory data
        function sendData(element) {
            e = $(e);
            var form = e.parents('form').get(0);
            swal({
                'title': "@lang('layout.AreYouSure?')",
                'icon': 'dander',
                'buttons': ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                danderMode: true
            }).then((whichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            })
        }
        // end inventory data
    </script>
@endpush