@extends('layouts.app')

@section('style')

    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />

    <style>
        .modal-container {
            width: 60% !important;
        }
    </style>
@stop
@section('content')
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'employee_assessment'"
        @closed="closeModal">

        <div slot="body">

            <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">

                    <ul class="nav nav-tabs">

                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        {{-- <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li> --}}
                        @endpermission
                        @endif
                    </ul>

                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row">
                                       
                                         
                                    </div>
                                    <div class="row">
                                        <div class="form-group">
                                           
                                            <div class="col-md-12" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input type="hidden" name="id" value="{{$id}}">
                                                        <input class="form-control date" id="range-from-example"
                                                            v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example"
                                                            v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="employee_leaves_index">


                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>


                                        
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div> --}}

                    </div>
                </div>
            </div>


        </div>
    </report-modal>
</div>


<div id="laboratory-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
        v-if="is_show" 
        :value-type="'laboratory_Tests'"
        @closed="closeModal">

        <div slot="body">
             <input type="hidden" name="id" value="{{$transferAndLoading->id}}"/>

             <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label">@lang('layout.SelectType')</label>

                        <select class="form-control" name="report_type">
                            <option value="">@lang('layout.SelectType')</option>
                            <option value="general">@lang('layout.Details')</option>

                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                       autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                       autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </report-modal>
</div>

<div id="weighbridge-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
        v-if="is_show" 
        :value-type="'weighbridge'"
        @closed="closeModal">

        <div slot="body">
             <input type="hidden" name="id" value="{{$transferAndLoading->id}}"/>

             <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label">@lang('layout.SelectType')</label>

                        <select class="form-control" name="report_type">
                            <option value="">@lang('layout.SelectType')</option>
                            <option value="details">@lang('layout.Details')</option>

                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                       autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                       autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </report-modal>
</div>

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption"><i
                        class=""></i>@lang('layout.TransferAndLoadingDetail')

            </div>
            <div class="tools"><a
                        href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-
                   original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table
                        class="table table-striped table-bordered table-advance table-hover">
                    <thead>

                    <tr>
                        <th> @lang('layout.ID')</th>
                        <th> @lang('layout.ReferenceNumber')</th>
                        <th> @lang('layout.Type')</th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th>@lang('layout.DeliveryDate')</th>
                        <th><i class="fa fa-signal"></i> @lang('layout.Description')</th>


                    </tr>

                    </thead>
                    <tbody>

                    <tr>
                        <td class=""> {{ $transferAndLoading->id}}  </td>
                        <td class=""> {{ $transferAndLoading->ref_no}}  </td>
                        <td class=""> {{ __('layout.'.ucfirst($transferAndLoading->type))}}  </td>
                        <td class=""> {{convertDate($transferAndLoading->date)}}  </td>
                        <td class=""> {{convertDate($transferAndLoading->delivery_date)}}  </td>
                        <td class=""> {{ $transferAndLoading->description}}  </td>


                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div class="row">


        <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.TransferAndLoadingDetail')</a>
                </li>
                <li class="">
                    <a href="#tab3" data-toggle="tab" id="tab_adjustment">@lang('layout.AdjustmentDetails')</a>
                </li>
                <li class="">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
                @if(getFlour()=="true")
                <li class="">
                    <a href="#tab4" data-toggle="tab" id="laboratory_id">@lang('menu.LaboratoryTest')</a>
                </li>
                <li class="">
                    <a href="#tab5" data-toggle="tab" id="weighbridge_id">@lang('layout.Weighbridge')</a>
                </li>
                @endif
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.InventoryDetails')</span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">
                                    </div>
                                    <div class="actions">
                                        <span id="anchore-modal">
                                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                <i class="fa fa-print"></i>
                                            </a>
                                        </span>
                                </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover"
                                           id="inventory_transfer_detail">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.Type')</th>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Measure')</th>
                                            <th>@lang('layout.SelectedMeasure')</th>
                                            <th>@lang('layout.FactorNumber')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.FromSite')</th>
                                            <th>@lang('layout.ToSite')</th>
                                            <th>@lang('layout.SourcePlace')</th>
                                            <th>@lang('layout.Destination')</th>
                                            <th>@lang('layout.Driver')</th>
                                            <th>@lang('layout.VehicleName')/@lang('layout.NumberWagon')</th>
                                            <th>@lang('layout.Currency')</th>
                                            <th>@lang('layout.Rate')</th>
                                            <th>@lang('layout.FinedAmount')</th>
                                            <th>@lang('layout.BuyOverLoad')</th>
                                            <th>@lang('layout.Action')</th> 
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane" id="tab3">
                    <div class="">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.AdjustmentDetails')</span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">

                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover"
                                           id="adjustment_detail">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Site')</th>
                                            <th>@lang('layout.MeasureUnit')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.Price')</th>

                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                          enctype="multipart/form-data">

                                        @csrf
                                        <input type="hidden" name="redirect_route" value="transferAndLoading.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$transferAndLoading->id}}">
                                        <input type="hidden" name="path" value="uploads/TransferAndLoading">
                                        <input type="hidden" name="table_name" value="transfer_and_loadings">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input
                                                                                type="file" name="photo"> </span>

                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('inventoryTransfer.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.AttachmentTitle')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab4">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.LaboratoryTestCreate')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet green-meadow box">
                                <div class="portlet-title">
                                    
                                </div> 
                                <div class="portlet-body" id="laboratory">

                                    <form role="form" action="{{route('laboratory.store')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="foreign_data_id" value="{{$transferAndLoading->id}}">
                                        <input type="hidden" name="type_number" value="{{$transferAndLoading->number}}">
                                        <input type="hidden" name="type" value="transfer_and_loadings">
                                        <input type="hidden" name="redirect_route" value="transferAndLoading.show">

                                        <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Number')</label>
                                                    <input type="text" name="number" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Date')</label>
                                                    <input type="text" name="date" class="form-control date" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.CarNumber')</label>
                                                    <input type="text" name="vehicle_number" class="form-control" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label ">@lang('layout.SelectItem') </label>
                                                    <v-select class="vue-select2" v-model="selected_item" label="name"  :options="laboratory_item" @input="labSelectedMeasure()">
                                                    </v-select>
                                                    <input type="hidden" name="item_id" :value="!selected_item?null:selected_item.item_id" >
                                                    <input type="hidden" name="loading_detail_id" :value="!selected_item?null:selected_item.loading_detail_id" >
                                                </div>
                                    
                                              </div>
                                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label ">@lang('layout.Unit') </label>
                                                    <v-select class="vue-select2" v-model="selected_measure_laboratory" label="measure_name"  :options="laboratory_measure" >
                                                    </v-select>
                                                    <input type="hidden" name="um_id" :value="!selected_measure_laboratory?null:selected_measure_laboratory.measure_id" >
                                                </div>
                                    
                                              </div>

                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        @if(count($laboratoryTest)>0)
                                        <table id="table_content" class="table table-bordered">
                                            <thead style="background-color: #36c6d3; color:white"> 
                                            <tr>
                                                @foreach ($laboratoryTest as $key=>$value)
                                                <th >{{$value->name}}</th>
                                                @endforeach
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                @foreach ($laboratoryTest as $key=>$value)
                                                <td class="highlight">
                                                    <input type="text" name="laboratory_test[{{$value->id}}]" class="form-control" autocomplete="off">
                                                </td> 
                                                @endforeach
                    
                                            </tr> 
                                            </tbody>
                                        </table>
                                        @else
                                        <a href="{{route('laboratoryTest.create')}}"
                                            class="btn red">@lang('menu.LaboratoryTest')</a>
            
                                        @endif

                                        <div class="margiv-top-10" style="text-align: center">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('transferAndLoading.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="row">

                                <div class="col-md-12">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                        <div class="portlet-title">
                                            <div class="caption font-dark">
                                                <i class="icon-settings font-dark"></i>
                                                <span class="caption-subject bold uppercase">@lang('layout.LaboratoryTestList') </span>
                                            </div>
                                            <div class="tools"></div>
                                            <div class="actions">
                                                <span id="lab-modal">
                                                 <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                    <i class="fa fa-print"></i>
                                                 </a>
                                                </span>
        
                                            </div>
                                        </div>
                                        <div class="portlet-body">
                                            <table class="table table-striped table-bordered table-hover" id="laboratory_table">
                                                <thead>
                                                <tr>
                                                    <th>@lang('layout.Number')</th>
                                                    <th>@lang('layout.CarNumber')</th>
                                                    <th>@lang('layout.Item')</th>
                                                    <th>@lang('layout.Unit')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Date')</th>
                                                    <th>@lang('layout.Action')</th>
                
                
                
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>  
                <div class="tab-pane" id="tab5">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.WeighbridgeCreate')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet green-meadow box">
                                <div class="portlet-title">
                                    
                                </div> 
                                <div class="portlet-body" id="weighbridge">

                                    <form role="form" action="{{route('weighbridge.store')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="foreign_data_id" value="{{$transferAndLoading->id}}">
                                        <input type="hidden" name="type_number" value="{{$transferAndLoading->number}}">
                                        <input type="hidden" name="type" value="transfer_and_loadings">
                                        <input type="hidden" name="redirect_route" value="transferAndLoading.show">

                                        <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Number')</label>
                                                    <input type="text" name="number" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.CarNumber')</label>
                                                    <input type="text" name="vehicle_number" class="form-control" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.DriverName')</label>
                                                    <input type="text" name="driver_name" class="form-control" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                              <div class="form-group">
                                                  <label class="control-label">@lang('layout.FullWeight')</label>
                                                  <input type="number" name="full_weight" class="form-control" autocomplete="off">
                                              </div>
                                  
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.EmptyWeight')</label>
                                                    <input type="number" name="empty_weight" class="form-control" autocomplete="off">
                                                </div>
                                    
                                              </div>
                                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.NetWeight')</label>
                                                    <input type="number" name="net_weight" class="form-control" autocomplete="off">
                                                </div>
                                    
                                              </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label ">@lang('layout.SelectItem') </label>
                                                    <v-select class="vue-select2" v-model="selected_item_weighbridge" label="name"  :options="weighbridge_item" @input="selectedMeasure()">
                                                    </v-select>
                                                    <input type="hidden" name="item_id" :value="!selected_item_weighbridge?null:selected_item_weighbridge.item_id" >
                                                    <input type="hidden" name="loading_detail_id" :value="!selected_item_weighbridge?null:selected_item_weighbridge.loading_detail_id" >
                                                </div>
                                    
                                              </div>
                                              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label ">@lang('layout.Unit') </label>
                                                    <v-select class="vue-select2" v-model="selected_measure_weighbridge" label="measure_name"  :options="weighbridge_measure" >
                                                    </v-select>
                                                    <input type="hidden" name="um_id" :value="!selected_measure_weighbridge?null:selected_measure_weighbridge.measure_id" >
                                                </div>
                                    
                                              </div>


                                              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Date')</label>
                                                    <input type="text" name="date" class="form-control date" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Hour')</label>
                                                    <div class="input-group"> 
                                                        @if(getHourType() == 24)
                                                        <input type="text" class="form-control timepicker timepicker-24" name="hour">
                                                        @else
                                                        <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour">
                                                        @endif
                                                        <span class="input-group-btn">
                                                            <button class="btn default" type="button">
                                                                <i class="fa fa-clock-o"></i>
                                                            </button>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10" style="text-align: center">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('transferAndLoading.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="row">

                                <div class="col-md-12">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                        <div class="portlet-title">
                                            <div class="caption font-dark">
                                                <i class="icon-settings font-dark"></i>
                                                <span class="caption-subject bold uppercase">@lang('layout.WeighbridgeList') </span>
                                            </div>
                                            <div class="tools"></div>
                                            <div class="actions">
                                                <span id="weigh-modal">
                                                 <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                    <i class="fa fa-print"></i>
                                                 </a>
                                                </span>
        
                                            </div>
                                        </div>
                                        <div class="portlet-body">
                                            <table class="table table-striped table-bordered table-hover" id="weighbridge_table">
                                                <thead>
                                                <tr>
                                                    <th>@lang('layout.Number')</th>
                                                    <th>@lang('layout.CarNumber')</th>
                                                    <th>@lang('layout.DriverName')</th>
                                                    <th>@lang('layout.Item')</th>
                                                    <th>@lang('layout.Unit')</th>
                                                    <th>@lang('layout.FullWeight')</th>
                                                    <th>@lang('layout.EmptyWeight')</th>
                                                    <th>@lang('layout.NetWeight')</th>
                                                    <th>@lang('layout.Date')</th>
                                                    <th>@lang('layout.Hour')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Action')</th>
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>  

                {{--end of tabe--}}

            </div>
        </div>

    </div>
@endsection
@include('print.modal')

@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

    <script>
Vue.component('v-select', VueSelect.VueSelect);
        $(document).ready(function () {
            $('#inventory_transfer_detail').DataTable({
                ajax: {

                    url: '{{route("transferAndLoading.show",$transferAndLoading->id)}}',
                    data: {type: 'inventoryTransfer'}
                },
                scrollCollapse: true,
                serverSide: true,          
                paging: true,
                columns: [
                    {data: 'save_type', name: 'save_type', orderable: false, searchable: false},
                    {data: 'item_name', name: 'item_name', orderable: false, searchable: false},
                    {data: 'item_measure', name: 'item_measure', orderable: false, searchable: false},
                    {data: 'selected_measure', name: 'selected_measure', orderable: false, searchable: false},
                    {data: 'factor_number', name: 'factor_number', orderable: false, searchable: false},
                    {data: 'quantity', name: 'quantity', orderable: false, searchable: false},
                    {data: 'from_site', name: 'from_site', orderable: false, searchable: false},
                    {data: 'to_site', name: 'to_site', orderable: false, searchable: false},
                    {data: 'source', name: 'source', orderable: false, searchable: false},
                    {data: 'destination', name: 'destination', orderable: false, searchable: false},
                    {data: 'driver_name', name: 'driver_name', orderable: false, searchable: false},
                    {data: 'vehicle_name', name: 'vehicle_name', orderable: false, searchable: false},
                    {data: 'fined_currency', name: 'fined_currency', orderable: false, searchable: false},
                    {data: 'fined_rate', name: 'fined_rate', orderable: false, searchable: false},
                    {data: 'fined_amount', name: 'fined_amount', orderable: false, searchable: false},
                    {data: 'driver_overLoad_amount', name: 'driver_overLoad_amount', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]

            });


            $('#adjustment_detail').DataTable({
                ajax: {

                    url: '{{route("transferAndLoading.show",$transferAndLoading->id)}}',
                    data: {type: 'adjustment'}
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'item', name: 'item'},
                    {data: 'site', name: 'site'},
                    {data: 'measure', name: 'measure_unit'},
                    {data: 'quantity', name: 'quatity'},
                    {data: 'cost', name: 'cost'},
                ]

            });

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("transferAndLoading.show",$transferAndLoading->id)}}',
                    data: {type: 'attachment'}
                },

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });

            $('#laboratory_id').on('shown.bs.tab', function(event){
            $('#laboratory_table').DataTable({
                ajax: {
                    url: '{{route("transferAndLoading.show",$transferAndLoading->id)}}',
                    data: {type: 'laboratory'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [

                    {data: 'number', name: 'laboratories.number'},
                    {data: 'vehicle_number', name: 'laboratories.vehicle_number'},
                    {data: 'item_name', name: 'item_name', orderable: false, searchable: false},
                    {data: 'measure_name', name: 'measure_name', orderable: false, searchable: false},
                    {data: 'description', name: 'laboratories.description'},
                    {data: 'date', name: 'date', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            }); 
            });             
            
            $('#weighbridge_id').on('shown.bs.tab', function(event){
            $('#weighbridge_table').DataTable({
                ajax: {
                    url: '{{route("transferAndLoading.show",$transferAndLoading->id)}}',
                    data: {type: 'weighbridge'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [

                    {data: 'number', name: 'weighbridges.number'},
                    {data: 'vehicle_number', name: 'weighbridges.vehicle_number'},
                    {data: 'driver_name', name: 'weighbridges.driver_name'},
                    {data: 'item_name', name: 'item_name', orderable: false, searchable: false},
                    {data: 'measure_name', name: 'measure_name', orderable: false, searchable: false},
                    {data: 'full_weight', name: 'weighbridges.full_weight'},
                    {data: 'empty_weight', name: 'weighbridges.empty_weight'},
                    {data: 'net_weight', name: 'weighbridges.net_weight'},
                    {data: 'date', name: 'date', orderable: false, searchable: false},
                    {data: 'hour', name: 'hour', orderable: false, searchable: false},
                    {data: 'description', name: 'weighbridges.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            }); 
            }); 

        });


var vm_lab =new Vue({
    el: '#laboratory-modal',
    data:{
        is_show: false,
        pdfRoute: '{!!route('export.PDFAny') !!}',
        excelRoute: '{!! route('export.exportCsv') !!}'
    },

    methods:{
        closeModal: function(){
            this.is_show = !this.is_show;
        }
    }
});

var modal_lab= new Vue({
    el: '#lab-modal',
    methods: {
        showModal: function () {
            vm_lab.$data.is_show = true;

        }
        
    }
});

var vm_weigh =new Vue({
    el: '#weighbridge-modal',
    data:{
        is_show: false,
        pdfRoute: '{!!route('export.PDFAny') !!}',
        excelRoute: '{!! route('export.exportCsv') !!}'
    },

    methods:{
        closeModal: function(){
            this.is_show = !this.is_show;
        }
    }
});

var modal_weigh= new Vue({
    el: '#weigh-modal',
    methods: {
        showModal: function () {
            vm_weigh.$data.is_show = true;

        }
        
    }
});

var laboratory_item = {!! $laboratory_item!!}
var laboratory_measure = {!! $measureUnitList!!}

   var laboratory =  new Vue({
        el:'#laboratory',
        data:{
            laboratory_item:laboratory_item,
            selected_item:null,
            laboratory_measure:laboratory_measure,
            selected_measure_laboratory:null
        },
        methods:{
            labSelectedMeasure(){
                if(this.selected_item!=null){
                    var measure_id = this.selected_item.measure_id;
                    if(measure_id){
                        this.selected_measure_laboratory = _.find(this.laboratory_measure, (m) => m.measure_id == measure_id);
                    }
                }

            }
        }
    });
    
    var weighbridge_item = {!! $laboratory_item!!}
    var weighbridge_measure = {!! $measureUnitList!!}
    

   var weighbridge =  new Vue({
        el:'#weighbridge',
        data:{
            weighbridge_item:weighbridge_item,
            selected_item_weighbridge:null,
            weighbridge_measure:weighbridge_measure,
            selected_measure_weighbridge:null
        },
        methods:{
            selectedMeasure(){
                if(this.selected_item_weighbridge!=null){
                    var measure_id = this.selected_item_weighbridge.measure_id;
                    if(measure_id){
                        this.selected_measure_weighbridge = _.find(this.weighbridge_measure, (m) => m.measure_id == measure_id);
                    }
                }

            }
        }
    });

    



    var cust_rep = {!!customeReportNewData('transfer_and_loading_index')!!};

    
    var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false, 
                pdfRoute: '{!!route('transferAndLoadingReport.report') !!}',
                excelRoute: '{!! route('transferAndLoadingReport.report') !!}',
                selected_member:null,
                memberlist:[],
                // customReportData:
                // [
                // {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                //  {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                //  {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(cust_rep.code)?'checked':'',column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''},
                //  {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                //  {Name: '@lang("layout.Employee")', column_name: 'employee',checkedColumn:(cust_rep.employee)?'checked':'',column_percentage:(cust_rep.employee___percent)?cust_rep.employee___percent:''},
                //  {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                //  {Name: '@lang("layout.FromDate")', column_name: 'from_date',checkedColumn:(cust_rep.from_date)?'checked':'',column_percentage:(cust_rep.from_date___percent)?cust_rep.from_date___percent:''},
                //  {Name: '@lang("layout.ToDate")', column_name: 'to_date',checkedColumn:(cust_rep.to_date)?'checked':'',column_percentage:(cust_rep.to_date___percent)?cust_rep.to_date___percent:''},
                //  {Name: '@lang("layout.FromHour")', column_name: 'from_hour',checkedColumn:(cust_rep.from_hour)?'checked':'',column_percentage:(cust_rep.from_hour___percent)?cust_rep.from_hour___percent:''},
                //  {Name: '@lang("layout.ToHour")', column_name: 'to_hour',checkedColumn:(cust_rep.to_hour)?'checked':'',column_percentage:(cust_rep.to_hour___percent)?cust_rep.to_hour___percent:''},
                //  {Name: '@lang("layout.Duration")', column_name: 'duration',checkedColumn:(cust_rep.duration)?'checked':'',column_percentage:(cust_rep.duration___percent)?cust_rep.duration___percent:''},
                //  {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
                //  {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},



                //   ],
                //   cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Employee',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vm.memberlist = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
   

    </script>


@endpush

