@extends('layouts.app')
@section('style')
<style>
    .hide_btn {
        display: none;
    }
    .v-select .selected-tag{
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .v-select .selected-tag > button >span{
        display: none !important;
    }
    .modal-container {
        width: 60% !important;
    }
</style>
@endsection
@section('content')
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'transfer_and_loading'" @closed="closeModal"> 
        <div slot="body"> 
            <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop"> 
                    <ul class="nav nav-tabs"> 
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['transferAndLoading-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul> 
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <h4> <label class="control-label"> @lang('layout.FareLetters') <input name="driver_company" type="checkbox" value="true"> </label> </h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.Contract') </label>
                                            <v-select class="vue-select2" v-model="selectedContract" label="company_name" :options="contracts">
                                            </v-select>
                                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id">
                                        </div> 
                                        <div class="col-md-6"> 
                                            <label class="control-label ">@lang('layout.Driver') </label>
                                            <v-select class="vue-select2" v-model="selecteddriver" label="name" :options="drivers">
                                            </v-select>
                                            <input type="hidden" name="driver_id" v-model.number="(!selecteddriver)?null:selecteddriver.id">
                                        </div> 
                                    </div>


                                    <div class="row"> 

 
                                        {{-- <div class="col-md-4">
                                            <div class="form-group">
                                                <!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
                                                <option value="0">@lang('layout.SelectSite')</option>
                                                <select name="site_id"  v-model="" class="form-control">
                                                    <option value="0">@lang('layout.SelectSite')</option>
                                                    @foreach($loadingSites as $row)
                                                    <option value="{{$row['id']}}">{{$row['name']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div> --}}

                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.SelectSite') </label>
                                            <v-select class="vue-select2" v-model="selectedSite" label="name" :options="inventorySite" :multiple="true">
                                            </v-select>
                                            <input type="hidden" name="site_id" :value="inventory_site_id.length > 0 ? inventory_site_id:null">
                                        </div>
 

                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
                                                <option value="0">@lang('layout.Source')</option>
                                                <select name="source"  v-model="loadingSourceSel" class="form-control">
                                                    <option value="">@lang('layout.Source')</option>
                                                    @foreach($loadingSource as $row1)
                                                    <option value="{{$row1['name']}}">{{$row1['name']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <option value="0">@lang('layout.Destination')</option>
                                                <select name="destination"  v-model="loadingDestinationSel" class="form-control">
                                                    <option value="" selected>@lang('layout.Destination')</option>
                                                    @foreach($loadingDestination as $row2)
                                                    <option value="{{$row2['name']}}">{{$row2['name']}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <option value="0">@lang('layout.Type')</option>
                                                <select name="load_type"  v-model="load_type" class="form-control">
                                                    <option value="">@lang('layout.Type')</option>
                                                    <option value="Loading">@lang('layout.Loading')</option>
                                                    <option value="Discharge">@lang('layout.Discharge')</option>
                                                    <option value="DischargeAndLoading">@lang('layout.DischargeAndLoading')</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <option value="0">@lang('layout.ReportType')</option>
                                                <select name="type_details" class="form-control">
                                                    <option value="">@lang('layout.Type')</option>
                                                    <option value="details">@lang('layout.Details')</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.SelectItem') </label>
                                            <v-select class="vue-select2" v-model="selectedItem" label="name" @search="onItemSearch" :options="itemlist"> </v-select>
                                            <input type="hidden" name="item_id" v-model.number="(!selectedItem)?null:selectedItem.item_id">
                                        </div>
                                    </div>


                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.Date')</label>
                                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                    <option value="CustomDates">@lang('type.CustomDates')</option>
                                                    <option value="Today">@lang('type.Today')</option>
                                                    <option value="Yesterday">@lang('type.Yesterday')</option>
                                                    <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                    <option value="LastWeek">@lang('type.LastWeek')</option>
                                                    <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                    <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                    <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                    <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                    <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                    <option value="ThisYear">@lang('type.ThisYear')</option>
                                                    <option value="YearToDate">@lang('type.YearToDate')</option>
                                                </select>
                                            </div>
                                            <div class="col-md-8" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>                                                                     

                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="transfer_and_loading">

                                      
                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>



                                     
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px; margin-top:20px;"> @lang('layout.FareLetters') </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportDataFareLitters">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>



                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <h4 style="margin-bottom: 30px; margin-top:20px;"> @lang('layout.LoadingAndDischarge') </h4>
                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in loading_discharge">
                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                     
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>


        </div>
    </report-modal>
</div>






    {{-- <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'transfer_and_loading'"
                      @closed="closeModal">
            <div slot=body>
                <div class="row">
                    <div class="form-group"> 
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="col-md-4">
                                    <label class="control-label ">@lang('layout.Date')</label>
                                        <select name="period" v-model="period" @input="getDates()" class="form-control">
                                        <option value="CustomDates">@lang('type.CustomDates')</option>
                                        <option value="Today">@lang('type.Today')</option>
                                        <option value="Yesterday">@lang('type.Yesterday')</option>
                                        <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                        <option value="LastWeek">@lang('type.LastWeek')</option>
                                        <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                        <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                        <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                        <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                        <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                        <option value="ThisYear">@lang('type.ThisYear')</option>
                                        <option value="YearToDate">@lang('type.YearToDate')</option>
                                    </select>
                                </div>
                                <div class="col-md-8" v-show="period == 'CustomDates'">
                                    <div class="form-group">
                                        <label class="control-label"> @lang('layout.Date')</label>
                                        <div class="input-group">
                                            <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                            <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div> --}}
    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.TransferAndLoadingList')</span>
                </div>
                <div class="pull-right">
                    @permission('transferAndLoading-export')

                    <span id="anchore-modal">
                                 <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                    <i class="fa fa-print"></i>
                                 </a>
                            </span>

                    @endpermission
                    <a href="{{route('transferAndLoadingImport.loadingCreate')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus "></i> @lang('menu.ImportExcelTransferAndLoading')
                        </button>
                    </a>
                    
                    <a href="{{route('transferAndLoadingImport.dischargeCreate')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus "></i> @lang('menu.ImportExcelTransferDischarging')
                        </button>
                    </a>

                    @permission('transferAndLoading-create')
                    <a href="{{route('transferAndLoading.discharge_create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.Discharge')
                        </button>
                    </a>
                    <a href="{{route('transferAndLoading.loading_create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.Loading')
                        </button>
                    </a>
                  
                    <a href="{{route('transferAndLoading.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.DischargeAndLoading')
                        </button>
                    </a>
					@endpermission
                </div>
            </div>
            <div class="portlet-body">
                <div id="search_data">
                <div class="col-md-2">
                    <div class="form-group">
                        <!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
                        <select name="site_id" @input="getData()" v-model="site_id" class="form-control">
                            <option value="0">@lang('layout.SelectSite')</option>
                            @foreach($loadingSites as $row)
                            <option value="{{$row['id']}}">{{$row['name']}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
                        <select name="source" @input="getData()" v-model="loadingSourceSel" class="form-control">
                            <option value="0">@lang('layout.Source')</option>
                            @foreach($loadingSource as $row1)
                            <option value="{{$row1['name']}}">{{$row1['name']}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <select name="destination" @input="getData()" v-model="loadingDestinationSel" class="form-control">
                            <option value="0">@lang('layout.Destination')</option>
                            @foreach($loadingDestination as $row2)
                            <option value="{{$row2['name']}}">{{$row2['name']}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <select name="load_type" @input="getData()" v-model="load_type" class="form-control">
                            <option value="0">@lang('layout.Type')</option>
                            <option value="Loading">@lang('layout.Loading')</option>
                            <option value="Discharge">@lang('layout.Discharge')</option>
                            <option value="DischargeAndLoading">@lang('layout.DischargeAndLoading')</option>
                        </select>
                    </div>
                </div>
                </div>

                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="transfer">
                    <thead>
                    <tr>
                        <th width="2%">#</th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.DeliveryDate')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        let data_table;
            function getRecord() {
            data_table = $('#transfer').DataTable({
                ajax: {
                    ajax: '{{route("transferAndLoading.index")}}',
                    data: {
                        site_id: vtr.site_id,
                        loadingSource: vtr.loadingSourceSel,
                        loadingDestination: vtr.loadingDestinationSel,
                        load_type: vtr.load_type
                    }
                },
                pageLength: '{{getPageRows()}}',
                order: [
                    ["{{orderByColumn()=='number'?0:4}}", "{{getRowOrder()}}"]
                ],
                destroy: true,
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'id', name: 'transfer_and_loadings.id'},
                    {data: 'number', name: 'transfer_and_loadings.number'},
                    {data: 'ref_no', name: 'transfer_and_loadings.ref_no'},
                    {data: 'type', name: 'transfer_and_loadings.type', searchable: false},
                    {data: 'date', name: 'transfer_and_loadings.date', searchable: true},
                    {data: 'delivery_date', name: 'transfer_and_loadings.delivery_date', searchable: true},
                    {data: 'description', name: 'transfer_and_loadings.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ]
            });
            }

        $(document).ready(function() {
            getRecord();
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });

        Vue.component('v-select', VueSelect.VueSelect);
        var cust_rep = {!!customeReportNewData('transfer_and_loading')!!};
        var loadingSource = {!!json_encode($loadingSource)!!};
        var loadingDestination = {!!json_encode($loadingDestination)!!};
        var loadingLocation = {!!json_encode($loadingLocation)!!};
        var inventorySite = {!!json_encode($inventorySite)!!};

        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                contracts: {!! $contract !!},
                selectedContract: null,
                drivers: {!! $drivers !!},
                selecteddriver: null,
                loadingSource: loadingSource,
                inventorySite: inventorySite,
                inventory_site_id: [],
                selectedSite: null,
                loadingSourceSel: null,
                loadingDestination: loadingDestination,
                loadingDestinationSel: null,
                load_type: null,
                loadingLocation: loadingLocation,
                loadingLocationSel: null,
                site_id: 0,
                selectedItem: null,
                itemlist: [],
                customReportData:
                [
                {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.DeliveryDate")', column_name: 'delivery_date',checkedColumn:(cust_rep.delivery_date)?'checked':'',column_percentage:(cust_rep.delivery_date___percent)?cust_rep.delivery_date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_rep.reference_number)?'checked':'',column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                
                ],
                cust_rep:cust_rep,

                customReportDataFareLitters:
                [
                {Name: '@lang("layout.Transporter_name")', column_name: 'transporter_name',checkedColumn:(cust_rep.transporter_name)?'checked':'',column_percentage:(cust_rep.transporter_name___percent)?cust_rep.transporter_name___percent:''},
                 {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_rep.driver)?'checked':'',column_percentage:(cust_rep.driver___percent)?cust_rep.driver___percent:''},
                 {Name: '@lang("layout.VehicleName")', column_name: 'vehicle_name',checkedColumn:(cust_rep.vehicle_name)?'checked':'',column_percentage:(cust_rep.vehicle_name___percent)?cust_rep.vehicle_name___percent:''},
                 {Name: '@lang("layout.Source")', column_name: 'source',checkedColumn:(cust_rep.source)?'checked':'',column_percentage:(cust_rep.source___percent)?cust_rep.source___percent:''},
                 {Name: '@lang("layout.Destination")', column_name: 'destination',checkedColumn:(cust_rep.destination)?'checked':'',column_percentage:(cust_rep.destination___percent)?cust_rep.destination___percent:''},
                 {Name: '@lang("layout.Item")', column_name: 'item',checkedColumn:(cust_rep.item)?'checked':'',column_percentage:(cust_rep.item___percent)?cust_rep.item___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.RentQuantity")', column_name: 'rent_quantity',checkedColumn:(cust_rep.rent_quantity)?'checked':'',column_percentage:(cust_rep.rent_quantity___percent)?cust_rep.rent_quantity___percent:''},
                 {Name: '@lang("layout.Unit/M")', column_name: 'unit',checkedColumn:(cust_rep.unit)?'checked':'',column_percentage:(cust_rep.unit___percent)?cust_rep.unit___percent:''},
                 {Name: '@lang("layout.AprovedCode")', column_name: 'aproved_code',checkedColumn:(cust_rep.aproved_code)?'checked':'',column_percentage:(cust_rep.aproved_code___percent)?cust_rep.aproved_code___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                  ],
                  cust_rep:cust_rep, 
                  
                  loading_discharge:
                [
                 {Name: '@lang("layout.Contract")', column_name: 'contract_loading',checkedColumn:(cust_rep.contract_loading)?'checked':'',column_percentage:(cust_rep.contract_loading___percent)?cust_rep.contract_loading___percent:''},
                 {Name: '@lang("layout.ContractNumber")', column_name: 'contract_number_loading',checkedColumn:(cust_rep.contract_number_loading)?'checked':'',column_percentage:(cust_rep.contract_number_loading___percent)?cust_rep.contract_number_loading___percent:''},
                 {Name: '@lang("layout.WagonNumber")', column_name: 'wagon_number_loading',checkedColumn:(cust_rep.wagon_number_loading)?'checked':'',column_percentage:(cust_rep.wagon_number_loading___percent)?cust_rep.wagon_number_loading___percent:''},
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name_loading',checkedColumn:(cust_rep.item_name_loading)?'checked':'',column_percentage:(cust_rep.item_name_loading___percent)?cust_rep.item_name_loading___percent:''},
                 {Name: '@lang("layout.Site")', column_name: 'site_loading',checkedColumn:(cust_rep.site_loading)?'checked':'',column_percentage:(cust_rep.site_loading___percent)?cust_rep.site_loading___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date_loading',checkedColumn:(cust_rep.date_loading)?'checked':'',column_percentage:(cust_rep.date_loading___percent)?cust_rep.date_loading___percent:''},
                 {Name: '@lang("layout.Driver")', column_name: 'driver_loading',checkedColumn:(cust_rep.driver_loading)?'checked':'',column_percentage:(cust_rep.driver_loading___percent)?cust_rep.driver_loading___percent:''},
                 {Name: '@lang("layout.PaletNumber")', column_name: 'plate_number_quantity_loading',checkedColumn:(cust_rep.plate_number_quantity_loading)?'checked':'',column_percentage:(cust_rep.plate_number_quantity_loading___percent)?cust_rep.plate_number_quantity_loading___percent:''},
                 {Name: '@lang("layout.SourcePlace")', column_name: 'source_place_loading',checkedColumn:(cust_rep.source_place_loading)?'checked':'',column_percentage:(cust_rep.source_place_loading___percent)?cust_rep.source_place_loading___percent:''},
                 {Name: '@lang("layout.Destination")', column_name: 'destination_loading',checkedColumn:(cust_rep.destination_loading)?'checked':'',column_percentage:(cust_rep.destination_loading___percent)?cust_rep.destination_loading___percent:''},
                 {Name: '@lang("layout.Discharge")', column_name: 'discharge_loading',checkedColumn:(cust_rep.discharge_loading)?'checked':'',column_percentage:(cust_rep.discharge_loading___percent)?cust_rep.discharge_loading___percent:''},
                 {Name: '@lang("layout.Measure")', column_name: 'measure_loading',checkedColumn:(cust_rep.measure_loading)?'checked':'',column_percentage:(cust_rep.measure_loading___percent)?cust_rep.measure_loading___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity_loading',checkedColumn:(cust_rep.quantity_loading)?'checked':'',column_percentage:(cust_rep.quantity_loading___percent)?cust_rep.quantity_loading___percent:''},
                 {Name: '@lang("layout.DischargeQuantity")', column_name: 'discharge_loading_quantity',checkedColumn:(cust_rep.discharge_loading_quantity)?'checked':'',column_percentage:(cust_rep.discharge_loading_quantity___percent)?cust_rep.discharge_loading_quantity___percent:''},
                 {Name: '@lang("layout.Differ")', column_name: 'differ_loading',checkedColumn:(cust_rep.differ_loading)?'checked':'',column_percentage:(cust_rep.differ_loading___percent)?cust_rep.differ_loading___percent:''},
                 {Name: '@lang("layout.OverLoad")', column_name: 'overload_loading',checkedColumn:(cust_rep.overload_loading)?'checked':'',column_percentage:(cust_rep.overload_loading___percent)?cust_rep.overload_loading___percent:''},
                 {Name: '@lang("layout.LoadDrop")', column_name: 'loaddrop_loading',checkedColumn:(cust_rep.loaddrop_loading)?'checked':'',column_percentage:(cust_rep.loaddrop_loading___percent)?cust_rep.loaddrop_loading___percent:''},
                 {Name: '@lang("layout.FinedAmount")', column_name: 'fined_amount_loading',checkedColumn:(cust_rep.fined_amount_loading)?'checked':'',column_percentage:(cust_rep.fined_amount_loading___percent)?cust_rep.fined_amount_loading___percent:''},
                 {Name: '@lang("layout.Balance")', column_name: 'balance_loading',checkedColumn:(cust_rep.balance_loading)?'checked':'',column_percentage:(cust_rep.balance_loading___percent)?cust_rep.balance_loading___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type_loading',checkedColumn:(cust_rep.type_loading)?'checked':'',column_percentage:(cust_rep.type_loading___percent)?cust_rep.type_loading___percent:''},
                 {Name: '@lang("layout.TotalTransferFee")', column_name: 'total_transfer',checkedColumn:(cust_rep.total_transfer)?'checked':'',column_percentage:(cust_rep.total_transfer___percent)?cust_rep.total_transfer___percent:''},
                 {Name: '@lang("layout.Amount") $', column_name: 'total_amount',checkedColumn:(cust_rep.total_amount)?'checked':'',column_percentage:(cust_rep.total_amount___percent)?cust_rep.total_amount___percent:''},
                ],
                  cust_rep:cust_rep,
            },

            watch: { 
            selectedSite: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                    x.push(e.id);
                });
                this.inventory_site_id = x;
                // console.log('x value');
                // console.log(x);
            }
        },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

                //ajax call to get items
                onItemSearch(search, loading) {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchSale',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        vm.itemlist = [];
                        if (response.data.length > 0) {
                        vm.itemlist = response.data;
                        // console.log('data', vm.itemlist);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        var vtr = new Vue({
            el: '#search_data',
            data: {
                site_id: 0,
                loadingSourceSel: 0,
                loadingDestinationSel: 0,
                load_type: 0,
            },
            methods: {
                getData() {
                    // console.log(322, this.site_id,this.loadingSourceSel,this.loadingDestinationSel);
                    setTimeout(() => {
                        getRecord();
                    }, 200);
                }
            }
        });

    </script>


@endpush

