@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>
    .required {
        padding-left: 0px !important;
        color: red;
    }
</style>
@stop
@section('content')
<div class="row">
    <div class="portlet light bordered">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered sale">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.EditTransferAndLoading')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div id="app" class="portlet-body">

                <div class="tabbable tabbable-tabdrop">

                    <div>
                        {!! Form::model($loadingDetail,['method' => 'PATCH','route' => ['transferAndLoading.loacation_update',$loadingDetail->id],'class'=>'form-horizontal','id'=>'transfer-and-loading-form']) !!}

                        {{ csrf_field() }}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- BEGIN FORM-->


                                    <div class="form-body">
                                        <div class="row">
                                            <!-- begin inputs -->
                                            <div class="row">
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Source')</label>
                                                            <input type="text" name="source" class="form-control" value="{{$loadingDetail->source}}" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Location')</label>
                                                            <input type="text" name="location" class="form-control" value="{{$loadingDetail->location}}" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Destination')</label>
                                                            <input type="text" name="destination" class="form-control" value="{{$loadingDetail->destination}}" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                                            <a href="{{route('oilAndGasDashboard.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                        </div>

                                    </div>

                                </div>


                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>
    @endsection
    @push('scripts')


    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        
        Vue.use(VueInputAutowidth);

        Vue.component('v-select', VueSelect.VueSelect);

        var loadingDetail = {!!$loadingDetail!!};

        var v = new Vue({
            el: '#app',
            data: {


            },
            computed: {},
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            v.submitForm(e.target);
                        }
                    });
                },

                // submit the form
                submitForm() {

                    // if (this.isError == true) {
                    // alert('there is no item');
                    // return false;
                    // }
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("transfer-and-loading-form").submit()

                        } else {

                        }
                    });

                },


            },
            mounted: function() {

            }

        });
    </script>


    @endpush