@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>
    .required {
        padding-left: 0px !important;
        color: red;
    }
</style>
@stop
@section('content')
<div class="row">
    <div class="portlet light bordered">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered sale">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.EditTransferAndLoading')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div id="app" class="portlet-body">

                <div class="tabbable tabbable-tabdrop">

                    <div>
                        {!! Form::model($transferAndLoading,['method' => 'PATCH','route' => ['transferAndLoading.update',$transferAndLoading->id],'class'=>'form-horizontal','id'=>'transfer-and-loading-form']) !!}

                        {{ csrf_field() }}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- BEGIN FORM-->


                                    <div class="form-body">
                                        <div class="">
                                            <!-- begin inputs -->
                                            <div class="row">
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Number')</label>
                                                            <input type="text" name="number"  class="form-control" value="{{$transferAndLoading->number}}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                                            <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                                            <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">

                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Date')</label>
                                                            <input type="text" name="date" class="form-control date now" value="{{$transferAndLoading->date}}" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.DeliveryDate')</label>

                                                            <input type="text" name="delivery_date"
                                                                   class="form-control date" value="{{$transferAndLoading->delivery_date}}" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Description')</label>
                                                            <textarea name="description" class="form-control" rows="2">{{$transferAndLoading->description}}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <input type="hidden" name="edit_sale" value="{{$edit_sale}}" />
                                            </div>



                                            <div class="row" style="overflow-x: scroll;">
                                                <h3 style="margin-right:20px;">@lang('layout.Discharge')</h3>
                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th style="">@lang('layout.Off') </th>
                                                            <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                            <th style="min-width: 220px">@lang('layout.Contract') </th>
                                                            <th style="min-width: 130px">@lang('layout.WagonNumber') </th>
                                                            <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                                            <th style="min-width: 130px">@lang('layout.VehicleName')/@lang('layout.NumberWagon') </th>
                                                            <th style="min-width: 100px">@lang('layout.WayBillNumber') </th>
                                                            <th style="min-width: 120px">@lang('layout.FromSite') </th>
                                                            <th style="min-width: 120px">@lang('layout.ToSite') </th>

                                                            <th style="min-width: 150px">@lang('layout.Quantity') </th>
                                                            <th style="min-width: 50px">@lang('layout.LoadQuantity') </th>
                                                            <th style="min-width: 50px">@lang('layout.OnHand') </th>

                                                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                            <th style="min-width: 120px">@lang('layout.Driver') </th>
                                                            <th style="min-width: 150px">@lang('layout.SourcePlace') </th>
                                                            <th style="min-width: 150px">@lang('layout.Destination') </th>

                                                            <th style="min-width: 100px">@lang('layout.Type') </th>
                                                            <th style="min-width: 150px">@lang('layout.Quantity') </th>
                                                            <th style="min-width: 150px">@lang('layout.DriverQuantity') </th>
                                                            <th style="min-width: 150px">@lang('layout.Amount') </th>
                                                            <th style="min-width: 100px">@lang('layout.Currency') </th>
                                                            <th style="min-width: 150px">@lang('layout.Rate') </th>
                                                            <th style="min-width: 40px">@lang('layout.Cash') </th>
                                                            <th style="min-width: 120px">@lang('layout.Account') </th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(item,index) in inventories">
                                                            <td @click="addNew('inventory',index)">@{{index+1}}</td>
                                                            <td>
                                                                <div class="mt-checkbox" style="padding-left: 0px;">
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                        <input type="checkbox" :name="'load_off['+index+']'" v-model="item.load_off" checked />
                                                                        <span></span>
                                                                    </label>
                                                                </div>

                                                            </td>
                                                            <td @click="addNew('inventory',index)" v-show="showWhat('sale_category')=='yes'">
                                                                <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                                                @keyup.native="editKey = true, setIndex(index)" @click.native="editKey = true, setIndex(index)" @input="(editKey)?itemCategoryChange(index):''" ></v-select>
                                                                <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                            </td>
                                                            <td @click="addNew('inventory',index)" >
                                                                <v-select label="company_name" v-model="item.contract" :options="contracts" 
                                                                @keyup.native="editKey = true, setIndex(index)" @click.native="editKey = true, setIndex(index)" @input="(editKey)?contractChange(index):''" ></v-select>
                                                                {{-- <input  :value="(!item.contract)?null:item.contract.company_name" style="width: 0px; height: 0px; padding: 0px; opacity: 0;"> --}}
                                                                <input type="hidden" name="contract_id[]" :value="(!item.contract)?null:item.contract.id">
                                                            </td>
                                                            <td>
                                                                <v-select label="name" v-model="item.wagon" :options="item.wagonList" 
                                                                @keyup.native="editKey = true, setIndex(index)" @click.native="editKey = true, setIndex(index)" @input="(editKey)?contractChange(index):''" ></v-select>
                                                                <input type="hidden" name="wagon_number[]" :value="(!item.wagon)?null:item.wagon.name">
                                                            </td>
                                                            <td @click="addNew('inventory',index)" class="highlight">
                                                                <v-select label="name" @keyup.native="editKey = true, setIndex(index)" @click.native="editKey = true, setIndex(index)" @input="(editKey)?(onItemload(index)):''" 
                                                                v-model="item.inventory" :options="item.temp_items" @search="onItemSearch"></v-select>
                                                                {{-- <input  :value="(!item.inventory)?null:item.inventory.name" style="width: 0px; height: 0px; padding: 0px; opacity: 0;"> --}}
                                                                <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                                <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>

                                                            </td>
                                                            <td @click="addNew('inventory',index)" class="highlight">
                                                                <v-select label="name" @keyup.native="editKey = true, setIndex(index)" @click.native="editKey = true, setIndex(index)" @input="(editKey)?onItemloadTransfer(index):''"
                                                                v-model="item.loading_v" :options="item.temp_loading" @search="onItemSearchLoading" ></v-select>
                                                                <input type="hidden" :name="'loading_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.loading_v)?null:item.loading_v.id">
                                                                <span class="required">@{{ errors.first('loading_id['+index+']') }}</span>

                                                            </td>
                                                            <td>
                                                                @{{(item.item==null)?null:item.item.cmr_number}}
                                                            </td>
                                                            <td class="highlight">
                                                                <select v-model="(item.item==null)?null:item.item.site" class="form-control" disabled>
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item != null)">
                                                                        <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                            @{{site.site_name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                <input type="hidden" :name="'from_site['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                            </td>

                                                            <td class="highlight">
                                                                <select v-model="(item.item==null)?null:item.item.to_site" class="form-control">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item != null)">
                                                                        <option v-if="item.item.site.site_id!=site.id" v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                            @{{site.site_name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                <input type="hidden" :name="'to_site['+index+']'" :value="(item.item==null)?null:((item.item.to_site==null)?null:item.item.to_site.site_id)">
                                                            </td>

                                                            <td>

                                                                <input type="number" :name="'inventory_quantity['+index+']'" v-validate="''" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity"
                                                                 
                                                                @keyup="editKey = true" @click="editKey = true" @input="(editKey)?(selectLoadType(index), setRentQuantity(index)):''"
                                                                class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">
                                                                <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                            </td>
                                                            <td>
                                                                @{{myRound((item.item==null)?null:((item.item.load_quantity * item.item.measure_unit) / (item.item.measure.measure_unit)))}}
                                                            </td>
                                                            <td>
                                                                @{{myRound((item.item==null)?null:saleItemQuantity(item.item, Number(item.item.quantity) + Number((item.load_type=='Leakage')?(item.fined_quantity): -(item.fined_quantity)) + Number((item.load_type=='Leakage')?(item.load_quantity): -(item.load_quantity))))}}
                                                                {{-- @{{myRound((item.item==null)?null:saleItemQuantity(item.item, Number(item.item.quantity) + Number(item.fined_quantity) + Number((item.load_type=='Leakage')?(item.load_quantity):0)))}} --}}
                                                            </td>

                                                            <td class="highlight">
                                                                <select v-model="(item.item == null)?null:item.item.measure" class="form-control">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item ==null)?false:true">
                                                                        <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                            @{{measure.measure_name}}
                                                                        </option>
                                                                    </span>


                                                                </select>

                                                                <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                            </td>
                                                            <td>
                                                                @{{(item.item==null)?null:item.item.driver_name}}
                                                            </td>
                                                            <td>
                                                                @{{(item.item==null)?null:item.item.source}}
                                                            </td>
                                                            <td>
                                                                @{{(item.item==null)?null:item.item.destination}}
                                                            </td>

                                                            <td class="highlight">
                                                                <select v-model="(item==null)?null:item.load_type" class="form-control">
                                                                    <option value="OverLoad">@lang('layout.OverLoad')</option>
                                                                    <option value="Leakage">@lang('layout.Leakage')</option>
                                                                </select>

                                                                <input type="hidden" name="load_type[]" :value="(item==null)?null:item.load_type">
                                                            </td>
                                                            <td>
                                                                <input type="number" :name="'load_quantity['+index+']'" v-model.number="(item==null)?null:item.load_quantity"
                                                                 class="form-control input-style input-number chan_length" :placeholder="(item.load_type=='OverLoad')?`@lang('layout.OverLoad')`:`@lang('layout.LoadDrop')`">
                                                            </td>

                                                            <td>
                                                                <input type="number" :name="'fined_quantity['+index+']'" v-model.number="(item==null)?null:item.fined_quantity"
                                                                 class="form-control input-style input-number chan_length" 
                                                                :placeholder="(item.load_type=='OverLoad')?`@lang('layout.BuyOverLoad')`:`@lang('layout.FinedAmount')`">
                                                            </td>
                                                            <td>
                                                                <input type="number" :name="'fined_cost['+index+']'" v-model.number="(item.item==null)?null:item.item.cost"
                                                                 class="form-control input-style input-number chan_length" placeholder="@lang('layout.Amount')">
                                                            </td>

                                                            <td>
                                                                <v-select label="code" v-model="item.currency" :options="currency_list" @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?(changePrice(index), setSizeRow(item.currency.code,index)):''" ></v-select>
                                                                <input type="hidden" name="fined_currency[]" :value="(!item.currency)?null:item.currency.code">
                                                            </td>
                                                            <td>
                                                                <input type="number" name="fined_currency_rate[]"
                                                                 class="form-control input-style input-number chan_length" v-model="(!item.currency)?null:item.currency.rate">
                                                            </td>
                                                            <td>
                                                                <div class="mt-checkbox" style="padding-left: 0px;">
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                        <input type="checkbox" :name="'fined_type['+index+']'" v-model="item.cash" />
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <select v-show="item.cash" class="form-control" :name="'account_id['+index+']'" v-model="item.defaultAccount" >
                                                                    <option v-for="Account in item.accounts" :value="Account.id">
                                                                        @{{ Account.name }}
                                                                    </option>
                                                                </select>
                                                            </td>
                                                            <td>
                                                                <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            </td>
                                                        </tr>

                                                    </tbody>
                                                </table>

                                                <hr />
                                                <br />
                                                <br />
                                            </div>

                                            <div class="row" style="overflow-x: scroll;">

                                                <h3 style="margin-right:20px;">@lang('layout.Loading')</h3>

                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>

                                                            <th style="">@lang('layout.State') </th>
                                                            <th style="min-width: 160px">@lang('layout.ItemName') </th>
                                                            <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                            <th style="min-width: 150px">@lang('layout.Quantity') </th>
                                                            <th style="min-width: 100px">@lang('layout.Type') </th>
                                                            <th style="min-width: 150px">@lang('layout.Quantity') </th>
                                                            <th style="min-width: 160px">@lang('layout.Transporter_name') </th>
                                                            <!-- th v-if="driver_type == 'OwnDriver'" style="min-width: 100px">@lang('layout.TankerNumber') </th -->
                                                            <th style="min-width: 120px">@lang('layout.VehicleName')/@lang('layout.NumberWagon') </th>
                                                            <th style="min-width: 120px">@lang('layout.TankerNumber') </th>
                                                            <th v-if="driver_type == 'ForeignDriver1'" style="min-width: 120px">@lang('layout.Driver') </th>
                                                            <th v-if="driver_type == 'ForeignDriver1'" style="min-width: 120px">@lang('layout.VehicleName')/@lang('layout.NumberWagon') </th>
                                                            <th style="min-width: 150px">@lang('layout.TransitNumber') </th>
                                                            <th style="min-width: 150px">@lang('layout.WayBillNumber') </th>
                                                            <th style="min-width: 150px">@lang('layout.SourcePlace') </th>
                                                            <th style="min-width: 150px">@lang('layout.Destination') </th>
                                                            <th style="min-width: 100px">@lang('layout.LoadingDate') </th>
                                                            <th style="min-width: 150px">@lang('layout.RentQuantity') </th>
                                                            <th style="min-width: 150px">@lang('layout.Price') </th>
                                                            <th style="min-width: 100px">@lang('layout.Currency') </th>
                                                            <th style="min-width: 150px">@lang('layout.Rate') </th>
                                                            <th style="min-width: 150px">@lang('layout.Rent') </th>
                                                            <th style="min-width: 150px">@lang('layout.Rate') </th>
                                                            <th style="min-width: 150px">@lang('layout.TotalTransferFee') </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(item,index) in inventories">
                                                            <td>@{{index+1}}</td>

                                                            <td>
                                                                <div class="mt-checkbox" style="padding-left: 0px;">
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                        <input type="checkbox" :name="'load_tran_fer['+index+']'" value="ok" checked />
                                                                        <span></span>
                                                                    </label>
                                                                </div>

                                                            </td>
                                                            <td class="highlight">
                                                                @{{(!item.item)?null:item.item.name}}
                                                                <input type="hidden" v-model="(item.loading == null)?null: item.loading.id" :name="'loading_detail_id['+index+']'" />
                                                            </td>
                                                            <td class="highlight">
                                                                @{{(item.item==null)?null:((item.item.to_site==null)?null:item.item.to_site.name)}}
                                                                <input type="hidden" :name="'load_site['+index+']'" :value="(!item.item)?null:(item.item.to_site)?item.item.to_site.site_id:null">
                                                            </td>
                                                            <td>
                                                                @{{myRound((item.item==null)?null: ((Number.parseFloat(item.item.quantity) - Number.parseFloat((item.loading_type=='Leakage')?item.loading_quantity:0)) + Number.parseFloat((item.loading_type=='OverLoad')?item.loading_quantity:0)))}}

                                                                <input type="hidden" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')" readonly />
                                                            </td>
                                                            <td class="highlight">
                                                                <select v-model="(item==null)?null:item.loading_type" @input="setRentQuantity(index)" class="form-control">
                                                                    <option value="OverLoad">@lang('layout.OverLoad')</option>
                                                                    <option value="Leakage">@lang('layout.Leakage')</option>
                                                                </select>

                                                                <input type="hidden" name="loading_type[]" :value="(item==null)?null:item.loading_type">
                                                            </td>
                                                            <td>
                                                                <input type="number" :name="'loading_quantity['+index+']'" v-model.number="(item==null)?null:item.loading_quantity" @input="setRentQuantity(index)"
                                                                 class="form-control input-style input-number chan_length" :placeholder="(item.loading_type=='OverLoad')?`@lang('layout.OverLoad')`:`@lang('layout.LoadDrop')`">
                                                            </td>

                                                            <td>
                                                                <v-select label="name" v-model="item.driver" @keyup.native="vehicleSearch(index)" @Click.native="vehicleSearch(index)" :options="driver"></v-select>
                                                                <input type="hidden" :name="'load_driver_id['+index+']'" :value="(!item.driver)?null:item.driver.id">
                                                                <input type="hidden" :name="'load_driver_type['+index+']'" :value="(!item.driver)?null:item.driver.driver_type">
                                                                <input type="hidden" :name="'foreign_type['+index+']'" :value="(!item.driver)?null:item.driver.foreign_type">
                                                            </td>
                                                            <td v-if="((item == null)?'': item.driver_type) == 'OwnDriver'">
                                                                <v-select label="name" v-model="item.vehicle" @keyup.native="carChange(index)" @Click.native="carChange(index)" :options="vehicle"></v-select>
                                                                <input type="hidden" :name="'load_vehicle_id['+index+']'" :value="(!item.vehicle)?null:item.vehicle.id">
                                                                <input type="hidden" :name="'vehicle_currency['+index+']'" :value="(!item.vehicle)?null:item.vehicle.currency">
                                                                <input type="hidden" :name="'vehicle_driver_id['+index+']'" :value="(!item.vehicle)?null:item.vehicle.driver_id">
                                                                <input type="hidden" :name="'vehicle_foreign_type['+index+']'" :value="(!item.vehicle)?null:item.vehicle.foreign_type">
                                                            </td>
                                                            <td v-if="((item == null)?'': item.driver_type) == 'OwnDriver'">
                                                                <v-select label="name" v-model="item.tanker" @keyup.native="tankerChange(index)" @Click.native="tankerChange(index)" :options="vehicle"></v-select>
                                                                <input type="hidden" :name="'load_tanker_id['+index+']'" :value="(!item.tanker)?null:item.tanker.id">
                                                                <input type="hidden" :name="'tanker_currency['+index+']'" :value="(!item.tanker)?null:item.tanker.currency">
                                                                <input type="hidden" :name="'tanker_driver_id['+index+']'" :value="(!item.tanker)?null:item.tanker.driver_id">
                                                                <input type="hidden" :name="'tanker_foreign_type['+index+']'" :value="(!item.tanker)?null:item.tanker.foreign_type">
                                                            </td>
                                                            <td v-if="((item == null)?'': item.driver_type) == 'ForeignDriver'">
                                                                <input type="text" v-model="item.other_driver_name" :name="'load_other_driver_name['+index+']'" placeholder="@lang('layout.Driver')"
                                                                 class="form-control chan_length">
                                                            </td>
                                                            <td v-if="((item == null)?'': item.driver_type) == 'ForeignDriver'">
                                                                <input type="text" v-model="item.other_vehicle_name" :name="'load_other_vehicle_name['+index+']'" placeholder="@lang('layout.VehicleName')/@lang('layout.NumberWagon')"
                                                                 class="form-control chan_length">
                                                            </td>
                                                            <td>
                                                                <input type="text" v-model="item.transit_number" :name="'load_transit_number['+index+']'" placeholder="@lang('layout.TransitNumber')"
                                                                 class="form-control chan_length">
                                                            </td>

                                                            <td>
                                                                <input type="text" v-model="item.cmr_number" :name="'load_way_bill_number['+index+']'" placeholder="@lang('layout.WayBillNumber')"
                                                                 class="form-control chan_length">
                                                            </td>
                                                            <td>
                                                                <input type="text" v-model="item.source" :name="'load_source['+index+']'" placeholder="@lang('layout.SourcePlace')"
                                                                 class="form-control chan_length">
                                                            </td>
                                                            <td>
                                                                <input type="text" v-model="item.destination" :name="'load_destination['+index+']'" placeholder="@lang('layout.Destination')"
                                                                 class="form-control chan_length">
                                                            </td>
                                                            <td>
                                                                <date_picker v-model="item.loading_date" :name="'loading_date['+index+']'"
                                                                 class="chan_length" placeholder="@lang('layout.LoadingDate')"></date_picker>
                                                            </td>
                                                            <td>
                                                                <input type="number" :name="'rent_quantity['+index+']'"
                                                                       v-validate="''" data-vv-as="@lang('layout.RentQuantity')"
                                                                       v-model.number="(item.item==null)?null:item.item.rent_quantity"
                                                                       @input="TotalTransferFee(index)"
                                                                       
                                                                       class="form-control input-style input-number chan_length"
                                                                       placeholder="@lang('layout.RentQuantity')">
                                                                <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                            </td>
                                                            <td>
                                                                <input type="number" :name="'load_transfer_fee['+index+']'"
                                                                 class="form-control input-style input-number chan_length" v-model.number="(item==null)?null:item.transfer_fee" @input="TotalTransferFee(index)" placeholder="@lang('layout.Amount')">
                                                            </td>
                                                            <td>
                                                                <v-select label="code" :options="item.currency_list" v-model="item.load_currency"></v-select>
                                                                <input type="hidden" :name="'load_currency_loading['+index+']'" :value="(!item.load_currency)?null:item.load_currency.code">
                                                            </td>
                                                            <td>
                                                                <input type="number" :name="'load_currency_rate_loading['+index+']'" v-model="!item.load_currency?0:item.load_currency.rate"
                                                                 class="form-control chan_length" :class="{'has-error':rate<=0}">
                                                            </td>
                                                            <td>
                                                                <div v-if="((!item.vehicle)?null:item.vehicle.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) == 'ok' ">
                                                                    <input type="number" :name="'forign_rent_vehicle['+index+']'" placeholder="@lang('layout.Rate')" v-model="(!item.vehicle)?0:item.vehicle.rent"
                                                                     class="form-control chan_length" />
                                                                </div>
                                                                <div v-if="((!item.tanker)?null:item.tanker.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) != 'ok' ">
                                                                    <input type="number" :name="'forign_rent_tanker['+index+']'" placeholder="@lang('layout.Rate')" v-model="(!item.tanker)?0:item.tanker.rent"
                                                                     class="form-control chan_length" />
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <div v-if="((!item.vehicle)?null:item.vehicle.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) == 'ok' " class="input-group">
                                                                    <input type="number" :name="'forign_rate_vehicle['+index+']'" placeholder="@lang('layout.Rate')" v-model="!item.vehicle?0:item.vehicle.rate"
                                                                     class="form-control chan_length" />
                                                                    <span class="input-group-addon">
                                                                        @{{(!item.vehicle)?null:item.vehicle.currency}}
                                                                    </span>
                                                                </div>
                                                                <div v-if="((!item.tanker)?null:item.tanker.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) != 'ok' " class="input-group">
                                                                    <input type="number" :name="'forign_rate_tanker['+index+']'" placeholder="@lang('layout.Rate')" v-model="!item.tanker?0:item.tanker.rate"
                                                                     class="form-control chan_length" />
                                                                    <span class="input-group-addon">
                                                                        @{{(!item.tanker)?null:item.tanker.currency}}
                                                                    </span>
                                                                </div>
                                                            </td>
                                                            <td>
                                                                <input :value="(item==null)?null:item.itransfer_total" class="form-control input-style input-number chan_length"
                                                                 placeholder="@lang('layout.Total')" readonly />
                                                            </td>

                                                        </tr>
                                                    </tbody>
                                                </table>


                                                <br />
                                                <br />
                                            </div>

                                            <button type="button" @click="addNew('inventory',500)" class="btn btn-success"> <i class="fa fa-plus"></i> </button>
                                            <hr>


                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="isError1 ==false" v-if="!isError" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>


                                            <a href="{{route('transferAndLoading.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                        </div>

                                        <cmodal :show='showModal' @close="showModal=false">

                                        </cmodal>
                                    </div>

                                </div>


                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>
    @endsection
    @push('scripts')


    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        
        // Vue.use(VueInputAutowidth);

        Vue.component('v-select', VueSelect.VueSelect);

        var inventory_category = {!!$inventory_category!!};
        var site = {!!$site!!};
        var driver = {!!$driver!!};
        var currency = {!!$currency!!};
        var otherIncome = {!!$otherIncome!!};
        var transferAndLoading = {!!$transferAndLoading!!};
        var transferSelectedItem = {!!$transferSelectedItem!!};
        var finedDriver = {!!$finedDriver!!};
        let homeCurrency = {!!json_encode(getHomeCurrency()) !!};
        var bank = {!! $bank !!};
        var contract = {!! $contract !!};

        var v = new Vue({
            el: '#app',
            data: {
                bankes: bank,
                contracts: contract,
                editKey: false,
                showModal: false,
                driver_type: 'OwnDriver',
                rate: 1,
                temp_items: [],
                temp_loading: [],
                inventory_category: inventory_category,
                selected_iventory_category: null,
                selected_index: 0,
                site: site,
                currency_list: currency,
                inventories: [],
                adjustment: [],
                selected_type: '',
                driver: driver,
                otherIncome: otherIncome,
                selected_otherIncome: null,
                type_number: null,
                transferAndLoading: transferAndLoading,
                transferSelectedItem: transferSelectedItem,
                finedDriver: finedDriver,
                type_info: null,
                isError: true,
                ref_no: '',
                msg: '',
                isError1: false,
                vehicle: {!!$vehicle!!},


            },
            computed: {},
            methods: {
                checkRefNo() {

                    var chack = 'false';
                    var ref_no = v.ref_no;
                    if (ref_no != null) {


                        axios.get("{{route('callMethod.search')}}", {

                                params: {
                                    ref_no: v.ref_no,
                                    method_name: 'Search_ref_no',
                                    table_name: 'transfer_and_loadings'
                                },
                            })
                            .then(function(response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    // console.log(response.data.result);
                                    // v.temp_items=response.data;
                                    v.msg = "@lang('layout.DuplicateData')";
                                    v.isError1 = true;
                                } else {
                                    v.msg = 'no';
                                    v.isError1 = false;

                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });

                    }
                },
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            v.submitForm(e.target);
                        }
                    });
                },


                onItemSearch: _.debounce((search, loading) => {
                    loading(true);
                    var index = v.selected_index;

                    let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                    let contract_id = (v.inventories[index]['contract'] != undefined) ? v.inventories[index]['contract'].id : '';
                    let wagon_number = (v.inventories[index]['wagon'] != undefined)?v.inventories[index]['wagon'].name:null;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchLoading',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                contract_id: contract_id,
                                wagon_number: wagon_number,
                            }
                        })
                        .then(function(response) {
                            v.inventories[index]['temp_items'] = [];
                            if (response.data.length > 0) {
                                v.inventories[index]['temp_items'] = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            console.log(error);
                        })

                }, getDebounceTime()),


                onItemload(index) {
                    v.selected_index = index;
                    if (v.inventories[index].inventory != null) {
                        var inventory_id = v.inventories[index].inventory.id;
                        let wagon_number = (v.inventories[index]['wagon'] != undefined)?v.inventories[index]['wagon'].name:null;
                        let contract_id = (v.inventories[index]['contract'] != undefined)?v.inventories[index]['contract'].id:null;

                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchLoading',
                                    inventory_id: inventory_id,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number,
                                }
                            })
                            .then(function(response) {
                                v.inventories[index].item = null;
                                if (response.data.length > 0) {
                                    v.inventories[index].temp_loading = [];
                                    v.inventories[index].temp_loading = response.data;

                                    // console.log('asdasdas', v.inventories[index].temp_loading);
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                    }

                },

                onItemSearchLoading: _.debounce((search, loading) => {
                    loading(true);
                    var index = v.selected_index;
                    if (v.inventories[index].inventory != null) {
                        var inventory_id = v.inventories[index].inventory.id;
                        let wagon_number = (v.inventories[index]['wagon'] != undefined)?v.inventories[index]['wagon'].name:null;
                        let contract_id = (v.inventories[index]['contract'] != undefined)?v.inventories[index]['contract'].id:null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchLoading',
                                inventory_id: inventory_id,
                                keyword: search,
                                contract_id: contract_id,
                                wagon_number: wagon_number,
                            }
                        })
                        .then(function (response) {
                            v.inventories[index].item = null;
                            v.inventories[index].loading = null;
                            v.inventories[index].temp_loading = [];
                            if (response.data.length > 0) {
                                v.inventories[index].temp_loading = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                    }
                    
                }, getDebounceTime()),

                setIndex(index) {
                v.selected_index = index;
                },

                // contract search
                contractChange(index) {
                    v.selected_index = index;
                    if (v.inventories[index]['contract'] != null) {
                        v.inventories[index]['wagonList'] = [];
                        if (v.inventories[index]['contract'].wagon) {
                            v.inventories[index]['wagonList'] = v.inventories[index]['contract'].wagon;
                        }

                        v.inventories[index]['inventory'] = null;
                        v.inventories[index]['item'] = null;
                        let contract_id = v.inventories[index]['contract'].id;
                        let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                        let wagon_number = (v.inventories[index]['wagon'] != undefined)?v.inventories[index]['wagon'].name:null;
                        // console.log(333, wagon_number, contract_id);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemesSearchLoading',
                                inventory_category_id: inventory_category_id,
                                wagon_number: wagon_number,
                                contract_id: contract_id
                            }
                        })
                        .then(function (response) {
                            v.inventories[index]['temp_items'] = [];
                            if (response.data.length > 0) {
                                v.inventories[index]['temp_items'] = response.data;
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                    }
                },

                onItemloadTransfer(index) {

                    if (v.inventories[index].inventory != null && v.inventories[index].loading_v != null) {
                        var inventory_id = v.inventories[index].inventory.id;
                        var loading_id = v.inventories[index].loading_v.id;
                        // console.log('klk',inventory_id,loading_id);

                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'onItemloadTransfer',
                                    inventory_id: inventory_id,
                                    loading_id: loading_id,
                                }
                            })
                            .then(function(response) {
                                v.inventories[index].item = null;
                                if (response.data.length > 0) {
                                    v.inventories[index].item = response.data[0];
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                    }
                },


                vehicleSearch(index) {
                    var plate = null;
                    if (v.inventories[index].item) {
                        if (v.inventories[index].driver) {
                            plate = v.inventories[index]['driver']['plate'];
                            v.driver_type = v.inventories[index]['driver']['driver_type'];
                            v.inventories[index]['driver_type'] = v.inventories[index]['driver']['driver_type'];
                            // console.log('222',v.inventories[index]['driver']['driver_type']);
                            // console.log(v.inventories[index]['transfer_fee'] ,v.inventories[index].item.quantity , v.inventories[index]['transfer_fee']);

                        }
                        // v.inventories[index]['loading']['other_driver_name'] = '23 ';
                        // v.inventories[index]['loading']['other_vehicle_name'] = '3 ';
                    }
                    if (plate != null) {
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'Search_driver_vehicle',
                                    driver_vehicle_plate: plate,
                                }
                            })
                            .then(function(response) {

                                if (response.data.result != null) {
                                    // console.log('1231',response.data);
                                    v.inventories[index]['vehicle'] = null;
                                    v.inventories[index]['vehicle'] = response.data.result;
                                }
                                // console.log('1231', v.inventories[index]);
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                    }
                },

                // set new price
                TotalTransferFee(index) {
                    if (this.inventories[index].item) {
                        if (this.inventories[index].item.rent_quantity) {
                            this.inventories[index].itransfer_total = myRound(this.inventories[index].item.rent_quantity * this.inventories[index]['transfer_fee']);
                        }
                    }
                },

                // set new price
                setRentQuantity(index) {
                    setTimeout(() => {
                        if (this.inventories[index].item) {
                            if (this.inventories[index].item.quantity) {
                                var quantity = ((this.inventories[index].item.quantity - ((this.inventories[index].loading_type=='Leakage')?this.inventories[index].loading_quantity:0)) + ((this.inventories[index].loading_type=='OverLoad')?this.inventories[index].loading_quantity:0));
                                this.inventories[index].item.rent_quantity = quantity;
                                this.TotalTransferFee(index);
                            }
                        }
                    }, 400);
                },

                selectLoadType(index) {
                    if (v.inventories[index].item && v.inventories[index].load_off == true) {
                        var quantity = Number.parseFloat(v.inventories[index].item.quantity);
                        var load_quantity = ((Number.parseFloat(v.inventories[index].item.load_quantity) * Number.parseFloat(v.inventories[index].item.measure_unit)) / Number.parseFloat(v.inventories[index].item.measure.measure_unit));
                        
                        if (quantity > load_quantity) {
                            v.inventories[index].load_type = 'OverLoad';
                            v.inventories[index].load_quantity = Number.parseFloat(quantity - load_quantity).toFixed(precision());
                        }else{
                            v.inventories[index].load_type = 'Leakage';
                            v.inventories[index].load_quantity = Number.parseFloat(load_quantity - quantity).toFixed(precision());
                        }
                    }
                },

                // detect member change and searh
                carChange(index) {
                    if (v.inventories[index].item) {
                        if (v.inventories[index]['vehicle'].foreign_type == "ok") {
                            var currency = _.find(this.currency_list, (c) => c.code == v.inventories[index]['vehicle'].currency);
                            // console.log('rrrnnss', currency);
                            v.inventories[index]['vehicle'].rate = currency.rate;
                        }
                        // console.log('rrrnn', this.selected_vehicle);
                        this.TankerSearch(v.inventories[index]['vehicle'].tanker_number, index, this);
                    }
                },
                tankerChange(index) {
                    if (v.inventories[index].item) {
                        if (v.inventories[index]['tanker'].foreign_type == "ok") {
                            var currency = _.find(this.currency_list, (c) => c.code == v.inventories[index]['tanker'].currency);
                            v.inventories[index]['tanker'].rate = currency.rate;
                            // console.log('rrrnnss', currency);
                        }
                    }
                },
                TankerSearch(plate, index, vm) {
                    if (plate != null) {
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'Search_driver_vehicle',
                                    driver_vehicle_plate: plate,
                                }
                            })
                            .then(function(response) {

                                if (response.data.result != null) {
                                    v.inventories[index]['tanker'] = null;
                                    v.inventories[index]['tanker'] = response.data.result;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                    }
                },


                onItemloadAdjustment(index) {

                    v.selected_index = index;
                    if (v.adjustment[index].inventory != null) {
                        // console.log('klk',v.inventories[index].inventory,v.inventories);
                        var inventory_id = v.adjustment[index].inventory.id;
                        let inventory_category_id = (v.adjustment[index]['item_category'] != undefined) ? v.adjustment[index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                }
                            })
                            .then(function(response) {
                                v.adjustment[index].item = null;
                                if (response.data.length > 0) {
                                    v.adjustment[index].item = response.data[0];
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                    }
                },


                //ajax call to get items
                setIndex(e) {
                    //v.temp_items=[];
                    this.selected_index = e;
                },
                itemCategoryChange(index) {
                    v.selected_iventory_category = this.inventories[index]['item_category'];
                    if (this.inventories[index]['item_category'] != null) {
                        let inventory_category_id = v.inventories[index]['item_category'].id;
                        let contract_id = (v.inventories[index]['contract'] != undefined) ? v.inventories[index]['contract'].id : '';
                        let wagon_number = (v.inventories[index]['wagon'] != undefined)?v.inventories[index]['wagon'].name:null;

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchLoading',
                                inventory_category_id: inventory_category_id,
                                type: this.type,
                                type_number: this.type_number
                            }
                        })
                        .then(function(response) {
                            v.inventories[index]['temp_items'] = [];
                            if (response.data.length > 0) {
                                v.inventories[index]['temp_items'] = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    }

                },


                // end item search

                // contract search

                changePrice(index) {
                    if (v.inventories[index].item && v.inventories[index].currency) {
                            // console.log(33, v.inventories[index].item);
                        if (v.inventories[index].item.cost && v.inventories[index].item.LasCost && v.inventories[index].currency.rate) {
                            v.inventories[index].item.cost = Number.parseFloat(Number.parseFloat(v.inventories[index].item.LasCost) * Number.parseFloat(v.inventories[index].currency.rate)).toFixed(precision());
                        }
                    }
                    //  LasCost
                },

                setSizeRow(selected_code,index) {
                    var b = _.clone(v.bankes)
                    var accounts = b.filter((account) => {
                        return (new RegExp(selected_code.toLowerCase())).test(account.code.toLowerCase())
                    })

                    var defaultAccount = null;
                    var selected_banks=_.find(accounts,(v)=>v.code==selected_code);
                    if (selected_banks){
                        defaultAccount = selected_banks.id;
                    }

                    v.inventories[index].accounts = accounts;
                    v.inventories[index].defaultAccount = defaultAccount;
                },

                // generic function for adding item to list
                addNew(type = null, index) {

                    if (type != null) {
                        if (type == 'inventory') {
                            if (this.inventories[index + 1] == undefined) {

                                var b = _.clone(this.bankes)
                                var accounts = b.filter((account) => {
                                    return (new RegExp(homeCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                                })
                                
                                var defaultAccount = null;
                                var selected_banks=_.find(this.bankes,(v)=>v.code==homeCurrency.code);
                                if (selected_banks){
                                    defaultAccount = selected_banks.id;
                                }

                                this.inventories.push({
                                    inventory: null,
                                    loading: null,
                                    load_off:true, 
                                    load_type: 'OverLoad',
                                    load_quantity: 0,
                                    loading_type: 'OverLoad',
                                    loading_quantity: 0,
                                    fined_quantity: 0,
                                    item: null,
                                    temp_loading:[],
                                    temp_items:[],
                                    contract: null, 
                                    wagonList: [], 
                                    wagon: null,
                                    cash:null,
                                    item_category: this.selected_iventory_category,
                                    driver: null,
                                    vehicle: null,
                                    currency: homeCurrency,
                                    driver_type: 'OwnDriver',
                                    tanker: null,
                                    currency_list: currency,
                                    other_driver_name: null,
                                    other_vehicle_name: null,
                                    cmr_number: null,
                                    destination: null,
                                    loading_date: null,
                                    source: null,
                                    transit_number: null,
                                    defaultAccount:defaultAccount, 
                                    accounts: accounts
                                });
                            }
                        }
                        if (type == 'adjustment') {
                            if (this.adjustment[index + 1] == undefined) {

                                this.adjustment.push({
                                    item: null,
                                    inventory: null
                                });
                            }
                        }


                    }

                },

                // delete item from list
                deleteItem(type = null, index, category = "adjustment") {
                    if (type != null) {
                        if (type == 'inventory') {
                            this.inventories.splice(index, 1);
                        }
                        if (type == 'adjustment') {
                            this.adjustment.splice(index, 1);
                        }


                    }

                },
                // submit the form
                submitForm() {

                    // if (this.isError == true) {
                    // alert('there is no item');
                    // return false;
                    // }
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("transfer-and-loading-form").submit()

                        } else {

                        }
                    });

                },


            },
            mounted: function() {

                if (this.transferAndLoading) {
                    this.selected_type = this.transferAndLoading.type;
                    this.type_number = this.transferAndLoading.type_number;
                    this.ref_no = this.transferAndLoading.ref_no;
                    this.selected_otherIncome = _.find(this.otherIncome, (o) => o.id == this.transferAndLoading.other_income_account_id);


                    // begin transfer

                    for (var i = 0; i < this.transferSelectedItem.length; i++) {

                        var currency = [];
                        var fined_amount = null;

                        var vehicle = null;
                        var tanker = null;
                        var driver = null;
                        var selected_currency = null;
                        var s_rate = 1;
                        var total_transfer_fee = 0;
                        var itransfer_total = 0;
                        var driver_type = 'OwnDriver';
                        var other_driver_name = null;
                        var other_vehicle_name = null;
                        var cmr_number = null;
                        var destination = null;
                        var loading_date = null;
                        var source = null;
                        var transit_number = null;
                        var contractss = null;
                        var wagonList = [];
                        var wagon = null;
                        
                        if (this.transferSelectedItem[i].loading) {
                            // console.log(this.transferSelectedItem[i].loading);
                            if (this.transferSelectedItem[i].loading.vehicle_id != null) {
                                vehicle = _.find(this.vehicle, (v) => v.id == this.transferSelectedItem[i].loading.vehicle_id);
                                tanker = _.find(this.vehicle, (v) => v.id == this.transferSelectedItem[i].loading.tanker_id);
                            }

                            if (vehicle != null) {
                                vehicle.rent = this.transferSelectedItem[i].loading.v_rent;
                                vehicle.rate = this.transferSelectedItem[i].loading.v_rate;
                            }
                            if (tanker != null) {
                                tanker.rent = this.transferSelectedItem[i].loading.v_rent;
                                tanker.rate = this.transferSelectedItem[i].loading.v_rate;
                            }
                            driver = _.find(this.driver, (v) => v.id == this.transferSelectedItem[i].loading.driver_id);
                            selected_currency = _.find(this.currency_list, (v) => v.code == this.transferSelectedItem[i].loading.currency);
                            s_rate = this.transferSelectedItem[i].loading.rate;
                            driver_type = this.transferSelectedItem[i].loading.driver_type;
                            total_transfer_fee = this.transferSelectedItem[i].loading.total_transfer_fee;
                            // console.log(33, this.transferSelectedItem[i].rent_quantity);
                            // var qty = ((this.transferSelectedItem[i].quantity - Number.parseFloat((this.transferSelectedItem[i].loading.loading_type == 'Leakage') ? this.transferSelectedItem[i].loading.loading_qty : 0)) + Number.parseFloat((this.transferSelectedItem[i].loading.loading_type == 'OverLoad') ? this.transferSelectedItem[i].loading.loading_qty : 0))
                            itransfer_total = (this.transferSelectedItem[i].rent_quantity * this.transferSelectedItem[i].loading.total_transfer_fee);
                            // selected_currency.rate = s_rate;

                            other_driver_name = this.transferSelectedItem[i].loading.other_driver_name;
                            other_vehicle_name = this.transferSelectedItem[i].loading.other_vehicle_name;
                            cmr_number = this.transferSelectedItem[i].loading.cmr_number;
                            destination = this.transferSelectedItem[i].loading.destination;
                            loading_date = this.transferSelectedItem[i].loading.loading_date;
                            source = this.transferSelectedItem[i].loading.source;
                            transit_number = this.transferSelectedItem[i].loading.transit_number;

                        }

                        currency = _.find(this.currency_list, (c) => c.code == this.transferSelectedItem[i].currency);
                        if (currency) {
                            currency.rate = this.transferSelectedItem[i].rate;
                        }

                        var b = _.clone(this.bankes)
                        var accounts = b.filter((account) => {
                            return (new RegExp(currency.code.toLowerCase())).test(account.code.toLowerCase())
                        })
                        
                        var defaultAccount = null;
                        var selected_banks=_.find(this.bankes,(v)=>v.id==this.transferSelectedItem[i].account_id);
                        if (selected_banks){
                            defaultAccount = selected_banks.id;
                        }

                        // var item_category=_.find(this.inventory_category,(v)=>v.id==this.transferSelectedItem[i].inventory_category_id);
                        contractss=_.find(this.contracts,(v)=>v.id==this.transferSelectedItem[i].contract_id);
                        if (contractss) {
                            if (contractss.wagon) {
                                wagonList = contractss.wagon;
                                wagon =_.find(wagonList,(v)=>v.name==this.transferSelectedItem[i].wagon_number);
                            }
                        }

                        ///////////
                        this.inventories.push({
                            loading_v: this.transferSelectedItem[i].vehicle,
                            load_off: (this.transferSelectedItem[i].load_off == 'On')?false:true,
                            load_type: this.transferSelectedItem[i].load_type,
                            load_quantity: this.transferSelectedItem[i].over_load_quantity,
                            fined_quantity: this.transferSelectedItem[i].fined_quantity,
                            cash:this.transferSelectedItem[i].fined_type,
                            currency: currency,
                            inventory: this.transferSelectedItem[i],
                            item: this.transferSelectedItem[i],
                            item_category: this.transferSelectedItem[i].item_category,
                            amount: fined_amount,
                            currency_list: this.currency_list,
                            loading: this.transferSelectedItem[i].loading,
                            temp_loading:[], 
                            temp_items:[],
                            contract: contractss,
                            wagonList: wagonList,
                            wagon: wagon,
                            transfer_fee: total_transfer_fee,
                            itransfer_total: itransfer_total,
                            driver_type: driver_type,
                            vehicle: vehicle,
                            tanker: tanker,
                            driver: driver,
                            load_currency: selected_currency,
                            loading_type: (this.transferSelectedItem[i].loading)?this.transferSelectedItem[i].loading.loading_type:'OverLoad',
                            loading_quantity: (this.transferSelectedItem[i].loading)?this.transferSelectedItem[i].loading.loading_qty:0,
                            other_driver_name: other_driver_name,
                            other_vehicle_name: other_vehicle_name,
                            cmr_number: cmr_number,
                            destination: destination,
                            loading_date: loading_date,
                            source: source,
                            transit_number: transit_number,
                            defaultAccount:defaultAccount, 
                            accounts: accounts
                        });
                    }
                    // end transfer
                }

            }

        });
    </script>


    @endpush