@extends('layouts.factor-master')

@section('content')
    <?php
     $report = customeReportNew('transfer_and_loading');
     $_transporter_name= !in_array('transporter_name', $report);
     $_driver=!in_array('driver', $report);
     $_vehicle_name=!in_array('vehicle_name', $report);
     $_source=!in_array('source', $report);
     $_destination=!in_array('destination', $report);
     $_item =!in_array('item', $report);
     $_quantity=!in_array('quantity', $report);
     $_rent_quantity=!in_array('rent_quantity', $report);
     $_unit= !in_array('unit', $report);
     $_aproved_code=!in_array('aproved_code', $report);
     $_currency=!in_array('currency', $report);
     $_rate=!in_array('rate', $report);
     $_price=!in_array('price', $report);
     $_total =!in_array('total', $report);
     $_site_loading =!in_array('site_loading', $report);
 

     $report_percent = customeReportNewPercent('transfer_and_loading');
     $_transporter_name_percent= (array_key_exists('transporter_name___percent', $report_percent))?$report_percent['transporter_name___percent']:null;
     $_driver_percent= (array_key_exists('driver___percent', $report_percent))?$report_percent['driver___percent']:null;
     $_vehicle_name_percent= (array_key_exists('vehicle_name___percent', $report_percent))?$report_percent['vehicle_name___percent']:null;
     $_source_percent= (array_key_exists('source___percent', $report_percent))?$report_percent['source___percent']:null;
     $_destination_percent= (array_key_exists('destination___percent', $report_percent))?$report_percent['destination___percent']:null;
     $_item_percent= (array_key_exists('item___percent', $report_percent))?$report_percent['item___percent']:null;
     $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
     $_rent_quantity_percent= (array_key_exists('rent_quantity___percent', $report_percent))?$report_percent['rent_quantity___percent']:null;
     $_unit_percent= (array_key_exists('unit___percent', $report_percent))?$report_percent['unit___percent']:null;
     $_aproved_code_percent= (array_key_exists('aproved_code___percent', $report_percent))?$report_percent['aproved_code___percent']:null;
     $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
     $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
     $_price_percent= (array_key_exists('price___percent', $report_percent))?$report_percent['price___percent']:null;
     $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
     $_site_loading_percent= (array_key_exists('site_loading___percent', $report_percent))?$report_percent['site_loading___percent']:null;

    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.FareLettersReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
            

            @if($inventory_site_name)
            <td>
              <span>@lang('layout.SiteName')</span>: {{$inventory_site_name}}
            </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table" style="margin-top: 20px;" cellpadding="5px">
        <tr style="font-weight: bold; font-size: 17px" class="bg">
        <td class="center"> @lang('layout.Record') </td>
        @if($_driver)<td @if($_driver_percent) width="{{$_driver_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.DriverCompany')</div></td> @endif
        @if($_transporter_name)<td @if($_transporter_name_percent) width="{{$_transporter_name_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Transporter_name')</div></td> @endif
        @if($_vehicle_name)<td @if($_vehicle_name_percent) width="{{$_vehicle_name_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.VehiclePlateNumber')</div></td> @endif
        @if($_source)<td @if($_source_percent) width="{{$_source_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Source')</div></td> @endif
        @if($_destination)<td @if($_destination_percent) width="{{$_destination_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Destination')</div></td> @endif
        @if($_item) <td @if($_item_percent) width="{{$_item_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Item')</div></td> @endif
        @if($_site_loading) <td @if($_site_loading_percent) width="{{$_site_loading_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Site')</div></td> @endif
        @if($_quantity) <td @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Quantity')</div></td> @endif
        @if($_rent_quantity) <td @if($_rent_quantity_percent) width="{{$_rent_quantity_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.RentQuantity')</div></td> @endif
        @if($_unit) <td @if($_unit_percent) width="{{$_unit_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Unit/M')</div></td> @endif
        @if($_aproved_code) <td @if($_aproved_code_percent) width="{{$_aproved_code_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.AprovedCode')</div></td> @endif
        @if($_currency) <td @if($_currency_percent) width="{{$_currency_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Currency')</div></td> @endif
        @if($_rate) <td @if($_rate_percent) width="{{$_rate_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Rate')</div></td> @endif
        @if($_price) <td @if($_price_percent) width="{{$_price_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Price')</div></td> @endif
        @if($_total) <td @if($_total_percent) width="{{$_total_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Total')</div></td> @endif
        @if($_total) <td @if($_total_percent) width="{{$_total_percent}}%" @endif class="mt" class="center" ><div>@lang('layout.Total') {{getHomeCurrency()[getCurrencyType()]}}</div></td> @endif
       
    </tr> 
       <?php
          $count = 0;
          $totalDollor = 0;
          $colspan = 16;
          $currencies_in=[]; 
        ?>
      
       @foreach($data AS $record)
      <tr>
        <?php
                $totalDollor = $totalDollor + ($record->Total/$record->Rate);
                if($record['Total']>0){
                if(array_key_exists($record['Currency'], $currencies_in))
                {
                    $currencies_in[$record['Currency']]['Total']=$currencies_in[$record['Currency']]['Total']+$record['Total'];
                    $currencies_in[$record['Currency']]['base_amount']=$currencies_in[$record['Currency']]['base_amount']+($record['Total']/$record['Rate']);
                }
                else
                {
                    $currencies_in[$record['Currency']]['Total']=$record['Total'];
                    $currencies_in[$record['Currency']]['base_amount']=($record['Total']/$record['Rate']);
                }
            }
        ?>

      <td class="center"> {{++$count}} </td>
      @if($_driver)<td class="center">{{($record->driver_name)?$record->driver_name:''}} </td> @endif
      @if($_transporter_name)<td class="center">{{($record->other_driver_name)?$record->other_driver_name:''}}</td> @endif
      @if($_vehicle_name)<td class="center">{{($record->other_vehicle_name)?$record->other_vehicle_name:''}}</td> @endif
      @if($_source)<td class="center">{{$record->source}}</td> @endif
      @if($_destination)<td class="center">{{$record->destination}}</td> @endif
      @if($_item)<td class="center">{{$record->items}}</td> @endif
      @if($_quantity)<td class="center">{{$record->qty}}</td> @endif
      @if($_site_loading)<td class="center">{{$record->site}}</td> @endif
      @if($_rent_quantity)<td class="center">{{$record->rent_quantity}}</td> @endif
      @if($_unit)<td class="center">{{$record->measure}}</td> @endif
      @if($_aproved_code)<td class="center">{{$record->aproved_code}}</td> @endif
      @if($_currency)<td class="center">{{$record->Currency}}</td> @endif
      @if($_rate)<td class="center">{{$record->Rate}}</td> @endif
      @if($_price)<td class="center">{{myRound($record->total_transfer_fee, 3)}}</td> @endif
      @if($_total)<td class="center">{{myRound($record->Total, 3)}}</td> @endif
      @if($_total)<td class="center">{{myRound($record->Total/$record->Rate, 3)}}  </td> @endif
      </tr>
      @endforeach

      @if(!$_transporter_name)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_driver)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_vehicle_name)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_source)  <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_destination)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_item)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_quantity)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_rent_quantity)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_unit)  <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_aproved_code)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_currency)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_rate)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_price)   <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_total)  <?php  $colspan = $colspan-1;  ?>       @endif
      @if(!$_site_loading)  <?php  $colspan = $colspan-1;  ?>       @endif
      <tr class="bg">
        <td colspan="{{$colspan}}" class="center"> @lang('layout.Total') </td>
        <td colspan="1">{{myRound($totalDollor, 3)}}  {{getHomeCurrency()[getCurrencyType()]}}</td>
      </tr>
      </table>


      <table class="main-table" style="margin-top:1%">
        <tr class="bg">
          <td colspan="5" class="center">
            <h3>@lang('layout.TotalFareLettersAsCurrencies')</h3>
          </td>
        </tr>
        <tr>
          <td>
            <div class="center"> @lang('layout.Record') </div>
          </td>
          <td>
            <div class="center"> @lang('layout.Currency') </div>
          </td>
          <td>
            <div class="center"> @lang('layout.Amount') </div>
          </td>
          <td>
            <div class="center"> @lang('layout.Amount') {{getHomeCurrency()[getCurrencyType()]}} </div>
          </td>
          <td>
            <div class="center"> @lang('layout.AverageRate') </div>
          </td>
        </tr>
        <?php
    $count=0;
    foreach($currencies_in As $key=>$currency)
    {
      ?>
        <tr>
          <td>
            <div class="center">{{++$count}}</div>
          </td>
          <td>
            <div class="center">{{$key}}</div>
          </td>
          <td>
            <div class="center">{{myRound($currency['Total'], 3)}}</div>
          </td>
          <td>
            <div class="center">{{myRound($currency['base_amount'], 3)}}</div>
          </td>
          <td>
            <div class="center">{{myRound($currency['Total'] / $currency['base_amount'], 3)}}  {{getHomeCurrency()[getCurrencyType()]}}</div>
          </td>
    
        </tr>
        <?php
    }
    ?>
      </table>
    
    

           <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection