@extends('layouts.factor-master')

@section('content')
    <?php
     $report = customeReportNew('transfer_and_loading_index');
  

    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.TransferAndLoadingDetailReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Measure')</th>
            <th>@lang('layout.FactorNumber')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.FromSite')</th>
            <th>@lang('layout.ToSite')</th>
            <th>@lang('layout.SourcePlace')</th>
            <th>@lang('layout.Destination')</th>
            <th>@lang('layout.Driver')</th>
            <th>@lang('layout.VehicleName')/@lang('layout.NumberWagon')</th>
            <th>@lang('layout.AprovedCode')</th>
            <th>@lang('layout.Currency')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.FinedAmount')</th>
            <th>@lang('layout.BuyOverLoad')</th>
            <th>@lang('layout.RentQuantity')</th>
            <th>@lang('layout.TotalTransferFee')</th>
        </tr>
        </thead>
        <?php
        $count = 0;
        $totales = 0;
        $qty = 0;
        $rentQuantity = 0;
        ?>
        @foreach($data AS $record)
            <?php
            $totales += ((double)$record->Total / (double)$record->fined_rate);
            $qty += ((double)$record->quantity);
            $rentQuantity += ((double)$record->rent_quantity);
            ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">@lang('layout.' . $record->save_type)</td>
                <td class="center">{{$record->item_name}}</td>
                <td class="center">{{$record->selected_measure}}</td>
                <td class="center">{{$record->factor_number}}</td>
                <td class="center">{{$record->quantity}}</td>
                <td class="center">{{$record->from_site}}</td>
                <td class="center">{{$record->to_site}}</td>
                <td class="center">{{$record->source}}</td>
                <td class="center">{{$record->destination}}</td>
                <td class="center">{{$record->driver_name}}</td>
                @if ($record->driver_type == 'ForeignDriver') 
                   <td class="center"> {{$record->other_vehicle_name}} </td>
                 @else 
                   <td class="center"> {{$record->vehicle_name}} </td>
                @endif
                <td class="center">{{$record->aproved_code}}</td>
                <td class="center">{{$record->fined_currency}}</td>
                <td class="center">{{$record->fined_rate}}</td>
                @if($record->load_type  == 'Leakage') 
                    @if($record->fined_rate > 0 && $record->fined_amount > 0)
                        <td class="center">{{myRound($record->fined_amount * $record->fined_rate)}}</td> 
                     @else 
                        <td class="center">{{myRound($record->fined_amount)}}</td>  
                        @endif
                 @else 
                    <td class="center"></td>
                @endif
                @if($record->load_type  == 'OverLoad') 
                    @if ($record->fined_rate > 0 && $record->fined_amount > 0) 
                        <td class="center">
                            {{$record->fined_amount * $record->fined_rate}}
                         </td>
                     @else 
                     <td class="center">
                        {{myRound($record->fined_amount)}}
                     </td>
                    @endif
                 @else 
                 <td class="center">
                 </td>
                @endif
                <td class="center">{{$record->rent_quantity}}</td>
                <td class="center">@if($record->Total) {{myRound($record->Total)}} {{$record->fined_currency}} @endif</td>
            </tr>

        @endforeach
        <tr class="bg">
            <td colspan="4" class="center"> @lang('layout.Total') </td>
            <td colspan="1" class="center">{{myRound($qty)}}</td>
            <td colspan="12" class="center"></td>
            <td colspan="1" class="center">{{myRound($rentQuantity)}}</td>
            <td colspan="1" class="center">{{myRound($totales)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
        </tr>
    </table>


    
           <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection