@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>
        .required {
            padding-left: 0px !important;
            color: red;
        }
    </style> 
@stop
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <!-- BEGIN TAB PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>&nbsp;
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.AddLoading')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="app" class="portlet-body">

                    <div class="tabbable tabbable-tabdrop">

                        <div>
                            {{Form::open(['route' => 'transferAndLoading.loading_store','method' => 'POST','class' => 'form-horizontal','id'=>'transfer-and-loading-form'])}}
                            {{ csrf_field() }}
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab1">
                                    <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                        <!-- BEGIN FORM-->


                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Number')</label>
                                                            <input type="text" name="number"  class="form-control" value="{{$number}}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                                            <input type="text" name="ref_no" v-model="ref_no"
                                                                   class="form-control" @input="checkRefNo()">
                                                            <span v-if="isError1 ==true" class="input-has-error"
                                                                  style="color: red">@{{msg}}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                                <div class="row">
                                                    
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Date')</label> 
                                                                <input type="text" name="date"
                                                                 class="form-control date now" autocomplete="off"
                                                                 @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                                                 <span class="required">@{{errors.first('date')}}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.DeliveryDate')</label>

                                                                <input type="text" name="delivery_date"
                                                                       class="form-control date" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    
                                                    <!-- <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.ContractName')</label>
                                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                                v-model="selectedContract" label="company_name"
                                                                :options="{{$contract}}">
                                                        </v-select>
                                                        <input type="hidden" name="contract_id"
                                                            v-model.number="(!selectedContract)?null:selectedContract.id"
                                                            v-validate="''" data-vv-as="@lang('layout.ContractName')">
                                                        <span class="required">@{{ errors.first('contract_id') }}</span>
                                                    </div>
                                                    </div> -->
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control" rows="2"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            <div class="row" style="overflow-x: scroll;">
                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        
                                                        <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                        <th style="min-width: 220px">@lang('layout.Contract') </th>
                                                        <th style="min-width: 150px">@lang('layout.WagonNumber') </th>
                                                        <th style="min-width: 160px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 150px">@lang('layout.FromSite') </th>
                                                        <th style="min-width: 150px">@lang('layout.ToSite') </th>
                                                        <th style="min-width: 150px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 50px">@lang('layout.OnHand') </th>
                                                        <th style="min-width: 120px">@lang('layout.Measure') </th>
                                                        <th style="min-width: 120px">@lang('layout.FactorNumber') </th>
														<th style="min-width: 160px">@lang('layout.Transporter_name') </th>
														<!-- th v-if="driver_type == 'OwnDriver'" style="min-width: 100px">@lang('layout.TankerNumber') </th -->
														<th style="min-width: 160px">@lang('layout.VehicleName')/@lang('layout.NumberWagon') </th>
														<th style="min-width: 160px">@lang('layout.TankerNumber') </th>
														<th v-if="driver_type == 'ForeignDriver1'" style="min-width: 160px">@lang('layout.Driver') </th>
														<th v-if="driver_type == 'ForeignDriver1'" style="min-width: 160px">@lang('layout.VehicleName')/@lang('layout.NumberWagon') </th>
														<th style="min-width: 120px">@lang('layout.TransitNumber') </th>
														<th style="min-width: 120px">@lang('layout.WayBillNumber') </th>
														<th style="min-width: 120px">@lang('layout.SourcePlace') </th>
														<th style="min-width: 120px">@lang('layout.Destination') </th>
														<th style="min-width: 100px">@lang('layout.LoadingDate') </th>
                                                        <th style="min-width: 120px">@lang('layout.RentQuantity') </th>
														<th style="min-width: 120px">@lang('layout.Price') </th>
														<th style="min-width: 100px">@lang('layout.Currency') </th>
														<th style="min-width: 120px">@lang('layout.Rate') </th>
														<th style="min-width: 120px">@lang('layout.AprovedCode') </th>
                                                        <th style="min-width: 120px">@lang('layout.Rent') </th>
                                                        <th style="min-width: 120px">@lang('layout.Rate') </th>
														<th style="min-width: 50px">@lang('layout.TotalTransferFee') </th>
                                                        <th></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td @click="addNew('inventory',index)">@{{index+1}}</td>
                                                        <td @click="addNew('inventory',index)"
                                                            v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category" :options="inventory_category" @input="itemCategoryChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        <td @click="addNew('inventory',index)" >
                                                            <v-select label="company_name" v-model="item.contract" :options="contracts" @input="contractChange(index), contractWagon(index)"></v-select>
                                                            {{-- <input :value="(!item.contract)?null:item.contract.company_name" style="width: 0px; height: 0px; padding: 0px; opacity: 0;"> --}}
                                                            <input type="hidden" name="contract_id[]" :value="(!item.contract)?null:item.contract.id">
                                                        </td>
                                                        <td>
                                                            <v-select label="name" v-model="item.wagon" :options="item.wagonList" @input="contractChange(index)"></v-select>
                                                            <input type="hidden" name="wagon_number[]" :value="(!item.wagon)?null:item.wagon.name">
                                                        
                                                        </td>
                                                        <td @click="addNew('inventory',index)" class="highlight">
                                                            <v-select label="name" @keyup.native="editKey = true, setIndex(index)" @click.native="editKey = true, setIndex(index)" @input="(editKey)?onItemload(index):''"
                                                            v-model="item.inventory" :options="item.items_list" @search="onItemSearch"></v-select>
                                                            {{-- <input :value="(!item.inventory)?null:item.inventory.name" style="width: 0px; height: 0px; padding: 0px; opacity: 0;"> --}}
                                                            <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                            
                                                            <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                            
                                                        </td>
                                                        
                                                        <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site"
                                                                    class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
                                                                <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                                        :value="site">
                                                                  @{{site.site_name}}
                                                                </option> 
                                                              </span>
                                                            </select>
                                                            <input type="hidden" name="from_site[]"
                                                                   :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        
                                                                </td>
														
                                                        <td @click="addNew('inventory',index)">
                                                          <span v-if="(item.item !=null)">
                                                            <select class="form-control input_style"
                                                                    placeholder="@lang('layout.ToSite')"

                                                                    v-model="!item.item?null:item.item.to_site">

                                                            <option v-if="item.item.site.site_id!=si.id"
                                                                    v-for="si in site"
                                                                    :value="si.id">@{{si.name}}
                                                            </option>
                                                        </select>
                                                        </span>
                                                            <input type="hidden" name="to_site[]"
                                                                   :value="(!item.item)?null:(item.item.to_site)?item.item.to_site:null">
                                                        </td>
                                                        <td @click="addNew('inventory',index)">

                                                            <input type="number" :name="'inventory_quantity['+index+']'"
                                                                   v-validate="''" data-vv-as="@lang('layout.Quantity')"
                                                                   v-model.number="(item.item==null)?null:item.item.quantity"
                                                                   @input="setRentQuantity(index)"
                                                                
                                                                   class="form-control input-style input-number chan_length"
                                                                   placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>

                                                        <td @click="addNew('inventory',index)">
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity + item.fined_quantity + ((item.load_type=='Leakage')?item.load_quantity:0)))}}
                                                        </td>

                                                        <td @click="addNew('inventory',index)" class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure"
                                                                    class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                                            :value="measure">
                                                                    @{{measure.measure_name}}
                                                                  </option>
                                                                </span>


                                                            </select>

                                                            <input type="hidden" name="inventory_measure[]"
                                                                   :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                            <input type="text" :name="'factor_number['+index+']'" placeholder="@lang('layout.FactorNumber')" class="form-control chan_length">
                                                        </td>
														<td>
                                                            <v-select label="name" v-model="item.driver" @input="vehicleSearch(index)"
                                                                    :options="driver"></v-select>
                                                            <input type="hidden" :name="'driver_id['+index+']'" :value="(!item.driver)?null:item.driver.id">
                                                            <input type="hidden" :name="'driver_type['+index+']'" :value="(!item.driver)?null:item.driver.driver_type">
									                        <input type="hidden" :name="'foreign_type['+index+']'" :value="(!item.driver)?null:item.driver.foreign_type">
                                                        </td>
                                                        <td v-if="((item == null)?'': item.driver_type) == 'OwnDriver'">
                                                            <v-select label="name" v-model="item.vehicle" @input="carChange(index)" :options="vehicle"></v-select>
                                                            <input type="hidden" :name="'vehicle_id['+index+']'" :value="(!item.vehicle)?null:item.vehicle.id">
                                                            <input type="hidden" :name="'vehicle_currency['+index+']'" :value="(!item.vehicle)?null:item.vehicle.currency">
                                                            <input type="hidden" :name="'vehicle_driver_id['+index+']'" :value="(!item.vehicle)?null:item.vehicle.driver_id">
                                                            <input type="hidden" :name="'vehicle_foreign_type['+index+']'" :value="(!item.vehicle)?null:item.vehicle.foreign_type">
                                                        </td>
                                                        <td v-if="((item == null)?'': item.driver_type) == 'OwnDriver'">
                                                            <v-select label="name" v-model="item.tanker" @input="tankerChange(index)" :options="vehicle"></v-select>
                                                            <input type="hidden" :name="'tanker_id['+index+']'" :value="(!item.tanker)?null:item.tanker.id">
                                                            <input type="hidden" :name="'tanker_currency['+index+']'" :value="(!item.tanker)?null:item.tanker.currency">
                                                            <input type="hidden" :name="'tanker_driver_id['+index+']'" :value="(!item.tanker)?null:item.tanker.driver_id">
                                                            <input type="hidden" :name="'tanker_foreign_type['+index+']'" :value="(!item.tanker)?null:item.tanker.foreign_type">
                                                        </td>
                                                        <td v-if="((item == null)?'': item.driver_type) == 'ForeignDriver'">
                                                            <input type="text" :name="'other_driver_name['+index+']'"  placeholder="@lang('layout.Driver')"
                                                         class="form-control chan_length">
                                                        </td>
                                                        <td v-if="((item == null)?'': item.driver_type) == 'ForeignDriver'">
                                                            <input type="text" :name="'other_vehicle_name['+index+']'"  placeholder="@lang('layout.VehicleName')/@lang('layout.NumberWagon')"
                                                         class="form-control chan_length">
                                                        </td>
                                                        <td>
                                                            <input type="text" :name="'transit_number['+index+']'" placeholder="@lang('layout.TransitNumber')"
                                                         class="form-control chan_length">
                                                        </td>
                                                        
                                                        <td>
                                                            <input type="text" :name="'way_bill_number['+index+']'" placeholder="@lang('layout.WayBillNumber')"
                                                         class="form-control chan_length">
                                                        </td>
                                                        <td>
                                                            <input type="text" :name="'source['+index+']'" placeholder="@lang('layout.SourcePlace')"
                                                         class="form-control chan_length">
                                                        </td>
                                                        <td>
                                                            <input type="text" :name="'destination['+index+']'" placeholder="@lang('layout.Destination')"
                                                         class="form-control chan_length">
                                                        </td>
                                                        <td>
                                                            <date_picker :name="'loading_date['+index+']'"
                                                            class="chan_length" placeholder="@lang('layout.LoadingDate')" ></date_picker>
                                                        </td>
                                                        <td>
                                                            <input type="number" :name="'rent_quantity['+index+']'"
                                                                   v-validate="''" data-vv-as="@lang('layout.RentQuantity')"
                                                                   v-model.number="(item.item==null)?null:item.item.rent_quantity"
                                                                   @input="TotalTransferFee(index)"
                                                                
                                                                   class="form-control input-style input-number chan_length"
                                                                   placeholder="@lang('layout.RentQuantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>
                                                        <td>
                                                            <input type="number" :name="'transfer_fee['+index+']'" 
                                                                class="form-control input-style input-number chan_length"
                                                            
                                                                v-model.number="(item==null)?null:item.transfer_fee"
                                                                @input="TotalTransferFee(index)"
                                                                placeholder="@lang('layout.Amount')">
                                                        </td>
                                                        <td>
                                                            <v-select label="code" :options="item.currency_list"
                                                                    v-model="item.currency"></v-select>
                                                            <input type="hidden" :name="'currency_loading['+index+']'"
                                                                :value="(!item.currency)?null:item.currency.code">
                                                        </td>
                                                        <td>
                                                            <input type="number" :name="'currency_rate_loading['+index+']'"
                                                            v-model="!item.currency?0:item.currency.rate"
                                                        
                                                            class="form-control chan_length" :class="{'has-error':!item.currency?0:item.currency.rate<=0}">
                                                        </td>
                                                        <td>
                                                            <input type="text" :name="'aproved_code['+index+']'" placeholder="@lang('layout.AprovedCode')" class="form-control chan_length">
                                                        </td>
                                                        <td>
                                                            <div v-if="((!item.vehicle)?null:item.vehicle.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) == 'ok' ">
                                                                <input type="number" :name="'forign_rent_vehicle['+index+']'" placeholder="@lang('layout.Rate')"
                                                            
                                                                v-model="(!item.vehicle)?0:item.vehicle.rent" class="form-control chan_length" />
                                                            </div>
                                                            <div v-if="((!item.tanker)?null:item.tanker.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) != 'ok' ">
                                                                <input type="number" :name="'forign_rent_tanker['+index+']'" placeholder="@lang('layout.Rate')"
                                                            
                                                                v-model="(!item.tanker)?0:item.tanker.rent" class="form-control chan_length" />
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div v-if="((!item.vehicle)?null:item.vehicle.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) == 'ok' " class="input-group">
                                                                <input type="number" :name="'forign_rate_vehicle['+index+']'" placeholder="@lang('layout.Rate')"
                                                            
                                                                v-model="!item.vehicle?0:item.vehicle.rate" class="form-control chan_length" />
                                                                <span class="input-group-addon">
                                                                @{{(!item.vehicle)?null:item.vehicle.currency}}
                                                                </span>
                                                            </div>
                                                            <div v-if="((!item.tanker)?null:item.tanker.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) != 'ok' " class="input-group">
                                                                <input type="number" :name="'forign_rate_tanker['+index+']'" placeholder="@lang('layout.Rate')"
                                                            
                                                                v-model="!item.tanker?0:item.tanker.rate" class="form-control chan_length" />
                                                                <span class="input-group-addon">
                                                                @{{(!item.tanker)?null:item.tanker.currency}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            @{{(item==null)?null:item.itransfer_total}}
                                                        </td>
														<td>
                                                            <span v-on:click="deleteItem('inventory',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>

                                                    </tbody>
                                                </table>


                                            </div>
                                            <button type="button" v-if="inventories.length<=0"
                                                    @click="addNew('inventory',0)"
                                                    class="btn btn-success" style="background-color: rgb(80, 129, 141) !important;
                                                    border: 1px solid rgb(80, 129, 141); "><i
                                                        class="fa fa-plus"></i></button>

                                            <hr>
											
                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="isError1 ==false" v-if="!isError"
                                                    @click="handleSubmit($event)"
                                                    class="btn green">@lang('layout.Submit')</button>
                                            <button type="button" v-if="isError1 ==false" v-if="!isError"
                                                    class="btn blue"
                                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>

                                            <a href="{{route('transferAndLoading.index')}}" class="btn default"><i
                                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                        </div>

                                        <cmodal :show='showModal' @close="showModal=false">

                                        </cmodal>
                                    </div>

                                </div>


                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')


    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        // Vue.use(VueInputAutowidth);

        Vue.component('v-select', VueSelect.VueSelect);


        var inventory_category = {!! $inventory_category !!};
        var site = {!! $site !!};
        var driver = {!! $driver !!};
        var currency = {!! $currency !!};
		let homeCurrency = {!! json_encode(getHomeCurrency()) !!};
        var otherIncome = {!! $otherIncome !!};
        var contract = {!! $contract !!};
        var wagon = {!! $wagon !!};

        var v = new Vue({
            el: '#app',
            data: {
				
                driver_type: 'OwnDriver',
                showModal: false,
                editKey: false,
                temp_items: [],
                temp_loading: [],
                inventory_category: inventory_category,
                selected_iventory_category: null,
                selected_index: 0,
                selected_index_adjustment: 0,
                site: site,
                currency_list: currency,
                contracts: contract,
                selectedContract: null,
                inventories: [
                    {item: null,inventory:null, items_list:[], loading:null, wagonList:wagon, wagon:null, load_type:'OverLoad', load_quantity:null, fined_quantity:null, item_category: null, driver: null,vehicle:null, currency: homeCurrency, driver_type: 'OwnDriver', tanker: null,currency_list:currency,contract:null},
                ],
                adjustment: [
                    {item: null, inventory: null},
                ],
                selected_type: 'purchase',
                driver: driver,
                otherIncome: otherIncome,
                selected_otherIncome: null,
                type_number: null,
                type_info: null,
                isError: true,
                ref_no: '',
                msg: '',
                isError1: false,
                vehicle:{!! $vehicle !!},



            },
            computed: {},
            methods:
                {
                    checkRefNo() {

                        var chack = 'false';
                        var ref_no = v.ref_no;
                        if (ref_no != null) {


                            axios.get("{{route('callMethod.search')}}",
                                {

                                    params: {
                                        ref_no: v.ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'transfer_and_loadings'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        v.msg = "@lang('layout.DuplicateData')";
                                        v.isError1 = true;
                                    }
                                    else {
                                        v.msg = 'no';
                                        v.isError1 = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },
					
					                    // begin item search

                     onItemSearch: _.debounce((search, loading) => {

                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        let contract_id = (v.inventories[v.selected_index]['contract'] != undefined) ? v.inventories[v.selected_index]['contract'].id : '';
                        let wagon_number = (v.inventories[v.selected_index]['wagon'] != undefined) ? v.inventories[v.selected_index]['wagon'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                contract_id: contract_id,
                                wagon_number: wagon_number,
                            }
                        })
                            .then(function (response) {
                                v.inventories[v.selected_index]['items_list'] = [];
                                if (response.data.length > 0) {
                                    v.inventories[v.selected_index]['items_list'] = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),


                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let contract_id = (v.inventories[v.selected_index]['contract'] != undefined) ? v.inventories[v.selected_index]['contract'].id : '';
                            let wagon_number = (v.inventories[v.selected_index]['wagon'] != undefined) ? v.inventories[v.selected_index]['wagon'].name : '';
                            // console.log('klk', contract_id, wagon_number);
                            
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number,
                                }
                            })
                                .then(function (response) {
                                    // console.log('lal',response.data);
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
										// console.log(132,v.inventories[index].item);
										@if(getDefaultSite() > 0)
											var sites_id = {{getDefaultSite()}}
										for (var i = 0; i < v.inventories[index].item.site_list.length; i++) {
											if (v.inventories[index].item.site_list[i].site_id == sites_id) {
												v.inventories[index].item.site = v.inventories[index].item.site_list[i];
											}
										}
                                        @endif
										
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    setIndex(index) {
                        v.selected_index = index;
                    },

                     onItemloadTransfer(index) {

                        if (v.inventories[index].inventory != null && v.inventories[index].loading != null) {
                            var inventory_id = v.inventories[index].inventory.id;
                            var loading_id = v.inventories[index].loading.id;
                            // console.log('klk',inventory_id,loading_id);
                            
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'onItemloadTransfer',
                                    inventory_id: inventory_id,
                                    loading_id: loading_id,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    contractWagon(index) {
                        if (v.inventories[index]['contract']) {
                            v.inventories[index]['wagon'] = null;
                            v.inventories[index]['wagonList'] = [];
                            // console.log(2222,v.inventories[index]['contract'], this.wagon)
                            v.inventories[index]['wagonList'] = wagon.filter((wagonR) => {
                                return v.inventories[index]['contract'].id == wagonR.contract_id;
                            });
                        }
                    },

                    // set new price
                    TotalTransferFee(index) {
                        if (this.inventories[index].item) {
                            if (this.inventories[index].item.rent_quantity) {
                                this.inventories[index].itransfer_total = myRound(this.inventories[index].item.rent_quantity * this.inventories[index]['transfer_fee']);
                            }
						}
                    },

                    // set new price
                    setRentQuantity(index) {
                        if (this.inventories[index].item) {
                            if (this.inventories[index].item.quantity) {
                                this.inventories[index].item.rent_quantity = this.inventories[index].item.quantity;
                                this.TotalTransferFee(index);
                            }
						}
                    },
					
					vehicleSearch(index) {
						var plate = null;
						if (v.inventories[index].item) {
							// console.log('222pp',v.inventories[index]['driver']);
                          plate = v.inventories[index]['driver']['plate'];
                          v.driver_type = v.inventories[index]['driver']['driver_type'];
						  v.inventories[index]['driver_type'] = v.inventories[index]['driver']['driver_type'];
							// console.log('222',v.inventories[index]['driver']);
							// console.log(v.inventories[index]['transfer_fee'] ,v.inventories[index].item.quantity , v.inventories[index]['transfer_fee']);
						}
						if(plate != null){
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'Search_driver_vehicle',
                                driver_vehicle_plate: plate,
                            }
                        })
                            .then(function (response) {
								
                                if (response.data.result != null) {
                                // console.log('1231',response.data);
                                    v.inventories[index]['vehicle'] = null;
                                    v.inventories[index]['vehicle'] = response.data.result;
                                }
                                console.log('1231',v.inventories[index]);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
						}
                    },
					
					// detect member change and searh
                    carChange(index) {
                        if (v.inventories[index].item) {
                            if (v.inventories[index]['vehicle'].foreign_type == "ok") {
                                var currency = _.find(this.currency_list, (c) => c.code == v.inventories[index]['vehicle'].currency);
                                // console.log('rrrnnss', currency);
                                v.inventories[index]['vehicle'].rate = currency.rate;
                            }
							// console.log('rrrnn', this.selected_vehicle);
                            this.TankerSearch(v.inventories[index]['vehicle'].tanker_number, index, this);
                        }
                    },
                    tankerChange(index) {
                        if (v.inventories[index].item) {
                            if (v.inventories[index]['tanker'].foreign_type == "ok") {
                                var currency = _.find(this.currency_list, (c) => c.code == v.inventories[index]['tanker'].currency);
                                v.inventories[index]['tanker'].rate = currency.rate;
                                // console.log('rrrnnss', currency);
                            }
                        }
                    },
                    TankerSearch(plate, index, vm) {
						if(plate != null){
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'Search_driver_vehicle',
                                driver_vehicle_plate: plate,
                            }
                        })
                            .then(function (response) {
								
                                if (response.data.result != null) {
                                    v.inventories[index]['tanker'] = null;
                                    v.inventories[index]['tanker'] = response.data.result;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
						}
                    },


                   
                    onItemloadAdjustment(index) {

                        v.selected_index = index;
                        if (v.adjustment[index].inventory != null) {
                            // console.log('klk',v.inventories[index].inventory,v.inventories);
                            var inventory_id = v.adjustment[index].inventory.id;
                            let inventory_category_id = (v.adjustment[index]['item_category'] != undefined) ? v.adjustment[index]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                }
                            })
                                .then(function (response) {
                                    v.adjustment[index].item = null;
                                    if (response.data.length > 0) {
                                        v.adjustment[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    itemCategoryChange(index) {
                        // v.selected_iventory_category = this.inventories[index]['item_category'];
                        if (this.inventories[index]['item_category'] != null) {
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchSale',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index]['items_list'] = [];
                                    if (response.data.length > 0) {
                                        v.inventories[index]['items_list'] = response.data;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }

                    },

                    // end item search

                    // contract search

                    contractChange(index) {
                        v.selected_index = index;
                        if (v.inventories[index]['contract'] != null) {
                        v.inventories[index]['inventory'] = null;
                        v.inventories[index]['item'] = null;
                        let contract_id = v.inventories[index]['contract'].id;
                        let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                        let wagon_number = (v.inventories[index]['wagon'])?v.inventories[index]['wagon'].name:null;
                        // console.log(333, wagon_number, contract_id);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                wagon_number: wagon_number,
                                contract_id: contract_id
                            }
                        })
                            .then(function (response) {
                                v.inventories[index]['items_list'] = [];
                                if (response.data.length > 0) {
                                    v.inventories[index]['items_list'] = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },


                    // generic function for adding item to list
                    addNew(type = null, index) {
                        if (type != null) {
                            if (type == 'inventory') {
                                v.selected_index = index;
                                if (this.inventories[index + 1] == undefined) {
                                    this.inventories.push({
                                        inventory: null,
                                        items_list:[],
                                        loading: null,
										load_type:'OverLoad',
										load_quantity:null,
										fined_quantity:null,
                                        item: null,
                                        item_category: this.selected_iventory_category,
                                        wagonList:wagon, 
                                        wagon:null,
                                        driver: null,
                                        vehicle:null,
                                        currency: homeCurrency,
										driver_type: 'OwnDriver', tanker: null,currency_list:currency,
                                        contract:null
                                    });
                                }
                            }
                            if (type == 'adjustment') {
                                v.selected_index = index;
                                if (this.adjustment[index + 1] == undefined) {
                                    this.adjustment.push({
                                        inventory: null, inventory: null,
                                        item: null, inventory: null
                                    });
                                }
                            }


                        }

                    },

                    // delete item from list
                    deleteItem(type = null, index, category = "adjustment") {
                        if (type != null) {
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'adjustment') {
                                this.adjustment.splice(index, 1);
                            }


                        }

                    },
                    // submit the form
                    submitForm() {

                        // if (this.isError == true) {
                            // alert('there is no item');
                            // return false;
                        // }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("transfer-and-loading-form").submit()

                            }
                            else {

                            }
                        });

                    },
                    defaultValue() {
                        this.selected_index = 0;

                        this.inventories = [
                            {item: null, items_list: null, item_category: this.selected_iventory_category},
                        ];
                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {

                                    var url = "{{route('transferAndLoading.loading_store')}}";
                                    form_id = 'transfer-and-loading-form';
                                    var data = $('#' + form_id).serialize();
                                    toggleBlock(true);
                                    axios.post(url, data)
                                        .then(function (response) {
                                            toggleBlock(0);
                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                toastr.success('', response.data.message);

                                                v.defaultValue();
                                            }
                                            else {
                                                var message = "{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            }
                                        })
                                        .catch(function (error) {
                                            toggleBlock(0);
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush