@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>
        .required {
            padding-left: 0px !important;
            color: red;
        }
    </style>
@stop
@section('content')
    <div class="row">
        <div class="portlet light bordered">
            <!-- BEGIN TAB PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>&nbsp;
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.AddTransferAndLoading')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="app" class="portlet-body">

                    <div class="tabbable tabbable-tabdrop">

                        <div>
                            {{Form::open(['route' => 'transferAndLoading.store','method' => 'POST','class' => 'form-horizontal','id'=>'transfer-and-loading-form'])}}
                            {{ csrf_field() }}
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab1">
                                    <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                        <!-- BEGIN FORM-->


                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Number')</label>
                                                            <input type="text" name="number"  class="form-control" value="{{$number}}">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                                            <input type="text" name="ref_no" v-model="ref_no"
                                                                   class="form-control" @input="checkRefNo()">
                                                            <span v-if="isError1 ==true" class="input-has-error"
                                                                  style="color: red">@{{msg}}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                                <div class="row">
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Date')</label>

                                                                <input type="text" name="date"
                                                                       class="form-control date now" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.DeliveryDate')</label>

                                                                <input type="text" name="delivery_date"
                                                                       class="form-control date" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Description')</label>

                                                                <textarea name="description" class="form-control"
                                                                          rows="2"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            <div class="row" style="overflow-x: scroll;">
												<h3 style="margin-right:20px;">@lang('layout.Discharge')</h3>
												
                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th style="">@lang('layout.Off') </th>
                                                        
                                                        <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                        <th style="min-width: 220px">@lang('layout.Contract') </th>
                                                        <th style="min-width: 130px">@lang('layout.WagonNumber') </th>
                                                        <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 130px">@lang('layout.VehicleName')/@lang('layout.NumberWagon') </th>
                                                        <th style="min-width: 100px">@lang('layout.WayBillNumber') </th>
                                                        <th style="min-width: 150px">@lang('layout.FromSite') </th>
                                                        <th style="min-width: 150px">@lang('layout.ToSite') </th>

                                                        <th style="min-width: 150px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 50px">@lang('layout.LoadQuantity') </th>
                                                        <th style="min-width: 50px">@lang('layout.OnHand') </th>

                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <th style="min-width: 160px">@lang('layout.Driver') </th>
                                                        <th style="min-width: 120px">@lang('layout.SourcePlace') </th>
                                                        <th style="min-width: 120px">@lang('layout.Destination') </th>

                                                        <th style="min-width: 100px">@lang('layout.Type') </th>
                                                        <th style="min-width: 150px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 150px">@lang('layout.DriverQuantity') </th>
                                                        <th style="min-width: 150px">@lang('layout.Price') </th>
                                                        <th style="min-width: 100px">@lang('layout.Currency') </th>
                                                        <th style="min-width: 150px">@lang('layout.Rate') </th>
                                                        <th style="min-width: 40px">@lang('layout.Cash') </th>
                                                        <th style="min-width: 120px">@lang('layout.Account') </th>
                                                        <th></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td @click="addNew('inventory',index)">@{{index+1}}</td>
														<td>
															<div class="mt-checkbox" style="padding-left: 0px;">
															 <label class="mt-checkbox mt-checkbox-outline">
															 <input type="checkbox" :name="'load_off['+index+']'" v-model="item.load_off" checked />
															 <span></span>
															 </label>
															</div>
															
														</td>
                                                        <td @click="addNew('inventory',index)"
                                                            v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category" :options="inventory_category" @input="itemCategoryChange(index)"></v-select>
                                                            <input type="hidden" :name="'inventory_category_id['+index+']'" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        <td @click="addNew('inventory',index)" >
                                                            <v-select label="company_name" v-model="item.contract" :options="contracts" @input="contractChange(index)"></v-select>
                                                            {{-- <input  :value="(!item.contract)?null:item.contract.company_name" style="width: 0px; height: 0px; padding: 0px; opacity: 0;"> --}}
                                                            <input type="hidden" name="contract_id[]" :value="(!item.contract)?null:item.contract.id">
                                                        </td>
                                                        <td>
                                                            <v-select label="name" v-model="item.wagon" :options="item.wagonList" @input="contractChange(index)"></v-select>
                                                            <input type="hidden" name="wagon_number[]" :value="(!item.wagon)?null:item.wagon.name">
                                                        </td>
                                                        <td @click="addNew('inventory',index)" class="highlight">
                                                        <v-select label="name" @keyup.native="editKey = true, setIndex(index)" @click.native="editKey = true, setIndex(index)" @input="(editKey)?onItemload(index):''"
                                                        v-model="item.inventory" :options="item.temp_items" @search="onItemSearch"></v-select>
                                                        {{-- <input  :value="(!item.inventory)?null:item.inventory.name" style="width: 0px; height: 0px; padding: 0px; opacity: 0;"> --}}
														<input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
														<span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                        </td>
                                                        <td @click="addNew('inventory',index)" class="highlight">
                                                        <v-select label="name" @keyup.native="editKey = true, setIndex(index)" @click.native="editKey = true, setIndex(index)" @input="(editKey)?onItemloadTransfer(index):''"
                                                        v-model="item.loading" :options="item.temp_loading" @search="onItemSearchLoading" ></v-select>
														<input type="hidden" :name="'loading_id['+index+']'" v-validate="''"
															   data-vv-as="@lang('layout.ItemName')"
															   :value="(!item.loading)?null:item.loading.id">
														<span class="required">@{{ errors.first('loading_id['+index+']') }}</span>
														
                                                        </td>
														<td>
                                                            @{{(item.item==null)?null:item.item.cmr_number}}
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site"
                                                                    class="form-control" disabled>
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
                                                                <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                                        :value="site">
                                                                  @{{site.site_name}}
                                                                </option> 
                                                              </span>
                                                            </select>
                                                            <input type="hidden" name="from_site[]"
                                                                   :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td @click="addNew('inventory',index)">
                                                          <span v-if="(item.item !=null)">
                                                            <select class="form-control input_style"
                                                                    placeholder="@lang('layout.ToSite')"

                                                                    required="required"
                                                                    v-model="!item.item?null:item.item.to_site">

                                                            <option v-if="item.item.site.site_id!=si.id"
                                                                    v-for="si in site"
                                                                    :value="si">@{{si.name}}
                                                            </option>
                                                        </select>
                                                        </span>
                                                            <input type="hidden" name="to_site[]"
                                                                   :value="(!item.item)?null:(item.item.to_site)?item.item.to_site.id:null">
                                                        </td>
                                                        <td @click="addNew('inventory',index)">
                                                            <input type="number" :name="'inventory_quantity['+index+']'"
                                                                   v-validate="''" data-vv-as="@lang('layout.Quantity')"
                                                                   v-model.number="(item.item==null)?null:item.item.quantity"
                                                                   
                                                                   class="form-control input-style input-number chan_length"
                                                                   @input="selectLoadType(index), setRentQuantity(index)"
                                                                   placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>
                                                        <td>
                                                            @{{myRound((item.item==null)?null:((item.item.load_quantity * item.item.measure_unit) / (item.item.measure.measure_unit)))}}
                                                        </td>
                                                        <td @click="addNew('inventory',index)">
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item, Number(item.item.quantity) + Number((item.load_type=='Leakage')?(item.fined_quantity): -(item.fined_quantity)) + Number((item.load_type=='Leakage')?(item.load_quantity): -(item.load_quantity))))}}
                                                            {{-- @{{myRound((item.item==null)?null:saleItemQuantity(item.item, Number(item.item.quantity) + Number(item.fined_quantity) + Number((item.load_type=='Leakage')?(item.load_quantity):0)))}} --}}
                                                        </td>

                                                        <td @click="addNew('inventory',index)" class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure"
                                                                    class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                                            :value="measure">
                                                                    @{{measure.measure_name}}
                                                                  </option>
                                                                </span>


                                                            </select>

                                                            <input type="hidden" name="inventory_measure[]"
                                                                   :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
														<td>
                                                            @{{(item.item==null)?null:item.item.driver_name}}
                                                        </td>
														<td>
                                                            @{{(item.item==null)?null:item.item.source}}
                                                        </td>
														<td>
                                                            @{{(item.item==null)?null:item.item.destination}}
                                                        </td>
														
														<td class="highlight">
                                                            <select v-model="(item==null)?null:item.load_type"
                                                                    class="form-control">
                                                                <option value="OverLoad">@lang('layout.OverLoad')</option>
                                                                <option value="Leakage">@lang('layout.Leakage')</option>
                                                            </select>

                                                            <input type="hidden" name="load_type[]"
                                                                   :value="(item==null)?null:item.load_type">
                                                        </td>
														<td>
                                                            <input type="number" :name="'load_quantity['+index+']'"
                                                                   v-model.number="(item==null)?null:item.load_quantity"
                                                                   
                                                                   class="form-control input-style input-number chan_length"
                                                                   :placeholder="(item.load_type=='OverLoad')?`@lang('layout.OverLoad')`:`@lang('layout.LoadDrop')`">
                                                        </td>
														
														<td>
                                                            <input type="number" :name="'fined_quantity['+index+']'"
                                                                   v-model.number="(item==null)?null:item.fined_quantity"
                                                                   
                                                                   class="form-control input-style input-number chan_length"
                                                                   :placeholder="(item.load_type=='OverLoad')?`@lang('layout.BuyOverLoad')`:`@lang('layout.FinedAmount')`">
                                                        </td>
														<td>
                                                            <input type="number" :name="'fined_cost['+index+']'"
                                                                   v-model.number="(item.item==null)?null:item.item.cost"
                                                                   
                                                                   class="form-control input-style input-number chan_length"
                                                                   placeholder="@lang('layout.Amount')">
                                                        </td>
														
                                                        <td @click="addNew('inventory',index)">
                                                            <v-select label="code" v-model="item.currency" @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?(changePrice(index), setSizeRow(item.currency.code,index)):''" 
                                                            :options="currency_list"></v-select>
                                                            <input type="hidden" name="fined_currency[]"
                                                                   :value="(!item.currency)?null:item.currency.code">
                                                        </td>
                                                        <td>
                                                            <input type="number" name="fined_currency_rate[]"
                                                            
															class="form-control input-style input-number chan_length"
                                                                   v-model="(!item.currency)?null:item.currency.rate">
                                                        </td>
                                                        <td>
                                                            <div class="mt-checkbox" style="padding-left: 0px;">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" :name="'fined_type['+index+']'" v-model="item.cash" />
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <select v-show="item.cash" class="form-control" :name="'account_id['+index+']'" v-model="item.defaultAccount" >
                                                                <option v-for="Account in item.accounts" :value="Account.id">
                                                                    @{{ Account.name }}
                                                                </option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('inventory',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>

                                                    </tbody>
                                                </table>
												
												<hr/>
												
											<br/>
											<br/>
                                            </div>
											
											
											<div class="row" style="overflow-x: scroll;">
												
												<h3 style="margin-right:20px;">@lang('layout.Loading')</h3>
												
												<table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        
														<th style="">@lang('layout.State') </th>
														<th style="min-width: 120px">@lang('layout.ItemName') </th>
														<th style="min-width: 120px">@lang('layout.SiteName') </th>
														<th style="min-width: 150px">@lang('layout.Quantity') </th>
														<th style="min-width: 100px">@lang('layout.Type') </th>
                                                        <th style="min-width: 150px">@lang('layout.Quantity') </th>
														<th style="min-width: 160px">@lang('layout.Transporter_name') </th>
														<!-- th v-if="driver_type == 'OwnDriver'" style="min-width: 100px">@lang('layout.TankerNumber') </th -->
														<th style="min-width: 160px">@lang('layout.VehicleName')/@lang('layout.NumberWagon') </th>
														<th style="min-width: 160px">@lang('layout.TankerNumber') </th>
														<th v-if="driver_type == 'ForeignDriver1'" style="min-width: 150px">@lang('layout.Driver') </th>
														<th v-if="driver_type == 'ForeignDriver1'" style="min-width: 150px">@lang('layout.VehicleName')/@lang('layout.NumberWagon') </th>
														<th style="min-width: 120px">@lang('layout.TransitNumber') </th>
														<th style="min-width: 120px">@lang('layout.WayBillNumber') </th>
														<th style="min-width: 120px">@lang('layout.SourcePlace') </th>
														<th style="min-width: 120px">@lang('layout.Destination') </th>
														<th style="min-width: 120px">@lang('layout.LoadingDate') </th>
                                                        <th style="min-width: 120px">@lang('layout.RentQuantity') </th>
														<th style="min-width: 150px">@lang('layout.Price') </th>
														<th style="min-width: 100px">@lang('layout.Currency') </th>
														<th style="min-width: 150px">@lang('layout.Rate') </th>
                                                        <th style="min-width: 150px">@lang('layout.Rent') </th>
                                                        <th style="min-width: 150px">@lang('layout.Rate') </th>
														<th style="min-width: 150px">@lang('layout.TotalTransferFee') </th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(item,index) in inventories">
														<td>@{{index+1}}</td>
														
														<td>
															<div class="mt-checkbox" style="padding-left: 0px;">
															 <label class="mt-checkbox mt-checkbox-outline">
															 <input type="checkbox" :name="'load_tran_fer['+index+']'" value="ok" checked />
															 <span></span>
															 </label>
															</div>
															
														</td>
														<td class="highlight">
                                                            @{{(!item.item)?null:item.item.name}}
														</td>
														<td class="highlight">
                                                            @{{(item.item==null)?null:((item.item.to_site==null)?null:item.item.to_site.name)}}
															<input type="hidden" :name="'load_site['+index+']'" :value="(!item.item)?null:(item.item.to_site)?item.item.to_site.id:null">
														</td>
														<td>
														    @{{myRound((item.item==null)?null: ((item.item.quantity - ((item.loading_type=='Leakage')?item.loading_quantity:0)) + ((item.loading_type=='OverLoad')?item.loading_quantity:0)))}}
                                                        </td>
														<td class="highlight">
                                                            <select v-model="(item==null)?null:item.loading_type" @input="setRentQuantity(index)"
                                                                    class="form-control">
                                                                <option value="OverLoad">@lang('layout.OverLoad')</option>
                                                                <option value="Leakage">@lang('layout.Leakage')</option>
                                                            </select>

                                                            <input type="hidden" name="loading_type[]"
                                                                   :value="(item==null)?null:item.loading_type">
                                                        </td>
														<td>
                                                            <input type="number" :name="'loading_quantity['+index+']'" @input="setRentQuantity(index)"
                                                                   v-model.number="(item==null)?null:item.loading_quantity"
                                                                   
                                                                   class="form-control input-style input-number chan_length"
                                                                   :placeholder="(item.loading_type=='OverLoad')?`@lang('layout.OverLoad')`:`@lang('layout.LoadDrop')`">
                                                        </td>
														
														<td>
															<v-select label="name" v-model="item.driver" @input="vehicleSearch(index)"
																	  :options="driver"></v-select>
															<input type="hidden" :name="'load_driver_id['+index+']'" :value="(!item.driver)?null:item.driver.id">
															<input type="hidden" :name="'load_driver_type['+index+']'" :value="(!item.driver)?null:item.driver.driver_type">
									                        <input type="hidden" :name="'foreign_type['+index+']'" :value="(!item.driver)?null:item.driver.foreign_type">
														</td>
														<td v-if="((item == null)?'': item.driver_type) == 'OwnDriver'">
															<v-select label="name" v-model="item.vehicle" @input="carChange(index)"
																	  :options="vehicle"></v-select>
															<input type="hidden" :name="'load_vehicle_id['+index+']'" :value="(!item.vehicle)?null:item.vehicle.id">
                                                            <input type="hidden" :name="'vehicle_currency['+index+']'" :value="(!item.vehicle)?null:item.vehicle.currency">
                                                            <input type="hidden" :name="'vehicle_driver_id['+index+']'" :value="(!item.vehicle)?null:item.vehicle.driver_id">
                                                            <input type="hidden" :name="'vehicle_foreign_type['+index+']'" :value="(!item.vehicle)?null:item.vehicle.foreign_type">
														</td>
														<td v-if="((item == null)?'': item.driver_type) == 'OwnDriver'">
															<v-select label="name" v-model="item.tanker" @input="tankerChange(index)"
																	  :options="vehicle"></v-select>
															<input type="hidden" :name="'load_tanker_id['+index+']'" :value="(!item.tanker)?null:item.tanker.id">
                                                            <input type="hidden" :name="'tanker_currency['+index+']'" :value="(!item.tanker)?null:item.tanker.currency">
                                                            <input type="hidden" :name="'tanker_driver_id['+index+']'" :value="(!item.tanker)?null:item.tanker.driver_id">
                                                            <input type="hidden" :name="'tanker_foreign_type['+index+']'" :value="(!item.tanker)?null:item.tanker.foreign_type">
														</td>
														<td v-if="((item == null)?'': item.driver_type) == 'ForeignDriver'">
                                                            <input type="text" :name="'load_other_driver_name['+index+']'"  placeholder="@lang('layout.Driver')"
                                                             class="form-control chan_length">
														</td>
														<td v-if="((item == null)?'': item.driver_type) == 'ForeignDriver'">
                                                            <input type="text" :name="'load_other_vehicle_name['+index+']'"  placeholder="@lang('layout.VehicleName')/@lang('layout.NumberWagon')"
                                                             class="form-control chan_length">
														</td>
														<td>
                                                            <input type="text" :name="'load_transit_number['+index+']'" placeholder="@lang('layout.TransitNumber')"
                                                             class="form-control chan_length">
														</td>
														
														<td>
                                                            <input type="text" :name="'load_way_bill_number['+index+']'" placeholder="@lang('layout.WayBillNumber')"
                                                             class="form-control chan_length">
														</td>
														<td>
                                                            <input type="text" :name="'load_source['+index+']'" placeholder="@lang('layout.SourcePlace')"
                                                             class="form-control chan_length">
														</td>
														<td>
                                                            <input type="text" :name="'load_destination['+index+']'" placeholder="@lang('layout.Destination')"
                                                             class="form-control chan_length">
														</td>
														<td>
															<date_picker :name="'loading_date['+index+']'"  class="chan_length" placeholder="@lang('layout.LoadingDate')" ></date_picker>
														</td>
                                                        <td>
                                                            <input type="number" :name="'rent_quantity['+index+']'"
                                                                   v-validate="''" data-vv-as="@lang('layout.RentQuantity')"
                                                                   v-model.number="(item.item==null)?null:item.item.rent_quantity"
                                                                   @input="TotalTransferFee(index)"
                                                                   
                                                                   class="form-control input-style input-number chan_length"
                                                                   placeholder="@lang('layout.RentQuantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>
														<td>
															<input type="number" :name="'load_transfer_fee['+index+']'" 
                                                                   class="form-control input-style input-number chan_length"
                                                                   
																   v-model.number="(item==null)?null:item.transfer_fee"
																   @input="TotalTransferFee(index)"
																   placeholder="@lang('layout.Amount')">
														</td>
														<td>
															<v-select label="code" :options="item.currency_list"
																	  v-model="item.currency"></v-select>
															<input type="hidden" :name="'load_currency_loading['+index+']'"
																   :value="(!item.currency)?null:item.currency.code">
														</td>
														<td>
															<input type="number" :name="'load_currency_rate_loading['+index+']'"
                                                               v-model="!item.currency?0:item.currency.rate"
                                                               
															   class="form-control chan_length" :class="{'has-error':rate<=0}">
														</td>
                                                        <td>
                                                            <div v-if="((!item.vehicle)?null:item.vehicle.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) == 'ok' ">
                                                                <input type="number" :name="'forign_rent_vehicle['+index+']'" placeholder="@lang('layout.Rate')"
                                                                
                                                                v-model="(!item.vehicle)?0:item.vehicle.rent" class="form-control chan_length" />
                                                            </div>
                                                            <div v-if="((!item.tanker)?null:item.tanker.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) != 'ok' ">
                                                                <input type="number" :name="'forign_rent_tanker['+index+']'" placeholder="@lang('layout.Rate')"
                                                                
                                                                v-model="(!item.tanker)?0:item.tanker.rent" class="form-control chan_length" />
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div v-if="((!item.vehicle)?null:item.vehicle.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) == 'ok' " class="input-group">
                                                                <input type="number" :name="'forign_rate_vehicle['+index+']'" placeholder="@lang('layout.Rate')"
                                                                
                                                                v-model="!item.vehicle?0:item.vehicle.rate" class="form-control chan_length" />
                                                                <span class="input-group-addon">
                                                                @{{(!item.vehicle)?null:item.vehicle.currency}}
                                                                </span>
                                                            </div>
                                                            <div v-if="((!item.tanker)?null:item.tanker.foreign_type) == 'ok' && ((!item.driver)?null:item.driver.foreign_type) != 'ok' " class="input-group">
                                                                <input type="number" :name="'forign_rate_tanker['+index+']'" placeholder="@lang('layout.Rate')"
                                                                
                                                                v-model="!item.tanker?0:item.tanker.rate" class="form-control chan_length" />
                                                                <span class="input-group-addon">
                                                                @{{(!item.tanker)?null:item.tanker.currency}}
                                                                </span>
                                                            </div>
                                                        </td>
														<td>
                                                            <input :value="(item==null)?null:item.itransfer_total"  class="form-control input-style input-number chan_length"
                                                            
																   placeholder="@lang('layout.Total')" readonly />
														</td>
														
													</tr>
                                                    </tbody>
                                                </table>
												

											<br/>
											<br/>
                                            
                                            </div>
											
											
                                            <button type="button" v-if="inventories.length<=0"
                                                    @click="addNew('inventory',0)"
                                                    class="btn btn-success"><i
                                                        class="fa fa-plus"></i></button>

                                            <hr>
											
                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="isError1 ==false" v-if="!isError"
                                                    @click="handleSubmit($event)"
                                                    class="btn green">@lang('layout.Submit')</button>
                                            <button type="button" v-if="isError1 ==false" v-if="!isError"
                                                    class="btn blue"
                                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>

                                            <a href="{{route('transferAndLoading.index')}}" class="btn default"><i
                                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                        </div>

                                        <cmodal :show='showModal' @close="showModal=false">

                                        </cmodal>
                                    </div>

                                </div>


                                {!! Form::close() !!}
                            </div>
                        </div>
                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')


    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        // Vue.use(VueInputAutowidth);

        Vue.component('v-select', VueSelect.VueSelect);


        var inventory_category = {!! $inventory_category !!};
        var site = {!! $site !!};
        var driver = {!! $driver !!};
        var currency = {!! $currency !!};
        let homeCurrency = {!! json_encode(getHomeCurrency()) !!};
        var otherIncome = {!! $otherIncome !!};
        var bank = {!! $bank !!};
        var contract = {!! $contract !!};

        var v = new Vue({
            el: '#app',
            data: {
                bankes: bank,
                editKey: false,
                showModal: false,
                driver_type: 'OwnDriver',
                contracts: contract,
                temp_items: [],
                temp_loading: [],
                inventory_category: inventory_category,
                selected_iventory_category: null,
                selected_index: 0,
                selected_index_adjustment: 0,
                rate: 1,
                site: site,
                currency_list: currency,
                inventories: [],
                adjustment: [
                    {item: null, inventory: null},
                ],
                selected_type: 'purchase',
                driver: driver,
                otherIncome: otherIncome,
                selected_otherIncome: null,
                type_number: null,
                type_info: null,
                isError: true,
                ref_no: '',
                msg: '',
                isError1: false,
                vehicle:{!! $vehicle !!},



            },
            computed: {
            },
            mounted: function (v = this) {
                var b = _.clone(this.bankes)
                var accounts = b.filter((account) => {
                    return (new RegExp(homeCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                })
                
                var defaultAccount = null;
                var selected_banks=_.find(this.bankes,(v)=>v.code==homeCurrency.code);
                if (selected_banks){
                    defaultAccount = selected_banks.id;
                }
                v.inventories.push(
                    {item: null,inventory:null, loading:null, temp_loading:[], temp_items:[], contract: null, wagonList: [], wagon: null,  load_off:true, load_type:'OverLoad', load_quantity:null, loading_type:'OverLoad', loading_quantity:null, fined_quantity:null, item_category: null, driver: null,vehicle:null, currency: homeCurrency, driver_type: 'OwnDriver', tanker: null,currency_list:currency, cash:null, defaultAccount:defaultAccount, accounts: accounts},
                )

            },
            
				
            methods:
                {
                    checkRefNo() {

                        var chack = 'false';
                        var ref_no = v.ref_no;
                        if (ref_no != null) {


                            axios.get("{{route('callMethod.search')}}",
                                {

                                    params: {
                                        ref_no: v.ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'transfer_and_loadings'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.msg = "@lang('layout.DuplicateData')";
                                        v.isError1 = true;
                                    }
                                    else {
                                        v.msg = 'no';
                                        v.isError1 = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                v.submitForm(e.target);
                            }
                        });
                    },
				
                    // set new price
                    TotalTransferFee(index) {
                        if (this.inventories[index].item) {
                            if (this.inventories[index].item.rent_quantity) {
                                this.inventories[index].itransfer_total = myRound(this.inventories[index].item.rent_quantity * this.inventories[index]['transfer_fee']);
                            }
						}
                    },

                    // set new price
                    setRentQuantity(index) {
                        setTimeout(() => {
                            if (this.inventories[index].item) {
                                if (this.inventories[index].item.quantity) {
                                    var quantity = ((this.inventories[index].item.quantity - ((this.inventories[index].loading_type=='Leakage')?this.inventories[index].loading_quantity:0)) + ((this.inventories[index].loading_type=='OverLoad')?this.inventories[index].loading_quantity:0))
                                    this.inventories[index].item.rent_quantity = quantity;
                                    this.TotalTransferFee(index);
                                }
                            }
                        }, 400);
                    },
					
					// begin item search
                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);

                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
						let contract_id = (v.inventories[v.selected_index]['contract'] != undefined) ? v.inventories[v.selected_index]['contract'].id : null;
                        let wagon_number = (v.inventories[v.selected_index]['wagon'] != undefined)?v.inventories[v.selected_index]['wagon'].name:null;

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchLoading',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                contract_id: contract_id,
                                wagon_number: wagon_number,
                            }
                        })
                        .then(function (response) {
                            v.inventories[v.selected_index]['temp_items'] = [];
                            if (response.data.length > 0) {
                                v.inventories[v.selected_index]['temp_items'] = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
						
                    }, getDebounceTime()),


                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            var inventory_id = v.inventories[index].inventory.id;
                            let wagon_number = (v.inventories[index]['wagon'] != undefined)?v.inventories[index]['wagon'].name:null;
                            let contract_id = (v.inventories[index]['contract'] != undefined)?v.inventories[index]['contract'].id:null;
                            
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchLoading',
                                    inventory_id: inventory_id,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
										v.inventories[index].temp_loading = [];
										v.inventories[index].temp_loading = response.data;
										
                                        // console.log('asdasdas',v.inventories[index].temp_loading);
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
						
                    },

                    onItemSearchLoading: _.debounce((search, loading) => {
                        loading(true);
                        var index = v.selected_index;
                        if (v.inventories[index].inventory != null) {
                            var inventory_id = v.inventories[index].inventory.id;
                            let wagon_number = (v.inventories[index]['wagon'] != undefined)?v.inventories[index]['wagon'].name:null;
                            let contract_id = (v.inventories[index]['contract'] != undefined)?v.inventories[index]['contract'].id:null;
                            
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchLoading',
                                    inventory_id: inventory_id,
                                    keyword: search,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number,
                                }
                            })
                            .then(function (response) {
                                v.inventories[index].item = null;
                                v.inventories[index].loading = null;
                                v.inventories[index].temp_loading = [];
                                if (response.data.length > 0) {
                                    v.inventories[index].temp_loading = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                loading(false);
                                console.log(error);
                            })
                        }
						
                    }, getDebounceTime()),

                    setIndex(index) {
                    v.selected_index = index;
                    },
                    setClearIndex(index) {
                    v.inventories[index].temp_loading = [];
                    v.selected_index = index;
                    },

                    // contract search
                    contractChange(index) {
                        v.selected_index = index;
                        if (v.inventories[index]['contract'] != null) {
                            v.inventories[index]['wagonList'] = [];
                            if (v.inventories[index]['contract'].wagon) {
                                v.inventories[index]['wagonList'] = v.inventories[index]['contract'].wagon;
                            }

                            v.inventories[index]['inventory'] = null;
                            v.inventories[index]['item'] = null;
                            let contract_id = v.inventories[index]['contract'].id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let wagon_number = (v.inventories[index]['wagon'] != undefined)?v.inventories[index]['wagon'].name:null;
                            // console.log(333, wagon_number, contract_id);
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemesSearchLoading',
                                    inventory_category_id: inventory_category_id,
                                    wagon_number: wagon_number,
                                    contract_id: contract_id
                                }
                            })
                            .then(function (response) {
                                v.inventories[index]['temp_items'] = [];
                                if (response.data.length > 0) {
                                    v.inventories[index]['temp_items'] = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }
                    },

                    onItemloadTransfer(index) {

                        if (v.inventories[index].inventory != null && v.inventories[index].loading != null) {
                            var inventory_id = v.inventories[index].inventory.id;
                            var loading_id = v.inventories[index].loading.id;
                            // console.log('klk',inventory_id,loading_id);
                            
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'onItemloadTransfer',
                                    inventory_id: inventory_id,
                                    loading_id: loading_id,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
                                        // console.log(321, response.data[0])
                                        v.inventories[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },
					
					vehicleSearch(index) {
						var plate = null;
						if (v.inventories[index].item) {
							// console.log('222pp',v.inventories[index]['driver']);
                          plate = v.inventories[index]['driver']['plate'];
                          v.driver_type = v.inventories[index]['driver']['driver_type'];
						  v.inventories[index]['driver_type'] = v.inventories[index]['driver']['driver_type'];
							// console.log('222',v.inventories[index]['driver']);
							// console.log(v.inventories[index]['transfer_fee'] ,v.inventories[index].item.quantity , v.inventories[index]['transfer_fee']);
						}
						if(plate != null){
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'Search_driver_vehicle',
                                driver_vehicle_plate: plate,
                            }
                        })
                            .then(function (response) {
								
                                if (response.data.result != null) {
                                // console.log('1231',response.data);
                                    v.inventories[index]['vehicle'] = null;
                                    v.inventories[index]['vehicle'] = response.data.result;
                                }
                                // console.log('1231',v.inventories[index]);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
						}
                    },
					
					// detect member change and searh
                    carChange(index) {
                        if (v.inventories[index].item) {
                            if (v.inventories[index]['vehicle'].foreign_type == "ok") {
                                var currency = _.find(this.currency_list, (c) => c.code == v.inventories[index]['vehicle'].currency);
                                // console.log('rrrnnss', currency);
                                v.inventories[index]['vehicle'].rate = currency.rate;
                            }
							// console.log('rrrnn', this.selected_vehicle);
                            this.TankerSearch(v.inventories[index]['vehicle'].tanker_number, index, this);
                        }
                    },
                    tankerChange(index) {
                        if (v.inventories[index].item) {
                            if (v.inventories[index]['tanker'].foreign_type == "ok") {
                                var currency = _.find(this.currency_list, (c) => c.code == v.inventories[index]['tanker'].currency);
                                v.inventories[index]['tanker'].rate = currency.rate;
                                // console.log('rrrnnss', currency);
                            }
                        }
                    },
                    TankerSearch(plate, index, vm) {
						if(plate != null){
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'Search_driver_vehicle',
                                driver_vehicle_plate: plate,
                            }
                        })
                            .then(function (response) {
								
                                if (response.data.result != null) {
                                    v.inventories[index]['tanker'] = null;
                                    v.inventories[index]['tanker'] = response.data.result;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
						}
                    },

                    onItemloadAdjustment(index) {

                        v.selected_index = index;
                        if (v.adjustment[index].inventory != null) {
                            // console.log('klk',v.inventories[index].inventory,v.inventories);
                            var inventory_id = v.adjustment[index].inventory.id;
                            let inventory_category_id = (v.adjustment[index]['item_category'] != undefined) ? v.adjustment[index]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                }
                            })
                                .then(function (response) {
                                    v.adjustment[index].item = null;
                                    if (response.data.length > 0) {
                                        v.adjustment[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    itemCategoryChange(index) {
                        v.selected_iventory_category = this.inventories[index]['item_category'];
                        if (this.inventories[index]['item_category'] != null) {
                            let inventory_category_id = v.inventories[index]['item_category'].id;
                            let contract_id = (v.inventories[index]['contract'] != undefined) ? v.inventories[index]['contract'].id : null;
                            let wagon_number = (v.inventories[index]['wagon'] != undefined)?v.inventories[index]['wagon'].name:null;

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchLoading',
                                    inventory_category_id: inventory_category_id,
                                    contract_id: contract_id,
                                    wagon_number: wagon_number
                                }
                            })
                            .then(function (response) {
                                v.inventories[index]['temp_items'] = [];
                                if (response.data.length > 0) {
                                    v.inventories[index]['temp_items'] = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }

                    },

                    // end item search

                    // contract search

                    selectLoadType(index) {
                        if (v.inventories[index].item && v.inventories[index].load_off == true) {
                            var quantity = Number.parseFloat(v.inventories[index].item.quantity);
                            var load_quantity = ((Number.parseFloat(v.inventories[index].item.load_quantity) * Number.parseFloat(v.inventories[index].item.measure_unit)) / Number.parseFloat(v.inventories[index].item.measure.measure_unit));
                            
                            if (quantity > load_quantity) {
                                v.inventories[index].load_type = 'OverLoad';
                                v.inventories[index].load_quantity = Number.parseFloat(quantity - load_quantity).toFixed(precision());
                            }else{
                                v.inventories[index].load_type = 'Leakage';
                                v.inventories[index].load_quantity = Number.parseFloat(load_quantity - quantity).toFixed(precision());
                            }
                        }
                    },

                    // generic function for adding item to list
                    changePrice(index) {
                        if (v.inventories[index].item && v.inventories[index].currency) {
                            if (v.inventories[index].item.cost && v.inventories[index].item.LasCost && v.inventories[index].currency.rate) {
                                v.inventories[index].item.cost = Number.parseFloat(Number.parseFloat(v.inventories[index].item.LasCost) * Number.parseFloat(v.inventories[index].currency.rate)).toFixed(precision());
                                // console.log(33, v.inventories[index].item);
                            }
                        }
                        //  LasCost
                    },

                    setSizeRow(selected_code,index) {
                        var b = _.clone(v.bankes)
                        var accounts = b.filter((account) => {
                            return (new RegExp(selected_code.toLowerCase())).test(account.code.toLowerCase())
                        })

                        var defaultAccount = null;
                        var selected_banks=_.find(accounts,(v)=>v.code==selected_code);
                        if (selected_banks){
                            defaultAccount = selected_banks.id;
                        }

                        v.inventories[index].accounts = accounts;
                        v.inventories[index].defaultAccount = defaultAccount;
                    },

                    addNew(type = null, index) {
                        
                        if (type != null) {
                            if (type == 'inventory') {
                                v.selected_index = index;
                                if (this.inventories[index + 1] == undefined) {
                                   // this.temp_items = [];


                                   var b = _.clone(this.bankes)
                                    var accounts = b.filter((account) => {
                                        return (new RegExp(homeCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                                    })
                                    
                                    var defaultAccount = null;
                                    var selected_banks=_.find(this.bankes,(v)=>v.code==homeCurrency.code);
                                    if (selected_banks){
                                        defaultAccount = selected_banks.id;
                                    }

                                    this.inventories.push({
                                        inventory: null,
                                        loading: null,
                                        load_off:true, 
										load_type:'OverLoad',
										load_quantity:null,
										loading_type:'OverLoad',
										loading_quantity:null, 
										fined_quantity:null,
                                        item: null,
                                        temp_loading:[], 
                                        temp_items:[],
                                        contract: null, 
                                        wagonList: [], 
                                        wagon: null,  
                                        item_category: this.selected_iventory_category,
                                        driver: null,
                                        vehicle:null,
                                        currency: homeCurrency, 
										driver_type: 'OwnDriver', 
                                        tanker: null,
                                        currency_list:currency, 
                                        cash:null, 
                                        defaultAccount:defaultAccount, 
                                        accounts: accounts
										
                                    });
                                }
                            }
                            if (type == 'adjustment') {
                                v.selected_index = index;
                                if (this.adjustment[index + 1] == undefined) {
                                    //this.temp_items = [];
                                    this.adjustment.push({
                                        inventory: null, inventory: null,
                                        item: null, inventory: null
                                    });
                                }
                            }


                        }

                    },

                    // delete item from list
                    deleteItem(type = null, index, category = "adjustment") {
                        if (type != null) {
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'adjustment') {
                                this.adjustment.splice(index, 1);
                            }


                        }

                    },
                    // submit the form
                    submitForm() {

                        // if (this.isError == true) {
                            // alert('there is no item');
                            // return false;
                        // }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("transfer-and-loading-form").submit()

                            }
                            else {

                            }
                        });

                    },
                    defaultValue() {
                        this.selected_index = 0;

                        this.inventories = [
                            {item: null, load_off:true, temp_loading:[], temp_items:[], contract: null, wagonList: [], wagon: null,  item_category: this.selected_iventory_category},
                        ];

                        this.temp_items = [];

                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {

                                    var url = "{{route('transferAndLoading.store')}}";
                                    form_id = 'transfer-and-loading-form';
                                    var data = $('#' + form_id).serialize();
                                    toggleBlock(true);
                                    axios.post(url, data)
                                        .then(function (response) {
                                            toggleBlock(0);
                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                toastr.success('', response.data.message);

                                                // v.defaultValue();
                                                location.reload();
                                            }
                                            else {
                                                var message = "{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                            }
                                        })
                                        .catch(function (error) {
                                            toggleBlock(0);
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },
                },
            created: function () {

            }

        });

    </script>


@endpush