@extends('layouts.factor-master')

@section('content')
    <?php
     $report = customeReportNew('transfer_and_loading');
     $_record= !in_array('record', $report);
     $_number=!in_array('number', $report);
     $_date=!in_array('date', $report);
     $_delivery_date=!in_array('delivery_date', $report);
     $_description=!in_array('description', $report);
     $_reference_number =!in_array('reference_number', $report);
     $_type=!in_array('type', $report);
     $_user=!in_array('user', $report);


     $report_percent = customeReportNewPercent('transfer_and_loading');
     $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
     $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
     $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
     $_delivery_date_percent= (array_key_exists('delivery_date___percent', $report_percent))?$report_percent['delivery_date___percent']:null;
     $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
     $_reference_number_percent= (array_key_exists('reference_number___percent', $report_percent))?$report_percent['reference_number___percent']:null;
     $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
     $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;


    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.TransferAndLoadingReport')</h3>
    <table class="main-table">
        <tr>
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif

            @if($inventory_site_name)
            <td>
              <span>@lang('layout.SiteName')</span>: {{$inventory_site_name}}
            </td>
            @endif

            
        </tr>
    </table>
    <br>
    <table class="main-table">

        <thead>
        <tr class="bg">
            @if($_record)<td @if($_record_percent) width="{{$_record_percent}}%" @endif class="center" >
                <div > @lang('layout.Record') </div>
            </td>@endif
                @if($_number)
            <td  class="center" @if($_number_percent) width="{{$_number_percent}}%" @endif>
                <div > @lang('layout.Number') </div>
            </td>@endif
            @if($_date)
            <td  class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif>
                <div > @lang('layout.Date') </div>
            </td>@endif
            @if($_delivery_date)
            <td  class="center" @if($_delivery_date_percent) width="{{$_delivery_date_percent}}%" @endif>
                <div > @lang('layout.DeliveryDate') </div>
            </td>@endif
            @if($_description)
            <td  class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif>
                <div > @lang('layout.Description') </div>
            </td>@endif
            @if($_reference_number)
                <td  class="center" @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif>
                    <div > @lang('layout.ReferenceNumber') </div>
                </td>@endif
                @if($_type)
                <td  class="center" @if($_type_percent) width="{{$_type_percent}}%" @endif>
                    <div > @lang('layout.Type') </div>
                </td>@endif
                @if($_user)
                <td  class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif>
                    <div > @lang('layout.User') </div>
                </td>@endif
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)

            <tr>
                @if($_record)
                <td class="center">{{++$count}}</td>
                @endif
                @if($_number)
                <td class="center">{{$record->number}}</td>
                @endif
                @if($_date)
                <td class="center">{{convertDate($record->date)}}</td>
                @endif
                @if($_delivery_date)
                <td class="center">{{convertDate($record->delivery_date)}}</td>
                @endif
                @if($_description)
                <td style="@if($_description_percent) text-align: justify @endif">{{$record->description}}</td>
                @endif
                @if($_reference_number)
                    <td class="center">{{$record->ref_no}}</td>
                    @endif
                @if($_type)
                    <td class="center">{{__('layout.'.ucfirst($record->type))}}</td>
                    @endif
              @if($_user)
                    <td class="center">{{$record->user}}</td>
                    @endif
            </tr>

        @endforeach
    </table>


    
<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection