@extends('layouts.factor-master')

@section('content')
<?php
  

$report = customeReportNew('dashboard_loading_index');
$_driver = !in_array('driver', $report);
$_transporter_name = !in_array('transporter_name', $report);
$_vehicle_name = !in_array('vehicle_name', $report);
$_tanker_number = !in_array('tanker_number', $report);
$_driver_type = !in_array('driver_type', $report);
$_type = !in_array('type', $report);
$_type_number = !in_array('type_number', $report);
$_way_bill_number = !in_array('way_bill_number', $report);
$_transite_number = !in_array('transite_number', $report);
$_source_place = !in_array('source_place', $report);
$_destination = !in_array('destination', $report);
$_location = !in_array('location', $report);
$_loading_date = !in_array('loading_date', $report);
$_discharge_date = !in_array('discharge_date', $report);
$_item_name = !in_array('item_name', $report);
$_site = !in_array('site', $report);
$_measure = !in_array('measure', $report);
$_quantity = !in_array('quantity', $report);
$_rent_quantity = !in_array('rent_quantity', $report);
$_price = !in_array('price', $report);
$_currency = !in_array('currency', $report);
$_rate = !in_array('rate', $report);
$_total_transfer = !in_array('total_transfer', $report); 
$_total_amount = !in_array('total_amount', $report); 
$_contract = !in_array('contract', $report); 



$report_percent = customeReportNewPercent('dashboard_loading_index');
$_driver_percent= (array_key_exists('driver___percent', $report_percent))?$report_percent['driver___percent']:null; 
$_transporter_name_percent= (array_key_exists('transporter_name___percent', $report_percent))?$report_percent['transporter_name___percent']:null; 
$_vehicle_name_percent= (array_key_exists('vehicle_name___percent', $report_percent))?$report_percent['vehicle_name___percent']:null; 
$_tanker_number_percent= (array_key_exists('tanker_number___percent', $report_percent))?$report_percent['tanker_number___percent']:null; 
$_driver_type_percent= (array_key_exists('driver_type___percent', $report_percent))?$report_percent['driver_type___percent']:null; 
$_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null; 
$_type_number_percent= (array_key_exists('type_number___percent', $report_percent))?$report_percent['type_number___percent']:null; 
$_way_bill_number_percent= (array_key_exists('way_bill_number___percent', $report_percent))?$report_percent['way_bill_number___percent']:null; 
$_transite_number_percent= (array_key_exists('transite_number___percent', $report_percent))?$report_percent['transite_number___percent']:null; 
$_source_place_percent= (array_key_exists('source_place___percent', $report_percent))?$report_percent['source_place___percent']:null; 
$_destination_percent= (array_key_exists('destination___percent', $report_percent))?$report_percent['destination___percent']:null; 
$_location_percent= (array_key_exists('location___percent', $report_percent))?$report_percent['location___percent']:null; 
$_loading_date_percent= (array_key_exists('loading_date___percent', $report_percent))?$report_percent['loading_date___percent']:null; 
$_discharge_date_percent= (array_key_exists('discharge_date___percent', $report_percent))?$report_percent['discharge_date___percent']:null; 
$_item_name_percent= (array_key_exists('item_name___percent', $report_percent))?$report_percent['item_name___percent']:null; 
$_site_percent= (array_key_exists('site___percent', $report_percent))?$report_percent['site___percent']:null; 
$_measure_percent= (array_key_exists('measure___percent', $report_percent))?$report_percent['measure___percent']:null; 
$_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null; 
$_rent_quantity_percent= (array_key_exists('rent_quantity___percent', $report_percent))?$report_percent['rent_quantity___percent']:null; 
$_price_percent= (array_key_exists('price___percent', $report_percent))?$report_percent['price___percent']:null; 
$_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;     
$_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null; 
$_total_transfer_percent= (array_key_exists('total_transfer___percent', $report_percent))?$report_percent['total_transfer___percent']:null; 
$_total_amount_percent= (array_key_exists('total_amount___percent', $report_percent))?$report_percent['total_amount___percent']:null; 
$_contract_percent= (array_key_exists('contract___percent', $report_percent))?$report_percent['contract___percent']:null; 

?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.LoadingReport')</h3>
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
        @if($contract_name)
        <td>
            <span>@lang('layout.Contract')</span>:
            <BDO>{{$contract_name}}</BDO>
        </td>
        @endif
    </tr>
</table>
<br>
<table class="main-table"> 
    <thead>
        <tr class="bg">
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            @if($_driver)
            <th @if($_driver_percent) width="{{$_driver_percent}}%" @endif style="min-width: 100px">@lang('layout.Driver') </th>
            @endif
            @if($_transporter_name)
            <th   @if($_transporter_name_percent) width="{{$_transporter_name_percent}}%" @endif   style="min-width: 100px">@lang('layout.Transporter_name') </th>
            @endif
            @if(!$contract_name)
            @if($_contract)
            <th   @if($_contract_percent) width="{{$_contract_percent}}%" @endif   style="min-width: 100px">@lang('layout.Contract') </th>
            @endif
            @endif
            @if($_vehicle_name)
            <th   @if($_vehicle_name_percent) width="{{$_vehicle_name_percent}}%" @endif   style="min-width: 100px">@lang('layout.VehicleName')</th>
            @endif
            @if($_tanker_number)
            <th   @if($_tanker_number_percent) width="{{$_tanker_number_percent}}%" @endif   style="min-width: 100px">@lang('layout.TankerNumber')</th>
            @endif
            @if($_driver_type)
            <th   @if($_driver_type_percent) width="{{$_driver_type_percent}}%" @endif   style="min-width: 100px">@lang('layout.DriverType')</th>
            @endif
            @if($_type)
            <th   @if($_type_percent) width="{{$_type_percent}}%" @endif   style="min-width: 100px">@lang('layout.Type')</th>
            @endif
            @if($_type_number)
            <th   @if($_type_number_percent) width="{{$_type_number_percent}}%" @endif   style="min-width: 100px">@lang('layout.TypeNumber')</th>
            @endif
            @if($_way_bill_number)
            <th   @if($_way_bill_number_percent) width="{{$_way_bill_number_percent}}%" @endif   style="min-width: 100px">@lang('layout.WayBillNumber') </th>
            @endif
            @if($_transite_number)
            <th   @if($_transite_number_percent) width="{{$_transite_number_percent}}%" @endif   style="min-width: 100px">@lang('layout.TransitNumber') </th>
            @endif
            @if($_source_place)
            <th   @if($_source_place_percent) width="{{$_source_place_percent}}%" @endif   style="min-width: 100px">@lang('layout.SourcePlace') </th>
            @endif
            @if($_destination)
            <th   @if($_destination_percent) width="{{$_destination_percent}}%" @endif   style="min-width: 100px">@lang('layout.Destination') </th>
            @endif
            @if($_location)
            <th   @if($_location_percent) width="{{$_location_percent}}%" @endif   style="min-width: 100px">@lang('layout.Location') </th>
            @endif
            @if($_loading_date)
            <th   @if($_loading_date_percent) width="{{$_loading_date_percent}}%" @endif   style="min-width: 100px">@lang('layout.LoadingDate') </th>
            @endif
            @if($_discharge_date)
            <th   @if($_discharge_date_percent) width="{{$_discharge_date_percent}}%" @endif   style="min-width: 100px">@lang('layout.DischargeDate') </th>
            @endif
            @if($_item_name)
            <th   @if($_item_name_percent) width="{{$_item_name_percent}}%" @endif   style="min-width: 100px">@lang('layout.ItemName') </th>
            @endif
            @if($_site)
            <th   @if($_site_percent) width="{{$_site_percent}}%" @endif   style="min-width: 100px">@lang('layout.Site') </th>
            @endif
            @if($_measure)
            <th   @if($_measure_percent) width="{{$_measure_percent}}%" @endif   style="min-width: 100px">@lang('layout.Measure') </th>
            @endif
            @if($_quantity)
            <th   @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif  >@lang('layout.Quantity') </th>
            @endif
            @if($_rent_quantity)
            <th   @if($_rent_quantity_percent) width="{{$_rent_quantity_percent}}%" @endif  >@lang('layout.RentQuantity') </th>
            @endif
            @if($_price)
            <th   @if($_price_percent) width="{{$_price_percent}}%" @endif  >@lang('layout.Price') </th>
            @endif
            @if($_currency)
            <th   @if($_currency_percent) width="{{$_currency_percent}}%" @endif  >@lang('layout.Currency') </th>
            @endif
            @if($_rate)
            <th   @if($_rate_percent) width="{{$_rate_percent}}%" @endif  >@lang('layout.Rate') </th>
            @endif
            @if($_total_transfer)
            <th   @if($_total_transfer_percent) width="{{$_total_transfer_percent}}%" @endif  >@lang('layout.TotalTransferFee') </th>
            @endif 
            @if($_total_amount)
            <th   @if($_total_amount_percent) width="{{$_total_amount_percent}}%" @endif  >   @lang('layout.TotalAmount')  {{getHomeCurrency()[getCurrencyType()]}}  </th>
            @endif 
        </tr> 
    </thead>
    
    <?php
    
    $count = 0;
    $totales = 0;
    $measure = [];
    $Currency = []; 
    $qty = 0;
    $rentQuantity = 0;
    $totalTransferFee = 0;
    $colspan = 19;
    $totalBase = 0; 
    $totalMoney = 0;
    ?> 

    @foreach($data AS $record)
    <?php
    $totales += ($record->Total / $record->Rate);
    $qty +=  $record->qty;
    $rentQuantity +=  $record->rent_quantity;
    $totalTransferFee +=  $record->total_transfer_fee;
    $totalMoney +=  $record->Total;
    // $totalBase +=  $record->total_transfer_fee;


    if (array_key_exists($record->measure, $measure)) {
        $measure[$record->measure] = $measure[$record->measure] + $record->qty;
    } else {
        $measure[$record->measure] = $record->qty;
    }


    if (array_key_exists($record->Currency, $Currency)) {
        $Currency[$record->Currency] = $Currency[$record->Currency] + $record->Total;
    } else {
        $Currency[$record->Currency] = $record->Total;
    }
    
    ?>
    <tr>
        <td class="center">{{++$count}}</td>
        @if($_driver)
        <td class="center">{{$record->driver_name}}</td>
        @endif
        @if($_transporter_name)
        <td class="center">{{$record->other_driver_name}}</td>
        @endif 

        @if(!$contract_name)
        @if($_contract)
        <td class="center">{{$record->contract}} </th>
        @endif
        @endif 

        @if($_vehicle_name)
        <td class="center">{{$record->vehicle_name}} @if($record->driver_type == 'OwnDriver') {{$record->vehicle_name}} @else {{$record->other_vehicle_name}} @endif</td>
        @endif
        @if($_tanker_number)
        <td class="center">{{$record->tanker_name}}</td>
        @endif
        @if($_driver_type)
        <td class="center">{{__('layout.' . $record->driver_type)}}</td>
        @endif
        @if($_type)
        <td class="center">{{__('menu.' . $record->part_type)}}</td>
        @endif
        @if($_type_number)
        <td class="center">{{$record->part_number}}</td>
        @endif
        @if($_way_bill_number)
        <td class="center">{{$record->cmr_number}}</td>
        @endif
        @if($_transite_number)
        <td class="center">{{$record->transit_number}}</td>
        @endif
        @if($_source_place)
        <td class="center">{{$record->source}}</td>
        @endif
        @if($_destination)
        <td class="center">{{$record->destination}}</td>
        @endif
        @if($_location)
        <td class="center">{{$record->location}}</td>
        @endif
        @if($_loading_date)
        <td class="center">{{convertDate($record->loading_date)}}</td>
        @endif
        @if($_discharge_date)
        <td class="center">{{convertDate($record->discharge_date)}}</td>
        @endif
        @if($_item_name)
        <td class="center">{{$record->items}}</td>
        @endif
        @if($_site)
        <td class="center">{{$record->site}}</td>
        @endif
        @if($_measure)
        <td class="center">{{$record->measure}}</td>
        @endif
        @if($_quantity)
        <td class="center">{{myRound($record->qty)}}</td>
        @endif
        @if($_rent_quantity)
        <td class="center">{{myRound($record->rent_quantity)}}</td>
        @endif
        @if($_price)
        <td class="center">{{myRound($record->total_transfer_fee)}}</td>
        @endif
        @if($_currency)
        <td class="center">{{$record->Currency}}</td>
        @endif
        @if($_rate)
        <td class="center">{{$record->Rate}}</td>
        @endif
        @if($_total_transfer)
        <td class="center">{{myRound($record->Total)}}</td>
        @endif 
        @if($_total_transfer)
        <td class="center">{{ myRound($record->Total / $record->Rate) }}</td>
        @endif 
    </tr>
    @endforeach  

    @if(!$_driver)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if($contract_name || !$_contract)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_transporter_name)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_vehicle_name)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_tanker_number)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_driver_type)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_type)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_type_number)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_way_bill_number)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_transite_number)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_source_place)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_destination)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_location)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_loading_date)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_discharge_date)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_item_name)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_site)   <?php  $colspan = $colspan-1;  ?>       @endif
    @if(!$_measure)   <?php  $colspan = $colspan-1;  ?>       @endif 

    <tr class="bg">
        <td colspan="{{$colspan}}" class="center"> @lang('layout.Total') </td>
        @if(count($measure) <= 1)
        <td class="center">{{myRound($qty)}}</td>
        <td class="center">{{myRound($rentQuantity)}}</td>
        @else 
        <td></td>
        <td></td>
        @endif
        @if(count($Currency) <= 1)
        <td class="center">{{myRound($totalTransferFee)}}</td>
        @else 
        <td></td>
        @endif

        @if($_currency)
        <td></td>
        @endif 

        @if($_rate)
        <td></td>
        @endif 

        @if($_total_transfer)
        @if(count($Currency) <= 1)
        <td class="center"> {{myRound($totalMoney)}} </td>
        @else 
        <td> </td>
        @endif
        <td class="center"> {{myRound($totales)}} </td>
        @endif

    </tr>
</table>

<table class="main-table" style="margin-top: 20px;">
    <tr class="bg">
        <td>
            <div class="center"> @lang('layout.Record') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Measure') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Quantity') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($measure as $key => $mes) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{myRound($mes)}}</div>
            </td>

        </tr>
    <?php
    }
    ?> 
</table> 
 
<table class="main-table" style="margin-top: 20px;">
    <tr class="bg">
        <td class="center" colspan="3"> @lang('layout.TotalRentAsCurrency') </td>
    </tr>
    <tr class="bg">
        <td>
            <div class="center"> @lang('layout.Record') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($Currency as $key => $curr) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{myRound($curr)}}</div>
            </td>

        </tr>
    <?php
    }
    ?>
    <tr class="bg">
        <td colspan="2" class="center"> @lang('layout.Total') </td>
        <td colspan="1" class="center">{{myRound($totales)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
</table>



<!--  signature ............................................ -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table> 
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr> 
            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature ................................................... -->

@endsection