@extends('layouts.app')
@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    
    }
   
</style>
@stop
@section('content')
@include('layouts.modal')
@include('todo_list.Fmodal')
      <div>

            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.ToDoShow')</span>
                    </div>
                   
                    <div class="tools"></div>
                    
                </div>
                <div class="portlet-body">
                    <div class="row">
                       <div class="col-md-12">
                           <table class="table">
                           <thead>
                                <tr>
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('menu.ToDoType')</th>
                                    <th>@lang('layout.Member')</th>
                                    <th>@lang('layout.OtherName')</th>
                                    <th>@lang('layout.Priority')</th>
                                    <th>@lang('layout.Date') </th>
                                    <th>@lang('layout.DueDate') </th>
                                    <th>@lang('layout.Time') </th>
                                    <th>@lang('layout.User') </th>
                                    <th>@lang('layout.Status') </th>
                                    <th>@lang('layout.Description') </th>
                                </tr>
                              </thead>
                            <tbody> 
                                <tr> 
                                    <td> {{ $toDoList->number}}  </td>
                                    <td> {{ $toDoList->type_name}}  </td>
                                    <td> {{ $toDoList->member}}  </td>
                                    <td> {{ $toDoList->other_member_name}}  </td>
                                    <td> {{ __('type.' . $toDoList->priority) }}  </td>
                                    <td> {{ $toDoList->create_date}}</td>
                                    <td> {{ $toDoList->date}}</td>
                                    <td> {{ $toDoList->time}}</td>
                                    <td> {{ $toDoList->user}}</td>
                                    <td> {{ $toDoList->status_name}}</td>
                                    <td> {{ $toDoList->description}}</td>
                                </tr>
                            </tbody>
                            </table>
                       </div> 
                    </div>
                    <div class="row" >
                        <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="">@lang('layout.Feedback')</a>
                                </li>
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="">@lang('layout.Attachments')</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab1">
                                    <div class="row">

                                        <div class="col-md-12 col-sm-12 col-xs-12" id="nProOrder" v-cloak>
                            
                                            <modal v-if="showModal" @close="showModal = false">
                                            <div slot="header">
                                                <div class="col-md-12 col-sm-12 col-xs-12">
                                                    <h3>
                                                        @lang('layout.Feedback')
                                                    </h3>
                                                </div>
                                                <div class="col-md-4">
                                                    <div v-if="fieldErrors.length > 0">
                                                        <p class="text-danger" fieldErrors>
                                                            <spna v-text="fieldErrors"></spna>
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div slot="body">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label>@lang("layout.Description") <span class="required"> * </span></label>
                                                            <textarea class="form-control" name="description" v-model="description"></textarea>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>


                                            <div slot="footer">
                                                <button type="button" class="btn btn-success" @click="addClass" >
                                                    @lang('layout.OK')
                                                </button>
                                                <button type="button" class="btn btn-danger"
                                                        @click="showModal =false" >
                                                    @lang('layout.Cancel')
                                                </button>
                                            </div>
                                            </modal>
                                            
                                        </div>

                                        <div class="col-md-12">
                                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                            <div class="portlet light bordered">
                                                <div class="title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.Feedback')</span>
                                                    </div>
                                                    <div class="btn-group pull-right">
                                                        <div id="app" v-cloak>
                                                            <Fmodal v-if="showFModal" @close="showFModal = false">
                                                                <div slot="header">
                                                                    <div class="col-md-12 col-sm-12 col-xs-12">
                                                                        <h3>
                                                                            @lang('layout.Feedback')
                                                                        </h3>
                                                                    </div>
                                                                    <div class="col-md-4">
                                                                        <div v-if="fieldErrors.length > 0">
                                                                            <p class="text-danger" fieldErrors>
                                                                                <spna v-text="fieldErrors"></spna>
                                                                            </p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div slot="body">
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <div class="form-group">
                                                                                <label>@lang("layout.Description") <span class="required"> * </span></label>
                                                                                <textarea class="form-control" name="description" v-model="description"></textarea>
                                                                            </div>
                    
                                                                        </div>
                                                                    </div>
                                                                </div>
                    
                    
                                                                <div slot="footer">
                                                                    <button type="button" class="btn btn-success" @click="addFeedback" >
                                                                        @lang('layout.OK')
                                                                    </button>
                                                                    <button type="button" class="btn btn-danger"
                                                                            @click="showFModal =false" >
                                                                        @lang('layout.Cancel')
                                                                    </button>
                                                                </div>
                                                                </Fmodal>
                                                                {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                                                   <input type="hidden" name="type" value="ngo_todo_list_Details"/>
                                                                   <input type="hidden" name="id" value="{{$toDoList->id}}"/> 
                                                                   <button type="submit" class="btn btn-sm btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                                                {{Form::close()}}
                                                                {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                                                                   <input type="hidden" name="type" value="ngo_todo_list_Details"/>
                                                                   <input type="hidden" name="id" value="{{$toDoList->id}}"/> 
                                                                   <button type="submit" class="btn btn-sm btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                                                {{Form::close()}} 
                                                                <button class="btn btn-success" @click="showFModal =true"><i class="fa fa-plus"></i> @lang('layout.AddNew')</button> 
                                                        </div>

                                                    </div>
                                                </div>
                                                <div class="portlet-body" id="itemsshow">
                                                    <table class="table table-striped table-bordered table-hover" id="feedback">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>@lang('layout.Parent')</th>
                                                                <th>@lang('layout.Description')</th>
                                                                <th>@lang('layout.Date')</th>
                                                                <th>@lang('layout.Action')</th>
                                                            </tr>
                                                        </thead>
                                                    </table>
                                                   
                                                </div>
                                            </div>
                                            <!-- END EXAMPLE TABLE PORTLET-->
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="tab2">
                                    <div class="portlet light bordered">
                                        <div class="title">
                                            <div class="caption font-dark">
                                                <i class="icon-settings font-dark"></i>
                                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                            </div>
                                        </div>
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <div class="portlet-body">

                                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                                        enctype="multipart/form-data">

                                                        @csrf
                                                        <input type="hidden" name="redirect_route" value="toDoList.show">
                                                        <input type="hidden" name="foreign_data_id" value="{{$toDoList->id}}">
                                                        <input type="hidden" name="path" value="uploads/todo">
                                                        <input type="hidden" name="table_name" value="todo_list">

                                                        <div class="row">
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                                    <input type="text" name="title" class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <label class="control-label">@lang('layout.Description')</label>
                                                                    <textarea name="description" class="form-control"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-7">
                                                                <div class="form-group">
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                                        <div class="fileinput-new thumbnail"
                                                                            style="width: 200px; height: 150px;">
                                                                            <img src="" alt=""></div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                                            style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                                        <div>
                                                                                    <span class="btn default btn-file">
                                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                        <input type="hidden" value="" name=""><input
                                                                                                type="file" name="photo"> </span>

                                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                                            data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                        </div>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="margiv-top-10">
                                                            <button type="button" onclick="regForm(this)"
                                                                    class="btn green"> @lang('layout.Submit') </button>
                                                            <a href="{{route('dailyExpense.index')}}"
                                                            class="btn default">@lang('layout.Cancel')</a>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                                <thead>
                                                <tr>
                                                    <th>@lang('layout.AttachmentTitle')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Action')</th>
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>        
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@endsection
@push('scripts') 
<script>

    $(document).ready(function(){
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#feedback').DataTable({  
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax:{
                url: '{{route("toDoList.show",$toDoList->id)}}',
                data:{type:'feedback'}
                }, 
            columns: [ 
                { data: 'id'   ,   name: 'id' },
                { data: 'parent'   ,   name: 'parent' },
                { data: 'description',   name: 'description' },
                { data: 'date',   name: 'date' },
                { data: 'action'   ,      name: 'action' },
            ]
        }); 

        $('#attachment').DataTable({
            ajax: {
                url: '{{route("toDoList.show",$toDoList->id)}}',
                data: {type: 'attachment'}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',

            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [
                {data: 'title', name: 'attachments.title'},
                {data: 'description', name: 'attachments.description'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false},
            ]
        });  

    });

    Vue.component('v-select', VueSelect.VueSelect);

    Vue.component('modal',{
        template: '#modal-template'
    });    
    
    Vue.component('Fmodal',{
        template: '#Fmodal-template'
    });


    function createFeedback(id, todo_id) {
        vu.showModal = true;
        vu.todo_id = todo_id;
        vu.feedback_id = id;
    }

    let vu = new Vue({
        el: '#nProOrder',
        data:{
            showModal:false,
            fieldErrors:[],
            description: null,
            todo_id: null,
            feedback_id: null,
        },
        methods:{
            addClass(){
                // console.log('DDDDD', this.todo_id, this.feedback_id, this.description)
                axios.post("{{route('toDoList.storeFeedback')}}",{
                    toDoList_id:this.todo_id,
                    feedback_id:this.feedback_id,
                    description:this.description
                })
                .then(function(response){
                    vu.showModal = false;
                    vu.todo_id = null;
                    vu.feedback_id = null;
                    vu.description = null;
                    $('#feedback').DataTable().ajax.reload();
                })
            }
        }
     });
    
    let vue = new Vue({
        el: '#app',
        data: {
            selectedFeedback: null,
            description:null,
            showFModal:false,
            fieldErrors:[],
            toDoList_id: "{{$toDoList->id}}"
        },
        computed: {
        },
        methods: {
            addFeedback(){
                console.log('mmmmmmm',this.toDoList_id)
                vue.showFModal = false;
                var datas = $("#FmodalForm").serializeArray();
                $.ajax({
                    headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                    url: '{{route("toDoList.storeFeedback")}}',
                    method: 'post',
                    data: {
                        "toDoList_id": this.toDoList_id,
                        'description': this.description
                    },
                    dataType: 'json',

                }).done(function (response) {
                    if (response) {
                        vue.showFModal = false;
                        vue.description = null;
                        $('#feedback').DataTable().ajax.reload();
                    }
                }).fail(function (error) {
                    console.log('error', error);
                });
            }
        }
    });

</script>
@endpush