@extends('layouts.app')
@section('content')
@include('layouts.modal')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show" :value-type="'todo_list'" @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                               @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label class="control-label">@lang('menu.ToDoType')</label>
                                                <v-select label="name" :options="toDoType" v-model="selected_toDoType"> 
                                                </v-select>
                                                <input type="hidden" name="to_do_type_id" v-model.number="(!selected_toDoType)?null:selected_toDoType.id">
                                            </div>
                                            <div class="col-md-6">
                                                <label class="control-label">@lang('layout.Status')</label>
                                                <v-select label="name" :options="toDoStatus" v-model="selected_toDoStatus"> 
                                                </v-select>
                                                <input type="hidden" name="status_id" v-model.number="(!selected_toDoStatus)?null:selected_toDoStatus.id">
                                                {{-- <label class="control-label">@lang('layout.Status')</label>
                                                <select name="status" class="form-control">
                                                    <option value="">@lang('layout.Select')</option>
                                                    <option value="Active">@lang('layout.Active')</option>
                                                    <option value="Deactive">@lang('layout.Deactive')</option>
                                                    <option value="OnProgress">@lang('layout.OnProgress')</option>
                                                </select> --}}
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label class="control-label">@lang('layout.Type')</label>
                                                <v-select class="vue-select2" v-model="selected_member_types" label="name" :options="member_types" @input="memberChange">
                                                </v-select>
                                                <input type="hidden" name="member_type" v-model.number="(!selected_member_types)?null:selected_member_types.name">
                                            </div>
                                            <div class="col-md-6">
                                                <label class="control-label">@lang('layout.Member')</label>
                                                <v-select class="vue-select2" v-model="selected_member" label="name" :options="members">
                                                </v-select>
                                                <input type="hidden" name="user_id" v-model="(!selected_member)?null:selected_member.id">
                                            </div>
                                        </div>
                                        <div class="row">
                                                {{-- <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.Member') </label>
                                                    <v-select class="vue-select2" v-model="selecteduser" label="name" :options="{{ $users }}">
                                                    </v-select>
                                                    <input type="hidden" name="user_id" v-model.number="(!selecteduser)?null:selecteduser.id">
                                                </div> --}}
                                                
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div slot="date">
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="todo_list_index">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">
                                                             <label> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">

                                                             <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label>
                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                <option value="">@lang('layout.Select')</option>
                                                                <option value="2">2 %</option>
                                                                <option value="6">6 %</option>
                                                                <option value="10">10 %</option>
                                                                <option value="15">15 %</option>
                                                                <option value="20">20 %</option>
                                                                <option value="25">25 %</option>
                                                                <option value="30">30 %</option>
                                                                <option value="40">40 %</option>
                                                                <option value="50">50 %</option>
                                                                <option value="60">60 %</option>
                                                            </select>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

            </div>
        </report-modal>
    </div>



<!-- END PAGE HEADER-->

<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.ToDoList') </span>
            </div>
             <div class="btn-group pull-right">
                    <!-- <a href="{{route('nProOrder.index_on')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.ActiveList')
                            <span class="badge badge-default" style="color: #ffffff; background-color: #f90000; font-size: 15px !important;"> 21 </span>
                        </button>
                    </a> -->
                    @permission('ToDo-export')
                        <span id="anchore-modal">
                            <a  @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                            </a>
                        </span>
                    @endpermission
                    @permission('ToDo-list')
                    <a href="{{route('toDoType.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder "></i> @lang('menu.ToDoType')
                        </button>
                    </a>
                    @endpermission
                    @permission('ToDo-list')
                    <a href="{{route('toDoStatus.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder"></i> @lang('layout.Status')
                        </button>
                    </a>
                    @endpermission
                    @permission('ToDo-create')
                    <a href="{{route('toDoList.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a>
                    @endpermission
                    <div id="nProOrder" v-cloak>
                        
                        <!-- <button class="btn btn-success" id="show-modal" @click="showModal =true">@lang('layout.AddNew')</button> -->

                         <modal v-if="showModal" @close="showModal = false">
                            <div slot="header">
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <h3>
                                        @lang('layout.Feedback')
                                    </h3>
                                </div>
                                <div class="col-md-4">
                                    <div v-if="fieldErrors.length > 0">
                                        <p class="text-danger" fieldErrors>
                                            <spna v-text="fieldErrors"></spna>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div slot="body">
                                <div class="row">
                                    <div class="col-md-12">
                                        {{-- <label class="control-label">@lang('layout.Status')</label>
                                        <select name="status" class="form-control" v-model="status" >
                                            <option value="Active">@lang('layout.Active')</option>
                                            <option value="Deactive">@lang('layout.Deactive')</option>
                                            <option value="OnProgress">@lang('layout.OnProgress')</option>
                                        </select> --}}
                                        <label class="control-label">@lang('layout.Status')</label>
                                        <v-select label="name" :options="toDoStatus" v-model="selected_toDoStatus1"> 
                                        </v-select>
                                        <input type="hidden" name="status_id" v-model.number="(!selected_toDoStatus1)?null:selected_toDoStatus1.id">
                                    </div>
                                </div>
                                <div class="row">
                                    <input type="hidden" name="toDoList_id" v-model="todo_id">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description") <span class="required"> * </span></label>
                                            <textarea class="form-control" name="description" v-model="description"></textarea>
                                        </div>

                                    </div>
                                </div>
                            </div>


                            <div slot="footer">
                                <button type=button class="btn btn-success" @click="addClass" >
                                    @lang('layout.OK')
                                </button>
                                <button type=button class="btn btn-danger"
                                       @click="showModal =false" >
                                    @lang('layout.Cancel')
                                </button>
                            </div>
                        </modal>
                        
                    </div>

            </div>
        </div>

        <div class="search-form" id="filter_part_app">
            <div class="col-lg-12 col-md-12" class="input-group input-medium ">
                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                    <table class="table table-striped table-bordered table-advance ">
                        <tbody>
                            <tr>
                                <td class="t_head">@lang('menu.ToDoType')</td>
                            </tr> 
                            <tr>
                                <td class="t_body">
                                    <select class="form-control"  @change="getData()" v-model="to_do_type" placeholder="{{__('Search1')}} "  name="category">
                                        <option value="">@lang('layout.Select')</option>
                                        @foreach($toDoType as $att)
                                        <option value="{{$att->id}}">{{$att->name}}</option>
                                        @endforeach
                                    </select>
                                </td>
                            </tr>
                        </tbody>
                    </table>


                </div>  
                <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12">
                    <table class="table table-striped table-bordered table-advance ">
                        <tbody>
                            <tr>
                                <td class="t_head">@lang('layout.Upcoming')</td>
                            </tr> 
                            <tr>
                                <td class="t_body">
                                    <input type="checkbox" @change="getData(this)" v-model="upcoming">
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                    <table class="table table-striped table-bordered table-advance ">
                        <tbody>
                            <tr>
                                <td class="t_head">@lang('layout.Status')</td>
                            </tr> 
                            <tr>
                                <td class="t_body">
                                    <select class="form-control"  @change="getData()" v-model="status_id"   name="status_id">
                                        <option value="">@lang('layout.Select')</option>
                                        @foreach($toDoStatus as $att)
                                        <option value="{{$att->id}}">{{$att->name}}</option>
                                        @endforeach
                                    </select>
                                    {{-- <select name="status" class="form-control" @change="getData()" v-model="status">
                                        <option value="">@lang('layout.Select')</option>
                                        <option value="Active">@lang('layout.Active')</option>
                                        <option value="Deactive">@lang('layout.Deactive')</option>
                                        <option value="OnProgress">@lang('layout.OnProgress')</option>
                                    </select> --}}
                                </td>
                            </tr>
                        </tbody>
                    </table>

                </div>                
                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                    <table class="table table-striped table-bordered table-advance ">
                        <tbody>
                            <tr>
                                <td class="t_head">@lang('layout.Priority')</td>
                            </tr> 
                            <tr>
                                <td class="t_body">
                                    <select name="priority" class="form-control" @change="getData()" v-model="priority">
                                        <option value="">@lang('layout.Select')</option>
                                        <option value="High">@lang('type.High')</option>
                                        <option value="Medium">@lang('type.Medium')</option>
                                        <option value="Low">@lang('type.Low')</option>
                                    </select>
                                </td>
                            </tr>
                        </tbody>
                    </table>

                </div>
                 
                        
                        


                {{-- <div class="col-lg-3 col-md-3">
                        <label class="control-label">@lang('layout.Description')</label>
                 
                        <input type="text" name="description" @input="getData()" v-model="description" class="form-control" autocomplete="off">

                </div> --}}
           </div>
       </div>

        <div class="portlet-body">

            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>

            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="toDoList" width="100%">
                <thead>
                <tr> 
                    <th>@lang('layout.Number')</th>
                    <th>@lang('menu.ToDoType')</th>
                    <th>@lang('layout.Member')</th>
                    <th>@lang('layout.OtherName')</th>
                    <th>@lang('layout.Priority')</th>
                    <th>@lang('layout.Date') </th>
                    <th>@lang('layout.DueDate') </th>
                    <th>@lang('layout.Time') </th>
                    <th>@lang('layout.User') </th>
                    <th>@lang('layout.Description') </th>
                    <th>@lang('layout.Status') </th>
                    <th>@lang('layout.Action') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    var cust_rep = {!!customeReportNewData('todo_list_index')!!};
    Vue.component("v-select", VueSelect.VueSelect);

    function createFeedback(id, status) {
        // var a = document.createElement('a');
        // a.href = "{{url('printTransferBillQuotation')}}/" + id;
        // a.target = "_blank";
        // document.body.appendChild(a);
        // a.click();
        // document.body.removeChild(a);
        vu.showModal = true;
        vu.todo_id = id;
        vu.status = status;
    }

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        getRecord();
    });

function getRecord(){
    
    $('#toDoList').DataTable( {
            ajax: {
                url:'{{route("toDoList.index")}}',
                data:{to_do_type:vuf.to_do_type,upcoming:vuf.upcoming,status_id:vuf.status_id,priority:vuf.priority}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging:         true,
            scrollCollapse: true,
            destroy: true,

            columns: [
            { data: 'number', name: 'number' },
            { data: 'type_name', name: 'type_name' },
            { data: 'member', name: 'member' },
            { data: 'other_member_name', name: 'other_member_name' },
            { data: 'priority', name: 'priority' },
            { data: 'create_date', name: 'create_date' },
            { data: 'date', name: 'date' },
            { data: 'time', name: 'time' },
            { data: 'user', name: 'user' },
            { data: 'description', name: 'description' },
            { data: 'status_name', name: 'status_name' },
            { data: 'action', name: 'action', searchable: false, orderable: false},
            ] 
    }); 
}

    Vue.component('modal',{
        template: '#modal-template'
    });

    let vuf = new Vue({
        el: "#filter_part_app",
        data:{
            to_do_type:null,
            upcoming:false,
            status_id:null,
            priority:null
        },
        methods:{
            getData(){
                getRecord();
            }
        }
    });

    


     let vu = new Vue({
        el: '#nProOrder',
        data:{
            showModal:false,
            fieldErrors:[],
            status_id: null,
            description: null,
            selected_toDoStatus1:null,
            todo_id: null

        },
        methods:{
            addClass(){
             
                // var myData = {name: this.status,description:this.description};

                axios.post("{{route('toDoList.storeFeedback')}}",{
                    toDoList_id:this.todo_id,
                    status_id:this.selected_toDoStatus1.id,
                    description:this.description
                })
                .then(function(response){
                    vu.showModal = false;
                    vu.todo_id = null;
                    vu.selected_toDoStatus1 = null;
                    vu.description = null;
                    $('#toDoList').DataTable().ajax.reload();
                })
            }

        }
     });

     new Vue({
         el: '#company_ll',
         methods: {
             setCompany: function (event) {
                 if (typeof data_table == 'object'){
                     data_table.clear();
                     data_table.ajax.reload();
                 }
             }
         }
     });

    //Begin Export Modal
    var toDoType = {!!json_encode($toDoType)!!};
    var toDoStatus = {!!json_encode($toDoStatus)!!};
    var member_types = {!! json_encode($member_types) !!};
    var members = {!! $members !!};

    var vm = new Vue({

        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
            selectedRequest: null, 
            requestList: [],
            selecteduser: null,
            projectList: [],
            customReportData:
            [      
            {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
            {Name: '@lang("menu.ToDoType")', column_name: 'toDoType',checkedColumn:(cust_rep.toDoType)?'checked':'',column_percentage:(cust_rep.toDoType___percent)?cust_rep.toDoType___percent:''},
            {Name: '@lang("layout.OtherName")', column_name: 'otherName',checkedColumn:(cust_rep.otherName)?'checked':'',column_percentage:(cust_rep.otherName___percent)?cust_rep.otherName___percent:''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
            {Name: '@lang("layout.Time")', column_name: 'time',checkedColumn:(cust_rep.time)?'checked':'',column_percentage:(cust_rep.time___percent)?cust_rep.time___percent:''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
            {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(cust_rep.member)?'checked':'',column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''},
            {Name: '@lang("layout.Priority")', column_name: 'Priority',checkedColumn:(cust_rep.Priority)?'checked':'',column_percentage:(cust_rep.Priority___percent)?cust_rep.Priority___percent:''},
            {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
            ],
            cust_rep:cust_rep,
            members: [],
            selected_member: null,
            toDoType:toDoType,
            toDoStatus:toDoStatus,
            selected_toDoType:null,
            selected_toDoStatus:null,
            member_types:member_types,
            selected_member_types:null
        },
        methods: {
            closeModal: function () {
                this.is_show = !this.is_show;
            },
            onProjectSearch(search, loading) {
                loading(true);
                this.searchProject(search, loading, this);
            },

            //ajax call to get items
            searchProject(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        'search_column': 'name',
                        'table_name': 'ngo_projects',
                        keyword: search,
                    }
                })
                    .then(function (response) {
                        this.projectList = [];
                        if (response.data.length > 0) {
                            vm.projectList = response.data;
                            console.log('data', vm.projectList);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },
            memberChange(){
                if (vm.selected_member_types &&  vm.selected_member_types != null ) {
                        vm.members = [];
                        let type = vm.selected_member_types.name;
                        axios.get("{{route('callToDoListMember.search')}}", {
                            params: {
                                method_name: 'selectMember',
                                type:type
                            }
                        })
                        .then(function (response) {
                            if (response.data) {
                                vm.members = [];
                                vm.members = response.data;
                            }

                        })
                        .catch(function (error) {
                            console.log(error);
                        });

                }

                },

            onRequestSearch(search, loading) {
                loading(true);
                this.requestSearch(search, loading, this);
            },

            //ajax call to get items
            requestSearch(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        'search_column': 'number',
                        'table_name': 'n_pro_orders',
                        keyword: search,
                    }
                })
                    .then(function (response) {
                        this.requestList = [];
                        if (response.data.length > 0) {
                            vm.requestList = response.data;
                            console.log('data', vm.requestList);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },
        }
    });

    var anchor = new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function () {
                // console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });

</script>

@endpush
