@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ToDoEdit') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom: 50%;" id="app" v-cloak>
            <!-- BEGIN FORM-->
            {!! Form::model($toDoList,['method' => 'PATCH','route' => ['toDoList.update',$toDoList->id],'class'=>'form-horizontal']) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="col-md-3">
                        <label class="control-label">@lang('menu.ToDoType')</label>
                        <v-select label="name" :options="toDoType" v-model="selected_toDoType"> 
                        </v-select>
                        <input type="hidden" name="to_do_type_id" v-model.number="(!selected_toDoType)?null:selected_toDoType.id" v-validate="'required'" data-vv-as="@lang('menu.ToDoType')">
                        <span class="required">@{{ errors.first('to_do_type_id') }}</span>
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Priority')</label>
                        <select name="priority" v-model="priority" class="form-control">
                            <option value="High">@lang('type.High')</option>
                            <option value="Medium">@lang('type.Medium')</option>
                            <option value="Low">@lang('type.Low')</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="control-label">@lang('layout.Number')</label>
                        <input type="text" name="number" value="{{$toDoList->number}}" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Type')</label>
                        <v-select class="vue-select2" v-model="selected_member_types" label="name" :options="member_types" @click.native="editKey = true" @input="(editKey)?memberChange():''">
                        </v-select>
                        <input type="hidden" name="member_type" v-model.number="(!selected_member_types)?null:selected_member_types.name">
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Member')</label>
                        <v-select class="vue-select2" v-model="selected_member" label="name" :options="members">
                        </v-select>
                        <input type="hidden" name="user_id" v-model.number="(!selected_member)?null:selected_member.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                        <span class="required">@{{ errors.first('user_id') }}</span>
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.OtherName')</label>
                        <input type="text" name="other_member_name" class="form-control" autocomplete="off" value="{{$toDoList->other_member_name}}">
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('menu.ToDoStatus')</label>
                        <v-select label="name" :options="toDoStatus" v-model="selected_toDoStatus"> 
                        </v-select>
                        <input type="hidden" name="status_id" v-model.number="(!selected_toDoStatus)?null:selected_toDoStatus.id" v-validate="'required'" data-vv-as="@lang('menu.ToDoStatus')">
                        <span class="required">@{{ errors.first('status_id') }}</span>
                        {{-- <label class="control-label">@lang('layout.Status')</label>
                        <select name="status" v-model="status" class="form-control">
                            <option value="Active">@lang('layout.Active')</option>
                            <option value="Deactive">@lang('layout.Deactive')</option>
                            <option value="OnProgress">@lang('layout.OnProgress')</option>
                        </select> --}}
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label class="control-label">@lang('layout.Date')</label>
                        <input type="text" class="form-control date" value="{{$toDoList->create_date}}" autocomplete="off" name="create_date">
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.DueDate')</label>
                        <input type="text" class="form-control date" value="{{$toDoList->date}}" autocomplete="off" name="date">
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Time')</label>
                        <div class="input-group">
                            <input type="time" class="form-control" name="time" value="{{$toDoList->time}}" >
                            <span class="input-group-btn">
                                <button class="btn default" type="button">
                                    <i class="fa fa-clock-o"></i>
                                </button>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label class="control-label">@lang('layout.Details')</label>
                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Details'),'class' => 'form-control','rows' => 3, 'cols' => 30, 'v-validate'=>"'required'", 'data-vv-as'=>__('layout.Description'))) !!}
                        <span class="required">@{{ errors.first('description') }}</span>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" class="btn green" @click="handleSubmit($event)"> @lang('layout.Update') </button>
                {{-- <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Update') </button> --}}
                <a href="{{route('toDoList.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')
<script>
    @if(App::getLocale())
  Vue.use(VeeValidate, {
      locale: '{{App::getLocale()}}',
  });
  @else
  Vue.use(VeeValidate, {
      locale: 'en',
  });
  @endif

    Vue.component('v-select', VueSelect.VueSelect);
    var user = {!!$user!!}; 
    var toDoType = {!! $toDoType !!};
    var toDoStatus = {!! $toDoStatus !!};
    var member_types = {!! $member_types !!};
    var toDoList = {!! $toDoList !!};
    var members = {!! $members !!};

    let vu = new Vue({
        el: '#app',
        data: {
            user: user,
            selectedUser: null,
            status: '{{$toDoList->status}}',
            priority: '{{$toDoList->priority}}',
            type: 'Simple',
            items: [],
            toDoType:toDoType,
            toDoStatus:toDoStatus,
            selected_toDoType:null,
            selected_toDoStatus:null,
            member_types:member_types,
            selected_member_types:null,
            members: members,
            selected_member: null,
            editKey: false
        },
        computed: {
            
        },
        mounted: function () {
            
            if(toDoList.to_do_type_id)
            {
                this.selected_toDoType = _.find(toDoType, (t) =>t.id==toDoList.to_do_type_id)
            }
            if(toDoList.status_id)
            {
                this.selected_toDoStatus = _.find(toDoStatus, (t) =>t.id==toDoList.status_id)
            }
            if(toDoList.member_type)
            {
                this.selected_member_types = _.find(member_types, (m) =>m.name==toDoList.member_type)
            }
            if(toDoList.member_type == "User")
            {
                this.selected_member = _.find(user, (u) =>u.id==toDoList.member_id)
            }
            if(toDoList.member_type !="User")
            {
                this.selected_member = _.find(members, (v) =>v.id==toDoList.member_id2)
            }

        },
        methods: {
            memberChange(){
            if (vu.selected_member_types &&  vu.selected_member_types != null ) {
                    vu.members = [];
                    
                    let type = vu.selected_member_types.name;
                    axios.get("{{route('callToDoListMember.search')}}", {
                        params: {
                            method_name: 'selectMember',
                            type:type
                        }
                    })
                    .then(function (response) {
                        if (response.data) {
                            vu.members = [];
                            vu.selected_member = null
                            vu.members = response.data;
                        }

                    })
                    .catch(function (error) {
                        console.log(error);
                    });

            }

            },
            addClass() {

            },
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // console.log(e);
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },
            // generic function for adding item to list
            addNew(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        if (this.items[index + 1] == undefined) {
                            this.items.push({quantity: null, description: null, price: null, um_id: null});
                        }
                    }
                }

            },

            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        this.items.splice(index, 1);
                    }
                }

            },
        }
    });
</script>

@endpush