@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
@include('to_do_types.modal')
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ToDoCreate') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom: 50%;" id="app" v-cloak>
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'toDoList.store','method'=>'POST','class'=>'form-horizontal','id'=>'toDo_form')) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="col-md-3">
                        <label class="control-label">@lang('menu.ToDoType')</label>
                        <div class="input-group">
                            <v-select label="name" :options="toDoType" v-model="selected_toDoType"></v-select>
                            <input type="hidden" name="to_do_type_id" v-model.number="(!selected_toDoType)?null:selected_toDoType.id" v-validate="'required'" data-vv-as="@lang('menu.ToDoType')">
                            <span class="required">@{{ errors.first('to_do_type_id') }}</span>

                            <span class="btn btn-success  input-group-addon"  id="show-modal" @click="showModal =true" style="background-color:  rgb(84, 199, 211)">
                                <i class="fa fa-plus" style="color: white"></i>
                            </span>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Priority')</label>
                        <select name="priority" class="form-control">
                            <option value="High">@lang('type.High')</option>
                            <option value="Medium">@lang('type.Medium')</option>
                            <option value="Low">@lang('type.Low')</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="control-label">@lang('layout.Number')</label>
                        <input type="text" name="number" value="{{$code}}" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Type')</label>
                        <v-select class="vue-select2" v-model="selected_member_types" label="name" :options="member_types" @input="memberChange">
                        </v-select>
                        <input type="hidden" name="member_type" v-model.number="(!selected_member_types)?null:selected_member_types.name">
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Member')</label>
                        <v-select class="vue-select2" v-model="selected_member" label="name" :options="members">
                        </v-select>
                        <input type="hidden" name="user_id" v-model="(!selected_member)?null:selected_member.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                        <span class="required">@{{ errors.first('user_id') }}</span>
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.OtherName')</label>
                        <input type="text" name="other_member_name" class="form-control" autocomplete="off">
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Status')</label>
                        <div class="input-group">
                            <v-select label="name" :options="toDoStatus" v-model="selected_toDoStatus"></v-select>
                            <input type="hidden" name="status_id" v-model.number="(!selected_toDoStatus)?null:selected_toDoStatus.id" v-validate="'required'" data-vv-as="@lang('menu.ToDoStatus')">
                            <span class="required">@{{ errors.first('status_id') }}</span>
                            <span class="btn btn-success  input-group-addon"  id="show-modal" @click="showModal1 =true" style="background-color:  rgb(84, 199, 211)">
                                <i class="fa fa-plus" style="color: white"></i>
                            </span>
                        </div>
                        {{-- <label class="control-label">@lang('layout.Status')</label>
                        <select name="status" class="form-control">
                            <option value="Active">@lang('layout.Active')</option>
                            <option value="Deactive">@lang('layout.Deactive')</option>
                            <option value="OnProgress">@lang('layout.OnProgress')</option>
                        </select> --}}
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <label class="control-label">@lang('layout.Date')</label>
                        <input type="text" class="form-control date" autocomplete="off" name="create_date">
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.DueDate')</label>
                        <input type="text" class="form-control date" autocomplete="off" name="date">
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('layout.Time')</label>
                        <div class="input-group">
                            <input type="time" class="form-control" name="time">
                            <span class="input-group-btn">
                                <button class="btn default" type="button">
                                    <i class="fa fa-clock-o"></i>
                                </button>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <label class="control-label">@lang('layout.Details')</label>
                        {!! Form::textarea('description', null, array('class' => 'form-control','rows' => 3, 'cols' => 30,'v-validate'=>"'required'", 'data-vv-as'=>__('layout.Description'))) !!}
                        <span class="required">@{{ errors.first('description') }}</span>
                    </div>
                </div> 
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" class="btn green" @click="handleSubmit($event)"> @lang('layout.Submit') </button>
                {{-- <button type="button" class="btn green" onclick="regForm(this)"> @lang('layout.Submit') </button> --}}
                <button type="button" class="btn blue" :disabled="disabled"  @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                <a href="{{route('toDoList.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
            </div>
            {!! Form::close() !!}


            <modal v-if="showModal" @close="showModal = false">
                <div slot="header">
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <h3>
                            @lang('layout.ToDoTypeCreate')
                        </h3>
                    </div>
                    <div class="col-md-4">
                        <div v-if="fieldErrors.length > 0">
                            <p class="text-danger" fieldErrors>
                                <spna v-text="fieldErrors"></spna>
                            </p>
                        </div>
                    </div>
                </div>
                <div slot="body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>@lang("layout.Name") <span class="required"> * </span></label>
                                <input type="text" class="form-control" name="name" v-model="className" autocomplete="off">
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>@lang("layout.Description")</label>
                                <textarea class="form-control" name="description" v-model="description">
                                    
                                </textarea>
                            </div>

                        </div>
                        
                    </div>
                </div>


                <div slot="footer">
                    <button type=button class="btn btn-success" @click="addClass" >
                        @lang('layout.OK')
                    </button>
                    <button type=button class="btn btn-danger"
                           @click="showModal =false" >
                        @lang('layout.Cancel')
                    </button>
                </div>
            </modal>
            
            <modal v-if="showModal1" @close="showModal1 = false">
                <div slot="header">
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <h3>
                            @lang('layout.CreateToDoStatus')
                        </h3>
                    </div>
                    <div class="col-md-4">
                        <div v-if="fieldErrors.length > 0">
                            <p class="text-danger" fieldErrors>
                                <spna v-text="fieldErrors"></spna>
                            </p>
                        </div>
                    </div>
                </div>
                <div slot="body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>@lang("layout.Name") <span class="required"> * </span></label>
                                <input type="text" class="form-control" name="name" v-model="className" autocomplete="off">
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>@lang("layout.Description")</label>
                                <textarea class="form-control" name="description" v-model="description">
                                    
                                </textarea>
                            </div>

                        </div>
                        
                    </div>
                </div>


                <div slot="footer">
                    <button type=button class="btn btn-success" @click="addClass1" >
                        @lang('layout.OK')
                    </button>
                    <button type=button class="btn btn-danger"
                           @click="showModal1 =false" >
                        @lang('layout.Cancel')
                    </button>
                </div>
            </modal>

        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection

@push('scripts')
<script>
@if(App::getLocale())
  Vue.use(VeeValidate, {
      locale: '{{App::getLocale()}}',
  });
  @else
  Vue.use(VeeValidate, {
      locale: 'en',
  });
  @endif

  Vue.component('modal',{
        template: '#modal-template'
    });

    Vue.component('v-select', VueSelect.VueSelect);

    var toDoType = {!! $toDoType !!};
    var toDoStatus = {!! $toDoStatus !!}
    var member_types = {!! $member_types !!};

    let vu = new Vue({
        el: '#app',
        data: {
            members: [],
            selected_member: null,
            type: 'Simple',
            items: [],
            toDoType:toDoType,
            toDoStatus:toDoStatus,
            selected_toDoType:null,
            selected_toDoStatus:null,
            member_types:member_types,
            selected_member_types:null,
            disabled:false,

            showModal:false,
            showModal1:false,
            fieldErrors:[],
            className: null,
            description: null
        },
        computed: {
            
        },
        methods: {
            memberChange(){
                if (vu.selected_member_types &&  vu.selected_member_types != null ) {
                        vu.members = [];
                        let type = vu.selected_member_types.name;
                        axios.get("{{route('callToDoListMember.search')}}", {
                            params: {
                                method_name: 'selectMember',
                                type:type
                            }
                        })
                        .then(function (response) {
                            if (response.data) {
                                vu.members = [];
                                vu.members = response.data;
                            }
    
                        })
                        .catch(function (error) {
                            console.log(error);
                        });

                }

            },
            addClass(){
                axios.post("{{route('toDoType.store')}}",{
                    name:this.className,
                    description:this.description
                })
                .then(function(response){
                    var message = "{{__('message.CSuccess')}}";
                    toastr.success('', message);

                    vu.showModal = false;
                    vu.className = null;
                    vu.description = null;
                    vu.selected_toDoType = response.data.toDoType;
                })
                .catch(function(error) {
                    var message = "{{__('message.Warning')}}";
                    toastr.warning('', message);
                });
            },
            addClass1(){
                axios.post("{{route('toDoStatus.store')}}",{
                    name:this.className,
                    description:this.description
                })
                .then(function(response){
                    var message = "{{__('message.CSuccess')}}";
                    toastr.success('', message);

                    vu.showModal1 = false;
                    vu.className = null;
                    vu.description = null;
                    vu.selected_toDoStatus = response.data.toDoStatus;
                })
                .catch(function(error) {
                    var message = "{{__('message.Warning')}}";
                    toastr.warning('', message);
                });
            },
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // console.log(e);
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },
            saveAndNew() {
                this.$validator.validate()
                    
                .then(valid => {
                if (valid) {
                    vu.disabled = true;
                    var url = "{{route('toDoList.store')}}";
                    form_id = 'toDo_form';
                    var data = $('#' + form_id).serialize();
                    toggleBlock(true);
                    axios.post(url, data)
                    .then(function (response) {
                        toggleBlock(0);
                        if (response.data.result == 1) {
                        $('#' + form_id).trigger('reset');
                        //$('#success-sound')[0].play();
                        toastr.success('', response.data.message);
                        location.reload();
                        
                        }
                        else {
                        var message = "{{__('message.Warning')}}";
                        vu.disabled = false;
                        //$('#error-sound')[0].play();
                        toastr.warning('', message);
                        }
                    })
                    .catch(function (error) {
                        toggleBlock(0);
                        vu.disabled = false;
                        console.log(error);
                        var message = "{{__('message.Warning')}}";
                        //$('#error-sound')[0].play();
                        toastr.warning('', message);
                    });

                }
                })
            },
            // generic function for adding item to list
            addNew(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        if (this.items[index + 1] == undefined) {
                            this.items.push({quantity: null, description: null, price: null, um_id: null});
                        }
                    }
                }

            },

            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'item') {
                        this.items.splice(index, 1);
                    }
                }

            },
        }
    });
</script>

@endpush