@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReportNew('todo_list_index');

    $_number = !in_array('number', $report);
    $_member = !in_array('member', $report);
    $_description = !in_array('description', $report);
    $_time = !in_array('time', $report);
    $_date = !in_array('date', $report);
    $_status = !in_array('status', $report);
    $_Priority = !in_array('Priority', $report);
    $_toDoType = !in_array('toDoType', $report);
    $_otherName = !in_array('otherName', $report);

    
    $report_percent = customeReportNewPercent('todo_list_index');
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_member_percent= (array_key_exists('member___percent', $report_percent))?$report_percent['member___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_time_percent= (array_key_exists('time___percent', $report_percent))?$report_percent['time___percent']:null;
    $_status_percent= (array_key_exists('status___percent', $report_percent))?$report_percent['status___percent']:null;
    $_Priority_percent= (array_key_exists('Priority___percent', $report_percent))?$report_percent['Priority___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_toDoType_percent= (array_key_exists('toDoType___percent', $report_percent))?$report_percent['toDoType___percent']:null;
    $_otherName_percent= (array_key_exists('otherName___percent', $report_percent))?$report_percent['otherName___percent']:null;
 
    
    ?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.ToDoReport')</h3>
<table class="main-table">

<thead>
<tr class="bg" >
    <td class="center">@lang('layout.Record')</td>
    @if($_number)<td class="center" @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number') </td>@endif
    @if($_date)<td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</td>@endif 
    @if($_date)<td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.DueDate')</td>@endif 
    @if($_time)<td class="center" @if($_time_percent) width="{{$_time_percent}}%" @endif>@lang('layout.Time')</td>@endif
    @if($_toDoType)<td class="center" @if($_toDoType_percent) width="{{$_toDoType_percent}}%" @endif>@lang('menu.ToDoType')</td>@endif
    @if($_description)<td class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</td>@endif
    @if($_member)<td class="center" @if($_member_percent) width="{{$_member_percent}}%" @endif>@lang('layout.Member')</td>@endif
    @if($_otherName)<td class="center" @if($_otherName_percent) width="{{$_otherName_percent}}%" @endif>@lang('layout.OtherName')</td>@endif
    @if($_Priority)<td class="center" @if($_Priority_percent) width="{{$_Priority_percent}}%" @endif>@lang('layout.Priority')</td>@endif
    @if($_status)<td class="center" @if($_status_percent) width="{{$_status_percent}}%" @endif>@lang('layout.Status')</td>@endif
    <td class="center">@lang('layout.User')</td> 
</tr>
</thead>
<?php
$count = 0;
?>

@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
@if($_number)<td class="center">{{$record['number']}}</td>@endif
@if($_date)<td class="center">{{convertDate($record['create_date'])}}</td>@endif
@if($_date)<td class="center">{{convertDate($record['date'])}}</td>@endif
@if($_time)<td class="center"> {{$record['time']}}</td>@endif
@if($_toDoType)<td class="center">{{$record['type_name']}}</td>@endif
@if($_description)<td style="@if($_description_percent) text-align: justify @endif">{{$record['description']}}</td>@endif
@if($_member)<td style="text-align: justify">{{$record['member']}}</td>@endif
@if($_otherName)<td style="text-align: justify">{{$record['other_member_name']}}</td>@endif
@if($_Priority)<td class="center">{{ __('type.' . $record['priority']) }}</td>@endif
@if($_status)<td class="center">{{__($record['status_name'])}}</td>@endif
<td style="text-align: justify"> {{$record['user']}}</td>

</tr>
@endforeach

</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection

