@extends('layouts.app')
@section('content')
@include('to_do_types.modal')
<!-- END PAGE HEADER-->
<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.ToDoStatusList') </span>
            </div>
            <div class="pull-right">
                <div id="ToDoStatus" v-cloak>
                    @permission('ToDo-list')
                    <a href="{{route('toDoList.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder "></i> @lang('layout.ToDo')
                        </button>
                    </a>
                    @endpermission
                    @permission('ToDo-list')
                    <a href="{{route('toDoType.index')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-reorder "></i> @lang('menu.ToDoType')
                        </button>
                    </a>
                    @endpermission
                    @permission('ToDoStatus-create')
                    <button class="btn btn-success" id="show-modal" @click="showModal =true"><i class="fa fa-plus"></i> @lang('layout.AddNew')</button>
                    <modal v-if="showModal" @close="showModal = false">
                        <div slot="header">
                            <div class="col-md-12 col-sm-12 col-xs-12">
                                <h3>
                                    @lang('layout.CreateToDoStatus')
                                </h3>
                            </div>
                            <div class="col-md-4">
                                <div v-if="fieldErrors.length > 0">
                                    <p class="text-danger" fieldErrors>
                                        <spna v-text="fieldErrors"></spna>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div slot="body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>@lang("layout.Name") <span class="required"> * </span></label>
                                        <input type="text" class="form-control" name="name" v-model="className" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>@lang("layout.Description")</label>
                                        <textarea class="form-control" name="description" v-model="description"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                    <label class="control-label"> <span style="color:rgb(14 177 177);"></span> @lang('layout.Alert')</label>
                                    <div class="col-md-12 mt-checkbox">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox" name="alert" v-model="alert" value="1">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div slot="footer">
                            <button type=button class="btn btn-success" @click="addClass" >
                                @lang('layout.OK')
                            </button>
                            <button type=button class="btn btn-danger"
                                    @click="showModal =false" >
                                @lang('layout.Cancel')
                            </button>
                        </div>
                    </modal>
                    @endpermission
                </div>
            </div>
        </div>
        <div class="portlet-body">
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="ToDoStatusTable" width="100%">
                <thead>
                    <tr> 
                        {{-- <th># </th>--}}
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Description') </th>
                        <th>@lang('layout.Alert') </th>
                        <th>@lang('layout.CreatedAt') </th>
                        <th>@lang('layout.UpdatedAt') </th>
                        <th>@lang('layout.Action') </th>
                    </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    let data_table;
    $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        data_table = $('#ToDoStatusTable').DataTable( {
            ajax:           '{{route("toDoStatus.index")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging:         true,
            columns: [
            /*{ data: 'id', name: 'id' },*/
            { data: 'name', name: 'name' },
            { data: 'description', name: 'description' },
            { data: 'alert', name: 'alert' },
            { data: 'created_at', name: 'created_at' },
            { data: 'updated_at', name: 'updated_at' },
            { data: 'action', name: 'action', searchable: false, orderable: false},
            ] 
        }); 
    });
    Vue.component('modal',{
        template: '#modal-template'
    });
    let vu = new Vue({
        el: '#ToDoStatus',
        data:{
            showModal:false,
            fieldErrors:[],
            className: null,
            description: null,
            alert: false,
        },
        methods:{
            addClass(){
                axios.post("{{route('toDoStatus.store')}}",{
                    name:this.className,
                    description:this.description,
                    alert:this.alert
                })
                .then(function(response){
                    var message = "{{__('message.CSuccess')}}";
                    toastr.success('', message);
                    vu.showModal = false;
                    vu.className = null;
                    vu.description = null;
                    vu.alert = null;
                    $('#ToDoStatusTable').DataTable().ajax.reload();
                })
                .catch(function(error) {
                    var message = "{{__('message.Warning')}}";
                    toastr.warning('', message);
                });
            }
        }
    });
    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function (event) {
                if (typeof data_table == 'object'){
                    data_table.clear();
                    data_table.ajax.reload();
                }
            }
        }
    });
</script>
@endpush