@extends('layouts.app')
@section('content')
@include('employee_assessment_categories.modal')

<div class="row">
    <div class="tabbable tabbable-tabdrop">

       <ul class="nav nav-tabs">
           
           <li class="active">
               <a href="#tab1" data-toggle="tab" id="tab_con">@lang('layout.Telegram')</a>
           </li>
           <li class="">
               <a href="#tab2" data-toggle="tab" id="tab_con2">@lang('layout.TelegramContacts')</a>
           </li>
       </ul>
       <div class="tab-content">
            <div class="tab-pane active" id="tab1"> 
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>
                            <span class="caption-subject bold uppercase">@lang('layout.Telegram')</span>
                        </div>
                        <div class="pull-right">
                            @if(\Entrust::can('Telegram-create'))
                            <form action="{{url('storeTelegramId')}}" method="post">
                                @csrf
                                <input type="submit" class="btn btn-success" value="{{__('layout.Add')}}">
                            </form>
                            @endif
                        </div>
                    </div>
                    <div class="portlet-body">
                        <template v-cloak id="company_ll">
                            <company @company="setCompany"></company>
                        </template>
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="teleg">
                            <thead>
                            <tr> 
                                <th>@lang('layout.TelegramID')</th>
                                <th>@lang('layout.Name')</th>
                                <th>@lang('layout.LastName') </th>
                                <th>@lang('layout.TelegramUserName') </th>
                                <th>@lang('layout.Status') </th>
                            </tr>
                            </thead> 
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="tab-pane" id="tab2"> 
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>
                            <span class="caption-subject bold uppercase">@lang('layout.TelegramContacts')</span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <template v-cloak id="company_ll">
                            <company @company="setCompany"></company>
                        </template>
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="tel_contact">
                            <thead>
                            <tr> 
                                <th>@lang('layout.TelegramID')</th>
                                <th>@lang('layout.Name')</th>
                                <th>@lang('layout.LastName') </th>
                                <th>@lang('layout.TelegramUserName') </th>
                                <th>@lang('layout.Action') </th>
                            </tr>
                            </thead> 
                        </table>
                    </div>
                </div>
            </div>
        </div>


</div>
</div>

<!-- END PAGE HEADER-->

@stop
@include('groupCompanyFilter.select')

@push('scripts')

<script>
    /**
     * for creating shortcuts
     */
    document.onkeyup = function(e)
    {
        //new form
        if (e.which ==78) {
            window.location.href   = "{{route('inventoryCategory.create')}}"
        }
        
    }

    let data_table;
    let data_table_contact;
     $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#teleg').DataTable( {
                    ajax:{
                        url:'{{route("telegram.index")}}',
                        data:{type:'tel_id'}
                    },
                    pageLength:'{{getPageRows()}}',
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    scrollCollapse: true,
                    serverSide: true,
                    paging:         true,
                    columns: [
                /* { data: 'id', name: 'id' },*/
                    { data: 'id', name: 'id' },
                    { data: 'name', name: 'name' },
                    { data: 'lastname', name: 'lastname' },
                    { data: 'username', name: 'username' },
                    { data: 'flag', name: 'flag' }
                    ] 
            }); 
    });
    $(document).ready(function() { 
        $('#tab_con2').on('shown.bs.tab', function (event) {
            data_table_contact = $('#tel_contact').DataTable( {
                    ajax:{
                        url:'{{route("telegram.index")}}',
                        data:{type:'tel_contact'}
                    },
                    pageLength:'{{getPageRows()}}',
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    scrollCollapse: true,
                    serverSide: true,
                    paging:         true,
                    destroy: true,
                    columns: [
                    { data: 'chat_id', name: 'telegram_ids.chat_id'},
                    { data: 'name', name: 'telegram_ids.name'},
                    { data: 'last_name', name: 'telegram_ids.last_name'},
                    { data: 'username', name: 'telegram_ids.username'},
                    { data: 'actions', name: 'actions' , orderable:false,searchable:false}
                    ] 
            }); 
        });
    });

</script>


@endpush
