@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.TaxationEdit')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="taxation">
            <!-- BEGIN FORM-->
            {!! Form::model($taxation, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['taxation.update',$taxation->id]]) !!}
                            <div class="row">

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-2">@lang('layout.Name'):</label>
                            <div class="col-md-10">
                                {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Name'),'placeholder' => __('layout.Name'),'autofocus'=>'autofocus'])}}
                            <span class="required">@{{ errors.first('name') }}</span>
                            </div>
                        </div>
                    </div>      

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-2">@lang('layout.Percent'):</label>
                            <div class="col-md-10">
                                {{Form::number('percent',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Percent'),'placeholder' => __('layout.Percent'),'autofocus'=>'autofocus'])}}
                            <span class="required">@{{ errors.first('percent') }}</span>
                            </div>
                        </div>
                    </div>                    

                    <div class="col-md-3">
                         <div class="form-group">
                            <label class="control-label col-md-2">@lang('layout.Date'):</label>
                            <div class="col-md-10">
                                <input type="text" name="date" class="form-control date" autocomplete="off" value="{{convertDate($taxation->date)}}">
                            </div>
                        </div>
                    </div>
                     <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-2">@lang('layout.Member'):</label>
                            <div class="col-md-10">
                                <v-select placeholder="@lang('layout.SelectMember')" label="name"
                                          v-model="selected_member"
                                          :options="members">
                                </v-select>
                                <input type="hidden" name="member_id"
                                       v-model.number="(!selected_member)?null:selected_member.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">


                                        
                                    <span class="required">@{{ errors.first('member_id') }}</span>




                            </div>
                        </div>
                    </div> 
                
                  
                </div>
                <div class="row">
                     <div class="col-md-3"> 
                        <div class="form-group">
                            <label class="control-label col-md-2">@lang('layout.Description'):</label>
                            <div class="col-md-10">
                                   {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 6, 'cols' => 60)) !!}

                            </div>
                        </div>
                        
                    </div>
                </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>

                <button href="{{url('taxation.index')}}" class="btn default"><i
                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection


@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

Vue.component("v-select", VueSelect.VueSelect);

        var members = {!! $members !!};
        var selected_member = {!! $selected_member !!};

        let vu = new Vue({
                el: '#taxation',
                data: {

                    members: members,
                    selected_member: selected_member
                },
                methods: {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                regForm(e.target);
                            }
                        });
                    },
                }
            })
    </script>
@endpush
