@extends('layouts.app')
@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    
    }
   
</style>
@stop
@section('content')
 
      <div class="row">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.RequestShow')</span>
                    </div>
                   
                    <div class="tools"></div>
                </div>
                <div class="portlet-body">
                    <div class="row">
                       <div class="col-md-12">
                           <table class="table">
                           <thead>
                                <tr>
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.ReferenceNumber')</th>
                                    <th>@lang('layout.Member')</th>
                                    <th>@lang('layout.Project')</th>
                                    <th>@lang('layout.Date') </th>
                                    <th>@lang('layout.Currency') </th>
                                    <th>@lang('layout.Rate') </th>
                                    <th>@lang('layout.Total')</th>
                                    <th>@lang('layout.Category')</th>
                                    <th>@lang('layout.Priority')</th>
                                    <th>@lang('layout.DateRequired') </th>
                                    <th>@lang('layout.User') </th>
                                    <th>@lang('layout.Description') </th>
                                </tr>
                              </thead>
                            <tbody> 
                                <tr>  
                                    <td class="hidden-xs"> {{ $nProOrder->number}}  </td>
                                    <td class="hidden-xs"> {{ $nProOrder->ref_no}}  </td>
                                    <td class="hidden-xs"> {{ $nProOrder->member}}  </td>
                                    <td class="hidden-xs"> {{ $nProOrder->project}}</td>
                                    <td class="hidden-xs"> {{ $nProOrder->date}}</td>
                                    <td class="hidden-xs"> {{ $nProOrder->currency}}</td>
                                    <td class="hidden-xs"> {{ $nProOrder->currency_rate}}</td>
                                    <td class="hidden-xs"> {{ $nProOrder->price}}</td>
                                    <td class="hidden-xs"> {{ $nProOrder->category}}</td>
                                    <td class="hidden-xs"> {{ __('type.'.$nProOrder->priority)}}</td>
                                    <td class="hidden-xs"> {{ $nProOrder->requir_date}}</td>
                                    <td class="hidden-xs"> {{ $nProOrder->user}}</td>
                                    <td class="hidden-xs"> {{ $nProOrder->description}}</td>
                                </tr>
                            </tbody>
                            </table>
                       </div> 
                       <div class="col-md-12">
                           <table class="table">
                           <thead>
                                <tr>
                                    <th>@lang('layout.Type')</th>
                                    @if($nProOrder->type == 'VehicleExpenses')
                                    <th>@lang('layout.Driver')</th>
                                    <th>@lang('layout.VehicleName')</th>
                                    <th>@lang('layout.PaletNumber')</th>
                                    @endif
                                </tr>
                              </thead>
                            <tbody> 
                                <tr>  
                                    <td class="hidden-xs"> {{ __('layout.'.$nProOrder->type)}}</td>
                                    @if($nProOrder->type == 'VehicleExpenses')
                                    <td class="hidden-xs"> {{ $nProOrder->driver_name}}  </td>
                                    <td class="hidden-xs"> {{ $nProOrder->vehicle_name}}  </td>
                                    <td class="hidden-xs"> {{ $nProOrder->palet_number}}  </td>
                                    @endif
                                </tr>
                            </tbody>
                            </table>
                       </div> 
                    </div>
                    <div class="row" >
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Request')</span>
                                </div>
                                <div class="actions">
                                </div>
                            </div>
                            <div class="portlet-body" id="itemsshow">
                                <table class="table table-striped table-bordered table-hover" id="orderDetail">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.Measure')</th>
                                            <th>@lang('layout.Price')</th>
                                            <th>@lang('layout.Total')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                    <div class="row" >
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Approveres')</span>
                                </div>
                                <div class="actions">
                                </div>
                            </div>
                            <div class="portlet-body" id="itemsshow">
                                <table class="table table-striped table-bordered table-hover" id="orderMemo">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>@lang('layout.Type')</th>
                                            <th>@lang('layout.User')</th>
                                            <th>@lang('layout.PositionName')</th>
                                            <th>@lang('layout.Date')</th>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.Action')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                    <div class="row" id="app">
                    {!! Form::open(array('route' => 'nProOrder.storeMemo','method'=>'POST','class'=>'form-horizontal')) !!}
                        {{ csrf_field() }}
                        <div class="col-md-12" style="padding: 0px;" >
                            <h3>@lang('layout.SendToSelfDepartment')</h3>
                            <div class="col-md-4" >
                                <label class="control-label">@lang('menu.Position')</label>
                                <v-select class="vue-select2" v-model="selected_position" label="name" :options="{{$position}}">
                                </v-select>
                                <input type="hidden" name="position_id" v-model.number="(!selected_position)?null:selected_position.id">
                                <input type="hidden" name="proOrder_id" value="{{$nProOrder->id}}">
                            </div>
                            <div class="col-md-8">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('memo_description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                            </div>
                        </div>
                        @if($selectedPosition)
                        <div class="col-md-12" >
                            <br/>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover">
                                    <tbody>
                                        <tr>
                                            <td class="highlight">
                                                <div class="form-control">
                                                    <label class="mt-checkbox mt-checkbox-outline"  style="color: blue;">
                                                        <input type="radio" value="memo" name="memo_type"><span></span> @lang('layout.Memo')
                                                    </label>
                                                </div>
                                            </td>
                                            @if($selectedPosition->accept_form == 'yes')
                                            <td class="highlight">
                                                <div class="form-control">
                                                    <label class="mt-checkbox mt-checkbox-outline"  style="color: green;">
                                                        <input type="radio" value="accupt" name="memo_type"><span></span> @lang('layout.Accept')
                                                    </label>
                                                </div>
                                            </td>
                                            @endif
                                            @if($selectedPosition->cancel_form == 'yes')
                                            <td class="highlight">
                                                <div class="form-control">
                                                    <label class="mt-checkbox mt-checkbox-outline" style="color: red;">
                                                        <input type="radio" value="cancel" name="memo_type"><span></span> @lang('layout.Cancel') @lang('layout.Request')
                                                    </label>
                                                </div>
                                            </td>
                                            @endif
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        @endif
                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                            <br/>
                            <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                        </div>
                    {!! Form::close() !!}
                    </div>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@endsection
@push('scripts') 
<script>

    $(document).ready(function(){
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#orderDetail').DataTable({  
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax:{
                url: '{{route("nProOrder.memo",$nProOrder->id)}}',
                data:{type:'orderDetail'}
                }, 
            columns: [ 
                { data: 'description',   name: 'description' },
                { data: 'quantity'   ,   name: 'quantity' },
                { data: 'measure_name',  name: 'measure_name' },
                { data: 'price'   ,      name: 'price' },
                { data: 'total'   ,      name: 'total' },
            ]
        }); 
        $('#orderMemo').DataTable({  
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax:{
                url: '{{route("nProOrder.memo",$nProOrder->id)}}',
                data:{type:'orderMemo'}
                }, 
            columns: [ 
                { data: 'id',   name: 'id' },
                { data: 'type',   name: 'type' },
                { data: 'user',  name: 'user' },
                { data: 'position_name', name: 'position_name' },
                { data: 'date',      name: 'date' },
                { data: 'description',   name: 'description' },
                { data: 'action',   name: 'action' },
            ]
        });  
    });

    Vue.component('v-select', VueSelect.VueSelect);
    
    var selectedPosition =  {!! json_encode($selectedPosition) !!}; 
    let vu = new Vue({
        el: '#app',
        data: {
            selectedPosition: selectedPosition,
            selected_position: null
        },
        computed: {
        },
        methods: {
        }
    });

</script>
@endpush