@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('contract', 'index');
?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.ToDoReport')</h3>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.Member')</th>
            <th>@lang('layout.Priority')</th>
            <th>@lang('layout.DueDate') </th>
            <th>@lang('layout.Time') </th>
            <th>@lang('layout.User') </th>
            <th>@lang('layout.Description') </th>
            <th>@lang('layout.Status') </th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class="hidden-xs"> {{ $data->number}}  </td>
            <td class="hidden-xs"> {{ $data->member}}  </td>
            <td class="hidden-xs"> {{ __('type.'.$data->priority)}}</td>
            <td class="hidden-xs"> {{ $data->date}}</td>
            <td class="hidden-xs"> {{ $data->time}}</td>
            <td class="hidden-xs"> {{ $data->user}}</td>
            <td class="hidden-xs"> {{ $data->description}}</td>
            <td class="hidden-xs"> {{ __('layout.'.$data->status)}}</td>
        </tr>
    </tbody>
</table>
<hr />
<h3>@lang('layout.Feedback')</h3>
<table class="main-table">
    <tr class="bg">
        <th>#</th>
        <th>@lang('layout.Parent')</th>
        <th>@lang('layout.Description')</th>
        <th>@lang('layout.Date')</th>
    </tr>
    <?php
    $count = 0;
    ?>
    @foreach($toDoFeedbackDetail AS $record1)
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record1->parent}}</td>
        <td class="center">{{$record1->description}}</td>
        <td class="center">{{convertDate($record1->date)}}</td>
    </tr>
    @endforeach
</table>

@endsection