@extends('layouts.app')
@section('content')

@include('layouts.modal')


    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show" :value-type="'ngo_pro_order_report'" @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">

                            <ul class="nav nav-tabs">
                                
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                               @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label ">@lang('layout.SelectProject') </label>
                                                    <v-select class="vue-select2" v-model="selectedproject" label="name"
                                                              @search="onProjectSearch" :options="projectList">
                                                    </v-select>
                                                    <input type="hidden" name="project_id"
                                                           v-model.number="(!selectedproject)?null:selectedproject.id">
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div slot="date">
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="n_pro_orders_index">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">
                                                             <label> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                             <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label>

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

            </div>
        </report-modal>
    </div>


<!-- END PAGE HEADER-->

<!-- BEGIN TAB PORTLET--> 
<div class="row"> 
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.RequestList') </span>
            </div>
             <div class="btn-group pull-right">
                    <a href="{{route('nProOrder.index')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.MainList')
                            
                            <!-- <span class="badge badge-default" style="color: #ffffff; background-color: #f90000; font-size: 15px !important;"> 21 </span> -->
                            
                        </button>
                    </a>
                    @permission('NGOProject-export')
                        <span id="anchore-modal">
                            <a  @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                            </a>
                        </span>
                    @endpermission
                    @permission('NGOProject-create')
                    <a href="{{route('nProOrder.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button></a>
                    @endpermission
                    <div id="nProOrder" v-cloak>
                        
                         <!-- <button class="btn btn-success" id="show-modal" @click="showModal =true">@lang('layout.AddNew')</button>

                         <modal v-if="showModal" @close="showModal = false">
                            <div slot="header">
                                <div class="col-md-12 col-sm-12 col-xs-12">
                                    <h3>
                                        @lang('layout.projectCategoryCreate')
                                    </h3>
                                </div>
                                <div class="col-md-4">
                                    <div v-if="fieldErrors.length > 0">
                                        <p class="text-danger" fieldErrors>
                                            <spna v-text="fieldErrors"></spna>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div slot="body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Name") <span class="required"> * </span></label>
                                            <input type="text" class="form-control" name="name" v-model="className">
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label>@lang("layout.Description") <span class="required"> * </span></label>
                                            <textarea class="form-control" name="description" v-model="description">
                                                
                                            </textarea>
                                        </div>

                                    </div>
                                    
                                </div>
                            </div>


                            <div slot="footer">
                                <button type=button class="btn btn-success" @click="addClass" >
                                    @lang('layout.OK')
                                </button>
                                <button type=button class="btn btn-danger"
                                       @click="showModal =false" >
                                    @lang('layout.Cancel')
                                </button>
                            </div>
                        </modal> -->
                        
                    </div>

            </div>
        </div>
        <div class="portlet-body">

            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>

            <table class="table table-striped table-bordered table-hover" cellspacing="1" id="nProOrders" width="100%">
                <thead>
                <tr> 
                    <th>@lang('layout.Number')</th>
                    <th>@lang('layout.ReferenceNumber')</th>
                    <th>@lang('layout.Member')</th>
                    <th>@lang('layout.Project')</th>
                    <th>@lang('layout.Date') </th>
                    <th>@lang('layout.Currency') </th>
                    <th>@lang('layout.Rate') </th>
                    <th>@lang('layout.Category')</th>
                    <th>@lang('layout.Priority')</th>
                    <th>@lang('layout.Type') </th>
                    <th>@lang('layout.DateRequired') </th>
                    <th>@lang('layout.User') </th>
                    <th>@lang('layout.Description') </th>
                    <th>@lang('layout.Action') </th>
                </tr>
                </thead> 
            </table>
        </div>
    </div>
</div> 
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script>
    var cust_rep = {!!customeReportNewData('n_pro_orders_index')!!};
    Vue.component("v-select", VueSelect.VueSelect);

    let data_table;
     $(document).ready(function() { 
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        data_table = $('#nProOrders').DataTable( {
            ajax: '{{route("nProOrder.index_on")}}',
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging:         true,
            columns: [
            { data: 'number', name: 'number' },
            { data: 'ref_no', name: 'ref_no' },
            { data: 'member', name: 'member' },
            { data: 'project', name: 'project' },
            { data: 'date', name: 'date' },
            { data: 'currency', name: 'currency' },
            { data: 'currency_rate', name: 'currency_rate' },
            { data: 'category', name: 'category' },
            { data: 'priority', name: 'priority' },
            { data: 'type', name: 'type' },
            { data: 'requir_date', name: 'requir_date' },
            { data: 'user', name: 'user' },
            { data: 'description', name: 'description' },
            { data: 'action', name: 'action' },
            ] 
    }); 
    });
        Vue.component('modal',{
            template: '#modal-template'
        });

     let vu = new Vue({
        el: '#nProOrder',
        data:{
            showModal:false,
            fieldErrors:[],
            className: null,
            description: null,
        },
        methods:{
            addClass(){
             
                // var myData = {name: this.className,description:this.description};

                axios.post("{{route('nProOrder.store')}}",{
                    name:this.className,
                    description:this.description
                })
                .then(function(response){
                    vu.showModal = false;
                    vu.className = null;
                    vu.description = null;
                    $('#nProOrders').DataTable().ajax.reload();
                })
            }
        }
     });

     new Vue({
         el: '#company_ll',
         methods: {
             setCompany: function (event) {
                 if (typeof data_table == 'object'){
                     data_table.clear();
                     data_table.ajax.reload();
                 }
             }
         }
     });

             //Begin Export Modal

    var vm = new Vue({

        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
            selectedproject: null,
            projectList: [],
            customReportData:
            [      
            {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':''},
            {Name: '@lang("layout.ProjectName")', column_name: 'name',checkedColumn:(cust_rep.name)?'checked':''},
            {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':''},
            {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':''},
            {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':''},
            {Name: '@lang("layout.DateRequired")', column_name: 'requir_date',checkedColumn:(cust_rep.requir_date)?'checked':''},
            {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':''},
            {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(cust_rep.member)?'checked':''},
            {Name: '@lang("layout.ReferenceNumber")', column_name: 'ref_no',checkedColumn:(cust_rep.ref_no)?'checked':''},
            {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_rep.category)?'checked':''},
            {Name: '@lang("layout.Priority")', column_name: 'priority',checkedColumn:(cust_rep.priority)?'checked':''},
            {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_rep.driver)?'checked':''},
            {Name: '@lang("layout.VehicleName")', column_name: 'vehicleName',checkedColumn:(cust_rep.vehicleName)?'checked':''},
            ],
            cust_rep:cust_rep
        },
        methods: {
            closeModal: function () {
                this.is_show = !this.is_show;
            },
            onProjectSearch(search, loading) {
                loading(true);
                this.searchProject(search, loading, this);
            },

            //ajax call to get items
            searchProject(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        'search_column': 'name',
                        'table_name': 'ngo_projects',
                        keyword: search,
                    }
                })
                    .then(function (response) {
                        this.projectList = [];
                        if (response.data.length > 0) {
                            vm.projectList = response.data;
                            console.log('data', vm.projectList);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
            },
        }
    });

    var anchor = new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function () {
                // console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });

</script>

@endpush
