@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReportNew('tablesInfo_index');

    $_tableName = !in_array('tableName', $report);
    $_size = !in_array('size', $report);
    $_row = !in_array('row', $report);
    $_date = !in_array('date', $report);

    $report_percent = customeReportNewPercent('tablesInfo_index');
    $_tableName_percent= (array_key_exists('tableName___percent', $report_percent))?$report_percent['tableName___percent']:null;
    $_size_percent= (array_key_exists('size___percent', $report_percent))?$report_percent['size___percent']:null;
    $_row_percent= (array_key_exists('row___percent', $report_percent))?$report_percent['row___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
 
    
    ?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.TableInfoReport')</h3>
<table class="main-table">

<thead>  
<tr class="bg" >
    <td class="center">@lang('layout.Record')</td>
    @if($_date)<td @if($_date_percent) width="{{$_date_percent}}%" @endif class="center">{{ trans('backup.created_at') }}</td>@endif
    @if($_tableName)<td @if($_tableName_percent) width="{{$_tableName_percent}}%" @endif class="center"> @lang('layout.TableName') </td>@endif
    @if($_row)<td @if($_row_percent) width="{{$_row_percent}}%" @endif class="center">@lang('layout.Total') @lang('layout.Record')</td>@endif
    @if($_size)<td @if($_size_percent) width="{{$_size_percent}}%" @endif class="center">{{ trans('backup.file_size') }}</td>@endif
</tr>
</thead>
<?php
$count = 0;
$total = 0;
?>

@foreach($data AS $record)
<?php
    $total += $record->size;
?>
<tr>
<td class="center">{{++$count}}</td>
@if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
@if($_tableName)<td class="center">{{$record->table}}</td>@endif
@if($_row)<td class="center">{{$record->row}}</td>@endif
@if($_size)<td class="center">{{$record->size}} KB</td>@endif
</tr>
@endforeach
</table>

<table class="main-table">
    <tr class="bg">
        <td class="center">@lang('layout.Total')</td>
        <td class="center"> {{myRound($total/1024)}} MB</td>
    </tr>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection

