@extends('layouts.app')
@section('style')
<link rel="stylesheet" href="{{url('/')}}/ltr/assets/global/css/components.min.css" type="text/css" media="all" />
<style>

.mt-element-ribbon .ribbon {
    float: {{(session()->get('system_direction') == 'ltr')? "left":"right"}};
}
</style>
@endsection

@section('content')

<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="fa fa-question font-dark"></i>
                <span class="caption-subject bold uppercase"></span>
            </div>

        </div>
        <div class="portlet-body">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-xs-12">
                    <div class="mt-element-ribbon bg-grey-steel">
                        <p class="ribbon-content" style="color: red">
                            <i class="fa fa-exclamation-triangle"></i> @lang('message.SystemUpdateMsg')
                        </p>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-6 col-md-6 col-xs-12">
                    <div class="mt-element-ribbon bg-grey-steel">
                        <div class="ribbon ribbon-color-default uppercase">@lang('layout.Backup')</div>
                        <p class="ribbon-content">
                            <center><form action="{{ route('backup.store') }}" method="post" id="data_backup">
                                {{ csrf_field() }}
                                    <input type="hidden" name="file_name" class="form-control" placeholder="{{ date('Y-m-d_Hi') }}" value="BeforUpdate{{date('Y-m-d_Hi')}}">
                                    
                                <div class="form-group">
                                    <input type="submit" value="{{ trans('backup.create') }}" class="btn btn-success">
                                </div>
                            </form></center>
                            <hr>
                            <table class="table" style="font-size: 14px; color: #777777;">
                                <thead>
                                    <th>{{ trans('backup.file_name') }}</th>
                                    <th>{{ trans('backup.file_size') }}</th>
                                    <th>{{ trans('backup.created_at') }}</th>
                                    <th class="text-center">{{ trans('backup.download') }}</th>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>{{ $last_backup->getFilename() }}</td>
                                        <td>{{ formatSizeUnits($last_backup->getSize()) }}</td>
                                        <td>{{ convertDate(date('Y-m-d H:i:s', $last_backup->getMTime())) }}</td>
                                        <td class="text-center">
                                            <a href="{{ route('backup.download', [$last_backup->getFilename()]) }}"
                                                id="download_{{ str_replace('.gz', '', $last_backup->getFilename()) }}"
                                                class="btn btn-info btn-xs"
                                                title="{{ trans('backup.download') }}"><i class="fa fa-download"></i></a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </p>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-xs-12">
                    <div class="mt-element-ribbon bg-grey-steel">
                        <div class="ribbon ribbon-color-default uppercase">@lang('menu.FileBackups')</div>
                        <p class="ribbon-content">
                            <center><form action="{{route('backupmanager_create')}}" method="post" id="file_backup">
                                {{ csrf_field() }}
                                <div class="form-group">
                                    <input type="submit" value="{{ trans('backup.create') }}" class="btn btn-success">
                                </div>
                            </form></center>
                            <hr>
                            <table class="table table-bordered table-hover" style="font-size: 14px;">
                                <thead>
                                <tr>
                                    <th>{{ trans('backup.file_name') }}</th>
                                    <th>{{ trans('backup.file_size') }}</th>
                                    <th>{{ trans('backup.created_at') }}</th>
                                    <th class="text-center">{{ trans('backup.download') }}</th>
                                </tr>
                                </thead>
                    
                                <tbody>
                                    <tr>
                                        <td>{{$last__file_backup['name']}}</td>
                                        <td>{{$last__file_backup['size']}}</td>
                                        <td>{{ convertDate($last__file_backup['date'])}}</td>
                                        <td style="text-align: center;">
                                            <a href="{{ route('backupmanager_download', [$last__file_backup['name']])  }}">
                                                <i class="fa fa-download btn btn-primary"></i>
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



@endsection

@push('scripts')


<script>
    new Vue({
        el:"#auto_backups_update",
        data:{
            last_bk:'',
            days:null
        },
        mounted(){
            let v = this;
            console.log("Data is come")
        //    var data_dk =  document.getElementById("data_backup").submit()
        //    console.log('ddd',data_dk)
            // document.getElementById("file_backup").submit()
            // axios.get("{{route('backup.index')}}")
            //     .then(function (response){
            //     })     
        }
    })

</script>
@endpush