
@extends('layouts.app')
@section('style')
<style type="text/css">
    .setting_menu li.active a,
    .ver-inline-menu li.active i {
        background-color: #d4d7dc !important;
        color: #393a3d !important;
    }
    .ver-inline-menu li a {
        background: #eceef1 !important;
        border-left: solid 2px #eceef1;
        color: #393a3d !important;
    }
    .ver-inline-menu li i {
        background: #eceef1 !important;
    }
    .t_head {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
    .t_body {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
</style>
@stop
@section('content')
 
<div class="portlet light ">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class="icon-equalizer font-green-haze"></i>&nbsp;
            <span class="caption-subject font-green-haze bold uppercase">@lang('menu.Settings')</span>
        </div>

    </div>
    <div class="portlet-body form">
        <div class="row" id="system_setting">
            <div class="profile">
                <div class="tabbable-line tabbable-full-width">
                    <ul class="nav nav-tabs"> 
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab_1_6">
                            <div class="row">
                                <div class="col-lg-2 col-md-2 col-sm-12 col-md-12">
                                    <ul class="ver-inline-menu tabbable margin-bottom-10 setting_menu">
                                        <li class="active">
                                            <a data-toggle="tab" href="#tab_6" aria-expanded="true">
                                                <i class="fa fa-cog" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.System') </a>
                                        </li>
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_1" aria-expanded="true">
                                                <i class="fa fa-group" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Members') </a>
                                        </li>
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_2" aria-expanded="true">
                                                <i class="fa fa-home" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Dashboard')</a>
                                        </li>
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_3" aria-expanded="true">
                                                <i class="icon-briefcase" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Account') </a>
                                        </li>
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_4" aria-expanded="true">
                                                <i class="fa fa-credit-card" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.ReceiveAndPayment') </a>
                                        </li>
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_5" aria-expanded="true">
                                                <i class="fa fa-industry" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.BuildSetting') </a>
                                        </li>
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_7" aria-expanded="true">
                                                <i class="fa fa-database" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.Inventory') </a>
                                        </li>
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_8" aria-expanded="true">
                                                <i class="fa fa-building-o" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.TransportCompany') </a>
                                        </li>
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_9" aria-expanded="true">
                                                <i class="icon-basket" style="color: #393a3d;font-size: 18px;"></i> @lang('layout.SaleAndPurchase') </a>
                                        </li>
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_10" aria-expanded="true">
                                                <i class="fa fa-file-code-o" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Report') </a>
                                        </li>
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_11" aria-expanded="true">
                                                <i class="fa fa-history" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Backups') </a>
                                        </li>
                                        @if(systemConfig()[5] != 0 )
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_12" aria-expanded="true">
                                                <i class="fa fa-tasks" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Project') </a>
                                        </li>
                                        @endif
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_13" aria-expanded="true">
                                            <i class="fa fa-bars " style="color: #393a3d;font-size: 18px;"></i> @lang('menu.MainMenu') </a>
                                        </li>
                                        @if(systemConfig()[20] == 1)
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_14" aria-expanded="true">
                                                <i class="fa fa-briefcase" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Contract') </a>
                                        </li>
                                        @endif
                                        <li class="">
                                            <a data-toggle="tab" href="#tab_15" aria-expanded="true">
                                                <i class="fa fa-briefcase" style="color: #393a3d;font-size: 18px;"></i> @lang('menu.Expenses') </a>
                                        </li>
                                    </ul>
                                </div>
                                
                                <div class="col-lg-10 col-md-10 col-sm-12 col-md-12">
                                    <div class="tab-content">
                                        <!----------------------------------------------------------------------------
                                            | BEGIN Members
                                            |---------------------------------------------------------------------------->
                                        <div id="tab_1" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle"data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('layout.Members') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CustomerStatement')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.customer_statement">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CustomerStatementType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.customer_statement_type">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="currency">@lang('layout.Currency')</option>
                                                                                <option value="base_currency">@lang('layout.BaseCurrency')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.FilterMemberStatment')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.member_statement_filter">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="0">0</option>
                                                                                <option value="1">1</option>
                                                                                <option value="2">2</option>
                                                                                <option value="3">3</option>
                                                                                <option value="4">4</option>
                                                                                <option value="5">5</option>
                                                                                <option value="6">6</option>
                                                                                <option value="7">7</option>
                                                                                <option value="8">8</option>
                                                                                <option value="9">9</option>
                                                                                <option value="10">10</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.DisableMember')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.disable_member">
                                                                                <option value="">@lang('layout.Default') (@lang('layout.PerCurrency'))</option>
                                                                                <option value="check_base_currency_balance">@lang('layout.CheckBaseCurrencyBalance')</option>
                                                                                <option value="without_balance_check">@lang('layout.WithoutBalanceCheck')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.MemberClassInMemberList')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.member_class_customer_list">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Item') @lang('layout.WithStatment')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.itemWithStatment">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ContractSalary')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.contract_salary">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.LastMemberStatementDates')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.lastMemberStatementDates">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('menu.AttendanceSheet') @lang('layout.Shifty')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.attendanceSheetShifty">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.AbsentOutOfTime')</option>
                                                                                <option value="false">@lang('layout.PresentOutOfTime')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.OvertimeAndDelayByBasicSalary')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.overtime_delay_Salary">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <!----------------------------------------------------------------------------
                                        | End Members
                                        |---------------------------------------------------------------------------->
                                        <!----------------------------------------------------------------------------
                                        | BEGIN Dashboard
                                        |---------------------------------------------------------------------------->
                                        <div id="tab_2" class="tab-pane" sty>
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('menu.Dashboard') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SalesCharts')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sales_chart">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option> 
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaleAreaChart')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_area_chart">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>    
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AccountsCharts')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.account_chart">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.TotalBalances')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.total_balance">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                        @lang('layout.Summary') @lang('layout.Daily')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.summaryDaily">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div> 
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SummaryTotal')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.summaryTotal">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div> 
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.BankBalances')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.bank_balance">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.InventoryCharts')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.inventory_chart">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('menu.CompanyProfile')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_profile">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CompanyNameFont')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_name_size_dashboard">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="30">30px</option>
                                                                                <option value="40">40px</option>
                                                                                <option value="50">50px</option>
                                                                                <option value="60">60px</option>
                                                                                <option value="70">70px</option>
                                                                                <option value="80">80px</option>
                                                                                <option value="90">90px</option>
                                                                                <option value="100">100px</option>
                                                                                <option value="120">120px</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>


                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CompanyLogoBorderRadius')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_logo_border_radius">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <!-- <option value="0">0%</option> -->
                                                                                <option value="5">5%</option>
                                                                                <option value="10">10%</option>
                                                                                <option value="20">20%</option>
                                                                                <option value="30">30%</option>
                                                                                <option value="40">40%</option>
                                                                                <option value="50">50%</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CompanyNameColor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_name_color_dashboard">
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CompanyProfileBgColor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_profile_bgcolor_dashboard">
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                        <!----------------------------------------------------------------------------
                                        | End Dashboard
                                        |---------------------------------------------------------------------------->

                                        <!----------------------------------------------------------------------------
                                        | BEGIN Accont
                                        |---------------------------------------------------------------------------->


                                        <div id="tab_3" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('layout.Account') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.BankAccountNumber')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.bank_number">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AccountNumber')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.account_number">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AddAmountInTransferRemark')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.add_amount_in_remark">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowSubAccount')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_sub_account">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AccountTransaction')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.account_transaction">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="dr_cr">@lang('layout.DrCr')</option>
                                                                                <option value="in_out">@lang('layout.InOut')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('menu.FinancialClass')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.financial_class">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SelectNumberByFinancialClass')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.numberByFinancialClass">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Unit') @lang('layout.Show') @lang('layout.OnHand')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.unit_show_onhand">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option v-for="m in measures" :value="m.value">@{{m.text}}</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.RvAndPvType') @lang('menu.Transactions')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.exchange_voucher_type">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="1">@lang('layout.Voucher')1</option>
                                                                                <option value="CustomePayment">@lang('layout.CustomePayment')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AverageRate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.averageRate">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ExpenseAccountFilter')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.expenseAccountFilter">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CurrencyType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.CurrencyType">
                                                                                <option value="code" >@lang('layout.Code')</option>
                                                                                <option value="symbol">@lang('layout.Symbol')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                        <!----------------------------------------------------------------------------
                                        | End Account
                                        |---------------------------------------------------------------------------->


                                        <!----------------------------------------------------------------------------
                                        | BEGIN Receive And Payment
                                        |---------------------------------------------------------------------------->


                                        <div id="tab_4" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('layout.ReceiveAndPayment') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.RvAndPvType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.voucher_type">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="1">@lang('layout.Voucher')1</option>
                                                                                <option value="2">@lang('layout.Voucher')2</option>
                                                                                <option value="3">@lang('layout.Voucher')3</option>
                                                                                <option value="4">@lang('layout.Voucher')4</option>
                                                                                <option value="5">@lang('layout.Voucher')5</option>
                                                                                <option value="6">@lang('layout.Voucher')6</option>
                                                                                <option value="customePayment">@lang('layout.CustomePayment')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Commission')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.commission">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.RAndPSystemDescription')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.r_p_system_des">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.VoucherPaperStyle')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.voucher_paper_style">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="landscape">Landscape</option>
                                                                                <option value="portrait">Portrait</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div> 
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.VoucherPaperType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.voucher_paper_type">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="A4">A4</option>
                                                                                <option value="A5">A5</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CopyNumberOfVoucher')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.copy_number_of_factor_receive">
                                                                                <option value="1">@lang('layout.Select')</option>
                                                                                <option value="2">2</option>
                                                                                <option value="3">3</option>
                                                                                <option value="4">4</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>


                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>


                                        <!----------------------------------------------------------------------------
                                        | End Receive And Payment
                                        |---------------------------------------------------------------------------->



                                        <!----------------------------------------------------------------------------
                                        | BEGIN Build
                                        |---------------------------------------------------------------------------->


                                        <div id="tab_5" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('layout.BuildSetting') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.BuildExpense')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.build_expense">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.BuildExpenseAccount')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.build_expense_account">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="OtherCurrentAsset">@lang('layout.OtherCurrentAsset') -- @lang('layout.Recommended')</option>
                                                                                <option value="CostOfGoodSold">@lang('layout.CostOfGoodSold')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.BuildColor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.build_color">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.RefNoByFormula')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.ref_no_by_formula">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CubicMetereItems')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.cubicMetereItems">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <!----------------------------------------------------------------------------
                                        | End Build
                                        |---------------------------------------------------------------------------->
                                        <!----------------------------------------------------------------------------
                                        | BEGIN  System Setting
                                        |---------------------------------------------------------------------------->
                                        <div id="tab_6" class="tab-pane active">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('layout.System') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head" style="display: flex; justify-content: space-between;">@lang('layout.Font') <i class="fa fa-info-circle text-primary popovers" data-container="body" data-trigger="hover" data-placement="top" data-content="@lang('help.FontHelp')" data-original-title="@lang('layout.Font')" style="font-size: 1.1em;"></i></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.font">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="aril">@lang('layout.Aaril')</option> 
                                                                                <option value="bzar" selected>@lang('layout.BZar')</option>
                                                                                <option value="bnazanin">@lang('layout.BNazanin')</option>
                                                                                <option value="Btitr">@lang('layout.Btitr')</option>
                                                                                <option value="BBaran">@lang('layout.BBaran')</option>
                                                                                <option value="BKoodakO">@lang('layout.Kodak')</option>
                                                                                <option value="BKoodakBd">@lang('layout.KodakBold')</option>
                                                                                <option value="IranNastaliq">@lang('layout.Nastaliq')</option>
                                                                                <option value="XBNiloofarBd">@lang('layout.XBNiloofarBd')</option>
                                                                                <option value="majalla">@lang('layout.Majalla')</option>
                                                                                <option value="majallab">@lang('layout.Majallab')</option>
                                                                                <option value="IRANSansWeb">@lang('layout.SansWeb')</option>
                                                                                <option value="Vazir">@lang('layout.Vazir')</option>
                                                                                <option value="Yekan">@lang('layout.Yekan')</option>
                                                                                <option value="Tanha">@lang('layout.Tanha')</option>
                                                                                <option value="Shabnam">@lang('layout.Shabnam')</option>
                                                                                <option value="ShabnamBold">@lang('layout.ShabnamBold')</option>
                                                                                <option value="ShabnamLight">@lang('layout.ShabnamLight')</option>
                                                                                <option value="Samim">@lang('layout.Samim')</option>
                                                                                <option value="SamimBold">@lang('layout.SamimBold')</option>
                                                                                <option value="Sahel">@lang('layout.Sahel')</option>
                                                                                <option value="SahelBold">@lang('layout.SahelBold')</option>
                                                                                <option value="SahelBlack">@lang('layout.SahelBlack')</option>
                                                                                <option value="Parastoo">@lang('layout.Parastoo')</option>
                                                                                <option value="ParastooBold">@lang('layout.ParastooBold')</option>
                                                                                <option value="TimesNewRoman">@lang('layout.TimesNewRoman')</option>
                                                                                <option value="TimesNewRomanBold">@lang('layout.TimesNewRomanBold')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head" style="display: flex; justify-content: space-between;">@lang('layout.FontSize') <i class="fa fa-info-circle text-primary popovers" data-container="body" data-trigger="hover" data-placement="top" data-content="@lang('help.FontSize')" data-original-title="@lang('layout.FontSize')" style="font-size: 1.1em;"></i></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.font_size">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="10">10</option>
                                                                                <option value="11">11</option>
                                                                                <option value="12">12</option>
                                                                                <option value="13">13</option>
                                                                                <option value="14">14</option>
                                                                                <option value="15">15</option>
                                                                                <option value="16">16</option>
                                                                                <option value="17">17</option>
                                                                                <option value="18">18</option>
                                                                                <option value="19">19</option>
                                                                                <option value="20">20</option>
                                                                                <option value="21">21</option>
                                                                                <option value="22">22</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head" style="display: flex; justify-content: space-between;">@lang('layout.DateType') <i class="fa fa-info-circle text-primary popovers" data-container="body" data-trigger="hover" data-placement="top" data-content="@lang('help.DateType')" data-original-title="@lang('layout.DateType')" style="font-size: 1.1em;"></i></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.date_type">
                                                                                <option value="jalali">@lang('layout.Jalali')</option>
                                                                                <option value="gregorian">@lang('layout.Gregorian')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head" style="display: flex; justify-content: space-between;">@lang('layout.DateFomrat') <i class="fa fa-info-circle text-primary popovers" data-container="body" data-trigger="hover" data-placement="top" data-content="@lang('help.DateFomrat')" data-original-title="@lang('layout.DateFomrat')" style="font-size: 1.1em;"></i></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.date_format">
                                                                                <option value="1">@lang('layout.SelectFormat')</option>
                                                                                <option value="ddd mmm dd yyyy HH:MM:ss">ddd mmm dd yyyy HH:MM:ss</option>
                                                                                <option value="ddd mmm dd yyyy HH:MM">ddd mmm dd yyyy HH:MM</option>
                                                                                <option value="dddd, mmmm d, yyyy">dddd, mmmm d, yyyy</option>
                                                                                <option value="mmmm d, yyyy">mmmm d, yyyy</option>
                                                                                <option value="mmm d, yyyy">mmm d, yyyy</option>
                                                                                <option value="yyyy-mm-dd">yyyy-mm-dd</option>
                                                                                <option value="dd-mmm-yy">dd-mmm-yy</option>
                                                                                <option value="dd-mmm-yyyy">dd-mmm-yyyy</option>
                                                                                <option value="mmm-dd-yy">mmm-dd-yy</option>
                                                                                <option value="mmm-dd-yyyy">mmm-dd-yyyy</option>
                                                                                <option value="m/d/yy">m/d/yy</option>
                                                                                <option value="m/d/yyyy">m/d/yyyy</option>
                                                                                <option value="dd/mm/yy">dd/mm/yy</option>
                                                                                <option value="dd/mm/yyyy">dd/mm/yyyy</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">@lang('layout.ThemeColor')</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.theme_color">
                                                                                <option value="">@lang('layout.SelectColor')</option>
                                                                                <option value="newTheme">@lang('layout.Default')</option>
                                                                                <option value="default">@lang('layout.DarkGray')</option> 
                                                                                <option value="blue">@lang('layout.Blue')</option>
                                                                                <option value="darkblue">@lang('layout.DarkBlue')</option>
                                                                                <option value="grey">@lang('layout.Grey')</option>
                                                                                <option value="light">@lang('layout.Light')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">@lang('layout.SidebarType')</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sidebar_type">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="collapse">@lang('layout.Collapse')</option>
                                                                                <option value="no_collapse">@lang('layout.NoCollapse')</option>
                                                                                <option value="hover_submenu">@lang('layout.HoverSubmenu')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">@lang('layout.BalanceSheet')</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.balance_sheet_style">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="first_style">@lang('layout.Style')1</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">@lang('layout.NumberPrecision')</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.number_precision">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="0">@lang('layout.WithoutPrecision')</option>
                                                                                <option value="1">1</option>
                                                                                <option value="2">2</option>
                                                                                <option value="3">3</option>
                                                                                <option value="4">4</option>
                                                                                <option value="5">5</option>
                                                                                <option value="6">6</option>
                                                                                <option value="7">7</option>
                                                                                <option value="8">8</option>
                                                                                <option value="9">9</option>
                                                                                <option value="10">10</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ReportOrder')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.report_order_column">
                                                                                <option value="sort_date">@lang('layout.Select')</option>
                                                                                <option value="sort_date">@lang('layout.Date')</option>
                                                                                <option value="name">@lang('layout.Name')</option>
                                                                                <option value="number">@lang('layout.Number')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ReportOrderType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.report_order">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="asc">@lang('layout.ASC')</option>
                                                                                <option value="desc">@lang('layout.DESC')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.PageRows')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.page_rows">
                                                                                <option value="default">@lang('layout.Default')</option>

                                                                                <option value="25">25</option>
                                                                                <option value="50">50</option>
                                                                                <option value="100">100</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.RowOrder')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.row_order">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="asc">@lang('layout.ASC')</option>
                                                                                <option value="desc">@lang('layout.DESC')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.LoadPageAlert')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.load_page_alert">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.NegativeBank')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.negative_bank">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.OrderByColumn')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.order_by_column">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="date">@lang('layout.Date') @lang('layout.OR') @lang('layout.Name')</option>
                                                                                <option value="number">@lang('layout.Number')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowAlerts')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_alert">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.InputBgColor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.input_bg_color">
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.InputBorder')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.input_border">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="1">1</option>
                                                                                <option value="2">2</option>
                                                                                <option value="3">3</option>
                                                                                <option value="4">4</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.NumberSeparator')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.number_separator">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value=",">,</option>
                                                                                <option value="/">/</option>
                                                                                <option value="-">-</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Whatsapp')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.whats_app">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.WhatsappType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.whats_app_type">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="direct">@lang('layout.DirectSend')</option>
                                                                                <option value="share">@lang('layout.Share')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.PaginationPagingType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.pagination_paging_type">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="simple">@lang('layout.Simple')</option>
                                                                                <option value="simple_numbers">@lang('layout.SimpleNumbers')</option>
                                                                                <option value="full">@lang('layout.Full')</option>
                                                                                <option value="full_numbers">@lang('layout.FullNumbers')</option>
                                                                                <option value="numbers">@lang('layout.Numbers')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ResponsiveDataTable')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.responsive_data_table">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaveTempData')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.save_temp_data">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.GoogleTranslate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.google_translate">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">@lang('layout.HourType')</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.hour_type">
                                                                                <option value="12">12</option>
                                                                                <option value="24">24</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">@lang('layout.GeneralSearch')</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.generalSearch">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.Simple')</option>
                                                                                <option value="false">@lang('layout.Details')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Fingerprint')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.fingerprint">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Telegram')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.telegram_bot">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.TelegramKeyboard')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.telegram_bot_keyboard">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.TelegramVoucherType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.telegram_voucher_type">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="1">@lang('layout.Voucher')1</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.OnlineUsers')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.online_users">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>


                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.LoginAsUserName')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.login_user_name">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div> 

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.UserSignature')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.user_signature">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>


                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowUserSignatureBelowFactor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.user_signature_below_factor">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.checkProjectServices')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.check_project_services">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.RequiredDate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.date_is_required">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.DescriptionWithNote')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.des_with_note">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CargoFactorType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.cargoFactorType">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="1">@lang('layout.Invoice')1</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <!-- <div class="table-scrollable">
                                                                    <div class="col-md-12">

                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.Font')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.font">
                                                                                    <option value="default">@lang('layout.Default')</option>
                                                                                    <option value="aril">@lang('layout.Aaril')</option>
                                                                                    <option value="bzar" selected>@lang('layout.BZar')</option>
                                                                                    <option value="bnazanin">@lang('layout.BNazanin')</option>
                                                                                    <option value="Btitr">@lang('layout.Btitr')</option>
                                                                                    <option value="BBaran">@lang('layout.BBaran')</option>
                                                                                    <option value="BKoodakO">@lang('layout.Kodak')</option>
                                                                                    <option value="BKoodakBd">@lang('layout.KodakBold')</option>
                                                                                    <option value="IranNastaliq">@lang('layout.Nastaliq')</option>
                                                                                    <option value="XBNiloofarBd">@lang('layout.XBNiloofarBd')</option>
                                                                                    <option value="majalla">@lang('layout.Majalla')</option>
                                                                                    <option value="majallab">@lang('layout.Majallab')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.FontSize')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.font_size">
                                                                                    <option value="default">@lang('layout.Default')</option>
                                                                                    <option value="10">10</option>
                                                                                    <option value="11">11</option>
                                                                                    <option value="12">12</option>
                                                                                    <option value="13">13</option>
                                                                                    <option value="14">14</option>
                                                                                    <option value="15">15</option>
                                                                                    <option value="16">16</option>
                                                                                    <option value="17">17</option>
                                                                                    <option value="18">18</option>
                                                                                    <option value="19">19</option>
                                                                                    <option value="20">20</option>
                                                                                    <option value="21">21</option>
                                                                                    <option value="22">22</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.DateType')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.date_type">
                                                                                    <option value="jalali">@lang('layout.Jalali')</option>
                                                                                    <option value="gregorian">@lang('layout.Gregorian')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.DateFomrat')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.date_format">
                                                                                    <option value="1">@lang('layout.SelectFormat')</option>
                                                                                    <option value="ddd mmm dd yyyy HH:MM:ss">ddd mmm dd yyyy HH:MM:ss</option>
                                                                                    <option value="ddd mmm dd yyyy HH:MM">ddd mmm dd yyyy HH:MM</option>
                                                                                    <option value="dddd, mmmm d, yyyy">dddd, mmmm d, yyyy</option>
                                                                                    <option value="mmmm d, yyyy">mmmm d, yyyy</option>
                                                                                    <option value="mmm d, yyyy">mmm d, yyyy</option>
                                                                                    <option value="yyyy-mm-dd">yyyy-mm-dd</option>
                                                                                    <option value="dd-mmm-yy">dd-mmm-yy</option>
                                                                                    <option value="dd-mmm-yyyy">dd-mmm-yyyy</option>
                                                                                    <option value="mmm-dd-yy">mmm-dd-yy</option>
                                                                                    <option value="mmm-dd-yyyy">mmm-dd-yyyy</option>
                                                                                    <option value="m/d/yy">m/d/yy</option>
                                                                                    <option value="m/d/yyyy">m/d/yyyy</option>
                                                                                    <option value="dd/mm/yy">dd/mm/yy</option>
                                                                                    <option value="dd/mm/yyyy">dd/mm/yyyy</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>



                                                                    </div>

                                                                    <div class="col-md-12">
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.ThemeColor')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.theme_color">
                                                                                    <option value="">@lang('layout.SelectColor')</option>
                                                                                    <option value="default">@lang('layout.Default')</option>
                                                                                    <option value="blue">@lang('layout.Blue')</option>
                                                                                    <option value="darkblue">@lang('layout.DarkBlue')</option>
                                                                                    <option value="grey">@lang('layout.Grey')</option>
                                                                                    <option value="light">@lang('layout.Light')</option>
                                                                                    <option value="newTheme">@lang('layout.BrightGray')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.SidebarType')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sidebar_type">
                                                                                    <option value="">@lang('layout.SelectFormat')</option>
                                                                                    <option value="collapse">@lang('layout.Collapse')</option>
                                                                                    <option value="no_collapse">@lang('layout.NoCollapse')</option>
                                                                                    <option value="hover_submenu">@lang('layout.HoverSubmenu')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('menu.BalanceSheet')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.balance_sheet_style">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="default">@lang('layout.Default')</option>
                                                                                    <option value="first_style">@lang('layout.Style')1</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.NumberPrecision')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.number_precision">
                                                                                    <option value="">@lang('layout.SelectFormat')</option>
                                                                                    <option value="0">@lang('layout.WithoutPrecision')</option>
                                                                                    <option value="1">1</option>
                                                                                    <option value="2">2</option>
                                                                                    <option value="3">3</option>
                                                                                    <option value="4">4</option>
                                                                                    <option value="5">5</option>
                                                                                    <option value="6">6</option>
                                                                                    <option value="7">7</option>
                                                                                    <option value="8">8</option>
                                                                                    <option value="9">9</option>
                                                                                    <option value="10">10</option>

                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-12">
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.ReportOrder')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.report_order_column">
                                                                                    <option value="sort_date">@lang('layout.Select')</option>
                                                                                    <option value="sort_date">@lang('layout.Date')</option>
                                                                                    <option value="name">@lang('layout.Name')</option>
                                                                                    <option value="number">@lang('layout.Number')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.ReportOrderType')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.report_order">
                                                                                    <option value="">@lang('layout.SelectFormat')</option>
                                                                                    <option value="asc">@lang('layout.ASC')</option>
                                                                                    <option value="desc">@lang('layout.DESC')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.PageRows')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.page_rows">
                                                                                    <option value="default">@lang('layout.Default')</option>

                                                                                    <option value="25">25</option>
                                                                                    <option value="50">50</option>
                                                                                    <option value="100">100</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.RowOrder')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.row_order">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="asc">@lang('layout.ASC')</option>
                                                                                    <option value="desc">@lang('layout.DESC')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>

                                                                    </div>
                                                                    <div class="col-md-12">
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.LoadPageAlert')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.load_page_alert">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.NegativeBank')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.negative_bank">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.OrderByColumn')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.order_by_column">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="date">@lang('layout.Date') @lang('layout.OR') @lang('layout.Name')</option>
                                                                                    <option value="number">@lang('layout.Number')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.ShowAlerts')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_alert">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>





                                                                    </div>

                                                                    <div class="col-md-12">


                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.InputBgColor')</label>
                                                                                <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.input_bg_color">
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.InputBorder')</label>

                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.input_border">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="1">1</option>
                                                                                    <option value="2">2</option>
                                                                                    <option value="3">3</option>
                                                                                    <option value="4">4</option>
                                                                                </select>



                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.NumberSeparator')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.number_separator">
                                                                                    <option value="">@lang('layout.SelectFormat')</option>
                                                                                    <option value=",">,</option>
                                                                                    <option value="/">/</option>
                                                                                    <option value="-">-</option>

                                                                                </select>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.Whatsapp')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.whats_app">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>


                                                                    </div>

                                                                    <div class="col-md-12">
                                                                        
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.PaginationPagingType')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.pagination_paging_type">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="simple">@lang('layout.Simple')</option>
                                                                                    <option value="simple_numbers">@lang('layout.SimpleNumbers')</option>
                                                                                    <option value="full">@lang('layout.Full')</option>
                                                                                    <option value="full_numbers">@lang('layout.FullNumbers')</option>
                                                                                    <option value="numbers">@lang('layout.Numbers')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.ResponsiveDataTable')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.responsive_data_table">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>

                                                                    </div>

                                                                </div> -->
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <!----------------------------------------------------------------------------
                                        | End System Setting
                                        |---------------------------------------------------------------------------->
                                        <!----------------------------------------------------------------------------
                                        | BEGIN  Inventory
                                        |---------------------------------------------------------------------------->
                                        <div id="tab_7" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('layout.Inventory') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Gauge')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.gauge">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SerialNum')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.serial_number">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Unit')2
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.inventory_measure2">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option v-for="m in measures" :value="m.value">@{{m.text}}</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Unit')3
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.inventory_measure3">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option v-for="m in measures" :value="m.value">@{{m.text}}</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Unit')4
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.inventory_measure4">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option v-for="m in measures" :value="m.value">@{{m.text}}</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.TransactionTypeShow')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.transaction_exchange">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="original">@lang('layout.OriginalTransaction')</option>
                                                                                <option value="exchange">@lang('layout.ExchangedTransaction')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.StockInfo')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.stock_info">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowTransferReport')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_transfer_report">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ItemPicture')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.item_picture">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.InvetoryPercent')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invetory_percent">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Brand')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.item_brand">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Category')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.item_category">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ItemType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.item_type">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.OnSaleOrder')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.item_on_sale_order">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SubMeasure')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sub_measure">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowPurchaseRate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_purchase_rate">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowSaleRate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_sale_rate">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AddItemWithZeroRate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.add_item_with_zero_rate">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Show') @lang('layout.Wing')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_wing">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AddExpenseAfterSale')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.Add_Expense_After_Sale">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.MakeCartan')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.Show_Make_Cartan">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Show') @lang('layout.SuperceedNo')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_superceedNo">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ImportEngineNumberByExcel')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.import_engine_number_byExcel">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Show') @lang('layout.Location')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_location">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Show') @lang('layout.ZeroOnHand')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_zero_onHand">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.LoadDropOnToCostOfGoodSoldAccount')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.loadDropOnToCostOfGoodSold">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.RemainQuantity')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.showRemainQuantity">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ExpireDateAlert')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.expire_date_alert">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="10">10 @lang('layout.Day')</option>
                                                                                <option value="30">1 @lang('layout.Month')</option>
                                                                                <option value="60">2 @lang('layout.Month')</option>
                                                                                <option value="120">4 @lang('layout.Month')</option>
                                                                                <option value="180">6 @lang('layout.Month')</option>
                                                                                <option value="360">12 @lang('layout.Month')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Times') @lang('layout.SerialNum')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.serial_number_times">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="1">1</option>
                                                                                <option value="2">2</option>
                                                                                <option value="3">3</option>
                                                                                <option value="4">4</option>
                                                                                <option value="5">5</option>
                                                                                <option value="6">6</option>
                                                                                <option value="7">7</option>
                                                                                <option value="8">8</option>
                                                                                <option value="9">9</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.InventoryTransferVoucher') 
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.inventory_transfer_voucher">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="1">@lang('layout.Voucher')1</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CalculateQuantityOfOtherMeasureWithoutRelation') 
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.calQuantityOfOtherMeasure">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="totalMethod">@lang('layout.TotalInItem')</option>
                                                                                <option value="avgMethod">@lang('layout.AutoSelectByAverageInQuantity')</option>
                                                                                <option value="simpleMethod">@lang('layout.SimpleMethod')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Show') @lang('layout.CBM')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_cbm">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                        </div>

                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <!----------------------------------------------------------------------------
                                        | End Inventory
                                        |---------------------------------------------------------------------------->
                                        <!----------------------------------------------------------------------------
                                        | BEGIN  TransportCompany
                                        |---------------------------------------------------------------------------->
                                        <div id="tab_8" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('menu.TransportCompany') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('menu.TransportCompany')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.transport_company">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.TransportCompanyInGrn')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.transport_company_in_grn">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.TransportCompanyFactor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.transport_company_factor">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <!-- <div class="table-scrollable">
                                                                    <div class="col-md-12">
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('menu.TransportCompany')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.transport_company">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>

                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.TransportCompanyInGrn')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.transport_company_in_grn">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.TransportCompanyFactor')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.transport_company_factor">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div> -->
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <!----------------------------------------------------------------------------
                                        | End TransportCompany
                                        |---------------------------------------------------------------------------->
                                        <!----------------------------------------------------------------------------
                                        | BEGIN  SaleAndPurchase
                                        |---------------------------------------------------------------------------->
                                        <div id="tab_9" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('layout.SaleAndPurchase') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('menu.ItemRateForCustomer')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.cost_for_customer">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.DefaultSite')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.default_site">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option v-for="s in sites" :value="s.value">@{{s.text}}</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('menu.SalePriceCalculation')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_price_calculate">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="customer">@lang('layout.ByCustomer')</option>
                                                                                <option value="advance_pricing">@lang('layout.ByAdvancePricing')</option>
                                                                                <option value="last_sale_price">@lang('layout.LastSalePrice')</option>
                                                                                <option value="price_level">@lang('menu.PriceLevel')</option>
                                                                                <option value="last_sale_price_customer">@lang('layout.LastSalePrice') @lang('layout.Customer')</option>
                                                                                <option value="static_item_price">@lang('menu.StaticItemPrice')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaleArea')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_area">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.InvoicTotal')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_total">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CustomerClass')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.member_class">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Description')1
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_description">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Description')2
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_description2">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.DriverInfo')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.driver_info">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.PerItemDiscount')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_discount">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Category')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_category">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ExpireDate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.expire_date">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.OtherMeasureWithoutRelations')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.other_measure">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.OtherMeasureWithoutRelations')2
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.other_measure2">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.FactorOtherMeasure')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_other_measure">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SearchResultNumber')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.search_result">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="10">10</option>
                                                                                <option value="15">15</option>
                                                                                <option value="20">20</option>
                                                                                <option value="50">50</option>
                                                                                <option value="100">100</option>
                                                                                <option value="500">500</option>
                                                                                <option value="1000">1000</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ItemOtherName')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.item_other_name">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CustomerOtherMemberName')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.descriptionASMemberName">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CostType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.costType">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="averageCost">@lang('layout.AverageCost')</option>
                                                                                <option value="lastPurchaseCost">@lang('layout.LastPurchaseCost')</option>
                                                                                <option value="upperCost">@lang('layout.UpperCost')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.NegativeSale')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.negative_sale">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.InvoicePayment')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_payment">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.TotalWithCodes')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.total_with_code">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.OilSale')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.oil_sale">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ActiveStatusOilSale')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.active_status_oil_sale">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowCodeBrand')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_code_brand">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ItemBySite')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.item_by_site_in_sale">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.PrintDescription')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.print_description">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('menu.Taxation')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.taxation">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaleTaxation')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_taxation">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Commission')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_commission">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Commission') @lang('layout.Marketer')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.saleCommissionMarketer">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.PurchaseExpense')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.purchase_expense">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.MarginAndMarkup')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.margin_and_markup">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowDriverInPurchaseReport')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_driver_purchase_report">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaleSubMeasure')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_sub_measure">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowPriceLevel')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_price_level">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="general">@lang('layout.General')</option>
                                                                                <option value="per_item">@lang('layout.PerItem')</option>
                                                                                <option value="general_percent">@lang('layout.GeneralPercent')</option>
                                                                                <option value="general_percent_per_item"> @lang('layout.PerItem') @lang('layout.GeneralPercent') </option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Sub-Total')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sub_total">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ItemNumberWithName')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.item_number_with_name">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaleByOtherMeasure')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_by_other_measure">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SelectQuantityByOtherMeasure')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.selectQuantityByOtherMeasure">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SelectQuantityByOtherMeasureInPurchase')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.selectQuantityByOtherMeasureInPurchase">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaleAmountInSecondMeasure')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_amount_in_second_measure">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('menu.DiscountDate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_discount_date">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaleBaseCurrency')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_to_base_currency">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaleByOtherMeasureRate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sale_by_other_measure_Rate">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ChangeItem')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.change_item">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.PrintDifferentTypeOfFactor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.print_different_type_of_factor">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                        @lang('layout.BarcodeNumber') @lang('layout.In') @lang('layout.Factor') 
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.tab_index_in_item_name">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                        @lang('layout.Type') @lang('layout.BarcodeNumber')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.barcode_type">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="false">@lang('type.Simple')</option>
                                                                                <option value="true">@lang('type.Fast')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowLastSales')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.last_item_sale">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.DoNotGetDuplicateItem')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.not_duplicate_item">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AutoAdvancePricing')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.auto_advancePricing">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowCreate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_create_to_customer">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.QuantityByWing')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.quantityByWing">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaveTempItemToCustomer')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.save_temp_itemTo_customer">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.DiscountPerItemToCost')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.discountPerItemToCost">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ActiveSale')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.activeSale">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Factor') @lang('layout.Pending')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factorPending">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Show') @lang('layout.SelectedMeasure')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.showSelectedMeasure">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AutoSelectOtherMeasureQuantity')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.autoSelectOtherMeasureQuantity">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AutoSelectFactorNumber')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.autoSelectFactorNumber">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.VoucherOffering')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.voucher_offering">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.VoucharType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.voucher_offering_type">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="1">1</option>
                                                                                {{-- <option value="false">2</option> --}}
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Installments')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.Installments">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Weighbridge') - @lang('menu.LaboratoryTest')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.flour">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.NotDischargeBeforWeighbridgeAndLaboratory')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.notDischargeBeforWeighbridgeAndLaboratory">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.TransferRent')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.transfer_rent">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.DuplicateRefNo')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.duplicate_ref_no">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowRefundToSale')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.showRefundToSale">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AutoSelectCustomer')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.auto_select_customer">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AutoSelectDate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.auto_select_date">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowSalesToTheDetriment')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.sales_to_the_detriment">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SearchByCodeLocation')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.searchByCodeLocation">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CostByLocation')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.costByLocation">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaleMainItemInFactorCode')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.saleMainItemInFactorCode">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AverageCostByCode')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.averageCostByCode">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SearchByImage')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.search_by_image">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            {{-- These Codes are for Litter custom House............................................... --}}
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CustomHouseLitter')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.custom_house_litter">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            {{-- End of codes for litter custom House.....................................................--}}
                                                            {{-- copy number start  --}}
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CopyNumberOfCheque')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.copy_number_of_cheque">
                                                                                <option value="1">@lang('layout.Select')</option>
                                                                                <option value="1">1</option>
                                                                                <option value="2">2</option>
                                                                                <option value="4">4</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            {{-- copy number end  --}}
                                                            {{-- copy number start  --}}
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.SaleCodePricePercentage')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.saleCodePricePercentage">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            {{-- copy number end  --}}
                                                            {{-- copy number start  --}}
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowBallonQuantity')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_ballon_quantity">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>



                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CheckGift')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.check_gift">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>


                                                            {{-- copy number end  --}}
                                                            <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                                                <div class="col-md-12">
                                                                    <!----------------------------------------------------------------------------
                                                                            | BEGIN  Invoice
                                                                            |---------------------------------------------------------------------------->
                                                                    <!-- <div class="panel panel-default">        
                                                                            <div class="panel-body"> -->
                                                                    <h4>@lang('layout.Invoice')</h4>
                                                                    <br/>

                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">@lang('layout.Font')</td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_font">
                                                                                        <option value="xbriyaz" selected>@lang('layout.Default')</option>
                                                                                        <option value="aril">@lang('layout.Aaril')</option> 
                                                                                        <option value="majalla">@lang('layout.Majalla')</option>
                                                                                        <option value="majallab">@lang('layout.Majallab')</option>
                                                                                        <option value="xbriyaz">@lang('layout.Xbriyaz')</option>
                                                                                        <option value="lateef">@lang('layout.Latif')</option>
        
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.GRN')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.grn">
                                                                                        <option value="">@lang('layout.SelectFormat')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.GRNType')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.grn_type">
                                                                                        <option value="default">@lang('layout.Default')</option>
                                                                                        <option value="1">@lang('layout.GRN')</option>
                                                                                        <option value="2">@lang('layout.GRNSmallFactor')</option>
                                                                                        <option value="G1">@lang('layout.GRN')1</option>
                                                                                        <option value="G2">@lang('layout.GRN')2</option>
                                                                                        <option value="G3">@lang('layout.GRN')3</option>
                                                                                        <option value="G4">@lang('layout.GRN')4</option>
                                                                                        <option value="CustomeInvoice">@lang('layout.CustomeInvoice')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.AmountInLetter')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.grn_amount_in_letter">
                                                                                        <option value="">@lang('layout.SelectFormat')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.ItemImage')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.item_image">
                                                                                        <option value="">@lang('layout.SelectFormat')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.HesabSabiqa')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.hesab_sabeqa">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.HesabSabiqaSaleRecept')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.hesab_sabeqa_sale">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.HesabSabeqahType')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.hesab_sabeqah_type">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="currency">@lang('layout.Currency')</option>
                                                                                        <option value="base_currency">@lang('layout.BaseCurrency')</option>
                                                                                        <option value="all_currency">@lang('layout.AllCurrency')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.WhiteRows')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.white_rows">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.InvoiceDateFormat')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_date_format">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="shamsi">@lang('layout.ShamsiDate')</option>
                                                                                        <option value="meladi">@lang('layout.MeladiDate')</option>
                                                                                        <option value="both">@lang('layout.BothDate')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.InvoiceType')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_type">
                                                                                        <option value="default">@lang('layout.Default')</option>
                                                                                        <option value="default1">@lang('layout.Default')1</option>
                                                                                        <option value="otherMeasureBaseFactor">@lang('layout.OtherMeasureBase')</option>
                                                                                        <option value="4">@lang('layout.ThermalPrinterFactor')</option>
                                                                                        <option value="customeInvoice">@lang('layout.CustomeInvoice')</option>
                                                                                        @if(systemConfig()[13] != 0 )
                                                                                        <option value="tailoring">@lang('menu.Tailoring')</option>
                                                                                        @endif
                                                                                        @if(systemConfig()[27] != 0 )
                                                                                        <option value="oilFactor">@lang('layout.Invoice') @lang('layout.Oil')</option>
                                                                                        @endif
                                                                                        <option value="locationFactor">@lang('layout.Invoice') @lang('layout.Location')</option>
                                                                                        <option value="subMeasureFactor">@lang('layout.Invoice') @lang('layout.SubMeasure')</option>
                                                                                        <option value="1">@lang('layout.Invoice')1</option>
                                                                                        <option value="2">@lang('layout.Invoice')2</option>
                                                                                        <option value="3">@lang('layout.Invoice')3</option>
                                                                                        <option value="5">@lang('layout.Invoice')5</option>
                                                                                        <option value="6">@lang('layout.Invoice')6</option>
                                                                                        <option value="7">@lang('layout.Invoice')7</option>
                                                                                        <option value="8">@lang('layout.Invoice')8</option>
                                                                                        <option value="9">@lang('layout.Invoice')9</option>
                                                                                        <option value="10">@lang('layout.Invoice')10</option>
                                                                                        <option value="11">@lang('layout.Invoice')11</option>
                                                                                        <option value="12">@lang('layout.Invoice')12</option>
                                                                                        <option value="13">@lang('layout.Invoice')13</option>
                                                                                        <option value="14">@lang('layout.Invoice')14</option>
                                                                                        <option value="15">@lang('layout.Invoice')15</option>
                                                                                        <option value="16">@lang('layout.Invoice')16</option>
                                                                                        <option value="17">@lang('layout.Invoice')17</option>
                                                                                        <option value="18">@lang('layout.Invoice')18</option>
                                                                                        <option value="19">@lang('layout.Invoice')19</option>
                                                                                        <option value="20">@lang('layout.Invoice')20</option>
                                                                                        <option value="21">@lang('layout.Invoice')21</option>
                                                                                        <option value="22">@lang('layout.Invoice')22</option>
                                                                                        <option value="23">@lang('layout.Invoice')23</option>
                                                                                        <option value="24">@lang('layout.Invoice')24</option>
                                                                                        <option value="25">@lang('layout.Invoice')25</option>
                                                                                        <option value="26">@lang('layout.Invoice')26</option>
                                                                                        <option value="27">@lang('layout.Invoice')27</option>
                                                                                        <option value="28">@lang('layout.Invoice')28</option>
                                                                                        <option value="29">@lang('layout.Invoice')29</option>
                                                                                        <option value="30">@lang('layout.Invoice')30</option>
                                                                                        <option value="31">@lang('layout.Invoice')31</option>
                                                                                        <option value="32">@lang('layout.Invoice')32</option>
                                                                                        <option value="33">@lang('layout.Invoice')33 @lang('layout.Change') @lang('layout.Color') 29</option>
                                                                                        <option value="34">@lang('layout.Invoice')34 @lang('layout.Change') @lang('layout.Color') 29</option>
                                                                                        <option value="35">@lang('layout.Invoice')35</option>
                                                                                        <option value="36">@lang('layout.Invoice')36</option>
                                                                                        <option value="37">@lang('layout.Invoice')37</option>
                                                                                        <option value="38">@lang('layout.Invoice')38</option>
                                                                                        <option value="39">@lang('layout.Invoice')39</option>
                                                                                        <option value="40">@lang('layout.Invoice')40</option>
                                                                                        <option value="41">@lang('layout.Invoice')41</option>
                                                                                        <option value="42">@lang('layout.Invoice')42</option>
                                                                                        <option value="43">@lang('layout.Invoice')43 @lang('layout.Change') 9</option>
                                                                                        <option value="44">@lang('layout.Invoice')44 - @lang('layout.Change') - @lang('layout.Invoice') @lang('layout.SubMeasure')</option>
                                                                                        <option value="45">@lang('layout.Invoice')45</option>
                                                                                        <option value="46">@lang('layout.Invoice')46</option>
                                                                                        <option value="47">@lang('layout.Invoice')47</option>
                                                                                        <option value="48">@lang('layout.Invoice')48</option>
                                                                                        <option value="49">@lang('layout.Invoice')49</option>
                                                                                        <option value="50">@lang('layout.Invoice')50</option>
                                                                                        <option value="51">@lang('layout.Invoice')51</option>
                                                                                        <option value="52">@lang('layout.Invoice')52</option>
                                                                                        <option value="53">@lang('layout.Invoice')53</option>
                                                                                        <option value="54">@lang('layout.Invoice')54</option>
                                                                                        <option value="55">@lang('layout.Invoice')55</option>
                                                                                        <option value="56">@lang('layout.Invoice')56</option>
                                                                                        <option value="57">@lang('layout.Invoice')57</option>
                                                                                        <option value="58">@lang('layout.Invoice')58</option>
                                                                                        <option value="59">@lang('layout.Invoice')59</option>
                                                                                        <option value="60">@lang('layout.Invoice')60</option>
                                                                                        <option value="61">@lang('layout.Invoice')61</option>
                                                                                        <option value="62">@lang('layout.Invoice')62</option>
                                                                                        <option value="63">@lang('layout.Invoice')63</option>
                                                                                        {{-- <option value="46">@lang('layout.Invoice')46</option> --}}
                                                                                    </select>
                                                                                </td> 
                                                                            </tr>
                                                                        </table>
                                                                    </div>

                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.ShowMultipleCurrencyFactor')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_multiplce_currency">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>


                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.MultiCurrencyFactor')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.multi_currency_invoice_type">
                                                                                        <option value="default">@lang('layout.Default')</option>
                                                                                        <option value="1">@lang('layout.Invoice')1</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.FactorPaperType')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.paper_type">
                                                                                        <option value="">@lang('layout.SelectFormat')</option>
                                                                                        <option value="A4">A4</option>
                                                                                        <option value="A5">A5</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.FactorPaperStyle')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.paper_style">
                                                                                        <option value="">@lang('layout.SelectFormat')</option>
                                                                                        <option value="landscape">Landscape</option>
                                                                                        <option value="portrait">Portrait</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.PrintFactor')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.print_factor">
                                                                                        <option value="">@lang('layout.SelectFormat')</option>
                                                                                        <option value="automatic">@lang('layout.Automatic')</option>
                                                                                        <option value="manualy">@lang('layout.Manualy')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.FactorAndGRN')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_and_havalah">
                                                                                        <option value="">@lang('layout.SelectFormat')</option>
                                                                                        <option value="factor_and_havalah">@lang('layout.FactorAndGRN')</option>
                                                                                        <option value="factor">@lang('layout.Factor')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.ThermalPrinterFactor')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.thermal_printer_factor">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                        <option value="both">@lang('type.Both')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.ItemFieldWidth')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.item_field_width">
                                                                                        <option value="default">@lang('layout.Default')</option>
                                                                                        <option value="230">230px</option>
                                                                                        <option value="280">280px</option>
                                                                                        <option value="350">350px</option>
                                                                                        <option value="400">400px</option>
                                                                                        <option value="500">500px</option>
                                                                                        <option value="700">700px</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.InvoiceTotal')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_total">
                                                                                        <option value="default">@lang('layout.Default')</option>
                                                                                        <option value="1">@lang('layout.Style')1</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.FactorLayout')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_layout">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="rtl">@lang('layout.RTL')</option>
                                                                                        <option value="ltr">@lang('layout.LTR')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.Language') @lang('layout.Factor')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_lang">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="en">English</option>
                                                                                        <option value="fa">Persian</option>
                                                                                        <option value="pa">Pashto</option>
                                                                                        <option value="ru">Russia</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.InvoiceDate')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_date">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.InvoiceHour')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_hour">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.InvoiceUser')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_user">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.InvoicNumberByInventory')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_no_site">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.InvoiceTypeCode')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_type_code">
                                                                                        <option value="default">@lang('layout.Default')</option>
                                                                                        <option value="otherMeasureBaseFactor">@lang('layout.OtherMeasureBase')</option>
                                                                                        <option value="thermal">@lang('layout.ThermalPrinterFactor')</option>
                                                                                        <option value="1">@lang('layout.Invoice')1</option>
                                                                                        <option value="2">@lang('layout.Invoice')2</option>
                                                                                        <option value="3">@lang('layout.Invoice')3</option>
                                                                                        <option value="4">@lang('layout.Invoice')4</option>
                                                                                        <option value="5">@lang('layout.Invoice')5</option>
                                                                                        <option value="6">@lang('layout.Invoice')6</option>
                                                                                        <option value="7">@lang('layout.Invoice')7</option>
                                                                                        <option value="8">@lang('layout.Invoice')8</option>
                                                                                        <option value="9">@lang('layout.Invoice')9</option>
                                                                                        <option value="10">@lang('layout.Invoice')10</option>
                                                                                        <option value="11">@lang('layout.Invoice')11</option>
                                                                                        <option value="12">@lang('layout.Invoice')12</option>
                                                                                        <option value="13">@lang('layout.Invoice')13</option>
                                                                                        <option value="14">@lang('layout.Invoice')14</option>
                                                                                        <option value="15">@lang('layout.Invoice')15</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.InvoicStockInfo')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_stock_info">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.CopyNumberOfFactor')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.copy_number_of_factor">
                                                                                        <option value="1">@lang('layout.Select')</option>
                                                                                        <option value="1">1</option>
                                                                                        <option value="2">2</option>
                                                                                        <option value="4">4</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.InventorySite')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.inventory_site">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.Brand')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.inventory_brand">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.TotalQuantity')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.total_item_quantity">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="defualt">@lang('layout.Default')</option>
                                                                                        <option value="per_unit">@lang('layout.PerUnit')</option>
                                                                                        <option value="all_unit">@lang('layout.AllUnit')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.BankNumber')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.bank_number_invoice">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.ShowTotalSalePriceFactor')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_total_sale_price_factor">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.SiteGRN')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.grn_site">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option v-for="s in sites" :value="s.value">@{{s.text}}</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.BillInvoiceType')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.bill_invoice_type">
                                                                                        <option value="default">@lang('layout.Default')</option>
                                                                                        <option value="1">@lang('layout.Invoice')1</option>
                                                                                        <option value="2">@lang('layout.Invoice')2</option>
                                                                                        <option value="CustomeInvoice">@lang('layout.CustomeInvoice')</option>
                                                                                        <option value="3">@lang('layout.Invoice')3</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.ReferenceNumber')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.invoice_reference_no">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.FactorGrnDifferentHeader')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_grn_differnt_header">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.Unit')2
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_measure2">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.Unit')3
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_measure3">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.Unit')4
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_measure4">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>
                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.DriverInfo') @lang('layout.In') @lang('layout.Factor')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.factor_driver_info">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.TotalByItemInFactorCode')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.total_by_item_in_factor_code">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.Show') @lang('layout.Bundl')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_bundl">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.Show') @lang('layout.LoadingDetail')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.showLoadingDetail">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.EquivalentToBaseUnit')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.equivalent_to_base_unit">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.AutoPrintPreview')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.auto_print_preview">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                    <div class="col-md-3 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_head">
                                                                                    @lang('layout.ShowVendorInFactor')
                                                                                </td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.show_vendor_in_factor">
                                                                                        <option value="">@lang('layout.Select')</option>
                                                                                        <option value="true">@lang('layout.yes')</option>
                                                                                        <option value="false">@lang('layout.Not')</option>

                                                                                    </select>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>

                                                                    <!-- </div>
                                                                                </div> -->
                                                                </div>
                                                                <!----------------------------------------------------------------------------
                                                            | BEGIN Backup
                                                            |---------------------------------------------------------------------------->



                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <!----------------------------------------------------------------------------
                                        | End SaleAndPurchase
                                        |---------------------------------------------------------------------------->
                                        <!----------------------------------------------------------------------------
                                        | BEGIN  Report
                                        |---------------------------------------------------------------------------->
                                        <div id="tab_10" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('menu.Report') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Contacts')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.contacts">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ContactsFont')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.contacts_font">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="10">10px</option>
                                                                                <option value="12">12px</option>
                                                                                <option value="16">16px</option>
                                                                                <option value="20">20px</option>
                                                                                <option value="22">22px</option>
                                                                                <option value="25">25px</option>
                                                                                <option value="30">30px</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ContactsColor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.contacts_color">
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CompanyNameFont')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_name_font">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="16">16px</option>
                                                                                <option value="20">20px</option>
                                                                                <option value="22">22px</option>
                                                                                <option value="25">25px</option>
                                                                                <option value="30">30px</option>
                                                                                <option value="35">35px</option>
                                                                                <option value="40">40px</option>
                                                                                <option value="50">50px</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.CompanyNameColor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_name_color">
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ComapyLogo')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_logo">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ExportBy')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.export_by">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ExportByFont')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.export_by_font">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="8">8px</option>
                                                                                <option value="10">10px</option>
                                                                                <option value="12">12px</option>
                                                                                <option value="14">14px</option>
                                                                                <option value="16">16px</option>
                                                                                <option value="18">18px</option>
                                                                                <option value="20">20px</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ExportByColor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.export_by_color">
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.LogoSize')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.logo_size">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="120">120px</option>
                                                                                <option value="130">130px</option>
                                                                                <option value="140">140px</option>
                                                                                <option value="150">150px</option>
                                                                                <option value="180">180px</option>
                                                                                <option value="200">200px</option>
                                                                                <option value="220">220px</option>
                                                                                <option value="250">250px</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ReportHeader')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.report_header">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.PaperType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.report_paper_type">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="A4">A4</option>
                                                                                <option value="A3">A3</option>
                                                                                <option value="A5">A5</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.PaperStyle')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.report_paper_style">
                                                                                <option value="">@lang('layout.SelectFormat')</option>
                                                                                <option value="landscape">Landscape</option>
                                                                                <option value="portrait">Portrait</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">@lang('layout.Font')</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.report_font">
                                                                                <option value="xbriyaz" selected>@lang('layout.Default')</option>
                                                                                <option value="aril">@lang('layout.Aaril')</option> 
                                                                                <option value="majalla">@lang('layout.Majalla')</option>
                                                                                <option value="majallab">@lang('layout.Majallab')</option>
                                                                                <option value="xbriyaz">@lang('layout.Xbriyaz')</option>
                                                                                <option value="lateef">@lang('layout.Latif')</option>

                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.UserSignature')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.report_user_signature">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ShowJalalianGerogorianDate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.jalali_and_gerogarian_date">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <!-- <div class="table-scrollable">
                                                                    <div class="col-md-12">
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.Contacts')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.contacts">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>

                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.ContactsFont')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.contacts_font">
                                                                                    <option value="default">@lang('layout.Default')</option>
                                                                                    <option value="10">10px</option>
                                                                                    <option value="12">12px</option>
                                                                                    <option value="16">16px</option>
                                                                                    <option value="20">20px</option>
                                                                                    <option value="22">22px</option>
                                                                                    <option value="25">25px</option>
                                                                                    <option value="30">30px</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.ContactsColor')</label>
                                                                                <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.contacts_color">
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.CompanyNameFont')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_name_font">
                                                                                    <option value="default">@lang('layout.Default')</option>
                                                                                    <option value="16">16px</option>
                                                                                    <option value="20">20px</option>
                                                                                    <option value="22">22px</option>
                                                                                    <option value="25">25px</option>
                                                                                    <option value="30">30px</option>
                                                                                    <option value="35">35px</option>
                                                                                    <option value="40">40px</option>
                                                                                    <option value="50">50px</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col-md-12">
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.CompanyNameColor')</label>
                                                                                <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_name_color">
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.ComapyLogo')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.company_logo">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>

                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.ExportBy')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.export_by">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>

                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.ExportByFont')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.export_by_font">
                                                                                    <option value="default">@lang('layout.Default')</option>
                                                                                    <option value="8">8px</option>
                                                                                    <option value="10">10px</option>
                                                                                    <option value="12">12px</option>
                                                                                    <option value="14">14px</option>
                                                                                    <option value="16">16px</option>
                                                                                    <option value="18">18px</option>
                                                                                    <option value="20">20px</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col-md-12">
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.ExportByColor')</label>
                                                                                <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.export_by_color">
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-md-3">
                                                                            <div class="form-group"> <label class="control-label">@lang('layout.LogoSize')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.logo_size">
                                                                                    <option value="default">@lang('layout.Default')</option>
                                                                                    <option value="120">120px</option>
                                                                                    <option value="130">130px</option>
                                                                                    <option value="140">140px</option>
                                                                                    <option value="150">150px</option>
                                                                                    <option value="180">180px</option>
                                                                                    <option value="200">200px</option>
                                                                                    <option value="220">220px</option>
                                                                                    <option value="250">250px</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.ReportHeader')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.report_header">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>

                                                                        </div>
                                                                    </div>

                                                                </div> -->
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!----------------------------------------------------------------------------
                                        | BEGIN Report
                                        |---------------------------------------------------------------------------->
                                        <!----------------------------------------------------------------------------
                                        | BEGIN  Backup
                                        |---------------------------------------------------------------------------->
                                        <div id="tab_11" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('menu.Backups') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AutoBackup')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.auto_backup">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AutoBackupTime')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.auto_backup_time">
                                                                                <option value="default">@lang('layout.Default')(12)</option>
                                                                                <option value="6">6 @lang('layout.Hour')</option>
                                                                                <option value="12">12 @lang('layout.Hour')</option>
                                                                                <option value="24">24 @lang('layout.Hour')</option>
                                                                                <option value="48">48 @lang('layout.Hour')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.AutoBackupToWhatsapp')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.auto_backup_whatsapp">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                            <!-- <div class="table-scrollable">
                                                                    <div class="col-md-12">
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.AutoBackup')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.auto_backup">
                                                                                    <option value="">@lang('layout.Select')</option>
                                                                                    <option value="true">@lang('layout.yes')</option>
                                                                                    <option value="false">@lang('layout.Not')</option>
                                                                                </select>
                                                                            </div>

                                                                        </div>
                                                                        <div class="col-md-3">
                                                                            <div class="form-group">
                                                                                <label class="control-label">@lang('layout.AutoBackupTime')</label>
                                                                                <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.auto_backup_time">
                                                                                    <option value="default">@lang('layout.Default')(12)</option>
                                                                                    <option value="6">6 @lang('layout.Hour')</option>
                                                                                    <option value="12">12 @lang('layout.Hour')</option>
                                                                                    <option value="24">24 @lang('layout.Hour')</option>
                                                                                    <option value="48">48 @lang('layout.Hour')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div> -->
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!----------------------------------------------------------------------------
                                        | BEGIN Backup
                                        |--------------------------------------------------------------------------->
                                        <!----------------------------------------------------------------------------
                                        | BEGIN  Project
                                        |---------------------------------------------------------------------------->
                                        @if(systemConfig()[5] != 0 )

                                        <div id="tab_12" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('menu.Project') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.ProjectInvoiceType')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.project_invoice_type">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="1">@lang('layout.Invoice')1</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                <!----------------------------------------------------------------------------
                                | End  Project
                                |---------------------------------------------------------------------------->                    
                    
                                    <!----------------------------------------------------------------------------
                                    | BEGIN  Contract
                                    |---------------------------------------------------------------------------->
                                    @if(systemConfig()[20] == 1)
                                        <div id="tab_14" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('menu.Contract') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.LoadingDate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.contract_loading_date">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Mine')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.mine">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                    <!----------------------------------------------------------------------------
                                    | End  Project
                                    |---------------------------------------------------------------------------->                                    
                                    
                                    
                                    <!----------------------------------------------------------------------------
                                    | BEGIN  Expenses
                                    |---------------------------------------------------------------------------->
                                        <div id="tab_15" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('menu.Expenses') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.FromDate')- @lang('layout.ToDate')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.expense_from_to_date">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.DoNotShowUsedCategory')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.doNotShowUsedCategory">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>



                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.QuantityInDailyExpenses')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.quantityInDailyExpense">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>


                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <!----------------------------------------------------------------------------
                                    | End  Expenses
                                    |---------------------------------------------------------------------------->

                            <!----------------------------------------------------------------------------
                            | BEGIN  MainMenu
                            |---------------------------------------------------------------------------->


                                        <div id="tab_13" class="tab-pane">
                                            <div id="accordion1" class="panel-group">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">
                                                            <a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion1" href="#accordion1_1">@lang('menu.MainMenu') </a>
                                                        </h4>
                                                    </div>
                                                    <div id="accordion1_1" class="panel-collapse collapse in">
                                                        <div class="panel-body">
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('menu.MainMenu')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.main_menu">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="true">@lang('layout.yes')</option>
                                                                                <option value="false">@lang('layout.Not')</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div> 

                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.Font')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <select class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.menu_font">
                                                                                <option value="default">@lang('layout.Default')</option>
                                                                                <option value="15">15px</option>
                                                                                <option value="20">20px</option>
                                                                                <option value="25">25px</option>
                                                                                <option value="30">30px</option>
                                                                                <option value="35">35px</option>
                                                                                <option value="40">40px</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div> 
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.BackgroundColor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.menu_color">
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                            <div class="col-md-3 col-sm-12 col-xs-12">
                                                                <table class="table table-striped table-bordered table-advance ">
                                                                    <tr>
                                                                        <td class="t_head">
                                                                            @lang('layout.TextColor')
                                                                        </td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td class="t_body">
                                                                            <input type="color" class="form-control input-inline input-sm input-small" v-model="(!settings)?null:settings.menu_text_color">
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                            </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- 
                                    <span style="font-size:20px; color: green">نقدی <input type="checkbox" class="in_rol"> </span>
                                    <span style="font-size:20px; color: red">نسیه <input type="checkbox" class="in_rol"> </span> --}}
                                    <!----------------------------------------------------------------------------
                            | BEGIN MainMenu
                            |---------------------------------------------------------------------------->

                                </div>
                            </div>



                        </div>
                    </div>
                </div>
            </div>
            <!--end tab-pane-->
        </div>
        <div class="col-md-4 col-md-offset-4 text-center">
            <br>
            <button class="btn btn-primary" @click="saveSetting">
                <i class="icon-settings"></i> @lang('layout.SaveChanges')</button>
        </div>
    </div>

    <!-- END FORM-->
</div>
</div>


    <!-- <ul id="treeUL">
        <li>
            <span class="rootTree">@lang('menu.Settings')</span>
                <ul class="children">
                <li>
                    <a data-toggle="tab" href="#tab_6" aria-expanded="true"> @lang('layout.System') </a>
                </li>
                <li>
                    <a data-toggle="tab" href="#tab_1" aria-expanded="true">@lang('layout.Members') </a>
                </li>
                <li class="">
                    <a data-toggle="tab" href="#tab_2" aria-expanded="true"> @lang('menu.Dashboard')</a>
                </li>
                <li class="">
                    <a data-toggle="tab" href="#tab_3" aria-expanded="true"> @lang('layout.Account') </a>
                </li>
                <span class="rootTree">@lang('layout.ReceiveAndPayment')</span>
                        <ul class="children">
                            <li class="">
                                <a data-toggle="tab" href="#tab_4" aria-expanded="true"> @lang('layout.ReceiveAndPayment') </a>
                            </li>
                            <li class="">
                                <a data-toggle="tab" href="#tab_4" aria-expanded="true"> @lang('layout.Receive') </a>
                            </li>
                        </ul>
                
                <li class="">
                    <a data-toggle="tab" href="#tab_5" aria-expanded="true"> @lang('layout.BuildSetting') </a>
                </li> 
                <li class="">
                    <a data-toggle="tab" href="#tab_7" aria-expanded="true"> @lang('layout.Inventory') </a>
                </li>
                <li class="">
                    <a data-toggle="tab" href="#tab_8" aria-expanded="true"> @lang('menu.TransportCompany') </a>
                </li>
                <li class="">
                    <a data-toggle="tab" href="#tab_9" aria-expanded="true"> @lang('layout.SaleAndPurchase') </a>
                </li> 
                <li class="">
                    <a data-toggle="tab" href="#tab_10" aria-expanded="true"> @lang('menu.Report') </a>
                </li>
                <li class="">
                    <a data-toggle="tab" href="#tab_11" aria-expanded="true"> @lang('menu.Backups') </a>
                </li>
                @if(systemConfig()[5] != 0 )
                <li class="">
                    <a data-toggle="tab" href="#tab_12" aria-expanded="true"> @lang('menu.Project') </a>
                </li>
                @endif
                </ul>
        </li>
    </ul> -->
<!-- <button class="btn btn-outline yellow-mint  uppercase" data-toggle="confirmation" data-placement="bottom">Confirmation on bottom</button> -->
<!-- <button class="btn btn-outline yellow-mint  uppercase" data-toggle="confirmation"
     data-placement="bottom"
     >FFFF</button> -->
@endsection
@push('scripts')
<script src="{{url('/assets/global/plugins/bootstrap-confirmation/bootstrap-confirmation.js')}}" type="text/javascript"></script>
<script src="{{url('/assets/pages/scripts/ui-confirmations.min.js')}}" type="text/javascript"></script>
<script type="text/javascript">
    // var toggler = document.querySelectorAll(".rootTree");
    // Array.from(toggler).forEach(item => {
    //     item.addEventListener("click", () => {
    //         item.parentElement .querySelector(".children") .classList.toggle("active");
    //         item.classList.toggle("rootTree-down");
    //     });
    // });
    var settingAll = {!! getUserSetting() !!};
    var measures = {!! getAllMeasures1() !!};
    var sites = {!! getAllInventorySites() !!};
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
            saveSetting: function() {
                var data = this.settings;
                // console.log('sssssssss',data)
                var req = axios.post("{{route('setting.update')}}", data)
                .then(function(response) {
                    // vu.showModal = false;
                    // vu.fieldErrors = [];
                    // vu.selectedMetric = {};
                    // vu.selectedMeasure = {};
                    var message = "{{__('message.CSuccess')}}";
                    toastr.success('', message);
                    location.reload();
                })    
                .catch(function(error) {
                });
            },
        }
    });
    //This is used to Customize Confirmition
    //     $('[data-toggle=confirmation]').confirmation({
    //     rootSelector:'[data-toggle=confirmation]',
    //     title:"@lang('layout.AreYouSure?')",
    //     html: true,
    //     popout: false,
    //     singleton: false,
    //     copyAttributes: 'href target',
    //     onConfirm: $.noop,
    //     onCancel: $.noop,
    //     btnOkClass: 'btn-xs btn-primary',
    //     btnOkIcon: 'glyphicon glyphicon-ok',
    //     btnOkLabel: "@lang('layout.yes')",
    //     btnCancelClass: 'btn-xs btn-default',
    //     btnCancelIcon: 'glyphicon glyphicon-remove',
    //     btnCancelLabel: "@lang('layout.No')",
    //     template:
    //       '<div class="popover confirmation">' +
    //         '<div class="arrow"></div>' +
    //         '<h3 class="popover-title"></h3>' +
    //         '<div class="popover-content text-center">'+
    //           '<div class="btn-group">'+
    //             '<a class="btn" >@lang("menu.ChartOfAccount")</a>'+
    //             '<a class="btn" ></a>'+
    //             '<a class="btn" ></a>'+
    //             '<a class="btn" ></a>'+
    //             '<a class="btn" ></a>'+
    //             '<a class="btn" ></a>'+
    //           '</div>'+
    //         '</div>'+
    //       '</div>'
    // });
</script>

@endpush