@extends('layouts.app')
@section('content')
@include('loans.modal')



<div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>&nbsp;
            <span class="caption-subject bold uppercase">@lang('layout.Alerts')</span>
        </div>
        <div class="tools"> </div>
        <!--div class="btn-group pull-right">
                @permission('services-export')
                   
                    <a href="{{route('systemAlerts.create')}}">
                                  <button class="btn btn-success">
                                      <i class="fa fa-plus"></i> @lang('layout.AddNew')
                                  </button>
                    </a>
                @endpermission
            </div-->
    </div>
</div>


<div class="tabbable-line tabbable-custom-profile">
    <ul class="nav nav-tabs">
        <li class="active">
            <a href="#both" data-toggle="tab" id="tab-on" style="color:red">
                <i class="fa  "></i><b> @lang('layout.GarlicLicense') </b></a>
        </li>
        <li class="">
            <a href="#logBook" data-toggle="tab" id="tab-logBook" style="color:red">
                <i class="fa  "></i><b> @lang('layout.LogBook') </b></a>
        </li>
        <li class="">
            <a href="#ex-transport" data-toggle="tab" id="tab-trasnport" style="color: red">
                <i class="fa  "></i><b> @lang('layout.Visa') </b></a>
        </li>
        <li class="">
            <a href="#ex-vehicle_equipment" data-toggle="tab" id="tab-vehicle_equipment" style="color: red">
                <i class="fa  "></i><b> @lang('menu.VehicleEquipment') </b></a>
        </li>


    </ul>
    <div class="tab-content padding" style="padding: 0px;">
        <div class="tab-pane active" id="both">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.GarlicLicense') </span>
                        </div>
                        <div class="tools"> </div>
                        <div class="pull-right">
                            @permission('customers-export')
                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="garlic_license_alert" />
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}}

                            @endpermission
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="garlic_license_alert">
                            <thead>
                                <tr>
                                    <th>@lang('layout.PaletNumber')</th>
                                    <th>@lang('menu.Vehicle')</th>
                                    <th>@lang('layout.GarlicLicenseIssueDate') </th>
                                    <th>@lang('layout.GarlicLicenseEndDate')</th>
                                    <th>@lang('layout.Action')</th>

                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>
        
        <div class="tab-pane" id="logBook">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.LogBook') </span>
                        </div>
                        <div class="tools"> </div>
                        <div class="pull-right">
                            @permission('customers-export')
                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="garlic_license_alert" />
                            <input type="hidden" name="logBook" value="yes" />
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}}

                            @endpermission
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="logBook_alert">
                            <thead>
                                <tr>
                                    <th>@lang('layout.PaletNumber')</th>
                                    <th>@lang('menu.Vehicle')</th>
                                    <th>@lang('layout.LogBookStartDate') </th>
                                    <th>@lang('layout.LogBookEndDate')</th>
                                    <th>@lang('layout.Action')</th>

                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>

        <div class="tab-pane" id="ex-transport">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.Visa')</span>
                        </div>
                        <div class="tools"> </div>
                        <div class="btn-group pull-right">
                            @permission('driver-export')
                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="visa_alert" />
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}}

                            @endpermission
                        </div>

                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="visa_alert">
                            <thead>
                                <tr>
                                    <th>@lang('layout.Number') </th>
                                    <th>@lang('layout.Driver') </th>
                                    <th>@lang('layout.PlateNumber') </th>
                                    <th>@lang('layout.VisaIssueDate') </th>
                                    <th>@lang('layout.VisaEndDate')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                            </thead>

                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>

        <div class="tab-pane" id="ex-vehicle_equipment">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.Visa')</span>
                        </div>
                        <div class="tools"> </div>
                        <div class="btn-group pull-right">
                            @permission('driver-export')
                            {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="visa_alert" />
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}}

                            @endpermission
                        </div>

                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="vehicle_equipment">
                            <thead>
                                <tr>
                                <th>@lang('layout.VehicleName')</th>
                                <th>@lang('layout.PlateNumber')</th>
                                <th>@lang('layout.Name')</th>
                                <th>@lang('layout.Value')</th>
                                <th>@lang('layout.Description')</th>
                                <th>@lang('layout.ChangeDate')</th>
                                <th>@lang('layout.Actions')</th>
                                </tr>
                            </thead>

                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>


    </div>
</div>


@stop

@push('scripts')

<script>
    // delete item by ajax
    function DisableItemAjax(element, datatableId) {
        var e = $(element);
        var form = e.parent('form').get(0);
        var url = $(form).get(0).action;
        var table = $(datatableId).DataTable();

        swal({
            title: "@lang('layout.AreYouSure?')",
            icon: "warning",
            buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
            dangerMode: true,
        }).then((willDelete) => {
            if (willDelete) {
                $.ajax({
                    type: 'PATCH',
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    success: function(result) {
                        // swal("{{__('message.DSuccess')}}",result.message);

                        toastr.success('', result.message);
                        table.ajax.reload();
                    },
                    error: function(error) {
                        swal("{{__('message.Warning')}}", error.responseJSON.message);

                    }
                });
            } else {
                swal({
                    buttons: "@lang('layout.Confirm')",
                    title: "@lang('layout.FileIsSave')",
                });
                return false;
            }
        });

    }




    

    $(document).ready(function() {

        $('#garlic_license_alert').DataTable({
            ajax: {
                url: '{{route("systemAlerts.vehicle_alert")}}',
                data: {
                    type: 'garlic_license_alert'
                }
            },
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            destroy: true,
            columns: [{
                    data: 'palet_number',
                    name: 'vehicles.palet_number'
                },
                {
                    data: 'vehicle_name',
                    name: 'vehicles.vehicle_name'
                },
                {
                    data: 'garlic_license_issue_date',
                    name: 'garlic_license_issue_date',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'garlic_license_end_date',
                    name: 'garlic_license_end_date',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ]



        });


        $('#tab-logBook').on('shown.bs.tab', function(event) {
            $('#logBook_alert').DataTable({
                ajax: {
                    url: '{{route("systemAlerts.vehicle_alert")}}',
                    data: {
                        type: 'logBook_alert'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [{
                        data: 'palet_number',
                        name: 'vehicles.palet_number'
                    },
                    {
                        data: 'vehicle_name',
                        name: 'vehicles.vehicle_name'
                    },
                    {
                        data: 'log_book_start_date',
                        name: 'log_book_start_date',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'log_book_end_date',
                        name: 'log_book_end_date',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        orderable: false,
                        searchable: false
                    }
                ]

            });
        });

        $('#tab-trasnport').on('shown.bs.tab', function(event) {
            $('#visa_alert').DataTable({
                ajax: {
                    url: '{{route("systemAlerts.vehicle_alert")}}',
                    data: {
                        type: 'visa_alert'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [{
                        data: 'code',
                        name: 'code'
                    },
                    {
                        data: 'name',
                        name: 'members.name'
                    },
                    {
                        data: 'plate_number',
                        name: 'transfers.plate_number'
                    },
                    {
                        data: 'visa_issue_date',
                        name: 'visa_issue_date',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'visa_end_date',
                        name: 'visa_end_date',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        orderable: false,
                        searchable: false
                    }

                ]

            });
        });

        $('#tab-vehicle_equipment').on('shown.bs.tab', function(event) {
            $('#vehicle_equipment').DataTable({
                ajax: {
                    url: '{{route("systemAlerts.vehicle_alert")}}',
                    data: {
                        type: 'vehicle_equipment'
                    }
                },
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [
                    { data: 'vehicle_name', name: 'vehicle_name',orderable:false,searchable:false },
                    { data: 'palet_number', name: 'palet_number',orderable:false,searchable:false },
                    { data: 'name',         name: 'name',orderable:false,searchable:false },
                    { data: 'value',        name: 'value',orderable:false,searchable:false },
                    { data: 'description',  name: 'description',orderable:false,searchable:false },
                    { data: 'date',         name: 'date',orderable:false,searchable:false },
                    { data: 'actions',      name: 'actions',orderable:false,searchable:false }
                ]

            });
        });
    });





    //Start Export Modal
    var Modal = Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });


    // start app
    new Vue({
        el: '#app',
        data: {
            showModal: false,
        },
        methods: {
            ok: function() {
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {

                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });
    // start app
    new Vue({
        el: '#app2',
        data: {
            showModal: false,
        },
        methods: {
            ok: function() {
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {

                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        $(".date").persianDatepicker(modelDate());
                    });
                })
            }
        },
    });

    $('#print_pdf_all').on('click', function(e) {
        $('#show-modal').click();
        e.preventDefault();
    })
    $('#print_pdf_all2').on('click', function(e) {
        $('#show-modal2').click();
        e.preventDefault();
    })

    //End Export Modal
</script>


@endpush