@extends('layouts.app')
@section('content')
@section('style')
<style>
    .modal-container {
        width: 50% !important;
    }
</style>
@endsection

@include('loans.modal')
@include('drawings.modal')

</style>
  <!-- new modal -->

  <div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'transferAndLoading_alert_all'"
                  @closed="closeModal">
        <div slot="body">
        </div>
    </report-modal>
</div>  

<div id="print-modal-loading">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'loading_alert_all'"
                  @closed="closeModal">
        <div slot="body">
        </div>
    </report-modal>
</div>

<!-- /new modal -->



<div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>&nbsp;
            <span class="caption-subject bold uppercase">@lang('layout.Alerts')-- <span style="color: red"> @lang('layout.Loading') -- @lang('menu.TransferAndLoading')</span></span>
        </div>
        <div class="tools"> </div>
    </div>
</div>


<div class="tabbable-line tabbable-custom-profile">
    <ul class="nav nav-tabs">
                
        <li class="active">
            <a href="#tab2" data-toggle="tab">@lang('menu.TransferAndLoading')</a>
        </li>
        <li >
            <a href="#tab3" data-toggle="tab">@lang('layout.Loading')</a>
        </li>
    </ul>
    <div class="tab-content padding" style="padding: 0px;">
        <div class="tab-pane active" id="tab2">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('menu.TransferAndLoading') </span>
                        </div>
                        <div class="tools"> </div>
                        <div class="pull-right">
                            <span id="anchore-modal">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                   <i class="fa fa-print"></i>
                                </a>
                               </span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="transferAndLoadingAlertTable">
                            <thead>
                                <tr>
                                    <th>@lang('layout.Record')</th>
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.ReferenceNumber')</th>
                                    <th>@lang('layout.Type')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.DeliveryDate')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.User')</th>
                                    <th>@lang('layout.Actions')</th>

                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>        
        
        <div class="tab-pane" id="tab3">
            <div class="col-md-12">
                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>&nbsp;
                            <span class="caption-subject bold uppercase">@lang('layout.Loading') </span>
                        </div>
                        <div class="tools"> </div>
                        <div class="pull-right">
                            <span id="anchore-modal-loading">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                   <i class="fa fa-print"></i>
                                </a>
                               </span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" cellspacing="0" id="loadingAlertTable">
                            <thead>
                                <tr>
                                    <th>@lang('layout.Driver') </th>
                                    <th>@lang('layout.Transporter_name') </th>
                                    <th>@lang('layout.VehicleName')</th>
                                    <th>@lang('layout.TankerNumber')</th>
                                    <th>@lang('layout.DriverType')</th>
                                    <th>@lang('layout.WayBillNumber') </th>
                                    <th>@lang('layout.TransitNumber') </th>
                                    <th>@lang('layout.LoadingDate') </th>
                                    <th>@lang('layout.DeliveryDate') </th>
                                    <th>@lang('layout.ItemName') </th>
                                    <th>@lang('layout.Measure') </th>
                                    <th>@lang('layout.Quantity') </th>
                                    <th>@lang('layout.Action') </th>

                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>
       


    </div>
</div>


@stop
@include('print.modal')

@push('scripts')

<script>

// Disable item by ajax
function DisableItemAjax(element, datatableId) {
    var e = $(element);
    var form = e.parent('form').get(0);
    var url = $(form).get(0).action;
    var table = $(datatableId).DataTable();

    swal({
        title: "@lang('layout.AreYouSure?')",
        icon: "warning",
        buttons: ["@lang('layout.Cancel')", "@lang('layout.Deactive')"],
        dangerMode: true,
    }).then((willDelete) => {
        if (willDelete) {
            $.ajax({
                type: 'PATCH',
                url: url,
                headers: {
                    'X-CSRF-TOKEN': "{{csrf_token()}}"
                },
                success: function(result) {
                    // swal("{{__('message.DSuccess')}}",result.message);

                    toastr.success('', result.message);
                    table.ajax.reload();
                },
                error: function(error) {
                    swal("{{__('message.Warning')}}", error.responseJSON.message);

                }
            });
        } else {
            swal({
                buttons: "@lang('layout.Confirm')",
                title: "@lang('layout.FileIsSave')",
            });
            return false;
        }
    });

}
   
    
//DataTable Part
$(document).ready(function() {
    $('#transferAndLoadingAlertTable').DataTable({
        ajax: {
            url: '{{route("systemAlerts.transferAndLoading")}}',
            data: {
                type: 'transferAndLoading'
            }
        },
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        destroy: true,
        columns: [
            {data: 'id', name: 'id'},
            {data: 'number', name: 'number'},
            {data: 'ref_no', name: 'ref_no'},
            {data: 'type', name: 'type',orderable: false, searchable: false},
            {data: 'date', name: 'date', orderable: true, searchable: true},
            {data: 'delivery_date', name: 'delivery_date', orderable: true, searchable: true},
            {data: 'description', name: 'description'},
            {data: 'user', name: 'user', orderable: false, searchable: false},
            {data: 'actions', name: 'actions', orderable: false, searchable: false}
        ]
    });     
    
    $('#loadingAlertTable').DataTable({
        ajax: {
            url: '{{route("systemAlerts.transferAndLoading")}}',
            data: {
                type: 'loading'
            }
        },
        scrollCollapse: true,
        serverSide: true,
        paging: true,
        destroy: true,
        columns: [
            {
                    data: 'driver_name',
                    name: 'driver_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'other_driver_name',
                    name: 'other_driver_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'vehicle_name',
                    name: 'vehicle_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'tanker_name',
                    name: 'tanker_name',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'driver_type',
                    name: 'driver_type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'cmr_number',
                    name: 'cmr_number',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'transit_number',
                    name: 'transit_number',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'loading_date',
                    name: 'loading_date',
                    orderable: false,
                    searchable: false
                }, 
                {
                    data: 'delivery_date',
                    name: 'loading_details.delivery_date'
                },
                {
                    data: 'items',
                    name: 'items.name'
                },
                {
                    data: 'measure',
                    name: 'measure',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'qty',
                    name: 'qty',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
        ]
    });   

});       
    


//Print Modal     
var vm = new Vue({
    el: '#print-modal',
    data: {
        is_show: false,
        pdfRoute: '{!!route("export.PDFAll") !!}',
        excelRoute: '{!! route("export.ExcelAll") !!}'
    },
    methods: {
        closeModal: function () {
            this.is_show = !this.is_show
        }
    },
});

new Vue({
    el: '#anchore-modal',
    methods: {
        showModal: function () {
            vm.$data.is_show = true;
        }
    }
});

var vml = new Vue({
    el: '#print-modal-loading',
    data: {
        is_show: false,
        pdfRoute: '{!!route("export.PDFAll") !!}',
        excelRoute: '{!! route("export.ExcelAll") !!}'
    },
    methods: {
        closeModal: function () {
            this.is_show = !this.is_show
        }
    },
});

new Vue({
    el: '#anchore-modal-loading',
    methods: {
        showModal: function () {
            vml.$data.is_show = true;
        }
    }
});


</script>


@endpush