@extends('layouts.app')

@section('content')

    <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.SystemAlertDetails')</span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                         
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                        <tr>  
                            <th>@lang('layout.ID')</th>
							<th>@lang('layout.Name')</th>
							<th>@lang('layout.Description')</th>
							<th>@lang('layout.Status')</th>
							<th>@lang('layout.Date')</th>
							<th>@lang('layout.UpdatedAt')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div> 
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
 @push('scripts')
<script>
        $(document).ready(function () {
        $('#sales').DataTable({
            ajax:'{{route("systemAlerts.show",$systemAlerts->member_id)}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [

                { data: 'id', name: 'id' },
                { data: 'name', name: 'name' },
                { data: 'description', name: 'description' },
                { data: 'status', name: 'status' },
                { data: 'date', name: 'date' },
                { data: 'updated_at', name: 'updated_at' },
					
        ]
        });

    });
</script>


@endpush 